// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// The Microsoft Active Directory attributes of the Amazon FSx for Windows File
// Server file system.
type ActiveDirectoryBackupAttributes struct {

	// The ID of the Amazon Web Services Managed Microsoft Active Directory instance
	// to which the file system is joined.
	ActiveDirectoryId *string

	// The fully qualified domain name of the self-managed Active Directory directory.
	DomainName *string

	// The Amazon Resource Name (ARN) for a given resource. ARNs uniquely identify
	// Amazon Web Services resources. We require an ARN when you need to specify a
	// resource unambiguously across all of Amazon Web Services. For more information,
	// see [Amazon Resource Names (ARNs)]in the Amazon Web Services General Reference.
	//
	// [Amazon Resource Names (ARNs)]: https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html
	ResourceARN *string

	noSmithyDocumentSerde
}

// Describes a specific Amazon FSx administrative action for the current Windows,
// Lustre, OpenZFS, or ONTAP file system or volume.
type AdministrativeAction struct {

	// Describes the type of administrative action, as follows:
	//
	//   - FILE_SYSTEM_UPDATE - A file system update administrative action initiated
	//   from the Amazon FSx console, API ( UpdateFileSystem ), or CLI (
	//   update-file-system ).
	//
	//   - THROUGHPUT_OPTIMIZATION - After the FILE_SYSTEM_UPDATE task to increase a
	//   file system's throughput capacity has been completed successfully, a
	//   THROUGHPUT_OPTIMIZATION task starts.
	//
	// You can track the storage-optimization progress using the ProgressPercent
	//   property. When THROUGHPUT_OPTIMIZATION has been completed successfully, the
	//   parent FILE_SYSTEM_UPDATE action status changes to COMPLETED . For more
	//   information, see [Managing throughput capacity]in the Amazon FSx for Windows File Server User Guide.
	//
	//   - STORAGE_OPTIMIZATION - After the FILE_SYSTEM_UPDATE task to increase a file
	//   system's storage capacity has completed successfully, a STORAGE_OPTIMIZATION
	//   task starts.
	//
	//   - For Windows and ONTAP, storage optimization is the process of migrating the
	//   file system data to newer larger disks.
	//
	//   - For Lustre, storage optimization consists of rebalancing the data across
	//   the existing and newly added file servers.
	//
	// You can track the storage-optimization progress using the ProgressPercent
	//   property. When STORAGE_OPTIMIZATION has been completed successfully, the
	//   parent FILE_SYSTEM_UPDATE action status changes to COMPLETED . For more
	//   information, see [Managing storage capacity]in the Amazon FSx for Windows File Server User Guide, [Managing storage capacity]in the
	//   Amazon FSx for Lustre User Guide, and [Managing storage capacity and provisioned IOPS]in the Amazon FSx for NetApp ONTAP User
	//   Guide.
	//
	//   - FILE_SYSTEM_ALIAS_ASSOCIATION - A file system update to associate a new
	//   Domain Name System (DNS) alias with the file system. For more information, see [AssociateFileSystemAliases]
	//   .
	//
	//   - FILE_SYSTEM_ALIAS_DISASSOCIATION - A file system update to disassociate a
	//   DNS alias from the file system. For more information, see [DisassociateFileSystemAliases].
	//
	//   - IOPS_OPTIMIZATION - After the FILE_SYSTEM_UPDATE task to increase a file
	//   system's throughput capacity has been completed successfully, a
	//   IOPS_OPTIMIZATION task starts.
	//
	// You can track the storage-optimization progress using the ProgressPercent
	//   property. When IOPS_OPTIMIZATION has been completed successfully, the parent
	//   FILE_SYSTEM_UPDATE action status changes to COMPLETED . For more information,
	//   see [Managing provisioned SSD IOPS]in the Amazon FSx for Windows File Server User Guide.
	//
	//   - STORAGE_TYPE_OPTIMIZATION - After the FILE_SYSTEM_UPDATE task to increase a
	//   file system's throughput capacity has been completed successfully, a
	//   STORAGE_TYPE_OPTIMIZATION task starts.
	//
	// You can track the storage-optimization progress using the ProgressPercent
	//   property. When STORAGE_TYPE_OPTIMIZATION has been completed successfully, the
	//   parent FILE_SYSTEM_UPDATE action status changes to COMPLETED .
	//
	//   - VOLUME_UPDATE - A volume update to an Amazon FSx for OpenZFS volume
	//   initiated from the Amazon FSx console, API ( UpdateVolume ), or CLI (
	//   update-volume ).
	//
	//   - VOLUME_RESTORE - An Amazon FSx for OpenZFS volume is returned to the state
	//   saved by the specified snapshot, initiated from an API (
	//   RestoreVolumeFromSnapshot ) or CLI ( restore-volume-from-snapshot ).
	//
	//   - SNAPSHOT_UPDATE - A snapshot update to an Amazon FSx for OpenZFS volume
	//   initiated from the Amazon FSx console, API ( UpdateSnapshot ), or CLI (
	//   update-snapshot ).
	//
	//   - RELEASE_NFS_V3_LOCKS - Tracks the release of Network File System (NFS) V3
	//   locks on an Amazon FSx for OpenZFS file system.
	//
	//   - DOWNLOAD_DATA_FROM_BACKUP - An FSx for ONTAP backup is being restored to a
	//   new volume on a second-generation file system. Once the all the file metadata is
	//   loaded onto the volume, you can mount the volume with read-only access. during
	//   this process.
	//
	//   - VOLUME_INITIALIZE_WITH_SNAPSHOT - A volume is being created from a snapshot
	//   on a different FSx for OpenZFS file system. You can initiate this from the
	//   Amazon FSx console, API ( CreateVolume ), or CLI ( create-volume ) when using
	//   the using the FULL_COPY strategy.
	//
	//   - VOLUME_UPDATE_WITH_SNAPSHOT - A volume is being updated from a snapshot on a
	//   different FSx for OpenZFS file system. You can initiate this from the Amazon FSx
	//   console, API ( CopySnapshotAndUpdateVolume ), or CLI (
	//   copy-snapshot-and-update-volume ).
	//
	// [Managing storage capacity]: https://docs.aws.amazon.com/fsx/latest/LustreGuide/managing-storage-capacity.html
	// [AssociateFileSystemAliases]: https://docs.aws.amazon.com/fsx/latest/APIReference/API_AssociateFileSystemAliases.html
	// [DisassociateFileSystemAliases]: https://docs.aws.amazon.com/fsx/latest/APIReference/API_DisassociateFileSystemAliases.html
	// [Managing provisioned SSD IOPS]: https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-provisioned-ssd-iops.html
	// [Managing throughput capacity]: https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-throughput-capacity.html
	// [Managing storage capacity and provisioned IOPS]: https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/managing-storage-capacity.html
	AdministrativeActionType AdministrativeActionType

	// Provides information about a failed administrative action.
	FailureDetails *AdministrativeActionFailureDetails

	// The percentage-complete status of a STORAGE_OPTIMIZATION or
	// DOWNLOAD_DATA_FROM_BACKUP administrative action. Does not apply to any other
	// administrative action type.
	ProgressPercent *int32

	// The remaining bytes to transfer for the FSx for OpenZFS snapshot that you're
	// copying.
	RemainingTransferBytes *int64

	// The time that the administrative action request was received.
	RequestTime *time.Time

	// The status of the administrative action, as follows:
	//
	//   - FAILED - Amazon FSx failed to process the administrative action successfully.
	//
	//   - IN_PROGRESS - Amazon FSx is processing the administrative action.
	//
	//   - PENDING - Amazon FSx is waiting to process the administrative action.
	//
	//   - COMPLETED - Amazon FSx has finished processing the administrative task.
	//
	// For a backup restore to a second-generation FSx for ONTAP file system,
	//   indicates that all data has been downloaded to the volume, and clients now have
	//   read-write access to volume.
	//
	//   - UPDATED_OPTIMIZING - For a storage-capacity increase update, Amazon FSx has
	//   updated the file system with the new storage capacity, and is now performing the
	//   storage-optimization process.
	//
	//   - PENDING - For a backup restore to a second-generation FSx for ONTAP file
	//   system, indicates that the file metadata is being downloaded onto the volume.
	//   The volume's Lifecycle state is CREATING.
	//
	//   - IN_PROGRESS - For a backup restore to a second-generation FSx for ONTAP file
	//   system, indicates that all metadata has been downloaded to the new volume and
	//   client can access data with read-only access while Amazon FSx downloads the file
	//   data to the volume. Track the progress of this process with the
	//   ProgressPercent element.
	Status Status

	// The target value for the administration action, provided in the UpdateFileSystem
	// operation. Returned for FILE_SYSTEM_UPDATE administrative actions.
	TargetFileSystemValues *FileSystem

	// A snapshot of an Amazon FSx for OpenZFS volume.
	TargetSnapshotValues *Snapshot

	// Describes an Amazon FSx volume.
	TargetVolumeValues *Volume

	// The number of bytes that have transferred for the FSx for OpenZFS snapshot that
	// you're copying.
	TotalTransferBytes *int64

	noSmithyDocumentSerde
}

// Provides information about a failed administrative action.
type AdministrativeActionFailureDetails struct {

	// Error message providing details about the failed administrative action.
	Message *string

	noSmithyDocumentSerde
}

// Used to specify configuration options for a volume’s storage aggregate or
// aggregates.
type AggregateConfiguration struct {

	// The list of aggregates that this volume resides on. Aggregates are storage
	// pools which make up your primary storage tier. Each high-availability (HA) pair
	// has one aggregate. The names of the aggregates map to the names of the
	// aggregates in the ONTAP CLI and REST API. For FlexVols, there will always be a
	// single entry.
	//
	// Amazon FSx responds with an HTTP status code 400 (Bad Request) for the
	// following conditions:
	//
	//   - The strings in the value of Aggregates are not are not formatted as aggrX ,
	//   where X is a number between 1 and 12.
	//
	//   - The value of Aggregates contains aggregates that are not present.
	//
	//   - One or more of the aggregates supplied are too close to the volume limit to
	//   support adding more volumes.
	Aggregates []string

	// The total number of constituents this FlexGroup volume has. Not applicable for
	// FlexVols.
	TotalConstituents *int32

	noSmithyDocumentSerde
}

// A DNS alias that is associated with the file system. You can use a DNS alias to
// access a file system using user-defined DNS names, in addition to the default
// DNS name that Amazon FSx assigns to the file system. For more information, see [DNS aliases]
// in the FSx for Windows File Server User Guide.
//
// [DNS aliases]: https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-dns-aliases.html
type Alias struct {

	// Describes the state of the DNS alias.
	//
	//   - AVAILABLE - The DNS alias is associated with an Amazon FSx file system.
	//
	//   - CREATING - Amazon FSx is creating the DNS alias and associating it with the
	//   file system.
	//
	//   - CREATE_FAILED - Amazon FSx was unable to associate the DNS alias with the
	//   file system.
	//
	//   - DELETING - Amazon FSx is disassociating the DNS alias from the file system
	//   and deleting it.
	//
	//   - DELETE_FAILED - Amazon FSx was unable to disassociate the DNS alias from
	//   the file system.
	Lifecycle AliasLifecycle

	// The name of the DNS alias. The alias name has to meet the following
	// requirements:
	//
	//   - Formatted as a fully-qualified domain name (FQDN), hostname.domain , for
	//   example, accounting.example.com .
	//
	//   - Can contain alphanumeric characters, the underscore (_), and the hyphen (-).
	//
	//   - Cannot start or end with a hyphen.
	//
	//   - Can start with a numeric.
	//
	// For DNS names, Amazon FSx stores alphabetic characters as lowercase letters
	// (a-z), regardless of how you specify them: as uppercase letters, lowercase
	// letters, or the corresponding letters in escape codes.
	Name *string

	noSmithyDocumentSerde
}

// Sets the autocommit period of files in an FSx for ONTAP SnapLock volume, which
// determines how long the files must remain unmodified before they're
// automatically transitioned to the write once, read many (WORM) state.
//
// For more information, see [Autocommit].
//
// [Autocommit]: https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/worm-state.html#worm-state-autocommit
type AutocommitPeriod struct {

	// Defines the type of time for the autocommit period of a file in an FSx for
	// ONTAP SnapLock volume. Setting this value to NONE disables autocommit. The
	// default value is NONE .
	//
	// This member is required.
	Type AutocommitPeriodType

	// Defines the amount of time for the autocommit period of a file in an FSx for
	// ONTAP SnapLock volume. The following ranges are valid:
	//
	//   - Minutes : 5 - 65,535
	//
	//   - Hours : 1 - 65,535
	//
	//   - Days : 1 - 3,650
	//
	//   - Months : 1 - 120
	//
	//   - Years : 1 - 10
	Value *int32

	noSmithyDocumentSerde
}

// Describes a data repository association's automatic export policy. The
// AutoExportPolicy defines the types of updated objects on the file system that
// will be automatically exported to the data repository. As you create, modify, or
// delete files, Amazon FSx for Lustre automatically exports the defined changes
// asynchronously once your application finishes modifying the file.
//
// The AutoExportPolicy is only supported on Amazon FSx for Lustre file systems
// with a data repository association.
type AutoExportPolicy struct {

	// The AutoExportPolicy can have the following event values:
	//
	//   - NEW - New files and directories are automatically exported to the data
	//   repository as they are added to the file system.
	//
	//   - CHANGED - Changes to files and directories on the file system are
	//   automatically exported to the data repository.
	//
	//   - DELETED - Files and directories are automatically deleted on the data
	//   repository when they are deleted on the file system.
	//
	// You can define any combination of event types for your AutoExportPolicy .
	Events []EventType

	noSmithyDocumentSerde
}

// Describes the data repository association's automatic import policy. The
// AutoImportPolicy defines how Amazon FSx keeps your file metadata and directory
// listings up to date by importing changes to your Amazon FSx for Lustre file
// system as you modify objects in a linked S3 bucket.
//
// The AutoImportPolicy is only supported on Amazon FSx for Lustre file systems
// with a data repository association.
type AutoImportPolicy struct {

	// The AutoImportPolicy can have the following event values:
	//
	//   - NEW - Amazon FSx automatically imports metadata of files added to the linked
	//   S3 bucket that do not currently exist in the FSx file system.
	//
	//   - CHANGED - Amazon FSx automatically updates file metadata and invalidates
	//   existing file content on the file system as files change in the data repository.
	//
	//   - DELETED - Amazon FSx automatically deletes files on the file system as
	//   corresponding files are deleted in the data repository.
	//
	// You can define any combination of event types for your AutoImportPolicy .
	Events []EventType

	noSmithyDocumentSerde
}

// A backup of an Amazon FSx for Windows File Server, Amazon FSx for Lustre file
// system, Amazon FSx for NetApp ONTAP volume, or Amazon FSx for OpenZFS file
// system.
type Backup struct {

	// The ID of the backup.
	//
	// This member is required.
	BackupId *string

	// The time when a particular backup was created.
	//
	// This member is required.
	CreationTime *time.Time

	// The metadata of the file system associated with the backup. This metadata is
	// persisted even if the file system is deleted.
	//
	// This member is required.
	FileSystem *FileSystem

	// The lifecycle status of the backup.
	//
	//   - AVAILABLE - The backup is fully available.
	//
	//   - PENDING - For user-initiated backups on Lustre file systems only; Amazon FSx
	//   hasn't started creating the backup.
	//
	//   - CREATING - Amazon FSx is creating the backup.
	//
	//   - TRANSFERRING - For user-initiated backups on Lustre file systems only;
	//   Amazon FSx is transferring the backup to Amazon S3.
	//
	//   - COPYING - Amazon FSx is copying the backup.
	//
	//   - DELETED - Amazon FSx deleted the backup and it's no longer available.
	//
	//   - FAILED - Amazon FSx couldn't finish the backup.
	//
	// This member is required.
	Lifecycle BackupLifecycle

	// The type of the file-system backup.
	//
	// This member is required.
	Type BackupType

	// The configuration of the self-managed Microsoft Active Directory directory to
	// which the Windows File Server instance is joined.
	DirectoryInformation *ActiveDirectoryBackupAttributes

	// Details explaining any failures that occurred when creating a backup.
	FailureDetails *BackupFailureDetails

	// The ID of the Key Management Service (KMS) key used to encrypt the backup of
	// the Amazon FSx file system's data at rest.
	KmsKeyId *string

	// An Amazon Web Services account ID. This ID is a 12-digit number that you use to
	// construct Amazon Resource Names (ARNs) for resources.
	OwnerId *string

	// Displays the current percent of progress of an asynchronous task.
	ProgressPercent *int32

	// The Amazon Resource Name (ARN) for the backup resource.
	ResourceARN *string

	// Specifies the resource type that's backed up.
	ResourceType ResourceType

	//  The size of the backup in bytes. This represents the amount of data that the
	// file system would contain if you restore this backup.
	SizeInBytes *int64

	// The ID of the source backup. Specifies the backup that you are copying.
	SourceBackupId *string

	// The source Region of the backup. Specifies the Region from where this backup is
	// copied.
	SourceBackupRegion *string

	// The tags associated with a particular file system.
	Tags []Tag

	// Describes an Amazon FSx volume.
	Volume *Volume

	noSmithyDocumentSerde
}

// If backup creation fails, this structure contains the details of that failure.
type BackupFailureDetails struct {

	// A message describing the backup-creation failure.
	Message *string

	noSmithyDocumentSerde
}

// Provides a report detailing the data repository task results of the files
// processed that match the criteria specified in the report Scope parameter. FSx
// delivers the report to the file system's linked data repository in Amazon S3,
// using the path specified in the report Path parameter. You can specify whether
// or not a report gets generated for a task using the Enabled parameter.
type CompletionReport struct {

	// Set Enabled to True to generate a CompletionReport when the task completes. If
	// set to true , then you need to provide a report Scope , Path , and Format . Set
	// Enabled to False if you do not want a CompletionReport generated when the task
	// completes.
	//
	// This member is required.
	Enabled *bool

	// Required if Enabled is set to true . Specifies the format of the
	// CompletionReport . REPORT_CSV_20191124 is the only format currently supported.
	// When Format is set to REPORT_CSV_20191124 , the CompletionReport is provided in
	// CSV format, and is delivered to {path}/task-{id}/failures.csv .
	Format ReportFormat

	// Required if Enabled is set to true . Specifies the location of the report on the
	// file system's linked S3 data repository. An absolute path that defines where the
	// completion report will be stored in the destination location. The Path you
	// provide must be located within the file system’s ExportPath. An example Path
	// value is "s3://amzn-s3-demo-bucket/myExportPath/optionalPrefix". The report
	// provides the following information for each file in the report: FilePath,
	// FileStatus, and ErrorCode.
	Path *string

	// Required if Enabled is set to true . Specifies the scope of the CompletionReport
	// ; FAILED_FILES_ONLY is the only scope currently supported. When Scope is set to
	// FAILED_FILES_ONLY , the CompletionReport only contains information about files
	// that the data repository task failed to process.
	Scope ReportScope

	noSmithyDocumentSerde
}

// Used to specify the configuration options for an FSx for ONTAP volume's storage
// aggregate or aggregates.
type CreateAggregateConfiguration struct {

	// Used to specify the names of aggregates on which the volume will be created.
	Aggregates []string

	// Used to explicitly set the number of constituents within the FlexGroup per
	// storage aggregate. This field is optional when creating a FlexGroup volume. If
	// unspecified, the default value will be 8. This field cannot be provided when
	// creating a FlexVol volume.
	ConstituentsPerAggregate *int32

	noSmithyDocumentSerde
}

// The Amazon File Cache configuration for the cache that you are creating.
type CreateFileCacheLustreConfiguration struct {

	// Specifies the cache deployment type, which must be CACHE_1 .
	//
	// This member is required.
	DeploymentType FileCacheLustreDeploymentType

	// The configuration for a Lustre MDT (Metadata Target) storage volume.
	//
	// This member is required.
	MetadataConfiguration *FileCacheLustreMetadataConfiguration

	// Provisions the amount of read and write throughput for each 1 tebibyte (TiB) of
	// cache storage capacity, in MB/s/TiB. The only supported value is 1000 .
	//
	// This member is required.
	PerUnitStorageThroughput *int32

	// A recurring weekly time, in the format D:HH:MM .
	//
	// D is the day of the week, for which 1 represents Monday and 7 represents
	// Sunday. For further details, see [the ISO-8601 spec as described on Wikipedia].
	//
	// HH is the zero-padded hour of the day (0-23), and MM is the zero-padded minute
	// of the hour.
	//
	// For example, 1:05:00 specifies maintenance at 5 AM Monday.
	//
	// [the ISO-8601 spec as described on Wikipedia]: https://en.wikipedia.org/wiki/ISO_week_date
	WeeklyMaintenanceStartTime *string

	noSmithyDocumentSerde
}

// The Lustre configuration for the file system being created.
//
// The following parameters are not supported for file systems with a data
// repository association created with .
//
//   - AutoImportPolicy
//
//   - ExportPath
//
//   - ImportedFileChunkSize
//
//   - ImportPath
type CreateFileSystemLustreConfiguration struct {

	//  (Optional) When you create your file system, your existing S3 objects appear
	// as file and directory listings. Use this parameter to choose how Amazon FSx
	// keeps your file and directory listings up to date as you add or modify objects
	// in your linked S3 bucket. AutoImportPolicy can have the following values:
	//
	//   - NONE - (Default) AutoImport is off. Amazon FSx only updates file and
	//   directory listings from the linked S3 bucket when the file system is created.
	//   FSx does not update file and directory listings for any new or changed objects
	//   after choosing this option.
	//
	//   - NEW - AutoImport is on. Amazon FSx automatically imports directory listings
	//   of any new objects added to the linked S3 bucket that do not currently exist in
	//   the FSx file system.
	//
	//   - NEW_CHANGED - AutoImport is on. Amazon FSx automatically imports file and
	//   directory listings of any new objects added to the S3 bucket and any existing
	//   objects that are changed in the S3 bucket after you choose this option.
	//
	//   - NEW_CHANGED_DELETED - AutoImport is on. Amazon FSx automatically imports
	//   file and directory listings of any new objects added to the S3 bucket, any
	//   existing objects that are changed in the S3 bucket, and any objects that were
	//   deleted in the S3 bucket.
	//
	// For more information, see [Automatically import updates from your S3 bucket].
	//
	// This parameter is not supported for file systems with a data repository
	// association.
	//
	// [Automatically import updates from your S3 bucket]: https://docs.aws.amazon.com/fsx/latest/LustreGuide/older-deployment-types.html#legacy-auto-import-from-s3
	AutoImportPolicy AutoImportPolicyType

	// The number of days to retain automatic backups. Setting this property to 0
	// disables automatic backups. You can retain automatic backups for a maximum of 90
	// days. The default is 0 .
	AutomaticBackupRetentionDays *int32

	// (Optional) Not available for use with file systems that are linked to a data
	// repository. A boolean flag indicating whether tags for the file system should be
	// copied to backups. The default value is false. If CopyTagsToBackups is set to
	// true, all file system tags are copied to all automatic and user-initiated
	// backups when the user doesn't specify any backup-specific tags. If
	// CopyTagsToBackups is set to true and you specify one or more backup tags, only
	// the specified tags are copied to backups. If you specify one or more tags when
	// creating a user-initiated backup, no tags are copied from the file system,
	// regardless of this value.
	//
	// (Default = false )
	//
	// For more information, see [Working with backups] in the Amazon FSx for Lustre User Guide.
	//
	// [Working with backups]: https://docs.aws.amazon.com/fsx/latest/LustreGuide/using-backups-fsx.html
	CopyTagsToBackups *bool

	// A recurring daily time, in the format HH:MM . HH is the zero-padded hour of the
	// day (0-23), and MM is the zero-padded minute of the hour. For example, 05:00
	// specifies 5 AM daily.
	DailyAutomaticBackupStartTime *string

	// Sets the data compression configuration for the file system. DataCompressionType
	// can have the following values:
	//
	//   - NONE - (Default) Data compression is turned off when the file system is
	//   created.
	//
	//   - LZ4 - Data compression is turned on with the LZ4 algorithm.
	//
	// For more information, see [Lustre data compression] in the Amazon FSx for Lustre User Guide.
	//
	// [Lustre data compression]: https://docs.aws.amazon.com/fsx/latest/LustreGuide/data-compression.html
	DataCompressionType DataCompressionType

	// (Optional) Choose SCRATCH_1 and SCRATCH_2 deployment types when you need
	// temporary storage and shorter-term processing of data. The SCRATCH_2 deployment
	// type provides in-transit encryption of data and higher burst throughput capacity
	// than SCRATCH_1 .
	//
	// Choose PERSISTENT_1 for longer-term storage and for throughput-focused
	// workloads that aren’t latency-sensitive. PERSISTENT_1 supports encryption of
	// data in transit, and is available in all Amazon Web Services Regions in which
	// FSx for Lustre is available.
	//
	// Choose PERSISTENT_2 for longer-term storage and for latency-sensitive workloads
	// that require the highest levels of IOPS/throughput. PERSISTENT_2 supports SSD
	// storage, and offers higher PerUnitStorageThroughput (up to 1000 MB/s/TiB). You
	// can optionally specify a metadata configuration mode for PERSISTENT_2 which
	// supports increasing metadata performance. PERSISTENT_2 is available in a
	// limited number of Amazon Web Services Regions. For more information, and an
	// up-to-date list of Amazon Web Services Regions in which PERSISTENT_2 is
	// available, see [File system deployment options for FSx for Lustre]in the Amazon FSx for Lustre User Guide.
	//
	// If you choose PERSISTENT_2 , and you set FileSystemTypeVersion to 2.10 , the
	// CreateFileSystem operation fails.
	//
	// Encryption of data in transit is automatically turned on when you access
	// SCRATCH_2 , PERSISTENT_1 , and PERSISTENT_2 file systems from Amazon EC2
	// instances that support automatic encryption in the Amazon Web Services Regions
	// where they are available. For more information about encryption in transit for
	// FSx for Lustre file systems, see [Encrypting data in transit]in the Amazon FSx for Lustre User Guide.
	//
	// (Default = SCRATCH_1 )
	//
	// [File system deployment options for FSx for Lustre]: https://docs.aws.amazon.com/fsx/latest/LustreGuide/using-fsx-lustre.html#lustre-deployment-types
	// [Encrypting data in transit]: https://docs.aws.amazon.com/fsx/latest/LustreGuide/encryption-in-transit-fsxl.html
	DeploymentType LustreDeploymentType

	// The type of drive cache used by PERSISTENT_1 file systems that are provisioned
	// with HDD storage devices. This parameter is required when storage type is HDD.
	// Set this property to READ to improve the performance for frequently accessed
	// files by caching up to 20% of the total storage capacity of the file system.
	//
	// This parameter is required when StorageType is set to HDD .
	DriveCacheType DriveCacheType

	// (Optional) Specifies whether Elastic Fabric Adapter (EFA) and GPUDirect Storage
	// (GDS) support is enabled for the Amazon FSx for Lustre file system.
	//
	// (Default = false )
	EfaEnabled *bool

	// (Optional) Specifies the path in the Amazon S3 bucket where the root of your
	// Amazon FSx file system is exported. The path must use the same Amazon S3 bucket
	// as specified in ImportPath. You can provide an optional prefix to which new and
	// changed data is to be exported from your Amazon FSx for Lustre file system. If
	// an ExportPath value is not provided, Amazon FSx sets a default export path,
	// s3://import-bucket/FSxLustre[creation-timestamp] . The timestamp is in UTC
	// format, for example s3://import-bucket/FSxLustre20181105T222312Z .
	//
	// The Amazon S3 export bucket must be the same as the import bucket specified by
	// ImportPath . If you specify only a bucket name, such as s3://import-bucket , you
	// get a 1:1 mapping of file system objects to S3 bucket objects. This mapping
	// means that the input data in S3 is overwritten on export. If you provide a
	// custom prefix in the export path, such as
	// s3://import-bucket/[custom-optional-prefix] , Amazon FSx exports the contents of
	// your file system to that export prefix in the Amazon S3 bucket.
	//
	// This parameter is not supported for file systems with a data repository
	// association.
	ExportPath *string

	// (Optional) The path to the Amazon S3 bucket (including the optional prefix)
	// that you're using as the data repository for your Amazon FSx for Lustre file
	// system. The root of your FSx for Lustre file system will be mapped to the root
	// of the Amazon S3 bucket you select. An example is
	// s3://import-bucket/optional-prefix . If you specify a prefix after the Amazon S3
	// bucket name, only object keys with that prefix are loaded into the file system.
	//
	// This parameter is not supported for file systems with a data repository
	// association.
	ImportPath *string

	// (Optional) For files imported from a data repository, this value determines the
	// stripe count and maximum amount of data per file (in MiB) stored on a single
	// physical disk. The maximum number of disks that a single file can be striped
	// across is limited by the total number of disks that make up the file system.
	//
	// The default chunk size is 1,024 MiB (1 GiB) and can go as high as 512,000 MiB
	// (500 GiB). Amazon S3 objects have a maximum size of 5 TB.
	//
	// This parameter is not supported for file systems with a data repository
	// association.
	ImportedFileChunkSize *int32

	// The Lustre logging configuration used when creating an Amazon FSx for Lustre
	// file system. When logging is enabled, Lustre logs error and warning events for
	// data repositories associated with your file system to Amazon CloudWatch Logs.
	LogConfiguration *LustreLogCreateConfiguration

	// The Lustre metadata performance configuration for the creation of an FSx for
	// Lustre file system using a PERSISTENT_2 deployment type.
	MetadataConfiguration *CreateFileSystemLustreMetadataConfiguration

	// Required with PERSISTENT_1 and PERSISTENT_2 deployment types, provisions the
	// amount of read and write throughput for each 1 tebibyte (TiB) of file system
	// storage capacity, in MB/s/TiB. File system throughput capacity is calculated by
	// multiplying ﬁle system storage capacity (TiB) by the PerUnitStorageThroughput
	// (MB/s/TiB). For a 2.4-TiB ﬁle system, provisioning 50 MB/s/TiB of
	// PerUnitStorageThroughput yields 120 MB/s of ﬁle system throughput. You pay for
	// the amount of throughput that you provision.
	//
	// Valid values:
	//
	//   - For PERSISTENT_1 SSD storage: 50, 100, 200 MB/s/TiB.
	//
	//   - For PERSISTENT_1 HDD storage: 12, 40 MB/s/TiB.
	//
	//   - For PERSISTENT_2 SSD storage: 125, 250, 500, 1000 MB/s/TiB.
	PerUnitStorageThroughput *int32

	// The Lustre root squash configuration used when creating an Amazon FSx for
	// Lustre file system. When enabled, root squash restricts root-level access from
	// clients that try to access your file system as a root user.
	RootSquashConfiguration *LustreRootSquashConfiguration

	// (Optional) The preferred start time to perform weekly maintenance, formatted
	// d:HH:MM in the UTC time zone, where d is the weekday number, from 1 through 7,
	// beginning with Monday and ending with Sunday.
	WeeklyMaintenanceStartTime *string

	noSmithyDocumentSerde
}

// The Lustre metadata performance configuration for the creation of an Amazon FSx
// for Lustre file system using a PERSISTENT_2 deployment type. The configuration
// uses a Metadata IOPS value to set the maximum rate of metadata disk IOPS
// supported by the file system.
//
// After creation, the file system supports increasing metadata performance. For
// more information on Metadata IOPS, see [Lustre metadata performance configuration]in the Amazon FSx for Lustre User Guide.
//
// [Lustre metadata performance configuration]: https://docs.aws.amazon.com/fsx/latest/LustreGuide/managing-metadata-performance.html#metadata-configuration
type CreateFileSystemLustreMetadataConfiguration struct {

	// The metadata configuration mode for provisioning Metadata IOPS for an FSx for
	// Lustre file system using a PERSISTENT_2 deployment type.
	//
	//   - In AUTOMATIC mode, FSx for Lustre automatically provisions and scales the
	//   number of Metadata IOPS for your file system based on your file system storage
	//   capacity.
	//
	//   - In USER_PROVISIONED mode, you specify the number of Metadata IOPS to
	//   provision for your file system.
	//
	// This member is required.
	Mode MetadataConfigurationMode

	// (USER_PROVISIONED mode only) Specifies the number of Metadata IOPS to provision
	// for the file system. This parameter sets the maximum rate of metadata disk IOPS
	// supported by the file system. Valid values are 1500 , 3000 , 6000 , 12000 , and
	// multiples of 12000 up to a maximum of 192000 .
	//
	// Iops doesn’t have a default value. If you're using USER_PROVISIONED mode, you
	// can choose to specify a valid value. If you're using AUTOMATIC mode, you cannot
	// specify a value because FSx for Lustre automatically sets the value based on
	// your file system storage capacity.
	Iops *int32

	noSmithyDocumentSerde
}

// The ONTAP configuration properties of the FSx for ONTAP file system that you
// are creating.
type CreateFileSystemOntapConfiguration struct {

	// Specifies the FSx for ONTAP file system deployment type to use in creating the
	// file system.
	//
	//   - MULTI_AZ_1 - A high availability file system configured for Multi-AZ
	//   redundancy to tolerate temporary Availability Zone (AZ) unavailability. This is
	//   a first-generation FSx for ONTAP file system.
	//
	//   - MULTI_AZ_2 - A high availability file system configured for Multi-AZ
	//   redundancy to tolerate temporary AZ unavailability. This is a second-generation
	//   FSx for ONTAP file system.
	//
	//   - SINGLE_AZ_1 - A file system configured for Single-AZ redundancy. This is a
	//   first-generation FSx for ONTAP file system.
	//
	//   - SINGLE_AZ_2 - A file system configured with multiple high-availability (HA)
	//   pairs for Single-AZ redundancy. This is a second-generation FSx for ONTAP file
	//   system.
	//
	// For information about the use cases for Multi-AZ and Single-AZ deployments,
	// refer to [Choosing a file system deployment type].
	//
	// [Choosing a file system deployment type]: https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/high-availability-AZ.html
	//
	// This member is required.
	DeploymentType OntapDeploymentType

	// The number of days to retain automatic backups. Setting this property to 0
	// disables automatic backups. You can retain automatic backups for a maximum of 90
	// days. The default is 30 .
	AutomaticBackupRetentionDays *int32

	// A recurring daily time, in the format HH:MM . HH is the zero-padded hour of the
	// day (0-23), and MM is the zero-padded minute of the hour. For example, 05:00
	// specifies 5 AM daily.
	DailyAutomaticBackupStartTime *string

	// The SSD IOPS configuration for the FSx for ONTAP file system.
	DiskIopsConfiguration *DiskIopsConfiguration

	// (Multi-AZ only) Specifies the IP address range in which the endpoints to access
	// your file system will be created. By default in the Amazon FSx API, Amazon FSx
	// selects an unused IP address range for you from the 198.19.* range. By default
	// in the Amazon FSx console, Amazon FSx chooses the last 64 IP addresses from the
	// VPC’s primary CIDR range to use as the endpoint IP address range for the file
	// system. You can have overlapping endpoint IP addresses for file systems deployed
	// in the same VPC/route tables, as long as they don't overlap with any subnet.
	EndpointIpAddressRange *string

	// The ONTAP administrative password for the fsxadmin user with which you
	// administer your file system using the NetApp ONTAP CLI and REST API.
	FsxAdminPassword *string

	// Specifies how many high-availability (HA) pairs of file servers will power your
	// file system. First-generation file systems are powered by 1 HA pair.
	// Second-generation multi-AZ file systems are powered by 1 HA pair. Second
	// generation single-AZ file systems are powered by up to 12 HA pairs. The default
	// value is 1. The value of this property affects the values of StorageCapacity ,
	// Iops , and ThroughputCapacity . For more information, see [High-availability (HA) pairs] in the FSx for ONTAP
	// user guide. Block storage protocol support (iSCSI and NVMe over TCP) is disabled
	// on file systems with more than 6 HA pairs. For more information, see [Using block storage protocols].
	//
	// Amazon FSx responds with an HTTP status code 400 (Bad Request) for the
	// following conditions:
	//
	//   - The value of HAPairs is less than 1 or greater than 12.
	//
	//   - The value of HAPairs is greater than 1 and the value of DeploymentType is
	//   SINGLE_AZ_1 , MULTI_AZ_1 , or MULTI_AZ_2 .
	//
	// [Using block storage protocols]: https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/supported-fsx-clients.html#using-block-storage
	// [High-availability (HA) pairs]: https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/administering-file-systems.html#HA-pairs
	HAPairs *int32

	// Required when DeploymentType is set to MULTI_AZ_1 or MULTI_AZ_2 . This specifies
	// the subnet in which you want the preferred file server to be located.
	PreferredSubnetId *string

	// (Multi-AZ only) Specifies the route tables in which Amazon FSx creates the
	// rules for routing traffic to the correct file server. You should specify all
	// virtual private cloud (VPC) route tables associated with the subnets in which
	// your clients are located. By default, Amazon FSx selects your VPC's default
	// route table.
	//
	// Amazon FSx manages these route tables for Multi-AZ file systems using tag-based
	// authentication. These route tables are tagged with Key: AmazonFSx; Value:
	// ManagedByAmazonFSx . When creating FSx for ONTAP Multi-AZ file systems using
	// CloudFormation we recommend that you add the Key: AmazonFSx; Value:
	// ManagedByAmazonFSx tag manually.
	RouteTableIds []string

	// Sets the throughput capacity for the file system that you're creating in
	// megabytes per second (MBps). For more information, see [Managing throughput capacity]in the FSx for ONTAP
	// User Guide.
	//
	// Amazon FSx responds with an HTTP status code 400 (Bad Request) for the
	// following conditions:
	//
	//   - The value of ThroughputCapacity and ThroughputCapacityPerHAPair are not the
	//   same value.
	//
	//   - The value of ThroughputCapacity when divided by the value of HAPairs is
	//   outside of the valid range for ThroughputCapacity .
	//
	// [Managing throughput capacity]: https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/managing-throughput-capacity.html
	ThroughputCapacity *int32

	// Use to choose the throughput capacity per HA pair, rather than the total
	// throughput for the file system.
	//
	// You can define either the ThroughputCapacityPerHAPair or the ThroughputCapacity
	// when creating a file system, but not both.
	//
	// This field and ThroughputCapacity are the same for file systems powered by one
	// HA pair.
	//
	//   - For SINGLE_AZ_1 and MULTI_AZ_1 file systems, valid values are 128, 256, 512,
	//   1024, 2048, or 4096 MBps.
	//
	//   - For SINGLE_AZ_2 , valid values are 1536, 3072, or 6144 MBps.
	//
	//   - For MULTI_AZ_2 , valid values are 384, 768, 1536, 3072, or 6144 MBps.
	//
	// Amazon FSx responds with an HTTP status code 400 (Bad Request) for the
	// following conditions:
	//
	//   - The value of ThroughputCapacity and ThroughputCapacityPerHAPair are not the
	//   same value for file systems with one HA pair.
	//
	//   - The value of deployment type is SINGLE_AZ_2 and ThroughputCapacity /
	//   ThroughputCapacityPerHAPair is not a valid HA pair (a value between 1 and 12).
	//
	//   - The value of ThroughputCapacityPerHAPair is not a valid value.
	ThroughputCapacityPerHAPair *int32

	// A recurring weekly time, in the format D:HH:MM .
	//
	// D is the day of the week, for which 1 represents Monday and 7 represents
	// Sunday. For further details, see [the ISO-8601 spec as described on Wikipedia].
	//
	// HH is the zero-padded hour of the day (0-23), and MM is the zero-padded minute
	// of the hour.
	//
	// For example, 1:05:00 specifies maintenance at 5 AM Monday.
	//
	// [the ISO-8601 spec as described on Wikipedia]: https://en.wikipedia.org/wiki/ISO_week_date
	WeeklyMaintenanceStartTime *string

	noSmithyDocumentSerde
}

// The Amazon FSx for OpenZFS configuration properties for the file system that
// you are creating.
type CreateFileSystemOpenZFSConfiguration struct {

	// Specifies the file system deployment type. Valid values are the following:
	//
	//   - MULTI_AZ_1 - Creates file systems with high availability and durability by
	//   replicating your data and supporting failover across multiple Availability Zones
	//   in the same Amazon Web Services Region.
	//
	//   - SINGLE_AZ_HA_2 - Creates file systems with high availability and throughput
	//   capacities of 160 - 10,240 MB/s using an NVMe L2ARC cache by deploying a primary
	//   and standby file system within the same Availability Zone.
	//
	//   - SINGLE_AZ_HA_1 - Creates file systems with high availability and throughput
	//   capacities of 64 - 4,096 MB/s by deploying a primary and standby file system
	//   within the same Availability Zone.
	//
	//   - SINGLE_AZ_2 - Creates file systems with throughput capacities of 160 -
	//   10,240 MB/s using an NVMe L2ARC cache that automatically recover within a single
	//   Availability Zone.
	//
	//   - SINGLE_AZ_1 - Creates file systems with throughput capacities of 64 - 4,096
	//   MBs that automatically recover within a single Availability Zone.
	//
	// For a list of which Amazon Web Services Regions each deployment type is
	// available in, see [Deployment type availability]. For more information on the differences in performance
	// between deployment types, see [File system performance]in the Amazon FSx for OpenZFS User Guide.
	//
	// [Deployment type availability]: https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/availability-durability.html#available-aws-regions
	// [File system performance]: https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/performance.html#zfs-fs-performance
	//
	// This member is required.
	DeploymentType OpenZFSDeploymentType

	// Specifies the throughput of an Amazon FSx for OpenZFS file system, measured in
	// megabytes per second (MBps). Valid values depend on the DeploymentType you
	// choose, as follows:
	//
	//   - For MULTI_AZ_1 and SINGLE_AZ_2 , valid values are 160, 320, 640, 1280, 2560,
	//   3840, 5120, 7680, or 10240 MBps.
	//
	//   - For SINGLE_AZ_1 , valid values are 64, 128, 256, 512, 1024, 2048, 3072, or
	//   4096 MBps.
	//
	// You pay for additional throughput capacity that you provision.
	//
	// This member is required.
	ThroughputCapacity *int32

	// The number of days to retain automatic backups. Setting this property to 0
	// disables automatic backups. You can retain automatic backups for a maximum of 90
	// days. The default is 30 .
	AutomaticBackupRetentionDays *int32

	// A Boolean value indicating whether tags for the file system should be copied to
	// backups. This value defaults to false . If it's set to true , all tags for the
	// file system are copied to all automatic and user-initiated backups where the
	// user doesn't specify tags. If this value is true , and you specify one or more
	// tags, only the specified tags are copied to backups. If you specify one or more
	// tags when creating a user-initiated backup, no tags are copied from the file
	// system, regardless of this value.
	CopyTagsToBackups *bool

	// A Boolean value indicating whether tags for the file system should be copied to
	// volumes. This value defaults to false . If it's set to true , all tags for the
	// file system are copied to volumes where the user doesn't specify tags. If this
	// value is true , and you specify one or more tags, only the specified tags are
	// copied to volumes. If you specify one or more tags when creating the volume, no
	// tags are copied from the file system, regardless of this value.
	CopyTagsToVolumes *bool

	// A recurring daily time, in the format HH:MM . HH is the zero-padded hour of the
	// day (0-23), and MM is the zero-padded minute of the hour. For example, 05:00
	// specifies 5 AM daily.
	DailyAutomaticBackupStartTime *string

	// The SSD IOPS (input/output operations per second) configuration for an Amazon
	// FSx for NetApp ONTAP, Amazon FSx for Windows File Server, or FSx for OpenZFS
	// file system. By default, Amazon FSx automatically provisions 3 IOPS per GB of
	// storage capacity. You can provision additional IOPS per GB of storage. The
	// configuration consists of the total number of provisioned SSD IOPS and how it is
	// was provisioned, or the mode (by the customer or by Amazon FSx).
	DiskIopsConfiguration *DiskIopsConfiguration

	// (Multi-AZ only) Specifies the IP address range in which the endpoints to access
	// your file system will be created. By default in the Amazon FSx API and Amazon
	// FSx console, Amazon FSx selects an available /28 IP address range for you from
	// one of the VPC's CIDR ranges. You can have overlapping endpoint IP addresses for
	// file systems deployed in the same VPC/route tables.
	EndpointIpAddressRange *string

	// Required when DeploymentType is set to MULTI_AZ_1 . This specifies the subnet in
	// which you want the preferred file server to be located.
	PreferredSubnetId *string

	//  Specifies the optional provisioned SSD read cache on file systems that use the
	// Intelligent-Tiering storage class.
	ReadCacheConfiguration *OpenZFSReadCacheConfiguration

	// The configuration Amazon FSx uses when creating the root value of the Amazon
	// FSx for OpenZFS file system. All volumes are children of the root volume.
	RootVolumeConfiguration *OpenZFSCreateRootVolumeConfiguration

	// (Multi-AZ only) Specifies the route tables in which Amazon FSx creates the
	// rules for routing traffic to the correct file server. You should specify all
	// virtual private cloud (VPC) route tables associated with the subnets in which
	// your clients are located. By default, Amazon FSx selects your VPC's default
	// route table.
	RouteTableIds []string

	// A recurring weekly time, in the format D:HH:MM .
	//
	// D is the day of the week, for which 1 represents Monday and 7 represents
	// Sunday. For further details, see [the ISO-8601 spec as described on Wikipedia].
	//
	// HH is the zero-padded hour of the day (0-23), and MM is the zero-padded minute
	// of the hour.
	//
	// For example, 1:05:00 specifies maintenance at 5 AM Monday.
	//
	// [the ISO-8601 spec as described on Wikipedia]: https://en.wikipedia.org/wiki/ISO_week_date
	WeeklyMaintenanceStartTime *string

	noSmithyDocumentSerde
}

// The configuration object for the Microsoft Windows file system used in
// CreateFileSystem and CreateFileSystemFromBackup operations.
type CreateFileSystemWindowsConfiguration struct {

	// Sets the throughput capacity of an Amazon FSx file system, measured in
	// megabytes per second (MB/s), in 2 to the nth increments, between 2^3 (8) and
	// 2^11 (2048).
	//
	// This member is required.
	ThroughputCapacity *int32

	// The ID for an existing Amazon Web Services Managed Microsoft Active Directory
	// (AD) instance that the file system should join when it's created.
	ActiveDirectoryId *string

	// An array of one or more DNS alias names that you want to associate with the
	// Amazon FSx file system. Aliases allow you to use existing DNS names to access
	// the data in your Amazon FSx file system. You can associate up to 50 aliases with
	// a file system at any time. You can associate additional DNS aliases after you
	// create the file system using the AssociateFileSystemAliases operation. You can
	// remove DNS aliases from the file system after it is created using the
	// DisassociateFileSystemAliases operation. You only need to specify the alias name
	// in the request payload.
	//
	// For more information, see [Working with DNS Aliases] and [Walkthrough 5: Using DNS aliases to access your file system], including additional steps you must take to be
	// able to access your file system using a DNS alias.
	//
	// An alias name has to meet the following requirements:
	//
	//   - Formatted as a fully-qualified domain name (FQDN), hostname.domain , for
	//   example, accounting.example.com .
	//
	//   - Can contain alphanumeric characters, the underscore (_), and the hyphen (-).
	//
	//   - Cannot start or end with a hyphen.
	//
	//   - Can start with a numeric.
	//
	// For DNS alias names, Amazon FSx stores alphabetic characters as lowercase
	// letters (a-z), regardless of how you specify them: as uppercase letters,
	// lowercase letters, or the corresponding letters in escape codes.
	//
	// [Walkthrough 5: Using DNS aliases to access your file system]: https://docs.aws.amazon.com/fsx/latest/WindowsGuide/walkthrough05-file-system-custom-CNAME.html
	// [Working with DNS Aliases]: https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-dns-aliases.html
	Aliases []string

	// The configuration that Amazon FSx for Windows File Server uses to audit and log
	// user accesses of files, folders, and file shares on the Amazon FSx for Windows
	// File Server file system.
	AuditLogConfiguration *WindowsAuditLogCreateConfiguration

	// The number of days to retain automatic backups. Setting this property to 0
	// disables automatic backups. You can retain automatic backups for a maximum of 90
	// days. The default is 30 .
	AutomaticBackupRetentionDays *int32

	// A boolean flag indicating whether tags for the file system should be copied to
	// backups. This value defaults to false. If it's set to true, all tags for the
	// file system are copied to all automatic and user-initiated backups where the
	// user doesn't specify tags. If this value is true, and you specify one or more
	// tags, only the specified tags are copied to backups. If you specify one or more
	// tags when creating a user-initiated backup, no tags are copied from the file
	// system, regardless of this value.
	CopyTagsToBackups *bool

	// The preferred time to take daily automatic backups, formatted HH:MM in the UTC
	// time zone.
	DailyAutomaticBackupStartTime *string

	// Specifies the file system deployment type, valid values are the following:
	//
	//   - MULTI_AZ_1 - Deploys a high availability file system that is configured for
	//   Multi-AZ redundancy to tolerate temporary Availability Zone (AZ) unavailability.
	//   You can only deploy a Multi-AZ file system in Amazon Web Services Regions that
	//   have a minimum of three Availability Zones. Also supports HDD storage type
	//
	//   - SINGLE_AZ_1 - (Default) Choose to deploy a file system that is configured
	//   for single AZ redundancy.
	//
	//   - SINGLE_AZ_2 - The latest generation Single AZ file system. Specifies a file
	//   system that is configured for single AZ redundancy and supports HDD storage
	//   type.
	//
	// For more information, see [Availability and Durability: Single-AZ and Multi-AZ File Systems].
	//
	// [Availability and Durability: Single-AZ and Multi-AZ File Systems]: https://docs.aws.amazon.com/fsx/latest/WindowsGuide/high-availability-multiAZ.html
	DeploymentType WindowsDeploymentType

	// The SSD IOPS (input/output operations per second) configuration for an Amazon
	// FSx for Windows file system. By default, Amazon FSx automatically provisions 3
	// IOPS per GiB of storage capacity. You can provision additional IOPS per GiB of
	// storage, up to the maximum limit associated with your chosen throughput
	// capacity.
	DiskIopsConfiguration *DiskIopsConfiguration

	// Required when DeploymentType is set to MULTI_AZ_1 . This specifies the subnet in
	// which you want the preferred file server to be located. For in-Amazon Web
	// Services applications, we recommend that you launch your clients in the same
	// Availability Zone (AZ) as your preferred file server to reduce cross-AZ data
	// transfer costs and minimize latency.
	PreferredSubnetId *string

	// The configuration that Amazon FSx uses to join a FSx for Windows File Server
	// file system or an FSx for ONTAP storage virtual machine (SVM) to a self-managed
	// (including on-premises) Microsoft Active Directory (AD) directory. For more
	// information, see [Using Amazon FSx for Windows with your self-managed Microsoft Active Directory]or [Managing FSx for ONTAP SVMs].
	//
	// [Using Amazon FSx for Windows with your self-managed Microsoft Active Directory]: https://docs.aws.amazon.com/fsx/latest/WindowsGuide/self-managed-AD.html
	// [Managing FSx for ONTAP SVMs]: https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/managing-svms.html
	SelfManagedActiveDirectoryConfiguration *SelfManagedActiveDirectoryConfiguration

	// The preferred start time to perform weekly maintenance, formatted d:HH:MM in
	// the UTC time zone, where d is the weekday number, from 1 through 7, beginning
	// with Monday and ending with Sunday.
	WeeklyMaintenanceStartTime *string

	noSmithyDocumentSerde
}

// Specifies the configuration of the ONTAP volume that you are creating.
type CreateOntapVolumeConfiguration struct {

	// Specifies the ONTAP SVM in which to create the volume.
	//
	// This member is required.
	StorageVirtualMachineId *string

	// Use to specify configuration options for a volume’s storage aggregate or
	// aggregates.
	AggregateConfiguration *CreateAggregateConfiguration

	// A boolean flag indicating whether tags for the volume should be copied to
	// backups. This value defaults to false. If it's set to true, all tags for the
	// volume are copied to all automatic and user-initiated backups where the user
	// doesn't specify tags. If this value is true, and you specify one or more tags,
	// only the specified tags are copied to backups. If you specify one or more tags
	// when creating a user-initiated backup, no tags are copied from the volume,
	// regardless of this value.
	CopyTagsToBackups *bool

	// Specifies the location in the SVM's namespace where the volume is mounted. This
	// parameter is required. The JunctionPath must have a leading forward slash, such
	// as /vol3 .
	JunctionPath *string

	// Specifies the type of volume you are creating. Valid values are the following:
	//
	//   - RW specifies a read/write volume. RW is the default.
	//
	//   - DP specifies a data-protection volume. A DP volume is read-only and can be
	//   used as the destination of a NetApp SnapMirror relationship.
	//
	// For more information, see [Volume types] in the Amazon FSx for NetApp ONTAP User Guide.
	//
	// [Volume types]: https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/managing-volumes.html#volume-types
	OntapVolumeType InputOntapVolumeType

	// Specifies the security style for the volume. If a volume's security style is
	// not specified, it is automatically set to the root volume's security style. The
	// security style determines the type of permissions that FSx for ONTAP uses to
	// control data access. Specify one of the following values:
	//
	//   - UNIX if the file system is managed by a UNIX administrator, the majority of
	//   users are NFS clients, and an application accessing the data uses a UNIX user as
	//   the service account.
	//
	//   - NTFS if the file system is managed by a Windows administrator, the majority
	//   of users are SMB clients, and an application accessing the data uses a Windows
	//   user as the service account.
	//
	//   - MIXED This is an advanced setting. For more information, see the topic [What the security styles and their effects are]in
	//   the NetApp Documentation Center.
	//
	// For more information, see [Volume security style] in the FSx for ONTAP User Guide.
	//
	// [What the security styles and their effects are]: https://docs.netapp.com/us-en/ontap/nfs-admin/security-styles-their-effects-concept.html
	// [Volume security style]: https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/managing-volumes.html#volume-security-style
	SecurityStyle SecurityStyle

	// Specifies the configured size of the volume, in bytes.
	SizeInBytes *int64

	// Use SizeInBytes instead. Specifies the size of the volume, in megabytes (MB),
	// that you are creating.
	//
	// Deprecated: This property is deprecated, use SizeInBytes instead
	SizeInMegabytes *int32

	// Specifies the SnapLock configuration for an FSx for ONTAP volume.
	SnaplockConfiguration *CreateSnaplockConfiguration

	// Specifies the snapshot policy for the volume. There are three built-in snapshot
	// policies:
	//
	//   - default : This is the default policy. A maximum of six hourly snapshots
	//   taken five minutes past the hour. A maximum of two daily snapshots taken Monday
	//   through Saturday at 10 minutes after midnight. A maximum of two weekly snapshots
	//   taken every Sunday at 15 minutes after midnight.
	//
	//   - default-1weekly : This policy is the same as the default policy except that
	//   it only retains one snapshot from the weekly schedule.
	//
	//   - none : This policy does not take any snapshots. This policy can be assigned
	//   to volumes to prevent automatic snapshots from being taken.
	//
	// You can also provide the name of a custom policy that you created with the
	// ONTAP CLI or REST API.
	//
	// For more information, see [Snapshot policies] in the Amazon FSx for NetApp ONTAP User Guide.
	//
	// [Snapshot policies]: https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/snapshots-ontap.html#snapshot-policies
	SnapshotPolicy *string

	// Set to true to enable deduplication, compression, and compaction storage
	// efficiency features on the volume, or set to false to disable them.
	//
	// StorageEfficiencyEnabled is required when creating a RW volume ( OntapVolumeType
	// set to RW ).
	StorageEfficiencyEnabled *bool

	// Describes the data tiering policy for an ONTAP volume. When enabled, Amazon FSx
	// for ONTAP's intelligent tiering automatically transitions a volume's data
	// between the file system's primary storage and capacity pool storage based on
	// your access patterns.
	//
	// Valid tiering policies are the following:
	//
	//   - SNAPSHOT_ONLY - (Default value) moves cold snapshots to the capacity pool
	//   storage tier.
	//
	//   - AUTO - moves cold user data and snapshots to the capacity pool storage tier
	//   based on your access patterns.
	//
	//   - ALL - moves all user data blocks in both the active file system and Snapshot
	//   copies to the storage pool tier.
	//
	//   - NONE - keeps a volume's data in the primary storage tier, preventing it from
	//   being moved to the capacity pool tier.
	TieringPolicy *TieringPolicy

	// Use to specify the style of an ONTAP volume. FSx for ONTAP offers two styles of
	// volumes that you can use for different purposes, FlexVol and FlexGroup volumes.
	// For more information, see [Volume styles]in the Amazon FSx for NetApp ONTAP User Guide.
	//
	// [Volume styles]: https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/managing-volumes.html#volume-styles
	VolumeStyle VolumeStyle

	noSmithyDocumentSerde
}

// The snapshot configuration to use when creating an Amazon FSx for OpenZFS
// volume from a snapshot.
type CreateOpenZFSOriginSnapshotConfiguration struct {

	// Specifies the strategy used when copying data from the snapshot to the new
	// volume.
	//
	//   - CLONE - The new volume references the data in the origin snapshot. Cloning a
	//   snapshot is faster than copying data from the snapshot to a new volume and
	//   doesn't consume disk throughput. However, the origin snapshot can't be deleted
	//   if there is a volume using its copied data.
	//
	//   - FULL_COPY - Copies all data from the snapshot to the new volume.
	//
	// Specify this option to create the volume from a snapshot on another FSx for
	//   OpenZFS file system.
	//
	// The INCREMENTAL_COPY option is only for updating an existing volume by using a
	// snapshot from another FSx for OpenZFS file system. For more information, see [CopySnapshotAndUpdateVolume].
	//
	// [CopySnapshotAndUpdateVolume]: https://docs.aws.amazon.com/fsx/latest/APIReference/API_CopySnapshotAndUpdateVolume.html
	//
	// This member is required.
	CopyStrategy OpenZFSCopyStrategy

	// The Amazon Resource Name (ARN) for a given resource. ARNs uniquely identify
	// Amazon Web Services resources. We require an ARN when you need to specify a
	// resource unambiguously across all of Amazon Web Services. For more information,
	// see [Amazon Resource Names (ARNs)]in the Amazon Web Services General Reference.
	//
	// [Amazon Resource Names (ARNs)]: https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html
	//
	// This member is required.
	SnapshotARN *string

	noSmithyDocumentSerde
}

// Specifies the configuration of the Amazon FSx for OpenZFS volume that you are
// creating.
type CreateOpenZFSVolumeConfiguration struct {

	// The ID of the volume to use as the parent volume of the volume that you are
	// creating.
	//
	// This member is required.
	ParentVolumeId *string

	// A Boolean value indicating whether tags for the volume should be copied to
	// snapshots. This value defaults to false . If it's set to true , all tags for the
	// volume are copied to snapshots where the user doesn't specify tags. If this
	// value is true , and you specify one or more tags, only the specified tags are
	// copied to snapshots. If you specify one or more tags when creating the snapshot,
	// no tags are copied from the volume, regardless of this value.
	CopyTagsToSnapshots *bool

	// Specifies the method used to compress the data on the volume. The compression
	// type is NONE by default.
	//
	//   - NONE - Doesn't compress the data on the volume. NONE is the default.
	//
	//   - ZSTD - Compresses the data in the volume using the Zstandard (ZSTD)
	//   compression algorithm. ZSTD compression provides a higher level of data
	//   compression and higher read throughput performance than LZ4 compression.
	//
	//   - LZ4 - Compresses the data in the volume using the LZ4 compression algorithm.
	//   LZ4 compression provides a lower level of compression and higher write
	//   throughput performance than ZSTD compression.
	//
	// For more information about volume compression types and the performance of your
	// Amazon FSx for OpenZFS file system, see [Tips for maximizing performance]File system and volume settings in the
	// Amazon FSx for OpenZFS User Guide.
	//
	// [Tips for maximizing performance]: https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/performance.html#performance-tips-zfs
	DataCompressionType OpenZFSDataCompressionType

	// The configuration object for mounting a Network File System (NFS) file system.
	NfsExports []OpenZFSNfsExport

	// The configuration object that specifies the snapshot to use as the origin of
	// the data for the volume.
	OriginSnapshot *CreateOpenZFSOriginSnapshotConfiguration

	// A Boolean value indicating whether the volume is read-only.
	ReadOnly *bool

	// Specifies the suggested block size for a volume in a ZFS dataset, in kibibytes
	// (KiB). For file systems using the Intelligent-Tiering storage class, valid
	// values are 128, 256, 512, 1024, 2048, or 4096 KiB, with a default of 1024 KiB.
	// For all other file systems, valid values are 4, 8, 16, 32, 64, 128, 256, 512, or
	// 1024 KiB, with a default of 128 KiB. We recommend using the default setting for
	// the majority of use cases. Generally, workloads that write in fixed small or
	// large record sizes may benefit from setting a custom record size, like database
	// workloads (small record size) or media streaming workloads (large record size).
	// For additional guidance on when to set a custom record size, see [ZFS Record size]in the Amazon
	// FSx for OpenZFS User Guide.
	//
	// [ZFS Record size]: https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/performance.html#record-size-performance
	RecordSizeKiB *int32

	// Sets the maximum storage size in gibibytes (GiB) for the volume. You can
	// specify a quota that is larger than the storage on the parent volume. A volume
	// quota limits the amount of storage that the volume can consume to the configured
	// amount, but does not guarantee the space will be available on the parent volume.
	// To guarantee quota space, you must also set StorageCapacityReservationGiB . To
	// not specify a storage capacity quota, set this to -1 .
	//
	// For more information, see [Volume properties] in the Amazon FSx for OpenZFS User Guide.
	//
	// [Volume properties]: https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/managing-volumes.html#volume-properties
	StorageCapacityQuotaGiB *int32

	// Specifies the amount of storage in gibibytes (GiB) to reserve from the parent
	// volume. Setting StorageCapacityReservationGiB guarantees that the specified
	// amount of storage space on the parent volume will always be available for the
	// volume. You can't reserve more storage than the parent volume has. To not
	// specify a storage capacity reservation, set this to 0 or -1 . For more
	// information, see [Volume properties]in the Amazon FSx for OpenZFS User Guide.
	//
	// [Volume properties]: https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/managing-volumes.html#volume-properties
	StorageCapacityReservationGiB *int32

	// Configures how much storage users and groups can use on the volume.
	UserAndGroupQuotas []OpenZFSUserOrGroupQuota

	noSmithyDocumentSerde
}

// Defines the SnapLock configuration when creating an FSx for ONTAP SnapLock
// volume.
type CreateSnaplockConfiguration struct {

	// Specifies the retention mode of an FSx for ONTAP SnapLock volume. After it is
	// set, it can't be changed. You can choose one of the following retention modes:
	//
	//   - COMPLIANCE : Files transitioned to write once, read many (WORM) on a
	//   Compliance volume can't be deleted until their retention periods expire. This
	//   retention mode is used to address government or industry-specific mandates or to
	//   protect against ransomware attacks. For more information, see [SnapLock Compliance].
	//
	//   - ENTERPRISE : Files transitioned to WORM on an Enterprise volume can be
	//   deleted by authorized users before their retention periods expire using
	//   privileged delete. This retention mode is used to advance an organization's data
	//   integrity and internal compliance or to test retention settings before using
	//   SnapLock Compliance. For more information, see [SnapLock Enterprise].
	//
	// [SnapLock Enterprise]: https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/snaplock-enterprise.html
	// [SnapLock Compliance]: https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/snaplock-compliance.html
	//
	// This member is required.
	SnaplockType SnaplockType

	// Enables or disables the audit log volume for an FSx for ONTAP SnapLock volume.
	// The default value is false . If you set AuditLogVolume to true , the SnapLock
	// volume is created as an audit log volume. The minimum retention period for an
	// audit log volume is six months.
	//
	// For more information, see [SnapLock audit log volumes].
	//
	// [SnapLock audit log volumes]: https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/how-snaplock-works.html#snaplock-audit-log-volume
	AuditLogVolume *bool

	// The configuration object for setting the autocommit period of files in an FSx
	// for ONTAP SnapLock volume.
	AutocommitPeriod *AutocommitPeriod

	// Enables, disables, or permanently disables privileged delete on an FSx for
	// ONTAP SnapLock Enterprise volume. Enabling privileged delete allows SnapLock
	// administrators to delete WORM files even if they have active retention periods.
	// PERMANENTLY_DISABLED is a terminal state. If privileged delete is permanently
	// disabled on a SnapLock volume, you can't re-enable it. The default value is
	// DISABLED .
	//
	// For more information, see [Privileged delete].
	//
	// [Privileged delete]: https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/snaplock-enterprise.html#privileged-delete
	PrivilegedDelete PrivilegedDelete

	// Specifies the retention period of an FSx for ONTAP SnapLock volume.
	RetentionPeriod *SnaplockRetentionPeriod

	// Enables or disables volume-append mode on an FSx for ONTAP SnapLock volume.
	// Volume-append mode allows you to create WORM-appendable files and write data to
	// them incrementally. The default value is false .
	//
	// For more information, see [Volume-append mode].
	//
	// [Volume-append mode]: https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/worm-state.html#worm-state-append
	VolumeAppendModeEnabled *bool

	noSmithyDocumentSerde
}

// The configuration that Amazon FSx uses to join the ONTAP storage virtual
// machine (SVM) to your self-managed (including on-premises) Microsoft Active
// Directory directory.
type CreateSvmActiveDirectoryConfiguration struct {

	// The NetBIOS name of the Active Directory computer object that will be created
	// for your SVM.
	//
	// This member is required.
	NetBiosName *string

	// The configuration that Amazon FSx uses to join a FSx for Windows File Server
	// file system or an FSx for ONTAP storage virtual machine (SVM) to a self-managed
	// (including on-premises) Microsoft Active Directory (AD) directory. For more
	// information, see [Using Amazon FSx for Windows with your self-managed Microsoft Active Directory]or [Managing FSx for ONTAP SVMs].
	//
	// [Using Amazon FSx for Windows with your self-managed Microsoft Active Directory]: https://docs.aws.amazon.com/fsx/latest/WindowsGuide/self-managed-AD.html
	// [Managing FSx for ONTAP SVMs]: https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/managing-svms.html
	SelfManagedActiveDirectoryConfiguration *SelfManagedActiveDirectoryConfiguration

	noSmithyDocumentSerde
}

// The configuration of a data repository association that links an Amazon FSx for
// Lustre file system to an Amazon S3 bucket or an Amazon File Cache resource to an
// Amazon S3 bucket or an NFS file system. The data repository association
// configuration object is returned in the response of the following operations:
//
//   - CreateDataRepositoryAssociation
//
//   - UpdateDataRepositoryAssociation
//
//   - DescribeDataRepositoryAssociations
//
// Data repository associations are supported on Amazon File Cache resources and
// all FSx for Lustre 2.12 and 2.15 file systems, excluding scratch_1 deployment
// type.
type DataRepositoryAssociation struct {

	// The system-generated, unique ID of the data repository association.
	AssociationId *string

	// A boolean flag indicating whether an import data repository task to import
	// metadata should run after the data repository association is created. The task
	// runs if this flag is set to true .
	//
	// BatchImportMetaDataOnCreate is not supported for data repositories linked to an
	// Amazon File Cache resource.
	BatchImportMetaDataOnCreate *bool

	// The time that the resource was created, in seconds (since
	// 1970-01-01T00:00:00Z), also known as Unix time.
	CreationTime *time.Time

	// The path to the data repository that will be linked to the cache or file system.
	//
	//   - For Amazon File Cache, the path can be an NFS data repository that will be
	//   linked to the cache. The path can be in one of two formats:
	//
	//   - If you are not using the DataRepositorySubdirectories parameter, the path is
	//   to an NFS Export directory (or one of its subdirectories) in the format
	//   nsf://nfs-domain-name/exportpath . You can therefore link a single NFS Export
	//   to a single data repository association.
	//
	//   - If you are using the DataRepositorySubdirectories parameter, the path is the
	//   domain name of the NFS file system in the format nfs://filer-domain-name ,
	//   which indicates the root of the subdirectories specified with the
	//   DataRepositorySubdirectories parameter.
	//
	//   - For Amazon File Cache, the path can be an S3 bucket or prefix in the format
	//   s3://bucket-name/prefix/ (where prefix is optional).
	//
	//   - For Amazon FSx for Lustre, the path can be an S3 bucket or prefix in the
	//   format s3://bucket-name/prefix/ (where prefix is optional).
	DataRepositoryPath *string

	// For Amazon File Cache, a list of NFS Exports that will be linked with an NFS
	// data repository association. All the subdirectories must be on a single NFS file
	// system. The Export paths are in the format /exportpath1 . To use this parameter,
	// you must configure DataRepositoryPath as the domain name of the NFS file
	// system. The NFS file system domain name in effect is the root of the
	// subdirectories. Note that DataRepositorySubdirectories is not supported for S3
	// data repositories.
	DataRepositorySubdirectories []string

	// Provides detailed information about the data repository if its Lifecycle is set
	// to MISCONFIGURED or FAILED .
	FailureDetails *DataRepositoryFailureDetails

	// The globally unique ID of the Amazon File Cache resource.
	FileCacheId *string

	// A path on the Amazon File Cache that points to a high-level directory (such as
	// /ns1/ ) or subdirectory (such as /ns1/subdir/ ) that will be mapped 1-1 with
	// DataRepositoryPath . The leading forward slash in the path is required. Two data
	// repository associations cannot have overlapping cache paths. For example, if a
	// data repository is associated with cache path /ns1/ , then you cannot link
	// another data repository with cache path /ns1/ns2 .
	//
	// This path specifies the directory in your cache where files will be exported
	// from. This cache directory can be linked to only one data repository (S3 or NFS)
	// and no other data repository can be linked to the directory.
	//
	// The cache path can only be set to root (/) on an NFS DRA when
	// DataRepositorySubdirectories is specified. If you specify root (/) as the cache
	// path, you can create only one DRA on the cache.
	//
	// The cache path cannot be set to root (/) for an S3 DRA.
	FileCachePath *string

	// The globally unique ID of the file system, assigned by Amazon FSx.
	FileSystemId *string

	// A path on the Amazon FSx for Lustre file system that points to a high-level
	// directory (such as /ns1/ ) or subdirectory (such as /ns1/subdir/ ) that will be
	// mapped 1-1 with DataRepositoryPath . The leading forward slash in the name is
	// required. Two data repository associations cannot have overlapping file system
	// paths. For example, if a data repository is associated with file system path
	// /ns1/ , then you cannot link another data repository with file system path
	// /ns1/ns2 .
	//
	// This path specifies where in your file system files will be exported from or
	// imported to. This file system directory can be linked to only one Amazon S3
	// bucket, and no other S3 bucket can be linked to the directory.
	//
	// If you specify only a forward slash ( / ) as the file system path, you can link
	// only one data repository to the file system. You can only specify "/" as the
	// file system path for the first data repository associated with a file system.
	FileSystemPath *string

	// For files imported from a data repository, this value determines the stripe
	// count and maximum amount of data per file (in MiB) stored on a single physical
	// disk. The maximum number of disks that a single file can be striped across is
	// limited by the total number of disks that make up the file system or cache.
	//
	// The default chunk size is 1,024 MiB (1 GiB) and can go as high as 512,000 MiB
	// (500 GiB). Amazon S3 objects have a maximum size of 5 TB.
	ImportedFileChunkSize *int32

	// Describes the state of a data repository association. The lifecycle can have
	// the following values:
	//
	//   - CREATING - The data repository association between the file system or cache
	//   and the data repository is being created. The data repository is unavailable.
	//
	//   - AVAILABLE - The data repository association is available for use.
	//
	//   - MISCONFIGURED - The data repository association is misconfigured. Until the
	//   configuration is corrected, automatic import and automatic export will not work
	//   (only for Amazon FSx for Lustre).
	//
	//   - UPDATING - The data repository association is undergoing a customer
	//   initiated update that might affect its availability.
	//
	//   - DELETING - The data repository association is undergoing a customer
	//   initiated deletion.
	//
	//   - FAILED - The data repository association is in a terminal state that cannot
	//   be recovered.
	Lifecycle DataRepositoryLifecycle

	// The configuration for an NFS data repository linked to an Amazon File Cache
	// resource with a data repository association.
	NFS *NFSDataRepositoryConfiguration

	// The Amazon Resource Name (ARN) for a given resource. ARNs uniquely identify
	// Amazon Web Services resources. We require an ARN when you need to specify a
	// resource unambiguously across all of Amazon Web Services. For more information,
	// see [Amazon Resource Names (ARNs)]in the Amazon Web Services General Reference.
	//
	// [Amazon Resource Names (ARNs)]: https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html
	ResourceARN *string

	// The configuration for an Amazon S3 data repository linked to an Amazon FSx for
	// Lustre file system with a data repository association.
	S3 *S3DataRepositoryConfiguration

	// A list of Tag values, with a maximum of 50 elements.
	Tags []Tag

	noSmithyDocumentSerde
}

// The data repository configuration object for Lustre file systems returned in
// the response of the CreateFileSystem operation.
//
// This data type is not supported on file systems with a data repository
// association. For file systems with a data repository association, see .
type DataRepositoryConfiguration struct {

	// Describes the file system's linked S3 data repository's AutoImportPolicy . The
	// AutoImportPolicy configures how Amazon FSx keeps your file and directory
	// listings up to date as you add or modify objects in your linked S3 bucket.
	// AutoImportPolicy can have the following values:
	//
	//   - NONE - (Default) AutoImport is off. Amazon FSx only updates file and
	//   directory listings from the linked S3 bucket when the file system is created.
	//   FSx does not update file and directory listings for any new or changed objects
	//   after choosing this option.
	//
	//   - NEW - AutoImport is on. Amazon FSx automatically imports directory listings
	//   of any new objects added to the linked S3 bucket that do not currently exist in
	//   the FSx file system.
	//
	//   - NEW_CHANGED - AutoImport is on. Amazon FSx automatically imports file and
	//   directory listings of any new objects added to the S3 bucket and any existing
	//   objects that are changed in the S3 bucket after you choose this option.
	//
	//   - NEW_CHANGED_DELETED - AutoImport is on. Amazon FSx automatically imports
	//   file and directory listings of any new objects added to the S3 bucket, any
	//   existing objects that are changed in the S3 bucket, and any objects that were
	//   deleted in the S3 bucket.
	AutoImportPolicy AutoImportPolicyType

	// The export path to the Amazon S3 bucket (and prefix) that you are using to
	// store new and changed Lustre file system files in S3.
	ExportPath *string

	// Provides detailed information about the data repository if its Lifecycle is set
	// to MISCONFIGURED or FAILED .
	FailureDetails *DataRepositoryFailureDetails

	// The import path to the Amazon S3 bucket (and optional prefix) that you're using
	// as the data repository for your FSx for Lustre file system, for example
	// s3://import-bucket/optional-prefix . If a prefix is specified after the Amazon
	// S3 bucket name, only object keys with that prefix are loaded into the file
	// system.
	ImportPath *string

	// For files imported from a data repository, this value determines the stripe
	// count and maximum amount of data per file (in MiB) stored on a single physical
	// disk. The maximum number of disks that a single file can be striped across is
	// limited by the total number of disks that make up the file system.
	//
	// The default chunk size is 1,024 MiB (1 GiB) and can go as high as 512,000 MiB
	// (500 GiB). Amazon S3 objects have a maximum size of 5 TB.
	ImportedFileChunkSize *int32

	// Describes the state of the file system's S3 durable data repository, if it is
	// configured with an S3 repository. The lifecycle can have the following values:
	//
	//   - CREATING - The data repository configuration between the FSx file system and
	//   the linked S3 data repository is being created. The data repository is
	//   unavailable.
	//
	//   - AVAILABLE - The data repository is available for use.
	//
	//   - MISCONFIGURED - Amazon FSx cannot automatically import updates from the S3
	//   bucket until the data repository configuration is corrected. For more
	//   information, see [Troubleshooting a Misconfigured linked S3 bucket].
	//
	//   - UPDATING - The data repository is undergoing a customer initiated update and
	//   availability may be impacted.
	//
	//   - FAILED - The data repository is in a terminal state that cannot be recovered.
	//
	// [Troubleshooting a Misconfigured linked S3 bucket]: https://docs.aws.amazon.com/fsx/latest/LustreGuide/troubleshooting.html#troubleshooting-misconfigured-data-repository
	Lifecycle DataRepositoryLifecycle

	noSmithyDocumentSerde
}

// Provides detailed information about the data repository if its Lifecycle is set
// to MISCONFIGURED or FAILED .
type DataRepositoryFailureDetails struct {

	// A detailed error message.
	Message *string

	noSmithyDocumentSerde
}

// A description of the data repository task.
//
//   - You use import and export data repository tasks to perform bulk transfer
//     operations between an Amazon FSx for Lustre file system and a linked data
//     repository.
//
//   - You use release data repository tasks to release files that have been
//     exported to a linked S3 bucket from your Amazon FSx for Lustre file system.
//
//   - An Amazon File Cache resource uses a task to automatically release files
//     from the cache.
//
// To learn more about data repository tasks, see [Data Repository Tasks].
//
// [Data Repository Tasks]: https://docs.aws.amazon.com/fsx/latest/LustreGuide/data-repository-tasks.html
type DataRepositoryTask struct {

	// The time that the resource was created, in seconds (since
	// 1970-01-01T00:00:00Z), also known as Unix time.
	//
	// This member is required.
	CreationTime *time.Time

	// The lifecycle status of the data repository task, as follows:
	//
	//   - PENDING - The task has not started.
	//
	//   - EXECUTING - The task is in process.
	//
	//   - FAILED - The task was not able to be completed. For example, there may be
	//   files the task failed to process. The DataRepositoryTaskFailureDetailsproperty provides more information
	//   about task failures.
	//
	//   - SUCCEEDED - The task has completed successfully.
	//
	//   - CANCELED - The task was canceled and it did not complete.
	//
	//   - CANCELING - The task is in process of being canceled.
	//
	// You cannot delete an FSx for Lustre file system if there are data repository
	// tasks for the file system in the PENDING or EXECUTING states. Please retry when
	// the data repository task is finished (with a status of CANCELED , SUCCEEDED , or
	// FAILED ). You can use the DescribeDataRepositoryTask action to monitor the task
	// status. Contact the FSx team if you need to delete your file system immediately.
	//
	// This member is required.
	Lifecycle DataRepositoryTaskLifecycle

	// The system-generated, unique 17-digit ID of the data repository task.
	//
	// This member is required.
	TaskId *string

	// The type of data repository task.
	//
	//   - EXPORT_TO_REPOSITORY tasks export from your Amazon FSx for Lustre file
	//   system to a linked data repository.
	//
	//   - IMPORT_METADATA_FROM_REPOSITORY tasks import metadata changes from a linked
	//   S3 bucket to your Amazon FSx for Lustre file system.
	//
	//   - RELEASE_DATA_FROM_FILESYSTEM tasks release files in your Amazon FSx for
	//   Lustre file system that have been exported to a linked S3 bucket and that meet
	//   your specified release criteria.
	//
	//   - AUTO_RELEASE_DATA tasks automatically release files from an Amazon File
	//   Cache resource.
	//
	// This member is required.
	Type DataRepositoryTaskType

	// Specifies the amount of data to release, in GiB, by an Amazon File Cache
	// AUTO_RELEASE_DATA task that automatically releases files from the cache.
	CapacityToRelease *int64

	// The time the system completed processing the task, populated after the task is
	// complete.
	EndTime *time.Time

	// Failure message describing why the task failed, it is populated only when
	// Lifecycle is set to FAILED .
	FailureDetails *DataRepositoryTaskFailureDetails

	// The system-generated, unique ID of the cache.
	FileCacheId *string

	// The globally unique ID of the file system.
	FileSystemId *string

	// An array of paths that specify the data for the data repository task to
	// process. For example, in an EXPORT_TO_REPOSITORY task, the paths specify which
	// data to export to the linked data repository.
	//
	// (Default) If Paths is not specified, Amazon FSx uses the file system root
	// directory.
	Paths []string

	// The configuration that specifies the last accessed time criteria for files that
	// will be released from an Amazon FSx for Lustre file system.
	ReleaseConfiguration *ReleaseConfiguration

	// Provides a report detailing the data repository task results of the files
	// processed that match the criteria specified in the report Scope parameter. FSx
	// delivers the report to the file system's linked data repository in Amazon S3,
	// using the path specified in the report Path parameter. You can specify whether
	// or not a report gets generated for a task using the Enabled parameter.
	Report *CompletionReport

	// The Amazon Resource Name (ARN) for a given resource. ARNs uniquely identify
	// Amazon Web Services resources. We require an ARN when you need to specify a
	// resource unambiguously across all of Amazon Web Services. For more information,
	// see [Amazon Resource Names (ARNs)]in the Amazon Web Services General Reference.
	//
	// [Amazon Resource Names (ARNs)]: https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html
	ResourceARN *string

	// The time the system began processing the task.
	StartTime *time.Time

	// Provides the status of the number of files that the task has processed
	// successfully and failed to process.
	Status *DataRepositoryTaskStatus

	// A list of Tag values, with a maximum of 50 elements.
	Tags []Tag

	noSmithyDocumentSerde
}

// Provides information about why a data repository task failed. Only populated
// when the task Lifecycle is set to FAILED .
type DataRepositoryTaskFailureDetails struct {

	// A detailed error message.
	Message *string

	noSmithyDocumentSerde
}

// (Optional) An array of filter objects you can use to filter the response of
// data repository tasks you will see in the response. You can filter the tasks
// returned in the response by one or more file system IDs, task lifecycles, and by
// task type. A filter object consists of a filter Name , and one or more Values
// for the filter.
type DataRepositoryTaskFilter struct {

	// Name of the task property to use in filtering the tasks returned in the
	// response.
	//
	//   - Use file-system-id to retrieve data repository tasks for specific file
	//   systems.
	//
	//   - Use task-lifecycle to retrieve data repository tasks with one or more
	//   specific lifecycle states, as follows: CANCELED, EXECUTING, FAILED, PENDING, and
	//   SUCCEEDED.
	Name DataRepositoryTaskFilterName

	// Use Values to include the specific file system IDs and task lifecycle states
	// for the filters you are using.
	Values []string

	noSmithyDocumentSerde
}

// Provides the task status showing a running total of the total number of files
// to be processed, the number successfully processed, and the number of files the
// task failed to process.
type DataRepositoryTaskStatus struct {

	// A running total of the number of files that the task failed to process.
	FailedCount *int64

	// The time at which the task status was last updated.
	LastUpdatedTime *time.Time

	// The total amount of data, in GiB, released by an Amazon File Cache
	// AUTO_RELEASE_DATA task that automatically releases files from the cache.
	ReleasedCapacity *int64

	// A running total of the number of files that the task has successfully processed.
	SucceededCount *int64

	// The total number of files that the task will process. While a task is
	// executing, the sum of SucceededCount plus FailedCount may not equal TotalCount .
	// When the task is complete, TotalCount equals the sum of SucceededCount plus
	// FailedCount .
	TotalCount *int64

	noSmithyDocumentSerde
}

// The configuration object for the Amazon FSx for Lustre file system being
// deleted in the DeleteFileSystem operation.
type DeleteFileSystemLustreConfiguration struct {

	// Use if SkipFinalBackup is set to false , and you want to apply an array of tags
	// to the final backup. If you have set the file system property CopyTagsToBackups
	// to true, and you specify one or more FinalBackupTags when deleting a file
	// system, Amazon FSx will not copy any existing file system tags to the backup.
	FinalBackupTags []Tag

	// Set SkipFinalBackup to false if you want to take a final backup of the file
	// system you are deleting. By default, Amazon FSx will not take a final backup on
	// your behalf when the DeleteFileSystem operation is invoked. (Default = true)
	//
	// The fsx:CreateBackup permission is required if you set SkipFinalBackup to false
	// in order to delete the file system and take a final backup.
	SkipFinalBackup *bool

	noSmithyDocumentSerde
}

// The response object for the Amazon FSx for Lustre file system being deleted in
// the DeleteFileSystem operation.
type DeleteFileSystemLustreResponse struct {

	// The ID of the final backup for this file system.
	FinalBackupId *string

	// The set of tags applied to the final backup.
	FinalBackupTags []Tag

	noSmithyDocumentSerde
}

// The configuration object for the Amazon FSx for OpenZFS file system used in the
// DeleteFileSystem operation.
type DeleteFileSystemOpenZFSConfiguration struct {

	// A list of tags to apply to the file system's final backup.
	FinalBackupTags []Tag

	// To delete a file system if there are child volumes present below the root
	// volume, use the string DELETE_CHILD_VOLUMES_AND_SNAPSHOTS . If your file system
	// has child volumes and you don't use this option, the delete request will fail.
	Options []DeleteFileSystemOpenZFSOption

	// By default, Amazon FSx for OpenZFS takes a final backup on your behalf when the
	// DeleteFileSystem operation is invoked. Doing this helps protect you from data
	// loss, and we highly recommend taking the final backup. If you want to skip
	// taking a final backup, set this value to true .
	SkipFinalBackup *bool

	noSmithyDocumentSerde
}

// The response object for the Amazon FSx for OpenZFS file system that's being
// deleted in the DeleteFileSystem operation.
type DeleteFileSystemOpenZFSResponse struct {

	// The ID of the source backup. Specifies the backup that you are copying.
	FinalBackupId *string

	// A list of Tag values, with a maximum of 50 elements.
	FinalBackupTags []Tag

	noSmithyDocumentSerde
}

// The configuration object for the Microsoft Windows file system used in the
// DeleteFileSystem operation.
type DeleteFileSystemWindowsConfiguration struct {

	// A set of tags for your final backup.
	FinalBackupTags []Tag

	// By default, Amazon FSx for Windows takes a final backup on your behalf when the
	// DeleteFileSystem operation is invoked. Doing this helps protect you from data
	// loss, and we highly recommend taking the final backup. If you want to skip this
	// backup, use this flag to do so.
	SkipFinalBackup *bool

	noSmithyDocumentSerde
}

// The response object for the Microsoft Windows file system used in the
// DeleteFileSystem operation.
type DeleteFileSystemWindowsResponse struct {

	// The ID of the final backup for this file system.
	FinalBackupId *string

	// The set of tags applied to the final backup.
	FinalBackupTags []Tag

	noSmithyDocumentSerde
}

// Use to specify skipping a final backup, adding tags to a final backup, or
// bypassing the retention period of an FSx for ONTAP SnapLock Enterprise volume
// when deleting an FSx for ONTAP volume.
type DeleteVolumeOntapConfiguration struct {

	// Setting this to true allows a SnapLock administrator to delete an FSx for ONTAP
	// SnapLock Enterprise volume with unexpired write once, read many (WORM) files.
	// The IAM permission fsx:BypassSnaplockEnterpriseRetention is also required to
	// delete SnapLock Enterprise volumes with unexpired WORM files. The default value
	// is false .
	//
	// For more information, see [Deleting a SnapLock volume].
	//
	// [Deleting a SnapLock volume]: https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/snaplock-delete-volume.html
	BypassSnaplockEnterpriseRetention *bool

	// A list of Tag values, with a maximum of 50 elements.
	FinalBackupTags []Tag

	// Set to true if you want to skip taking a final backup of the volume you are
	// deleting.
	SkipFinalBackup *bool

	noSmithyDocumentSerde
}

// The response object for the Amazon FSx for NetApp ONTAP volume being deleted in
// the DeleteVolume operation.
type DeleteVolumeOntapResponse struct {

	// The ID of the source backup. Specifies the backup that you are copying.
	FinalBackupId *string

	// A list of Tag values, with a maximum of 50 elements.
	FinalBackupTags []Tag

	noSmithyDocumentSerde
}

// A value that specifies whether to delete all child volumes and snapshots.
type DeleteVolumeOpenZFSConfiguration struct {

	// To delete the volume's child volumes, snapshots, and clones, use the string
	// DELETE_CHILD_VOLUMES_AND_SNAPSHOTS .
	Options []DeleteOpenZFSVolumeOption

	noSmithyDocumentSerde
}

// The SSD IOPS (input/output operations per second) configuration for an Amazon
// FSx for NetApp ONTAP, Amazon FSx for Windows File Server, or FSx for OpenZFS
// file system. By default, Amazon FSx automatically provisions 3 IOPS per GB of
// storage capacity. You can provision additional IOPS per GB of storage. The
// configuration consists of the total number of provisioned SSD IOPS and how it is
// was provisioned, or the mode (by the customer or by Amazon FSx).
type DiskIopsConfiguration struct {

	// The total number of SSD IOPS provisioned for the file system.
	//
	// The minimum and maximum values for this property depend on the value of HAPairs
	// and StorageCapacity . The minimum value is calculated as StorageCapacity * 3 *
	// HAPairs (3 IOPS per GB of StorageCapacity ). The maximum value is calculated as
	// 200,000 * HAPairs .
	//
	// Amazon FSx responds with an HTTP status code 400 (Bad Request) if the value of
	// Iops is outside of the minimum or maximum values.
	Iops *int64

	// Specifies whether the file system is using the AUTOMATIC setting of SSD IOPS of
	// 3 IOPS per GB of storage capacity, or if it using a USER_PROVISIONED value.
	Mode DiskIopsConfigurationMode

	noSmithyDocumentSerde
}

// Defines the minimum amount of time since last access for a file to be eligible
// for release. Only files that have been exported to S3 and that were last
// accessed or modified before this point-in-time are eligible to be released from
// the Amazon FSx for Lustre file system.
type DurationSinceLastAccess struct {

	// The unit of time used by the Value parameter to determine if a file can be
	// released, based on when it was last accessed. DAYS is the only supported value.
	// This is a required parameter.
	Unit Unit

	// An integer that represents the minimum amount of time (in days) since a file
	// was last accessed in the file system. Only exported files with a MAX(atime,
	// ctime, mtime) timestamp that is more than this amount of time in the past
	// (relative to the task create time) will be released. The default of Value is 0 .
	// This is a required parameter.
	//
	// If an exported file meets the last accessed time criteria, its file or
	// directory path must also be specified in the Paths parameter of the operation
	// in order for the file to be released.
	Value *int64

	noSmithyDocumentSerde
}

// A description of a specific Amazon File Cache resource, which is a response
// object from the DescribeFileCaches operation.
type FileCache struct {

	// The time that the resource was created, in seconds (since
	// 1970-01-01T00:00:00Z), also known as Unix time.
	CreationTime *time.Time

	// The Domain Name System (DNS) name for the cache.
	DNSName *string

	// A list of IDs of data repository associations that are associated with this
	// cache.
	DataRepositoryAssociationIds []string

	// A structure providing details of any failures that occurred.
	FailureDetails *FileCacheFailureDetails

	// The system-generated, unique ID of the cache.
	FileCacheId *string

	// The type of cache, which must be LUSTRE .
	FileCacheType FileCacheType

	// The Lustre version of the cache, which must be 2.12 .
	FileCacheTypeVersion *string

	// Specifies the ID of the Key Management Service (KMS) key to use for encrypting
	// data on an Amazon File Cache. If a KmsKeyId isn't specified, the Amazon
	// FSx-managed KMS key for your account is used. For more information, see [Encrypt]in the
	// Key Management Service API Reference.
	//
	// [Encrypt]: https://docs.aws.amazon.com/kms/latest/APIReference/API_Encrypt.html
	KmsKeyId *string

	// The lifecycle status of the cache. The following are the possible values and
	// what they mean:
	//
	//   - AVAILABLE - The cache is in a healthy state, and is reachable and available
	//   for use.
	//
	//   - CREATING - The new cache is being created.
	//
	//   - DELETING - An existing cache is being deleted.
	//
	//   - UPDATING - The cache is undergoing a customer-initiated update.
	//
	//   - FAILED - An existing cache has experienced an unrecoverable failure. When
	//   creating a new cache, the cache was unable to be created.
	Lifecycle FileCacheLifecycle

	// The configuration for the Amazon File Cache resource.
	LustreConfiguration *FileCacheLustreConfiguration

	// A list of network interface IDs.
	NetworkInterfaceIds []string

	// An Amazon Web Services account ID. This ID is a 12-digit number that you use to
	// construct Amazon Resource Names (ARNs) for resources.
	OwnerId *string

	// The Amazon Resource Name (ARN) for a given resource. ARNs uniquely identify
	// Amazon Web Services resources. We require an ARN when you need to specify a
	// resource unambiguously across all of Amazon Web Services. For more information,
	// see [Amazon Resource Names (ARNs)]in the Amazon Web Services General Reference.
	//
	// [Amazon Resource Names (ARNs)]: https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html
	ResourceARN *string

	// The storage capacity of the cache in gibibytes (GiB).
	StorageCapacity *int32

	// A list of subnet IDs that the cache will be accessible from. You can specify
	// only one subnet ID in a call to the CreateFileCache operation.
	SubnetIds []string

	// The ID of your virtual private cloud (VPC). For more information, see [VPC and subnets] in the
	// Amazon VPC User Guide.
	//
	// [VPC and subnets]: https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_Subnets.html
	VpcId *string

	noSmithyDocumentSerde
}

// The response object for the Amazon File Cache resource being created in the
// CreateFileCache operation.
type FileCacheCreating struct {

	// A boolean flag indicating whether tags for the cache should be copied to data
	// repository associations.
	CopyTagsToDataRepositoryAssociations *bool

	// The time that the resource was created, in seconds (since
	// 1970-01-01T00:00:00Z), also known as Unix time.
	CreationTime *time.Time

	// The Domain Name System (DNS) name for the cache.
	DNSName *string

	// A list of IDs of data repository associations that are associated with this
	// cache.
	DataRepositoryAssociationIds []string

	// A structure providing details of any failures that occurred in creating a cache.
	FailureDetails *FileCacheFailureDetails

	// The system-generated, unique ID of the cache.
	FileCacheId *string

	// The type of cache, which must be LUSTRE .
	FileCacheType FileCacheType

	// The Lustre version of the cache, which must be 2.12 .
	FileCacheTypeVersion *string

	// Specifies the ID of the Key Management Service (KMS) key to use for encrypting
	// data on an Amazon File Cache. If a KmsKeyId isn't specified, the Amazon
	// FSx-managed KMS key for your account is used. For more information, see [Encrypt]in the
	// Key Management Service API Reference.
	//
	// [Encrypt]: https://docs.aws.amazon.com/kms/latest/APIReference/API_Encrypt.html
	KmsKeyId *string

	// The lifecycle status of the cache. The following are the possible values and
	// what they mean:
	//
	//   - AVAILABLE - The cache is in a healthy state, and is reachable and available
	//   for use.
	//
	//   - CREATING - The new cache is being created.
	//
	//   - DELETING - An existing cache is being deleted.
	//
	//   - UPDATING - The cache is undergoing a customer-initiated update.
	//
	//   - FAILED - An existing cache has experienced an unrecoverable failure. When
	//   creating a new cache, the cache was unable to be created.
	Lifecycle FileCacheLifecycle

	// The configuration for the Amazon File Cache resource.
	LustreConfiguration *FileCacheLustreConfiguration

	// A list of network interface IDs.
	NetworkInterfaceIds []string

	// An Amazon Web Services account ID. This ID is a 12-digit number that you use to
	// construct Amazon Resource Names (ARNs) for resources.
	OwnerId *string

	// The Amazon Resource Name (ARN) for a given resource. ARNs uniquely identify
	// Amazon Web Services resources. We require an ARN when you need to specify a
	// resource unambiguously across all of Amazon Web Services. For more information,
	// see [Amazon Resource Names (ARNs)]in the Amazon Web Services General Reference.
	//
	// [Amazon Resource Names (ARNs)]: https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html
	ResourceARN *string

	// The storage capacity of the cache in gibibytes (GiB).
	StorageCapacity *int32

	// A list of subnet IDs that the cache will be accessible from. You can specify
	// only one subnet ID in a call to the CreateFileCache operation.
	SubnetIds []string

	// A list of Tag values, with a maximum of 50 elements.
	Tags []Tag

	// The ID of your virtual private cloud (VPC). For more information, see [VPC and subnets] in the
	// Amazon VPC User Guide.
	//
	// [VPC and subnets]: https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_Subnets.html
	VpcId *string

	noSmithyDocumentSerde
}

// The configuration for a data repository association (DRA) to be created during
// the Amazon File Cache resource creation. The DRA links the cache to either an
// Amazon S3 bucket or prefix, or a Network File System (NFS) data repository that
// supports the NFSv3 protocol.
//
// The DRA does not support automatic import or automatic export.
type FileCacheDataRepositoryAssociation struct {

	// The path to the S3 or NFS data repository that links to the cache. You must
	// provide one of the following paths:
	//
	//   - The path can be an NFS data repository that links to the cache. The path
	//   can be in one of two formats:
	//
	//   - If you are not using the DataRepositorySubdirectories parameter, the path is
	//   to an NFS Export directory (or one of its subdirectories) in the format
	//   nfs://nfs-domain-name/exportpath . You can therefore link a single NFS Export
	//   to a single data repository association.
	//
	//   - If you are using the DataRepositorySubdirectories parameter, the path is the
	//   domain name of the NFS file system in the format nfs://filer-domain-name ,
	//   which indicates the root of the subdirectories specified with the
	//   DataRepositorySubdirectories parameter.
	//
	//   - The path can be an S3 bucket or prefix in the format
	//   s3://bucket-name/prefix/ (where prefix is optional).
	//
	// This member is required.
	DataRepositoryPath *string

	// A path on the cache that points to a high-level directory (such as /ns1/ ) or
	// subdirectory (such as /ns1/subdir/ ) that will be mapped 1-1 with
	// DataRepositoryPath . The leading forward slash in the name is required. Two data
	// repository associations cannot have overlapping cache paths. For example, if a
	// data repository is associated with cache path /ns1/ , then you cannot link
	// another data repository with cache path /ns1/ns2 .
	//
	// This path specifies where in your cache files will be exported from. This cache
	// directory can be linked to only one data repository, and no data repository
	// other can be linked to the directory.
	//
	// The cache path can only be set to root (/) on an NFS DRA when
	// DataRepositorySubdirectories is specified. If you specify root (/) as the cache
	// path, you can create only one DRA on the cache.
	//
	// The cache path cannot be set to root (/) for an S3 DRA.
	//
	// This member is required.
	FileCachePath *string

	// A list of NFS Exports that will be linked with this data repository
	// association. The Export paths are in the format /exportpath1 . To use this
	// parameter, you must configure DataRepositoryPath as the domain name of the NFS
	// file system. The NFS file system domain name in effect is the root of the
	// subdirectories. Note that DataRepositorySubdirectories is not supported for S3
	// data repositories.
	DataRepositorySubdirectories []string

	// The configuration for a data repository association that links an Amazon File
	// Cache resource to an NFS data repository.
	NFS *FileCacheNFSConfiguration

	noSmithyDocumentSerde
}

// A structure providing details of any failures that occurred.
type FileCacheFailureDetails struct {

	// A message describing any failures that occurred.
	Message *string

	noSmithyDocumentSerde
}

// The configuration for the Amazon File Cache resource.
type FileCacheLustreConfiguration struct {

	// The deployment type of the Amazon File Cache resource, which must be CACHE_1 .
	DeploymentType FileCacheLustreDeploymentType

	// The configuration for Lustre logging used to write the enabled logging events
	// for your Amazon File Cache resource to Amazon CloudWatch Logs.
	LogConfiguration *LustreLogConfiguration

	// The configuration for a Lustre MDT (Metadata Target) storage volume.
	MetadataConfiguration *FileCacheLustreMetadataConfiguration

	// You use the MountName value when mounting the cache. If you pass a cache ID to
	// the DescribeFileCaches operation, it returns the the MountName value as part of
	// the cache's description.
	MountName *string

	// Per unit storage throughput represents the megabytes per second of read or
	// write throughput per 1 tebibyte of storage provisioned. Cache throughput
	// capacity is equal to Storage capacity (TiB) * PerUnitStorageThroughput
	// (MB/s/TiB). The only supported value is 1000 .
	PerUnitStorageThroughput *int32

	// A recurring weekly time, in the format D:HH:MM .
	//
	// D is the day of the week, for which 1 represents Monday and 7 represents
	// Sunday. For further details, see [the ISO-8601 spec as described on Wikipedia].
	//
	// HH is the zero-padded hour of the day (0-23), and MM is the zero-padded minute
	// of the hour.
	//
	// For example, 1:05:00 specifies maintenance at 5 AM Monday.
	//
	// [the ISO-8601 spec as described on Wikipedia]: https://en.wikipedia.org/wiki/ISO_week_date
	WeeklyMaintenanceStartTime *string

	noSmithyDocumentSerde
}

// The configuration for a Lustre MDT (Metadata Target) storage volume. The
// metadata on Amazon File Cache is managed by a Lustre Metadata Server (MDS) while
// the actual metadata is persisted on an MDT.
type FileCacheLustreMetadataConfiguration struct {

	// The storage capacity of the Lustre MDT (Metadata Target) storage volume in
	// gibibytes (GiB). The only supported value is 2400 GiB.
	//
	// This member is required.
	StorageCapacity *int32

	noSmithyDocumentSerde
}

// The configuration for an NFS data repository association (DRA) created during
// the creation of the Amazon File Cache resource.
type FileCacheNFSConfiguration struct {

	// The version of the NFS (Network File System) protocol of the NFS data
	// repository. The only supported value is NFS3 , which indicates that the data
	// repository must support the NFSv3 protocol.
	//
	// This member is required.
	Version NfsVersion

	// A list of up to 2 IP addresses of DNS servers used to resolve the NFS file
	// system domain name. The provided IP addresses can either be the IP addresses of
	// a DNS forwarder or resolver that the customer manages and runs inside the
	// customer VPC, or the IP addresses of the on-premises DNS servers.
	DnsIps []string

	noSmithyDocumentSerde
}

// A description of a specific Amazon FSx file system.
type FileSystem struct {

	// A list of administrative actions for the file system that are in process or
	// waiting to be processed. Administrative actions describe changes to the Amazon
	// FSx system that you have initiated using the UpdateFileSystem operation.
	AdministrativeActions []AdministrativeAction

	// The time that the file system was created, in seconds (since
	// 1970-01-01T00:00:00Z), also known as Unix time.
	CreationTime *time.Time

	// The Domain Name System (DNS) name for the file system.
	DNSName *string

	// A structure providing details of any failures that occurred.
	FailureDetails *FileSystemFailureDetails

	// The system-generated, unique 17-digit ID of the file system.
	FileSystemId *string

	// The type of Amazon FSx file system, which can be LUSTRE , WINDOWS , ONTAP , or
	// OPENZFS .
	FileSystemType FileSystemType

	// The Lustre version of the Amazon FSx for Lustre file system, which can be 2.10 ,
	// 2.12 , or 2.15 .
	FileSystemTypeVersion *string

	// The ID of the Key Management Service (KMS) key used to encrypt Amazon FSx file
	// system data. Used as follows with Amazon FSx file system types:
	//
	//   - Amazon FSx for Lustre PERSISTENT_1 and PERSISTENT_2 deployment types only.
	//
	// SCRATCH_1 and SCRATCH_2 types are encrypted using the Amazon FSx service KMS key
	//   for your account.
	//
	//   - Amazon FSx for NetApp ONTAP
	//
	//   - Amazon FSx for OpenZFS
	//
	//   - Amazon FSx for Windows File Server
	KmsKeyId *string

	// The lifecycle status of the file system. The following are the possible values
	// and what they mean:
	//
	//   - AVAILABLE - The file system is in a healthy state, and is reachable and
	//   available for use.
	//
	//   - CREATING - Amazon FSx is creating the new file system.
	//
	//   - DELETING - Amazon FSx is deleting an existing file system.
	//
	//   - FAILED - An existing file system has experienced an unrecoverable failure.
	//   When creating a new file system, Amazon FSx was unable to create the file
	//   system.
	//
	//   - MISCONFIGURED - The file system is in a failed but recoverable state.
	//
	//   - MISCONFIGURED_UNAVAILABLE - (Amazon FSx for Windows File Server only) The
	//   file system is currently unavailable due to a change in your Active Directory
	//   configuration.
	//
	//   - UPDATING - The file system is undergoing a customer-initiated update.
	Lifecycle FileSystemLifecycle

	// The configuration for the Amazon FSx for Lustre file system.
	LustreConfiguration *LustreFileSystemConfiguration

	// The IDs of the elastic network interfaces from which a specific file system is
	// accessible. The elastic network interface is automatically created in the same
	// virtual private cloud (VPC) that the Amazon FSx file system was created in. For
	// more information, see [Elastic Network Interfaces]in the Amazon EC2 User Guide.
	//
	// For an Amazon FSx for Windows File Server file system, you can have one network
	// interface ID. For an Amazon FSx for Lustre file system, you can have more than
	// one.
	//
	// [Elastic Network Interfaces]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html
	NetworkInterfaceIds []string

	// The configuration for this Amazon FSx for NetApp ONTAP file system.
	OntapConfiguration *OntapFileSystemConfiguration

	// The configuration for this Amazon FSx for OpenZFS file system.
	OpenZFSConfiguration *OpenZFSFileSystemConfiguration

	// The Amazon Web Services account that created the file system. If the file
	// system was created by a user in IAM Identity Center, the Amazon Web Services
	// account to which the IAM user belongs is the owner.
	OwnerId *string

	// The Amazon Resource Name (ARN) of the file system resource.
	ResourceARN *string

	// The storage capacity of the file system in gibibytes (GiB).
	//
	// Amazon FSx responds with an HTTP status code 400 (Bad Request) if the value of
	// StorageCapacity is outside of the minimum or maximum values.
	StorageCapacity *int32

	// The type of storage the file system is using. If set to SSD , the file system
	// uses solid state drive storage. If set to HDD , the file system uses hard disk
	// drive storage.
	StorageType StorageType

	// Specifies the IDs of the subnets that the file system is accessible from. For
	// the Amazon FSx Windows and ONTAP MULTI_AZ_1 file system deployment type, there
	// are two subnet IDs, one for the preferred file server and one for the standby
	// file server. The preferred file server subnet identified in the
	// PreferredSubnetID property. All other file systems have only one subnet ID.
	//
	// For FSx for Lustre file systems, and Single-AZ Windows file systems, this is
	// the ID of the subnet that contains the file system's endpoint. For MULTI_AZ_1
	// Windows and ONTAP file systems, the file system endpoint is available in the
	// PreferredSubnetID .
	SubnetIds []string

	// The tags to associate with the file system. For more information, see [Tagging your Amazon FSx resources] in the
	// Amazon FSx for Lustre User Guide.
	//
	// [Tagging your Amazon FSx resources]: https://docs.aws.amazon.com/fsx/latest/LustreGuide/tag-resources.html
	Tags []Tag

	// The ID of the primary virtual private cloud (VPC) for the file system.
	VpcId *string

	// The configuration for this Amazon FSx for Windows File Server file system.
	WindowsConfiguration *WindowsFileSystemConfiguration

	noSmithyDocumentSerde
}

// An Amazon FSx for NetApp ONTAP file system has two endpoints that are used to
// access data or to manage the file system using the NetApp ONTAP CLI, REST API,
// or NetApp SnapMirror. They are the Management and Intercluster endpoints.
type FileSystemEndpoint struct {

	// The file system's DNS name. You can mount your file system using its DNS name.
	DNSName *string

	// IP addresses of the file system endpoint.
	IpAddresses []string

	noSmithyDocumentSerde
}

// An Amazon FSx for NetApp ONTAP file system has the following endpoints that are
// used to access data or to manage the file system using the NetApp ONTAP CLI,
// REST API, or NetApp SnapMirror.
type FileSystemEndpoints struct {

	// An endpoint for managing your file system by setting up NetApp SnapMirror with
	// other ONTAP systems.
	Intercluster *FileSystemEndpoint

	// An endpoint for managing your file system using the NetApp ONTAP CLI and NetApp
	// ONTAP API.
	Management *FileSystemEndpoint

	noSmithyDocumentSerde
}

// A structure providing details of any failures that occurred.
type FileSystemFailureDetails struct {

	// A message describing any failures that occurred.
	Message *string

	noSmithyDocumentSerde
}

// The Lustre metadata performance configuration of an Amazon FSx for Lustre file
// system using a PERSISTENT_2 deployment type. The configuration enables the file
// system to support increasing metadata performance.
type FileSystemLustreMetadataConfiguration struct {

	// The metadata configuration mode for provisioning Metadata IOPS for the file
	// system.
	//
	//   - In AUTOMATIC mode, FSx for Lustre automatically provisions and scales the
	//   number of Metadata IOPS on your file system based on your file system storage
	//   capacity.
	//
	//   - In USER_PROVISIONED mode, you can choose to specify the number of Metadata
	//   IOPS to provision for your file system.
	//
	// This member is required.
	Mode MetadataConfigurationMode

	// The number of Metadata IOPS provisioned for the file system. Valid values are
	// 1500 , 3000 , 6000 , 12000 , and multiples of 12000 up to a maximum of 192000 .
	Iops *int32

	noSmithyDocumentSerde
}

// A filter used to restrict the results of describe calls. You can use multiple
// filters to return results that meet all applied filter requirements.
type Filter struct {

	// The name for this filter.
	Name FilterName

	// The values of the filter. These are all the values for any of the applied
	// filters.
	Values []string

	noSmithyDocumentSerde
}

// Describes why a resource lifecycle state changed.
type LifecycleTransitionReason struct {

	// A detailed error message.
	Message *string

	noSmithyDocumentSerde
}

// The configuration for the Amazon FSx for Lustre file system.
type LustreFileSystemConfiguration struct {

	// The number of days to retain automatic backups. Setting this property to 0
	// disables automatic backups. You can retain automatic backups for a maximum of 90
	// days. The default is 30 .
	AutomaticBackupRetentionDays *int32

	// A boolean flag indicating whether tags on the file system are copied to
	// backups. If it's set to true, all tags on the file system are copied to all
	// automatic backups and any user-initiated backups where the user doesn't specify
	// any tags. If this value is true, and you specify one or more tags, only the
	// specified tags are copied to backups. If you specify one or more tags when
	// creating a user-initiated backup, no tags are copied from the file system,
	// regardless of this value. (Default = false)
	CopyTagsToBackups *bool

	// A recurring daily time, in the format HH:MM . HH is the zero-padded hour of the
	// day (0-23), and MM is the zero-padded minute of the hour. For example, 05:00
	// specifies 5 AM daily.
	DailyAutomaticBackupStartTime *string

	// The data compression configuration for the file system. DataCompressionType can
	// have the following values:
	//
	//   - NONE - Data compression is turned off for the file system.
	//
	//   - LZ4 - Data compression is turned on with the LZ4 algorithm.
	//
	// For more information, see [Lustre data compression].
	//
	// [Lustre data compression]: https://docs.aws.amazon.com/fsx/latest/LustreGuide/data-compression.html
	DataCompressionType DataCompressionType

	// The data repository configuration object for Lustre file systems returned in
	// the response of the CreateFileSystem operation.
	//
	// This data type is not supported on file systems with a data repository
	// association. For file systems with a data repository association, see .
	DataRepositoryConfiguration *DataRepositoryConfiguration

	// The deployment type of the FSx for Lustre file system. Scratch deployment type
	// is designed for temporary storage and shorter-term processing of data.
	//
	// SCRATCH_1 and SCRATCH_2 deployment types are best suited for when you need
	// temporary storage and shorter-term processing of data. The SCRATCH_2 deployment
	// type provides in-transit encryption of data and higher burst throughput capacity
	// than SCRATCH_1 .
	//
	// The PERSISTENT_1 and PERSISTENT_2 deployment type is used for longer-term
	// storage and workloads and encryption of data in transit. PERSISTENT_2 offers
	// higher PerUnitStorageThroughput (up to 1000 MB/s/TiB) along with a lower
	// minimum storage capacity requirement (600 GiB). To learn more about FSx for
	// Lustre deployment types, see [FSx for Lustre deployment options].
	//
	// The default is SCRATCH_1 .
	//
	// [FSx for Lustre deployment options]: https://docs.aws.amazon.com/fsx/latest/LustreGuide/lustre-deployment-types.html
	DeploymentType LustreDeploymentType

	// The type of drive cache used by PERSISTENT_1 file systems that are provisioned
	// with HDD storage devices. This parameter is required when StorageType is HDD.
	// When set to READ the file system has an SSD storage cache that is sized to 20%
	// of the file system's storage capacity. This improves the performance for
	// frequently accessed files by caching up to 20% of the total storage capacity.
	//
	// This parameter is required when StorageType is set to HDD.
	DriveCacheType DriveCacheType

	// Specifies whether Elastic Fabric Adapter (EFA) and GPUDirect Storage (GDS)
	// support is enabled for the Amazon FSx for Lustre file system.
	EfaEnabled *bool

	// The Lustre logging configuration. Lustre logging writes the enabled log events
	// for your file system to Amazon CloudWatch Logs.
	LogConfiguration *LustreLogConfiguration

	// The Lustre metadata performance configuration for an Amazon FSx for Lustre file
	// system using a PERSISTENT_2 deployment type.
	MetadataConfiguration *FileSystemLustreMetadataConfiguration

	// You use the MountName value when mounting the file system.
	//
	// For the SCRATCH_1 deployment type, this value is always " fsx ". For SCRATCH_2 ,
	// PERSISTENT_1 , and PERSISTENT_2 deployment types, this value is a string that
	// is unique within an Amazon Web Services Region.
	MountName *string

	// Per unit storage throughput represents the megabytes per second of read or
	// write throughput per 1 tebibyte of storage provisioned. File system throughput
	// capacity is equal to Storage capacity (TiB) * PerUnitStorageThroughput
	// (MB/s/TiB). This option is only valid for PERSISTENT_1 and PERSISTENT_2
	// deployment types.
	//
	// Valid values:
	//
	//   - For PERSISTENT_1 SSD storage: 50, 100, 200.
	//
	//   - For PERSISTENT_1 HDD storage: 12, 40.
	//
	//   - For PERSISTENT_2 SSD storage: 125, 250, 500, 1000.
	PerUnitStorageThroughput *int32

	// The Lustre root squash configuration for an Amazon FSx for Lustre file system.
	// When enabled, root squash restricts root-level access from clients that try to
	// access your file system as a root user.
	RootSquashConfiguration *LustreRootSquashConfiguration

	// The preferred start time to perform weekly maintenance, formatted d:HH:MM in
	// the UTC time zone. Here, d is the weekday number, from 1 through 7, beginning
	// with Monday and ending with Sunday.
	WeeklyMaintenanceStartTime *string

	noSmithyDocumentSerde
}

// The configuration for Lustre logging used to write the enabled logging events
// for your Amazon FSx for Lustre file system or Amazon File Cache resource to
// Amazon CloudWatch Logs.
type LustreLogConfiguration struct {

	// The data repository events that are logged by Amazon FSx.
	//
	//   - WARN_ONLY - only warning events are logged.
	//
	//   - ERROR_ONLY - only error events are logged.
	//
	//   - WARN_ERROR - both warning events and error events are logged.
	//
	//   - DISABLED - logging of data repository events is turned off.
	//
	// Note that Amazon File Cache uses a default setting of WARN_ERROR , which can't
	// be changed.
	//
	// This member is required.
	Level LustreAccessAuditLogLevel

	// The Amazon Resource Name (ARN) that specifies the destination of the logs. The
	// destination can be any Amazon CloudWatch Logs log group ARN. The destination ARN
	// must be in the same Amazon Web Services partition, Amazon Web Services Region,
	// and Amazon Web Services account as your Amazon FSx file system.
	Destination *string

	noSmithyDocumentSerde
}

// The Lustre logging configuration used when creating or updating an Amazon FSx
// for Lustre file system. An Amazon File Cache is created with Lustre logging
// enabled by default, with a setting of WARN_ERROR for the logging events. which
// can't be changed.
//
// Lustre logging writes the enabled logging events for your file system or cache
// to Amazon CloudWatch Logs.
type LustreLogCreateConfiguration struct {

	// Sets which data repository events are logged by Amazon FSx.
	//
	//   - WARN_ONLY - only warning events are logged.
	//
	//   - ERROR_ONLY - only error events are logged.
	//
	//   - WARN_ERROR - both warning events and error events are logged.
	//
	//   - DISABLED - logging of data repository events is turned off.
	//
	// This member is required.
	Level LustreAccessAuditLogLevel

	// The Amazon Resource Name (ARN) that specifies the destination of the logs.
	//
	// The destination can be any Amazon CloudWatch Logs log group ARN, with the
	// following requirements:
	//
	//   - The destination ARN that you provide must be in the same Amazon Web
	//   Services partition, Amazon Web Services Region, and Amazon Web Services account
	//   as your Amazon FSx file system.
	//
	//   - The name of the Amazon CloudWatch Logs log group must begin with the
	//   /aws/fsx prefix.
	//
	//   - If you do not provide a destination, Amazon FSx will create and use a log
	//   stream in the CloudWatch Logs /aws/fsx/lustre log group (for Amazon FSx for
	//   Lustre) or /aws/fsx/filecache (for Amazon File Cache).
	//
	//   - If Destination is provided and the resource does not exist, the request will
	//   fail with a BadRequest error.
	//
	//   - If Level is set to DISABLED , you cannot specify a destination in
	//   Destination .
	Destination *string

	noSmithyDocumentSerde
}

// The configuration for Lustre root squash used to restrict root-level access
// from clients that try to access your FSx for Lustre file system as root. Use the
// RootSquash parameter to enable root squash. To learn more about Lustre root
// squash, see [Lustre root squash].
//
// You can also use the NoSquashNids parameter to provide an array of clients who
// are not affected by the root squash setting. These clients will access the file
// system as root, with unrestricted privileges.
//
// [Lustre root squash]: https://docs.aws.amazon.com/fsx/latest/LustreGuide/root-squash.html
type LustreRootSquashConfiguration struct {

	// When root squash is enabled, you can optionally specify an array of NIDs of
	// clients for which root squash does not apply. A client NID is a Lustre Network
	// Identifier used to uniquely identify a client. You can specify the NID as either
	// a single address or a range of addresses:
	//
	//   - A single address is described in standard Lustre NID format by specifying
	//   the client’s IP address followed by the Lustre network ID (for example,
	//   10.0.1.6@tcp ).
	//
	//   - An address range is described using a dash to separate the range (for
	//   example, 10.0.[2-10].[1-255]@tcp ).
	NoSquashNids []string

	// You enable root squash by setting a user ID (UID) and group ID (GID) for the
	// file system in the format UID:GID (for example, 365534:65534 ). The UID and GID
	// values can range from 0 to 4294967294 :
	//
	//   - A non-zero value for UID and GID enables root squash. The UID and GID
	//   values can be different, but each must be a non-zero value.
	//
	//   - A value of 0 (zero) for UID and GID indicates root, and therefore disables
	//   root squash.
	//
	// When root squash is enabled, the user ID and group ID of a root user accessing
	// the file system are re-mapped to the UID and GID you provide.
	RootSquash *string

	noSmithyDocumentSerde
}

// The configuration for a data repository association that links an Amazon File
// Cache resource to an NFS data repository.
type NFSDataRepositoryConfiguration struct {

	// The version of the NFS (Network File System) protocol of the NFS data
	// repository. Currently, the only supported value is NFS3 , which indicates that
	// the data repository must support the NFSv3 protocol.
	//
	// This member is required.
	Version NfsVersion

	// This parameter is not supported for Amazon File Cache.
	AutoExportPolicy *AutoExportPolicy

	// A list of up to 2 IP addresses of DNS servers used to resolve the NFS file
	// system domain name. The provided IP addresses can either be the IP addresses of
	// a DNS forwarder or resolver that the customer manages and runs inside the
	// customer VPC, or the IP addresses of the on-premises DNS servers.
	DnsIps []string

	noSmithyDocumentSerde
}

// Configuration for the FSx for NetApp ONTAP file system.
type OntapFileSystemConfiguration struct {

	// The number of days to retain automatic backups. Setting this property to 0
	// disables automatic backups. You can retain automatic backups for a maximum of 90
	// days. The default is 30 .
	AutomaticBackupRetentionDays *int32

	// A recurring daily time, in the format HH:MM . HH is the zero-padded hour of the
	// day (0-23), and MM is the zero-padded minute of the hour. For example, 05:00
	// specifies 5 AM daily.
	DailyAutomaticBackupStartTime *string

	// Specifies the FSx for ONTAP file system deployment type in use in the file
	// system.
	//
	//   - MULTI_AZ_1 - A high availability file system configured for Multi-AZ
	//   redundancy to tolerate temporary Availability Zone (AZ) unavailability. This is
	//   a first-generation FSx for ONTAP file system.
	//
	//   - MULTI_AZ_2 - A high availability file system configured for Multi-AZ
	//   redundancy to tolerate temporary AZ unavailability. This is a second-generation
	//   FSx for ONTAP file system.
	//
	//   - SINGLE_AZ_1 - A file system configured for Single-AZ redundancy. This is a
	//   first-generation FSx for ONTAP file system.
	//
	//   - SINGLE_AZ_2 - A file system configured with multiple high-availability (HA)
	//   pairs for Single-AZ redundancy. This is a second-generation FSx for ONTAP file
	//   system.
	//
	// For information about the use cases for Multi-AZ and Single-AZ deployments,
	// refer to [Choosing Multi-AZ or Single-AZ file system deployment].
	//
	// [Choosing Multi-AZ or Single-AZ file system deployment]: https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/high-availability-multiAZ.html
	DeploymentType OntapDeploymentType

	// The SSD IOPS configuration for the ONTAP file system, specifying the number of
	// provisioned IOPS and the provision mode.
	DiskIopsConfiguration *DiskIopsConfiguration

	// (Multi-AZ only) Specifies the IP address range in which the endpoints to access
	// your file system will be created. By default in the Amazon FSx API, Amazon FSx
	// selects an unused IP address range for you from the 198.19.* range. By default
	// in the Amazon FSx console, Amazon FSx chooses the last 64 IP addresses from the
	// VPC’s primary CIDR range to use as the endpoint IP address range for the file
	// system. You can have overlapping endpoint IP addresses for file systems deployed
	// in the same VPC/route tables.
	EndpointIpAddressRange *string

	// The Management and Intercluster endpoints that are used to access data or to
	// manage the file system using the NetApp ONTAP CLI, REST API, or NetApp
	// SnapMirror.
	Endpoints *FileSystemEndpoints

	// You can use the fsxadmin user account to access the NetApp ONTAP CLI and REST
	// API. The password value is always redacted in the response.
	FsxAdminPassword *string

	// Specifies how many high-availability (HA) file server pairs the file system
	// will have. The default value is 1. The value of this property affects the values
	// of StorageCapacity , Iops , and ThroughputCapacity . For more information, see [High-availability (HA) pairs]
	// in the FSx for ONTAP user guide.
	//
	// Amazon FSx responds with an HTTP status code 400 (Bad Request) for the
	// following conditions:
	//
	//   - The value of HAPairs is less than 1 or greater than 12.
	//
	//   - The value of HAPairs is greater than 1 and the value of DeploymentType is
	//   SINGLE_AZ_1 , MULTI_AZ_1 , or MULTI_AZ_2 .
	//
	// [High-availability (HA) pairs]: https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/HA-pairs.html
	HAPairs *int32

	// The ID for a subnet. A subnet is a range of IP addresses in your virtual
	// private cloud (VPC). For more information, see [VPC and subnets]in the Amazon VPC User Guide.
	//
	// [VPC and subnets]: https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_Subnets.html
	PreferredSubnetId *string

	// (Multi-AZ only) The VPC route tables in which your file system's endpoints are
	// created.
	RouteTableIds []string

	// The sustained throughput of an Amazon FSx file system in Megabytes per second
	// (MBps).
	ThroughputCapacity *int32

	// Use to choose the throughput capacity per HA pair. When the value of HAPairs is
	// equal to 1, the value of ThroughputCapacityPerHAPair is the total throughput
	// for the file system.
	//
	// This field and ThroughputCapacity cannot be defined in the same API call, but
	// one is required.
	//
	// This field and ThroughputCapacity are the same for file systems with one HA
	// pair.
	//
	//   - For SINGLE_AZ_1 and MULTI_AZ_1 file systems, valid values are 128, 256, 512,
	//   1024, 2048, or 4096 MBps.
	//
	//   - For SINGLE_AZ_2 , valid values are 1536, 3072, or 6144 MBps.
	//
	//   - For MULTI_AZ_2 , valid values are 384, 768, 1536, 3072, or 6144 MBps.
	//
	// Amazon FSx responds with an HTTP status code 400 (Bad Request) for the
	// following conditions:
	//
	//   - The value of ThroughputCapacity and ThroughputCapacityPerHAPair are not the
	//   same value.
	//
	//   - The value of deployment type is SINGLE_AZ_2 and ThroughputCapacity /
	//   ThroughputCapacityPerHAPair is not a valid HA pair (a value between 1 and 12).
	//
	//   - The value of ThroughputCapacityPerHAPair is not a valid value.
	ThroughputCapacityPerHAPair *int32

	// A recurring weekly time, in the format D:HH:MM .
	//
	// D is the day of the week, for which 1 represents Monday and 7 represents
	// Sunday. For further details, see [the ISO-8601 spec as described on Wikipedia].
	//
	// HH is the zero-padded hour of the day (0-23), and MM is the zero-padded minute
	// of the hour.
	//
	// For example, 1:05:00 specifies maintenance at 5 AM Monday.
	//
	// [the ISO-8601 spec as described on Wikipedia]: https://en.wikipedia.org/wiki/ISO_week_date
	WeeklyMaintenanceStartTime *string

	noSmithyDocumentSerde
}

// The configuration of an Amazon FSx for NetApp ONTAP volume.
type OntapVolumeConfiguration struct {

	// This structure specifies configuration options for a volume’s storage aggregate
	// or aggregates.
	AggregateConfiguration *AggregateConfiguration

	// A boolean flag indicating whether tags for the volume should be copied to
	// backups. This value defaults to false. If it's set to true, all tags for the
	// volume are copied to all automatic and user-initiated backups where the user
	// doesn't specify tags. If this value is true, and you specify one or more tags,
	// only the specified tags are copied to backups. If you specify one or more tags
	// when creating a user-initiated backup, no tags are copied from the volume,
	// regardless of this value.
	CopyTagsToBackups *bool

	// Specifies the FlexCache endpoint type of the volume. Valid values are the
	// following:
	//
	//   - NONE specifies that the volume doesn't have a FlexCache configuration. NONE
	//   is the default.
	//
	//   - ORIGIN specifies that the volume is the origin volume for a FlexCache volume.
	//
	//   - CACHE specifies that the volume is a FlexCache volume.
	FlexCacheEndpointType FlexCacheEndpointType

	// Specifies the directory that network-attached storage (NAS) clients use to
	// mount the volume, along with the storage virtual machine (SVM) Domain Name
	// System (DNS) name or IP address. You can create a JunctionPath directly below a
	// parent volume junction or on a directory within a volume. A JunctionPath for a
	// volume named vol3 might be /vol1/vol2/vol3 , or /vol1/dir2/vol3 , or even
	// /dir1/dir2/vol3 .
	JunctionPath *string

	// Specifies the type of volume. Valid values are the following:
	//
	//   - RW specifies a read/write volume. RW is the default.
	//
	//   - DP specifies a data-protection volume. You can protect data by replicating
	//   it to data-protection mirror copies. If a disaster occurs, you can use these
	//   data-protection mirror copies to recover data.
	//
	//   - LS specifies a load-sharing mirror volume. A load-sharing mirror reduces the
	//   network traffic to a FlexVol volume by providing additional read-only access to
	//   clients.
	OntapVolumeType OntapVolumeType

	// The security style for the volume, which can be UNIX , NTFS , or MIXED .
	SecurityStyle SecurityStyle

	// The configured size of the volume, in bytes.
	SizeInBytes *int64

	// The configured size of the volume, in megabytes (MBs).
	SizeInMegabytes *int32

	// The SnapLock configuration object for an FSx for ONTAP SnapLock volume.
	SnaplockConfiguration *SnaplockConfiguration

	// Specifies the snapshot policy for the volume. There are three built-in snapshot
	// policies:
	//
	//   - default : This is the default policy. A maximum of six hourly snapshots
	//   taken five minutes past the hour. A maximum of two daily snapshots taken Monday
	//   through Saturday at 10 minutes after midnight. A maximum of two weekly snapshots
	//   taken every Sunday at 15 minutes after midnight.
	//
	//   - default-1weekly : This policy is the same as the default policy except that
	//   it only retains one snapshot from the weekly schedule.
	//
	//   - none : This policy does not take any snapshots. This policy can be assigned
	//   to volumes to prevent automatic snapshots from being taken.
	//
	// You can also provide the name of a custom policy that you created with the
	// ONTAP CLI or REST API.
	//
	// For more information, see [Snapshot policies] in the Amazon FSx for NetApp ONTAP User Guide.
	//
	// [Snapshot policies]: https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/snapshots-ontap.html#snapshot-policies
	SnapshotPolicy *string

	// The volume's storage efficiency setting.
	StorageEfficiencyEnabled *bool

	// The ID of the volume's storage virtual machine.
	StorageVirtualMachineId *string

	// A Boolean flag indicating whether this volume is the root volume for its
	// storage virtual machine (SVM). Only one volume on an SVM can be the root volume.
	// This value defaults to false . If this value is true , then this is the SVM root
	// volume.
	//
	// This flag is useful when you're deleting an SVM, because you must first delete
	// all non-root volumes. This flag, when set to false , helps you identify which
	// volumes to delete before you can delete the SVM.
	StorageVirtualMachineRoot *bool

	// The volume's TieringPolicy setting.
	TieringPolicy *TieringPolicy

	// The volume's universally unique identifier (UUID).
	UUID *string

	// Use to specify the style of an ONTAP volume. For more information about
	// FlexVols and FlexGroups, see [Volume types]in Amazon FSx for NetApp ONTAP User Guide.
	//
	// [Volume types]: https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/volume-types.html
	VolumeStyle VolumeStyle

	noSmithyDocumentSerde
}

// Specifies who can mount an OpenZFS file system and the options available while
// mounting the file system.
type OpenZFSClientConfiguration struct {

	// A value that specifies who can mount the file system. You can provide a
	// wildcard character ( * ), an IP address ( 0.0.0.0 ), or a CIDR address (
	// 192.0.2.0/24 ). By default, Amazon FSx uses the wildcard character when
	// specifying the client.
	//
	// This member is required.
	Clients *string

	// The options to use when mounting the file system. For a list of options that
	// you can use with Network File System (NFS), see the [exports(5) - Linux man page]. When choosing your
	// options, consider the following:
	//
	//   - crossmnt is used by default. If you don't specify crossmnt when changing the
	//   client configuration, you won't be able to see or access snapshots in your file
	//   system's snapshot directory.
	//
	//   - sync is used by default. If you instead specify async , the system
	//   acknowledges writes before writing to disk. If the system crashes before the
	//   writes are finished, you lose the unwritten data.
	//
	// [exports(5) - Linux man page]: https://linux.die.net/man/5/exports
	//
	// This member is required.
	Options []string

	noSmithyDocumentSerde
}

// The configuration of an Amazon FSx for OpenZFS root volume.
type OpenZFSCreateRootVolumeConfiguration struct {

	// A Boolean value indicating whether tags for the volume should be copied to
	// snapshots of the volume. This value defaults to false . If it's set to true ,
	// all tags for the volume are copied to snapshots where the user doesn't specify
	// tags. If this value is true and you specify one or more tags, only the
	// specified tags are copied to snapshots. If you specify one or more tags when
	// creating the snapshot, no tags are copied from the volume, regardless of this
	// value.
	CopyTagsToSnapshots *bool

	// Specifies the method used to compress the data on the volume. The compression
	// type is NONE by default.
	//
	//   - NONE - Doesn't compress the data on the volume. NONE is the default.
	//
	//   - ZSTD - Compresses the data in the volume using the Zstandard (ZSTD)
	//   compression algorithm. Compared to LZ4, Z-Standard provides a better compression
	//   ratio to minimize on-disk storage utilization.
	//
	//   - LZ4 - Compresses the data in the volume using the LZ4 compression algorithm.
	//   Compared to Z-Standard, LZ4 is less compute-intensive and delivers higher write
	//   throughput speeds.
	DataCompressionType OpenZFSDataCompressionType

	// The configuration object for mounting a file system.
	NfsExports []OpenZFSNfsExport

	// A Boolean value indicating whether the volume is read-only. Setting this value
	// to true can be useful after you have completed changes to a volume and no
	// longer want changes to occur.
	ReadOnly *bool

	// Specifies the record size of an OpenZFS root volume, in kibibytes (KiB). Valid
	// values are 4, 8, 16, 32, 64, 128, 256, 512, or 1024 KiB. The default is 128 KiB.
	// Most workloads should use the default record size. Database workflows can
	// benefit from a smaller record size, while streaming workflows can benefit from a
	// larger record size. For additional guidance on setting a custom record size, see
	// [Tips for maximizing performance]in the Amazon FSx for OpenZFS User Guide.
	//
	// [Tips for maximizing performance]: https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/performance.html#performance-tips-zfs
	RecordSizeKiB *int32

	// An object specifying how much storage users or groups can use on the volume.
	UserAndGroupQuotas []OpenZFSUserOrGroupQuota

	noSmithyDocumentSerde
}

// The configuration for the Amazon FSx for OpenZFS file system.
type OpenZFSFileSystemConfiguration struct {

	// The number of days to retain automatic backups. Setting this property to 0
	// disables automatic backups. You can retain automatic backups for a maximum of 90
	// days. The default is 30 .
	AutomaticBackupRetentionDays *int32

	// A Boolean value indicating whether tags on the file system should be copied to
	// backups. If it's set to true , all tags on the file system are copied to all
	// automatic backups and any user-initiated backups where the user doesn't specify
	// any tags. If this value is true and you specify one or more tags, only the
	// specified tags are copied to backups. If you specify one or more tags when
	// creating a user-initiated backup, no tags are copied from the file system,
	// regardless of this value.
	CopyTagsToBackups *bool

	// A Boolean value indicating whether tags for the volume should be copied to
	// snapshots. This value defaults to false . If it's set to true , all tags for the
	// volume are copied to snapshots where the user doesn't specify tags. If this
	// value is true and you specify one or more tags, only the specified tags are
	// copied to snapshots. If you specify one or more tags when creating the snapshot,
	// no tags are copied from the volume, regardless of this value.
	CopyTagsToVolumes *bool

	// A recurring daily time, in the format HH:MM . HH is the zero-padded hour of the
	// day (0-23), and MM is the zero-padded minute of the hour. For example, 05:00
	// specifies 5 AM daily.
	DailyAutomaticBackupStartTime *string

	// Specifies the file-system deployment type. Amazon FSx for OpenZFS supports
	// MULTI_AZ_1 , SINGLE_AZ_HA_2 , SINGLE_AZ_HA_1 , SINGLE_AZ_2 , and SINGLE_AZ_1 .
	DeploymentType OpenZFSDeploymentType

	// The SSD IOPS (input/output operations per second) configuration for an Amazon
	// FSx for NetApp ONTAP, Amazon FSx for Windows File Server, or FSx for OpenZFS
	// file system. By default, Amazon FSx automatically provisions 3 IOPS per GB of
	// storage capacity. You can provision additional IOPS per GB of storage. The
	// configuration consists of the total number of provisioned SSD IOPS and how it is
	// was provisioned, or the mode (by the customer or by Amazon FSx).
	DiskIopsConfiguration *DiskIopsConfiguration

	// The IP address of the endpoint that is used to access data or to manage the
	// file system.
	EndpointIpAddress *string

	// (Multi-AZ only) Specifies the IP address range in which the endpoints to access
	// your file system will be created. By default in the Amazon FSx API and Amazon
	// FSx console, Amazon FSx selects an available /28 IP address range for you from
	// one of the VPC's CIDR ranges. You can have overlapping endpoint IP addresses for
	// file systems deployed in the same VPC/route tables.
	EndpointIpAddressRange *string

	// Required when DeploymentType is set to MULTI_AZ_1 . This specifies the subnet in
	// which you want the preferred file server to be located.
	PreferredSubnetId *string

	//  Required when StorageType is set to INTELLIGENT_TIERING . Specifies the
	// optional provisioned SSD read cache.
	ReadCacheConfiguration *OpenZFSReadCacheConfiguration

	// The ID of the root volume of the OpenZFS file system.
	RootVolumeId *string

	// (Multi-AZ only) The VPC route tables in which your file system's endpoints are
	// created.
	RouteTableIds []string

	// The throughput of an Amazon FSx file system, measured in megabytes per second
	// (MBps).
	ThroughputCapacity *int32

	// A recurring weekly time, in the format D:HH:MM .
	//
	// D is the day of the week, for which 1 represents Monday and 7 represents
	// Sunday. For further details, see [the ISO-8601 spec as described on Wikipedia].
	//
	// HH is the zero-padded hour of the day (0-23), and MM is the zero-padded minute
	// of the hour.
	//
	// For example, 1:05:00 specifies maintenance at 5 AM Monday.
	//
	// [the ISO-8601 spec as described on Wikipedia]: https://en.wikipedia.org/wiki/ISO_week_date
	WeeklyMaintenanceStartTime *string

	noSmithyDocumentSerde
}

// The Network File System (NFS) configurations for mounting an Amazon FSx for
// OpenZFS file system.
type OpenZFSNfsExport struct {

	// A list of configuration objects that contain the client and options for
	// mounting the OpenZFS file system.
	//
	// This member is required.
	ClientConfigurations []OpenZFSClientConfiguration

	noSmithyDocumentSerde
}

// The snapshot configuration used when creating an Amazon FSx for OpenZFS volume
// from a snapshot.
type OpenZFSOriginSnapshotConfiguration struct {

	// The strategy used when copying data from the snapshot to the new volume.
	//
	//   - CLONE - The new volume references the data in the origin snapshot. Cloning a
	//   snapshot is faster than copying the data from a snapshot to a new volume and
	//   doesn't consume disk throughput. However, the origin snapshot can't be deleted
	//   if there is a volume using its copied data.
	//
	//   - FULL_COPY - Copies all data from the snapshot to the new volume.
	//
	// The INCREMENTAL_COPY option is only for updating an existing volume by using a
	// snapshot from another FSx for OpenZFS file system. For more information, see [CopySnapshotAndUpdateVolume].
	//
	// [CopySnapshotAndUpdateVolume]: https://docs.aws.amazon.com/fsx/latest/APIReference/API_CopySnapshotAndUpdateVolume.html
	CopyStrategy OpenZFSCopyStrategy

	// The Amazon Resource Name (ARN) for a given resource. ARNs uniquely identify
	// Amazon Web Services resources. We require an ARN when you need to specify a
	// resource unambiguously across all of Amazon Web Services. For more information,
	// see [Amazon Resource Names (ARNs)]in the Amazon Web Services General Reference.
	//
	// [Amazon Resource Names (ARNs)]: https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html
	SnapshotARN *string

	noSmithyDocumentSerde
}

//	The configuration for the optional provisioned SSD read cache on file systems
//
// that use the Intelligent-Tiering storage class.
type OpenZFSReadCacheConfiguration struct {

	//  Required if SizingMode is set to USER_PROVISIONED . Specifies the size of the
	// file system's SSD read cache, in gibibytes (GiB).
	SizeGiB *int32

	//  Specifies how the provisioned SSD read cache is sized, as follows:
	//
	//   - Set to NO_CACHE if you do not want to use an SSD read cache with your
	//   Intelligent-Tiering file system.
	//
	//   - Set to USER_PROVISIONED to specify the exact size of your SSD read cache.
	//
	//   - Set to PROPORTIONAL_TO_THROUGHPUT_CAPACITY to have your SSD read cache
	//   automatically sized based on your throughput capacity.
	SizingMode OpenZFSReadCacheSizingMode

	noSmithyDocumentSerde
}

// Used to configure quotas that define how much storage a user or group can use
// on an FSx for OpenZFS volume. For more information, see [Volume properties]in the FSx for OpenZFS
// User Guide.
//
// [Volume properties]: https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/managing-volumes.html#volume-properties
type OpenZFSUserOrGroupQuota struct {

	// The ID of the user or group that the quota applies to.
	//
	// This member is required.
	Id *int32

	// The user or group's storage quota, in gibibytes (GiB).
	//
	// This member is required.
	StorageCapacityQuotaGiB *int32

	// Specifies whether the quota applies to a user or group.
	//
	// This member is required.
	Type OpenZFSQuotaType

	noSmithyDocumentSerde
}

// The configuration of an Amazon FSx for OpenZFS volume.
type OpenZFSVolumeConfiguration struct {

	// Specifies the strategy used when copying data from the snapshot to the new
	// volume.
	//
	//   - CLONE - The new volume references the data in the origin snapshot. Cloning a
	//   snapshot is faster than copying data from the snapshot to a new volume and
	//   doesn't consume disk throughput. However, the origin snapshot can't be deleted
	//   if there is a volume using its copied data.
	//
	//   - FULL_COPY - Copies all data from the snapshot to the new volume.
	//
	// Specify this option to create the volume from a snapshot on another FSx for
	//   OpenZFS file system.
	//
	// The INCREMENTAL_COPY option is only for updating an existing volume by using a
	// snapshot from another FSx for OpenZFS file system. For more information, see [CopySnapshotAndUpdateVolume].
	//
	// [CopySnapshotAndUpdateVolume]: https://docs.aws.amazon.com/fsx/latest/APIReference/API_CopySnapshotAndUpdateVolume.html
	CopyStrategy OpenZFSCopyStrategy

	// A Boolean value indicating whether tags for the volume should be copied to
	// snapshots. This value defaults to false . If it's set to true , all tags for the
	// volume are copied to snapshots where the user doesn't specify tags. If this
	// value is true and you specify one or more tags, only the specified tags are
	// copied to snapshots. If you specify one or more tags when creating the snapshot,
	// no tags are copied from the volume, regardless of this value.
	CopyTagsToSnapshots *bool

	// Specifies the method used to compress the data on the volume. The compression
	// type is NONE by default.
	//
	//   - NONE - Doesn't compress the data on the volume. NONE is the default.
	//
	//   - ZSTD - Compresses the data in the volume using the Zstandard (ZSTD)
	//   compression algorithm. Compared to LZ4, Z-Standard provides a better compression
	//   ratio to minimize on-disk storage utilization.
	//
	//   - LZ4 - Compresses the data in the volume using the LZ4 compression algorithm.
	//   Compared to Z-Standard, LZ4 is less compute-intensive and delivers higher write
	//   throughput speeds.
	DataCompressionType OpenZFSDataCompressionType

	// A Boolean value indicating whether dependent clone volumes created from
	// intermediate snapshots should be deleted when a volume is restored from
	// snapshot.
	DeleteClonedVolumes *bool

	// A Boolean value indicating whether snapshot data that differs between the
	// current state and the specified snapshot should be overwritten when a volume is
	// restored from a snapshot.
	DeleteIntermediateData *bool

	// A Boolean value indicating whether snapshots between the current state and the
	// specified snapshot should be deleted when a volume is restored from snapshot.
	DeleteIntermediateSnaphots *bool

	// The ID of the snapshot that's being copied or was most recently copied to the
	// destination volume.
	DestinationSnapshot *string

	// The configuration object for mounting a Network File System (NFS) file system.
	NfsExports []OpenZFSNfsExport

	// The configuration object that specifies the snapshot to use as the origin of
	// the data for the volume.
	OriginSnapshot *OpenZFSOriginSnapshotConfiguration

	// The ID of the parent volume.
	ParentVolumeId *string

	// A Boolean value indicating whether the volume is read-only.
	ReadOnly *bool

	// The record size of an OpenZFS volume, in kibibytes (KiB). Valid values are 4,
	// 8, 16, 32, 64, 128, 256, 512, or 1024 KiB. The default is 128 KiB. Most
	// workloads should use the default record size. For guidance on when to set a
	// custom record size, see the Amazon FSx for OpenZFS User Guide.
	RecordSizeKiB *int32

	// Specifies the ID of the snapshot to which the volume was restored.
	RestoreToSnapshot *string

	// The Amazon Resource Name (ARN) for a given resource. ARNs uniquely identify
	// Amazon Web Services resources. We require an ARN when you need to specify a
	// resource unambiguously across all of Amazon Web Services. For more information,
	// see [Amazon Resource Names (ARNs)]in the Amazon Web Services General Reference.
	//
	// [Amazon Resource Names (ARNs)]: https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html
	SourceSnapshotARN *string

	// The maximum amount of storage in gibibytes (GiB) that the volume can use from
	// its parent. You can specify a quota larger than the storage on the parent
	// volume.
	StorageCapacityQuotaGiB *int32

	// The amount of storage in gibibytes (GiB) to reserve from the parent volume. You
	// can't reserve more storage than the parent volume has reserved.
	StorageCapacityReservationGiB *int32

	// An object specifying how much storage users or groups can use on the volume.
	UserAndGroupQuotas []OpenZFSUserOrGroupQuota

	// The path to the volume from the root volume. For example,
	// fsx/parentVolume/volume1 .
	VolumePath *string

	noSmithyDocumentSerde
}

// The configuration that specifies a minimum amount of time since last access for
// an exported file to be eligible for release from an Amazon FSx for Lustre file
// system. Only files that were last accessed before this point-in-time can be
// released. For example, if you specify a last accessed time criteria of 9 days,
// only files that were last accessed 9.00001 or more days ago can be released.
//
// Only file data that has been exported to S3 can be released. Files that have
// not yet been exported to S3, such as new or changed files that have not been
// exported, are not eligible for release. When files are released, their metadata
// stays on the file system, so they can still be accessed later. Users and
// applications can access a released file by reading the file again, which
// restores data from Amazon S3 to the FSx for Lustre file system.
//
// If a file meets the last accessed time criteria, its file or directory path
// must also be specified with the Paths parameter of the operation in order for
// the file to be released.
type ReleaseConfiguration struct {

	// Defines the point-in-time since an exported file was last accessed, in order
	// for that file to be eligible for release. Only files that were last accessed
	// before this point-in-time are eligible to be released from the file system.
	DurationSinceLastAccess *DurationSinceLastAccess

	noSmithyDocumentSerde
}

// Specifies the retention period of an FSx for ONTAP SnapLock volume. After it is
// set, it can't be changed. Files can't be deleted or modified during the
// retention period.
//
// For more information, see [Working with the retention period in SnapLock].
//
// [Working with the retention period in SnapLock]: https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/snaplock-retention.html
type RetentionPeriod struct {

	// Defines the type of time for the retention period of an FSx for ONTAP SnapLock
	// volume. Set it to one of the valid types. If you set it to INFINITE , the files
	// are retained forever. If you set it to UNSPECIFIED , the files are retained
	// until you set an explicit retention period.
	//
	// This member is required.
	Type RetentionPeriodType

	// Defines the amount of time for the retention period of an FSx for ONTAP
	// SnapLock volume. You can't set a value for INFINITE or UNSPECIFIED . For all
	// other options, the following ranges are valid:
	//
	//   - Seconds : 0 - 65,535
	//
	//   - Minutes : 0 - 65,535
	//
	//   - Hours : 0 - 24
	//
	//   - Days : 0 - 365
	//
	//   - Months : 0 - 12
	//
	//   - Years : 0 - 100
	Value *int32

	noSmithyDocumentSerde
}

// The configuration for an Amazon S3 data repository linked to an Amazon FSx for
// Lustre file system with a data repository association. The configuration
// consists of an AutoImportPolicy that defines which file events on the data
// repository are automatically imported to the file system and an AutoExportPolicy
// that defines which file events on the file system are automatically exported to
// the data repository. File events are when files or directories are added,
// changed, or deleted on the file system or the data repository.
//
// Data repository associations on Amazon File Cache don't use
// S3DataRepositoryConfiguration because they don't support automatic import or
// automatic export.
type S3DataRepositoryConfiguration struct {

	// Specifies the type of updated objects (new, changed, deleted) that will be
	// automatically exported from your file system to the linked S3 bucket.
	AutoExportPolicy *AutoExportPolicy

	// Specifies the type of updated objects (new, changed, deleted) that will be
	// automatically imported from the linked S3 bucket to your file system.
	AutoImportPolicy *AutoImportPolicy

	noSmithyDocumentSerde
}

// The configuration of the self-managed Microsoft Active Directory (AD) directory
// to which the Windows File Server or ONTAP storage virtual machine (SVM) instance
// is joined.
type SelfManagedActiveDirectoryAttributes struct {

	// A list of up to three IP addresses of DNS servers or domain controllers in the
	// self-managed AD directory.
	DnsIps []string

	// The fully qualified domain name of the self-managed AD directory.
	DomainName *string

	// The name of the domain group whose members have administrative privileges for
	// the FSx file system.
	FileSystemAdministratorsGroup *string

	// The fully qualified distinguished name of the organizational unit within the
	// self-managed AD directory to which the Windows File Server or ONTAP storage
	// virtual machine (SVM) instance is joined.
	OrganizationalUnitDistinguishedName *string

	// The user name for the service account on your self-managed AD domain that FSx
	// uses to join to your AD domain.
	UserName *string

	noSmithyDocumentSerde
}

// The configuration that Amazon FSx uses to join a FSx for Windows File Server
// file system or an FSx for ONTAP storage virtual machine (SVM) to a self-managed
// (including on-premises) Microsoft Active Directory (AD) directory. For more
// information, see [Using Amazon FSx for Windows with your self-managed Microsoft Active Directory]or [Managing FSx for ONTAP SVMs].
//
// [Using Amazon FSx for Windows with your self-managed Microsoft Active Directory]: https://docs.aws.amazon.com/fsx/latest/WindowsGuide/self-managed-AD.html
// [Managing FSx for ONTAP SVMs]: https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/managing-svms.html
type SelfManagedActiveDirectoryConfiguration struct {

	// A list of up to three IP addresses of DNS servers or domain controllers in the
	// self-managed AD directory.
	//
	// This member is required.
	DnsIps []string

	// The fully qualified domain name of the self-managed AD directory, such as
	// corp.example.com .
	//
	// This member is required.
	DomainName *string

	// The password for the service account on your self-managed AD domain that Amazon
	// FSx will use to join to your AD domain.
	//
	// This member is required.
	Password *string

	// The user name for the service account on your self-managed AD domain that
	// Amazon FSx will use to join to your AD domain. This account must have the
	// permission to join computers to the domain in the organizational unit provided
	// in OrganizationalUnitDistinguishedName , or in the default location of your AD
	// domain.
	//
	// This member is required.
	UserName *string

	// (Optional) The name of the domain group whose members are granted
	// administrative privileges for the file system. Administrative privileges include
	// taking ownership of files and folders, setting audit controls (audit ACLs) on
	// files and folders, and administering the file system remotely by using the FSx
	// Remote PowerShell. The group that you specify must already exist in your domain.
	// If you don't provide one, your AD domain's Domain Admins group is used.
	FileSystemAdministratorsGroup *string

	// (Optional) The fully qualified distinguished name of the organizational unit
	// within your self-managed AD directory. Amazon FSx only accepts OU as the direct
	// parent of the file system. An example is OU=FSx,DC=yourdomain,DC=corp,DC=com .
	// To learn more, see [RFC 2253]. If none is provided, the FSx file system is created in the
	// default location of your self-managed AD directory.
	//
	// Only Organizational Unit (OU) objects can be the direct parent of the file
	// system that you're creating.
	//
	// [RFC 2253]: https://tools.ietf.org/html/rfc2253
	OrganizationalUnitDistinguishedName *string

	noSmithyDocumentSerde
}

// Specifies changes you are making to the self-managed Microsoft Active Directory
// configuration to which an FSx for Windows File Server file system or an FSx for
// ONTAP SVM is joined.
type SelfManagedActiveDirectoryConfigurationUpdates struct {

	// A list of up to three DNS server or domain controller IP addresses in your
	// self-managed Active Directory domain.
	DnsIps []string

	// Specifies an updated fully qualified domain name of your self-managed Active
	// Directory configuration.
	DomainName *string

	// For FSx for ONTAP file systems only - Specifies the updated name of the
	// self-managed Active Directory domain group whose members are granted
	// administrative privileges for the Amazon FSx resource.
	FileSystemAdministratorsGroup *string

	// Specifies an updated fully qualified distinguished name of the organization
	// unit within your self-managed Active Directory.
	OrganizationalUnitDistinguishedName *string

	// Specifies the updated password for the service account on your self-managed
	// Active Directory domain. Amazon FSx uses this account to join to your
	// self-managed Active Directory domain.
	Password *string

	// Specifies the updated user name for the service account on your self-managed
	// Active Directory domain. Amazon FSx uses this account to join to your
	// self-managed Active Directory domain.
	//
	// This account must have the permissions required to join computers to the domain
	// in the organizational unit provided in OrganizationalUnitDistinguishedName .
	UserName *string

	noSmithyDocumentSerde
}

// Specifies the SnapLock configuration for an FSx for ONTAP SnapLock volume.
type SnaplockConfiguration struct {

	// Enables or disables the audit log volume for an FSx for ONTAP SnapLock volume.
	// The default value is false . If you set AuditLogVolume to true , the SnapLock
	// volume is created as an audit log volume. The minimum retention period for an
	// audit log volume is six months.
	//
	// For more information, see [SnapLock audit log volumes].
	//
	// [SnapLock audit log volumes]: https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/how-snaplock-works.html#snaplock-audit-log-volume
	AuditLogVolume *bool

	// The configuration object for setting the autocommit period of files in an FSx
	// for ONTAP SnapLock volume.
	AutocommitPeriod *AutocommitPeriod

	// Enables, disables, or permanently disables privileged delete on an FSx for
	// ONTAP SnapLock Enterprise volume. Enabling privileged delete allows SnapLock
	// administrators to delete write once, read many (WORM) files even if they have
	// active retention periods. PERMANENTLY_DISABLED is a terminal state. If
	// privileged delete is permanently disabled on a SnapLock volume, you can't
	// re-enable it. The default value is DISABLED .
	//
	// For more information, see [Privileged delete].
	//
	// [Privileged delete]: https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/snaplock-enterprise.html#privileged-delete
	PrivilegedDelete PrivilegedDelete

	// Specifies the retention period of an FSx for ONTAP SnapLock volume.
	RetentionPeriod *SnaplockRetentionPeriod

	// Specifies the retention mode of an FSx for ONTAP SnapLock volume. After it is
	// set, it can't be changed. You can choose one of the following retention modes:
	//
	//   - COMPLIANCE : Files transitioned to write once, read many (WORM) on a
	//   Compliance volume can't be deleted until their retention periods expire. This
	//   retention mode is used to address government or industry-specific mandates or to
	//   protect against ransomware attacks. For more information, see [SnapLock Compliance].
	//
	//   - ENTERPRISE : Files transitioned to WORM on an Enterprise volume can be
	//   deleted by authorized users before their retention periods expire using
	//   privileged delete. This retention mode is used to advance an organization's data
	//   integrity and internal compliance or to test retention settings before using
	//   SnapLock Compliance. For more information, see [SnapLock Enterprise].
	//
	// [SnapLock Enterprise]: https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/snaplock-enterprise.html
	// [SnapLock Compliance]: https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/snaplock-compliance.html
	SnaplockType SnaplockType

	// Enables or disables volume-append mode on an FSx for ONTAP SnapLock volume.
	// Volume-append mode allows you to create WORM-appendable files and write data to
	// them incrementally. The default value is false .
	//
	// For more information, see [Volume-append mode].
	//
	// [Volume-append mode]: https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/worm-state.html#worm-state-append
	VolumeAppendModeEnabled *bool

	noSmithyDocumentSerde
}

// The configuration to set the retention period of an FSx for ONTAP SnapLock
// volume. The retention period includes default, maximum, and minimum settings.
// For more information, see [Working with the retention period in SnapLock].
//
// [Working with the retention period in SnapLock]: https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/snaplock-retention.html
type SnaplockRetentionPeriod struct {

	// The retention period assigned to a write once, read many (WORM) file by default
	// if an explicit retention period is not set for an FSx for ONTAP SnapLock volume.
	// The default retention period must be greater than or equal to the minimum
	// retention period and less than or equal to the maximum retention period.
	//
	// This member is required.
	DefaultRetention *RetentionPeriod

	// The longest retention period that can be assigned to a WORM file on an FSx for
	// ONTAP SnapLock volume.
	//
	// This member is required.
	MaximumRetention *RetentionPeriod

	// The shortest retention period that can be assigned to a WORM file on an FSx for
	// ONTAP SnapLock volume.
	//
	// This member is required.
	MinimumRetention *RetentionPeriod

	noSmithyDocumentSerde
}

// A snapshot of an Amazon FSx for OpenZFS volume.
type Snapshot struct {

	// A list of administrative actions for the file system that are in process or
	// waiting to be processed. Administrative actions describe changes to the Amazon
	// FSx system.
	AdministrativeActions []AdministrativeAction

	// The time that the resource was created, in seconds (since
	// 1970-01-01T00:00:00Z), also known as Unix time.
	CreationTime *time.Time

	// The lifecycle status of the snapshot.
	//
	//   - PENDING - Amazon FSx hasn't started creating the snapshot.
	//
	//   - CREATING - Amazon FSx is creating the snapshot.
	//
	//   - DELETING - Amazon FSx is deleting the snapshot.
	//
	//   - AVAILABLE - The snapshot is fully available.
	Lifecycle SnapshotLifecycle

	// Describes why a resource lifecycle state changed.
	LifecycleTransitionReason *LifecycleTransitionReason

	// The name of the snapshot.
	Name *string

	// The Amazon Resource Name (ARN) for a given resource. ARNs uniquely identify
	// Amazon Web Services resources. We require an ARN when you need to specify a
	// resource unambiguously across all of Amazon Web Services. For more information,
	// see [Amazon Resource Names (ARNs)]in the Amazon Web Services General Reference.
	//
	// [Amazon Resource Names (ARNs)]: https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html
	ResourceARN *string

	// The ID of the snapshot.
	SnapshotId *string

	// A list of Tag values, with a maximum of 50 elements.
	Tags []Tag

	// The ID of the volume that the snapshot is of.
	VolumeId *string

	noSmithyDocumentSerde
}

// A filter used to restrict the results of DescribeSnapshots calls. You can use
// multiple filters to return results that meet all applied filter requirements.
type SnapshotFilter struct {

	// The name of the filter to use. You can filter by the file-system-id or by
	// volume-id .
	Name SnapshotFilterName

	// The file-system-id or volume-id that you are filtering for.
	Values []string

	noSmithyDocumentSerde
}

// Describes the Amazon FSx for NetApp ONTAP storage virtual machine (SVM)
// configuration.
type StorageVirtualMachine struct {

	// Describes the Microsoft Active Directory configuration to which the SVM is
	// joined, if applicable.
	ActiveDirectoryConfiguration *SvmActiveDirectoryConfiguration

	// The time that the resource was created, in seconds (since
	// 1970-01-01T00:00:00Z), also known as Unix time.
	CreationTime *time.Time

	// The endpoints that are used to access data or to manage the SVM using the
	// NetApp ONTAP CLI, REST API, or NetApp CloudManager. They are the Iscsi ,
	// Management , Nfs , and Smb endpoints.
	Endpoints *SvmEndpoints

	// The globally unique ID of the file system, assigned by Amazon FSx.
	FileSystemId *string

	// Describes the SVM's lifecycle status.
	//
	//   - CREATED - The SVM is fully available for use.
	//
	//   - CREATING - Amazon FSx is creating the new SVM.
	//
	//   - DELETING - Amazon FSx is deleting an existing SVM.
	//
	//   - FAILED - Amazon FSx was unable to create the SVM.
	//
	//   - MISCONFIGURED - The SVM is in a failed but recoverable state.
	//
	//   - PENDING - Amazon FSx has not started creating the SVM.
	Lifecycle StorageVirtualMachineLifecycle

	// Describes why the SVM lifecycle state changed.
	LifecycleTransitionReason *LifecycleTransitionReason

	// The name of the SVM, if provisioned.
	Name *string

	// The Amazon Resource Name (ARN) for a given resource. ARNs uniquely identify
	// Amazon Web Services resources. We require an ARN when you need to specify a
	// resource unambiguously across all of Amazon Web Services. For more information,
	// see [Amazon Resource Names (ARNs)]in the Amazon Web Services General Reference.
	//
	// [Amazon Resource Names (ARNs)]: https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html
	ResourceARN *string

	// The security style of the root volume of the SVM.
	RootVolumeSecurityStyle StorageVirtualMachineRootVolumeSecurityStyle

	// The SVM's system generated unique ID.
	StorageVirtualMachineId *string

	// Describes the SVM's subtype.
	Subtype StorageVirtualMachineSubtype

	// A list of Tag values, with a maximum of 50 elements.
	Tags []Tag

	// The SVM's UUID (universally unique identifier).
	UUID *string

	noSmithyDocumentSerde
}

// A filter used to restrict the results of describe calls for Amazon FSx for
// NetApp ONTAP storage virtual machines (SVMs). You can use multiple filters to
// return results that meet all applied filter requirements.
type StorageVirtualMachineFilter struct {

	// The name for this filter.
	Name StorageVirtualMachineFilterName

	// The values of the filter. These are all the values for any of the applied
	// filters.
	Values []string

	noSmithyDocumentSerde
}

// Describes the Microsoft Active Directory (AD) directory configuration to which
// the FSx for ONTAP storage virtual machine (SVM) is joined. Note that account
// credentials are not returned in the response payload.
type SvmActiveDirectoryConfiguration struct {

	// The NetBIOS name of the AD computer object to which the SVM is joined.
	NetBiosName *string

	// The configuration of the self-managed Microsoft Active Directory (AD) directory
	// to which the Windows File Server or ONTAP storage virtual machine (SVM) instance
	// is joined.
	SelfManagedActiveDirectoryConfiguration *SelfManagedActiveDirectoryAttributes

	noSmithyDocumentSerde
}

// An Amazon FSx for NetApp ONTAP storage virtual machine (SVM) has four endpoints
// that are used to access data or to manage the SVM using the NetApp ONTAP CLI,
// REST API, or NetApp CloudManager. They are the Iscsi , Management , Nfs , and
// Smb endpoints.
type SvmEndpoint struct {

	// The file system's DNS name. You can mount your file system using its DNS name.
	DNSName *string

	// The SVM endpoint's IP addresses.
	IpAddresses []string

	noSmithyDocumentSerde
}

// An Amazon FSx for NetApp ONTAP storage virtual machine (SVM) has the following
// endpoints that are used to access data or to manage the SVM using the NetApp
// ONTAP CLI, REST API, or NetApp CloudManager.
type SvmEndpoints struct {

	// An endpoint for connecting using the Internet Small Computer Systems Interface
	// (iSCSI) protocol.
	Iscsi *SvmEndpoint

	// An endpoint for managing SVMs using the NetApp ONTAP CLI, NetApp ONTAP API, or
	// NetApp CloudManager.
	Management *SvmEndpoint

	// An endpoint for connecting using the Network File System (NFS) protocol.
	Nfs *SvmEndpoint

	// An endpoint for connecting using the Server Message Block (SMB) protocol.
	Smb *SvmEndpoint

	noSmithyDocumentSerde
}

// Specifies a key-value pair for a resource tag.
type Tag struct {

	// A value that specifies the TagKey , the name of the tag. Tag keys must be unique
	// for the resource to which they are attached.
	//
	// This member is required.
	Key *string

	// A value that specifies the TagValue , the value assigned to the corresponding
	// tag key. Tag values can be null and don't have to be unique in a tag set. For
	// example, you can have a key-value pair in a tag set of finances : April and
	// also of payroll : April .
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// Describes the data tiering policy for an ONTAP volume. When enabled, Amazon FSx
// for ONTAP's intelligent tiering automatically transitions a volume's data
// between the file system's primary storage and capacity pool storage based on
// your access patterns.
//
// Valid tiering policies are the following:
//
//   - SNAPSHOT_ONLY - (Default value) moves cold snapshots to the capacity pool
//     storage tier.
//
//   - AUTO - moves cold user data and snapshots to the capacity pool storage tier
//     based on your access patterns.
//
//   - ALL - moves all user data blocks in both the active file system and Snapshot
//     copies to the storage pool tier.
//
//   - NONE - keeps a volume's data in the primary storage tier, preventing it from
//     being moved to the capacity pool tier.
type TieringPolicy struct {

	// Specifies the number of days that user data in a volume must remain inactive
	// before it is considered "cold" and moved to the capacity pool. Used with the
	// AUTO and SNAPSHOT_ONLY tiering policies. Enter a whole number between 2 and
	// 183. Default values are 31 days for AUTO and 2 days for SNAPSHOT_ONLY .
	CoolingPeriod *int32

	// Specifies the tiering policy used to transition data. Default value is
	// SNAPSHOT_ONLY .
	//
	//   - SNAPSHOT_ONLY - moves cold snapshots to the capacity pool storage tier.
	//
	//   - AUTO - moves cold user data and snapshots to the capacity pool storage tier
	//   based on your access patterns.
	//
	//   - ALL - moves all user data blocks in both the active file system and Snapshot
	//   copies to the storage pool tier.
	//
	//   - NONE - keeps a volume's data in the primary storage tier, preventing it from
	//   being moved to the capacity pool tier.
	Name TieringPolicyName

	noSmithyDocumentSerde
}

// The configuration update for an Amazon File Cache resource.
type UpdateFileCacheLustreConfiguration struct {

	// A recurring weekly time, in the format D:HH:MM .
	//
	// D is the day of the week, for which 1 represents Monday and 7 represents
	// Sunday. For further details, see [the ISO-8601 spec as described on Wikipedia].
	//
	// HH is the zero-padded hour of the day (0-23), and MM is the zero-padded minute
	// of the hour.
	//
	// For example, 1:05:00 specifies maintenance at 5 AM Monday.
	//
	// [the ISO-8601 spec as described on Wikipedia]: https://en.wikipedia.org/wiki/ISO_week_date
	WeeklyMaintenanceStartTime *string

	noSmithyDocumentSerde
}

// The configuration object for Amazon FSx for Lustre file systems used in the
// UpdateFileSystem operation.
type UpdateFileSystemLustreConfiguration struct {

	//  (Optional) When you create your file system, your existing S3 objects appear
	// as file and directory listings. Use this property to choose how Amazon FSx keeps
	// your file and directory listing up to date as you add or modify objects in your
	// linked S3 bucket. AutoImportPolicy can have the following values:
	//
	//   - NONE - (Default) AutoImport is off. Amazon FSx only updates file and
	//   directory listings from the linked S3 bucket when the file system is created.
	//   FSx does not update the file and directory listing for any new or changed
	//   objects after choosing this option.
	//
	//   - NEW - AutoImport is on. Amazon FSx automatically imports directory listings
	//   of any new objects added to the linked S3 bucket that do not currently exist in
	//   the FSx file system.
	//
	//   - NEW_CHANGED - AutoImport is on. Amazon FSx automatically imports file and
	//   directory listings of any new objects added to the S3 bucket and any existing
	//   objects that are changed in the S3 bucket after you choose this option.
	//
	//   - NEW_CHANGED_DELETED - AutoImport is on. Amazon FSx automatically imports
	//   file and directory listings of any new objects added to the S3 bucket, any
	//   existing objects that are changed in the S3 bucket, and any objects that were
	//   deleted in the S3 bucket.
	//
	// This parameter is not supported for file systems with a data repository
	// association.
	AutoImportPolicy AutoImportPolicyType

	// The number of days to retain automatic backups. Setting this property to 0
	// disables automatic backups. You can retain automatic backups for a maximum of 90
	// days. The default is 0 .
	AutomaticBackupRetentionDays *int32

	// A recurring daily time, in the format HH:MM . HH is the zero-padded hour of the
	// day (0-23), and MM is the zero-padded minute of the hour. For example, 05:00
	// specifies 5 AM daily.
	DailyAutomaticBackupStartTime *string

	// Sets the data compression configuration for the file system. DataCompressionType
	// can have the following values:
	//
	//   - NONE - Data compression is turned off for the file system.
	//
	//   - LZ4 - Data compression is turned on with the LZ4 algorithm.
	//
	// If you don't use DataCompressionType , the file system retains its current data
	// compression configuration.
	//
	// For more information, see [Lustre data compression].
	//
	// [Lustre data compression]: https://docs.aws.amazon.com/fsx/latest/LustreGuide/data-compression.html
	DataCompressionType DataCompressionType

	// The Lustre logging configuration used when updating an Amazon FSx for Lustre
	// file system. When logging is enabled, Lustre logs error and warning events for
	// data repositories associated with your file system to Amazon CloudWatch Logs.
	LogConfiguration *LustreLogCreateConfiguration

	// The Lustre metadata performance configuration for an Amazon FSx for Lustre file
	// system using a PERSISTENT_2 deployment type. When this configuration is
	// enabled, the file system supports increasing metadata performance.
	MetadataConfiguration *UpdateFileSystemLustreMetadataConfiguration

	// The throughput of an Amazon FSx for Lustre Persistent SSD-based file system,
	// measured in megabytes per second per tebibyte (MB/s/TiB). You can increase or
	// decrease your file system's throughput. Valid values depend on the deployment
	// type of the file system, as follows:
	//
	//   - For PERSISTENT_1 SSD-based deployment types, valid values are 50, 100, and
	//   200 MB/s/TiB.
	//
	//   - For PERSISTENT_2 SSD-based deployment types, valid values are 125, 250, 500,
	//   and 1000 MB/s/TiB.
	//
	// For more information, see [Managing throughput capacity].
	//
	// [Managing throughput capacity]: https://docs.aws.amazon.com/fsx/latest/LustreGuide/managing-throughput-capacity.html
	PerUnitStorageThroughput *int32

	// The Lustre root squash configuration used when updating an Amazon FSx for
	// Lustre file system. When enabled, root squash restricts root-level access from
	// clients that try to access your file system as a root user.
	RootSquashConfiguration *LustreRootSquashConfiguration

	// (Optional) The preferred start time to perform weekly maintenance, formatted
	// d:HH:MM in the UTC time zone. d is the weekday number, from 1 through 7,
	// beginning with Monday and ending with Sunday.
	WeeklyMaintenanceStartTime *string

	noSmithyDocumentSerde
}

// The Lustre metadata performance configuration update for an Amazon FSx for
// Lustre file system using a PERSISTENT_2 deployment type. You can request an
// increase in your file system's Metadata IOPS and/or switch your file system's
// metadata configuration mode. For more information, see [Managing metadata performance]in the Amazon FSx for
// Lustre User Guide.
//
// [Managing metadata performance]: https://docs.aws.amazon.com/fsx/latest/LustreGuide/managing-metadata-performance.html
type UpdateFileSystemLustreMetadataConfiguration struct {

	// (USER_PROVISIONED mode only) Specifies the number of Metadata IOPS to provision
	// for your file system. Valid values are 1500 , 3000 , 6000 , 12000 , and
	// multiples of 12000 up to a maximum of 192000 .
	//
	// The value you provide must be greater than or equal to the current number of
	// Metadata IOPS provisioned for the file system.
	Iops *int32

	// The metadata configuration mode for provisioning Metadata IOPS for an FSx for
	// Lustre file system using a PERSISTENT_2 deployment type.
	//
	//   - To increase the Metadata IOPS or to switch from AUTOMATIC mode, specify
	//   USER_PROVISIONED as the value for this parameter. Then use the Iops parameter
	//   to provide a Metadata IOPS value that is greater than or equal to the current
	//   number of Metadata IOPS provisioned for the file system.
	//
	//   - To switch from USER_PROVISIONED mode, specify AUTOMATIC as the value for
	//   this parameter, but do not input a value for Iops.
	//
	// If you request to switch from USER_PROVISIONED to AUTOMATIC mode and the
	//   current Metadata IOPS value is greater than the automated default, FSx for
	//   Lustre rejects the request because downscaling Metadata IOPS is not supported.
	Mode MetadataConfigurationMode

	noSmithyDocumentSerde
}

// The configuration updates for an Amazon FSx for NetApp ONTAP file system.
type UpdateFileSystemOntapConfiguration struct {

	// (Multi-AZ only) A list of IDs of new virtual private cloud (VPC) route tables
	// to associate (add) with your Amazon FSx for NetApp ONTAP file system.
	AddRouteTableIds []string

	// The number of days to retain automatic backups. Setting this property to 0
	// disables automatic backups. You can retain automatic backups for a maximum of 90
	// days. The default is 30 .
	AutomaticBackupRetentionDays *int32

	// A recurring daily time, in the format HH:MM . HH is the zero-padded hour of the
	// day (0-23), and MM is the zero-padded minute of the hour. For example, 05:00
	// specifies 5 AM daily.
	DailyAutomaticBackupStartTime *string

	// The SSD IOPS (input output operations per second) configuration for an Amazon
	// FSx for NetApp ONTAP file system. The default is 3 IOPS per GB of storage
	// capacity, but you can provision additional IOPS per GB of storage. The
	// configuration consists of an IOPS mode ( AUTOMATIC or USER_PROVISIONED ), and in
	// the case of USER_PROVISIONED IOPS, the total number of SSD IOPS provisioned.
	// For more information, see [Updating SSD storage capacity and IOPS].
	//
	// [Updating SSD storage capacity and IOPS]: https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/increase-primary-storage.html
	DiskIopsConfiguration *DiskIopsConfiguration

	// Update the password for the fsxadmin user by entering a new password. You use
	// the fsxadmin user to access the NetApp ONTAP CLI and REST API to manage your
	// file system resources. For more information, see [Managing resources using NetApp Application].
	//
	// [Managing resources using NetApp Application]: https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/managing-resources-ontap-apps.html
	FsxAdminPassword *string

	// Use to update the number of high-availability (HA) pairs for a
	// second-generation single-AZ file system. If you increase the number of HA pairs
	// for your file system, you must specify proportional increases for
	// StorageCapacity , Iops , and ThroughputCapacity . For more information, see [High-availability (HA) pairs] in
	// the FSx for ONTAP user guide. Block storage protocol support (iSCSI and NVMe
	// over TCP) is disabled on file systems with more than 6 HA pairs. For more
	// information, see [Using block storage protocols].
	//
	// [Using block storage protocols]: https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/supported-fsx-clients.html#using-block-storage
	// [High-availability (HA) pairs]: https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/administering-file-systems.html#HA-pairs
	HAPairs *int32

	// (Multi-AZ only) A list of IDs of existing virtual private cloud (VPC) route
	// tables to disassociate (remove) from your Amazon FSx for NetApp ONTAP file
	// system. You can use the API operation to retrieve the list of VPC route table
	// IDs for a file system.
	RemoveRouteTableIds []string

	// Enter a new value to change the amount of throughput capacity for the file
	// system in megabytes per second (MBps). For more information, see [Managing throughput capacity]in the FSx for
	// ONTAP User Guide.
	//
	// Amazon FSx responds with an HTTP status code 400 (Bad Request) for the
	// following conditions:
	//
	//   - The value of ThroughputCapacity and ThroughputCapacityPerHAPair are not the
	//   same value.
	//
	//   - The value of ThroughputCapacity when divided by the value of HAPairs is
	//   outside of the valid range for ThroughputCapacity .
	//
	// [Managing throughput capacity]: https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/managing-throughput-capacity.html
	ThroughputCapacity *int32

	// Use to choose the throughput capacity per HA pair, rather than the total
	// throughput for the file system.
	//
	// This field and ThroughputCapacity cannot be defined in the same API call, but
	// one is required.
	//
	// This field and ThroughputCapacity are the same for file systems with one HA
	// pair.
	//
	//   - For SINGLE_AZ_1 and MULTI_AZ_1 file systems, valid values are 128, 256, 512,
	//   1024, 2048, or 4096 MBps.
	//
	//   - For SINGLE_AZ_2 , valid values are 1536, 3072, or 6144 MBps.
	//
	//   - For MULTI_AZ_2 , valid values are 384, 768, 1536, 3072, or 6144 MBps.
	//
	// Amazon FSx responds with an HTTP status code 400 (Bad Request) for the
	// following conditions:
	//
	//   - The value of ThroughputCapacity and ThroughputCapacityPerHAPair are not the
	//   same value for file systems with one HA pair.
	//
	//   - The value of deployment type is SINGLE_AZ_2 and ThroughputCapacity /
	//   ThroughputCapacityPerHAPair is not a valid HA pair (a value between 1 and 12).
	//
	//   - The value of ThroughputCapacityPerHAPair is not a valid value.
	ThroughputCapacityPerHAPair *int32

	// A recurring weekly time, in the format D:HH:MM .
	//
	// D is the day of the week, for which 1 represents Monday and 7 represents
	// Sunday. For further details, see [the ISO-8601 spec as described on Wikipedia].
	//
	// HH is the zero-padded hour of the day (0-23), and MM is the zero-padded minute
	// of the hour.
	//
	// For example, 1:05:00 specifies maintenance at 5 AM Monday.
	//
	// [the ISO-8601 spec as described on Wikipedia]: https://en.wikipedia.org/wiki/ISO_week_date
	WeeklyMaintenanceStartTime *string

	noSmithyDocumentSerde
}

// The configuration updates for an Amazon FSx for OpenZFS file system.
type UpdateFileSystemOpenZFSConfiguration struct {

	// (Multi-AZ only) A list of IDs of new virtual private cloud (VPC) route tables
	// to associate (add) with your Amazon FSx for OpenZFS file system.
	AddRouteTableIds []string

	// The number of days to retain automatic backups. Setting this property to 0
	// disables automatic backups. You can retain automatic backups for a maximum of 90
	// days. The default is 30 .
	AutomaticBackupRetentionDays *int32

	// A Boolean value indicating whether tags for the file system should be copied to
	// backups. This value defaults to false . If it's set to true , all tags for the
	// file system are copied to all automatic and user-initiated backups where the
	// user doesn't specify tags. If this value is true and you specify one or more
	// tags, only the specified tags are copied to backups. If you specify one or more
	// tags when creating a user-initiated backup, no tags are copied from the file
	// system, regardless of this value.
	CopyTagsToBackups *bool

	// A Boolean value indicating whether tags for the volume should be copied to
	// snapshots. This value defaults to false . If it's set to true , all tags for the
	// volume are copied to snapshots where the user doesn't specify tags. If this
	// value is true and you specify one or more tags, only the specified tags are
	// copied to snapshots. If you specify one or more tags when creating the snapshot,
	// no tags are copied from the volume, regardless of this value.
	CopyTagsToVolumes *bool

	// A recurring daily time, in the format HH:MM . HH is the zero-padded hour of the
	// day (0-23), and MM is the zero-padded minute of the hour. For example, 05:00
	// specifies 5 AM daily.
	DailyAutomaticBackupStartTime *string

	// The SSD IOPS (input/output operations per second) configuration for an Amazon
	// FSx for NetApp ONTAP, Amazon FSx for Windows File Server, or FSx for OpenZFS
	// file system. By default, Amazon FSx automatically provisions 3 IOPS per GB of
	// storage capacity. You can provision additional IOPS per GB of storage. The
	// configuration consists of the total number of provisioned SSD IOPS and how it is
	// was provisioned, or the mode (by the customer or by Amazon FSx).
	DiskIopsConfiguration *DiskIopsConfiguration

	//  The configuration for the optional provisioned SSD read cache on file systems
	// that use the Intelligent-Tiering storage class.
	ReadCacheConfiguration *OpenZFSReadCacheConfiguration

	// (Multi-AZ only) A list of IDs of existing virtual private cloud (VPC) route
	// tables to disassociate (remove) from your Amazon FSx for OpenZFS file system.
	// You can use the API operation to retrieve the list of VPC route table IDs for a
	// file system.
	RemoveRouteTableIds []string

	// The throughput of an Amazon FSx for OpenZFS file system, measured in megabytes
	// per second  (MB/s). Valid values depend on the DeploymentType you choose, as
	// follows:
	//
	//   - For MULTI_AZ_1 and SINGLE_AZ_2 , valid values are 160, 320, 640, 1280, 2560,
	//   3840, 5120, 7680, or 10240 MB/s.
	//
	//   - For SINGLE_AZ_1 , valid values are 64, 128, 256, 512, 1024, 2048, 3072, or
	//   4096 MB/s.
	ThroughputCapacity *int32

	// A recurring weekly time, in the format D:HH:MM .
	//
	// D is the day of the week, for which 1 represents Monday and 7 represents
	// Sunday. For further details, see [the ISO-8601 spec as described on Wikipedia].
	//
	// HH is the zero-padded hour of the day (0-23), and MM is the zero-padded minute
	// of the hour.
	//
	// For example, 1:05:00 specifies maintenance at 5 AM Monday.
	//
	// [the ISO-8601 spec as described on Wikipedia]: https://en.wikipedia.org/wiki/ISO_week_date
	WeeklyMaintenanceStartTime *string

	noSmithyDocumentSerde
}

// Updates the configuration for an existing Amazon FSx for Windows File Server
// file system. Amazon FSx only overwrites existing properties with non-null values
// provided in the request.
type UpdateFileSystemWindowsConfiguration struct {

	// The configuration that Amazon FSx for Windows File Server uses to audit and log
	// user accesses of files, folders, and file shares on the Amazon FSx for Windows
	// File Server file system..
	AuditLogConfiguration *WindowsAuditLogCreateConfiguration

	// The number of days to retain automatic backups. Setting this property to 0
	// disables automatic backups. You can retain automatic backups for a maximum of 90
	// days. The default is 30 . For more information, see [Working with Automatic Daily Backups].
	//
	// [Working with Automatic Daily Backups]: https://docs.aws.amazon.com/fsx/latest/WindowsGuide/using-backups.html#automatic-backups
	AutomaticBackupRetentionDays *int32

	// The preferred time to start the daily automatic backup, in the UTC time zone,
	// for example, 02:00
	DailyAutomaticBackupStartTime *string

	// The SSD IOPS (input/output operations per second) configuration for an Amazon
	// FSx for Windows file system. By default, Amazon FSx automatically provisions 3
	// IOPS per GiB of storage capacity. You can provision additional IOPS per GiB of
	// storage, up to the maximum limit associated with your chosen throughput
	// capacity.
	DiskIopsConfiguration *DiskIopsConfiguration

	// The configuration Amazon FSx uses to join the Windows File Server instance to
	// the self-managed Microsoft AD directory. You cannot make a self-managed
	// Microsoft AD update request if there is an existing self-managed Microsoft AD
	// update request in progress.
	SelfManagedActiveDirectoryConfiguration *SelfManagedActiveDirectoryConfigurationUpdates

	// Sets the target value for a file system's throughput capacity, in MB/s, that
	// you are updating the file system to. Valid values are 8, 16, 32, 64, 128, 256,
	// 512, 1024, 2048. You cannot make a throughput capacity update request if there
	// is an existing throughput capacity update request in progress. For more
	// information, see [Managing Throughput Capacity].
	//
	// [Managing Throughput Capacity]: https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-throughput-capacity.html
	ThroughputCapacity *int32

	// The preferred start time to perform weekly maintenance, formatted d:HH:MM in
	// the UTC time zone. Where d is the weekday number, from 1 through 7, with 1 =
	// Monday and 7 = Sunday.
	WeeklyMaintenanceStartTime *string

	noSmithyDocumentSerde
}

// Used to specify changes to the ONTAP configuration for the volume you are
// updating.
type UpdateOntapVolumeConfiguration struct {

	// A boolean flag indicating whether tags for the volume should be copied to
	// backups. This value defaults to false. If it's set to true, all tags for the
	// volume are copied to all automatic and user-initiated backups where the user
	// doesn't specify tags. If this value is true, and you specify one or more tags,
	// only the specified tags are copied to backups. If you specify one or more tags
	// when creating a user-initiated backup, no tags are copied from the volume,
	// regardless of this value.
	CopyTagsToBackups *bool

	// Specifies the location in the SVM's namespace where the volume is mounted. The
	// JunctionPath must have a leading forward slash, such as /vol3 .
	JunctionPath *string

	// The security style for the volume, which can be UNIX , NTFS , or MIXED .
	SecurityStyle SecurityStyle

	// The configured size of the volume, in bytes.
	SizeInBytes *int64

	// Specifies the size of the volume in megabytes.
	SizeInMegabytes *int32

	// The configuration object for updating the SnapLock configuration of an FSx for
	// ONTAP SnapLock volume.
	SnaplockConfiguration *UpdateSnaplockConfiguration

	// Specifies the snapshot policy for the volume. There are three built-in snapshot
	// policies:
	//
	//   - default : This is the default policy. A maximum of six hourly snapshots
	//   taken five minutes past the hour. A maximum of two daily snapshots taken Monday
	//   through Saturday at 10 minutes after midnight. A maximum of two weekly snapshots
	//   taken every Sunday at 15 minutes after midnight.
	//
	//   - default-1weekly : This policy is the same as the default policy except that
	//   it only retains one snapshot from the weekly schedule.
	//
	//   - none : This policy does not take any snapshots. This policy can be assigned
	//   to volumes to prevent automatic snapshots from being taken.
	//
	// You can also provide the name of a custom policy that you created with the
	// ONTAP CLI or REST API.
	//
	// For more information, see [Snapshot policies] in the Amazon FSx for NetApp ONTAP User Guide.
	//
	// [Snapshot policies]: https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/snapshots-ontap.html#snapshot-policies
	SnapshotPolicy *string

	// Default is false . Set to true to enable the deduplication, compression, and
	// compaction storage efficiency features on the volume.
	StorageEfficiencyEnabled *bool

	// Update the volume's data tiering policy.
	TieringPolicy *TieringPolicy

	noSmithyDocumentSerde
}

// Used to specify changes to the OpenZFS configuration for the volume that you
// are updating.
type UpdateOpenZFSVolumeConfiguration struct {

	// Specifies the method used to compress the data on the volume. The compression
	// type is NONE by default.
	//
	//   - NONE - Doesn't compress the data on the volume. NONE is the default.
	//
	//   - ZSTD - Compresses the data in the volume using the Zstandard (ZSTD)
	//   compression algorithm. Compared to LZ4, Z-Standard provides a better compression
	//   ratio to minimize on-disk storage utilization.
	//
	//   - LZ4 - Compresses the data in the volume using the LZ4 compression algorithm.
	//   Compared to Z-Standard, LZ4 is less compute-intensive and delivers higher write
	//   throughput speeds.
	DataCompressionType OpenZFSDataCompressionType

	// The configuration object for mounting a Network File System (NFS) file system.
	NfsExports []OpenZFSNfsExport

	// A Boolean value indicating whether the volume is read-only.
	ReadOnly *bool

	// Specifies the record size of an OpenZFS volume, in kibibytes (KiB). Valid
	// values are 4, 8, 16, 32, 64, 128, 256, 512, or 1024 KiB. The default is 128 KiB.
	// Most workloads should use the default record size. Database workflows can
	// benefit from a smaller record size, while streaming workflows can benefit from a
	// larger record size. For additional guidance on when to set a custom record size,
	// see [Tips for maximizing performance]in the Amazon FSx for OpenZFS User Guide.
	//
	// [Tips for maximizing performance]: https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/performance.html#performance-tips-zfs
	RecordSizeKiB *int32

	// The maximum amount of storage in gibibytes (GiB) that the volume can use from
	// its parent. You can specify a quota larger than the storage on the parent
	// volume. You can specify a value of -1 to unset a volume's storage capacity
	// quota.
	StorageCapacityQuotaGiB *int32

	// The amount of storage in gibibytes (GiB) to reserve from the parent volume. You
	// can't reserve more storage than the parent volume has reserved. You can specify
	// a value of -1 to unset a volume's storage capacity reservation.
	StorageCapacityReservationGiB *int32

	// An object specifying how much storage users or groups can use on the volume.
	UserAndGroupQuotas []OpenZFSUserOrGroupQuota

	noSmithyDocumentSerde
}

// Updates the SnapLock configuration for an existing FSx for ONTAP volume.
type UpdateSnaplockConfiguration struct {

	// Enables or disables the audit log volume for an FSx for ONTAP SnapLock volume.
	// The default value is false . If you set AuditLogVolume to true , the SnapLock
	// volume is created as an audit log volume. The minimum retention period for an
	// audit log volume is six months.
	//
	// For more information, see [SnapLock audit log volumes].
	//
	// [SnapLock audit log volumes]: https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/how-snaplock-works.html#snaplock-audit-log-volume
	AuditLogVolume *bool

	// The configuration object for setting the autocommit period of files in an FSx
	// for ONTAP SnapLock volume.
	AutocommitPeriod *AutocommitPeriod

	// Enables, disables, or permanently disables privileged delete on an FSx for
	// ONTAP SnapLock Enterprise volume. Enabling privileged delete allows SnapLock
	// administrators to delete write once, read many (WORM) files even if they have
	// active retention periods. PERMANENTLY_DISABLED is a terminal state. If
	// privileged delete is permanently disabled on a SnapLock volume, you can't
	// re-enable it. The default value is DISABLED .
	//
	// For more information, see [Privileged delete].
	//
	// [Privileged delete]: https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/snaplock-enterprise.html#privileged-delete
	PrivilegedDelete PrivilegedDelete

	// Specifies the retention period of an FSx for ONTAP SnapLock volume.
	RetentionPeriod *SnaplockRetentionPeriod

	// Enables or disables volume-append mode on an FSx for ONTAP SnapLock volume.
	// Volume-append mode allows you to create WORM-appendable files and write data to
	// them incrementally. The default value is false .
	//
	// For more information, see [Volume-append mode].
	//
	// [Volume-append mode]: https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/worm-state.html#worm-state-append
	VolumeAppendModeEnabled *bool

	noSmithyDocumentSerde
}

// Specifies updates to an FSx for ONTAP storage virtual machine's (SVM) Microsoft
// Active Directory (AD) configuration. Note that account credentials are not
// returned in the response payload.
type UpdateSvmActiveDirectoryConfiguration struct {

	// Specifies an updated NetBIOS name of the AD computer object NetBiosName to
	// which an SVM is joined.
	NetBiosName *string

	// Specifies changes you are making to the self-managed Microsoft Active Directory
	// configuration to which an FSx for Windows File Server file system or an FSx for
	// ONTAP SVM is joined.
	SelfManagedActiveDirectoryConfiguration *SelfManagedActiveDirectoryConfigurationUpdates

	noSmithyDocumentSerde
}

// Describes an Amazon FSx volume.
type Volume struct {

	// A list of administrative actions for the volume that are in process or waiting
	// to be processed. Administrative actions describe changes to the volume that you
	// have initiated using the UpdateVolume action.
	AdministrativeActions []AdministrativeAction

	// The time that the resource was created, in seconds (since
	// 1970-01-01T00:00:00Z), also known as Unix time.
	CreationTime *time.Time

	// The globally unique ID of the file system, assigned by Amazon FSx.
	FileSystemId *string

	// The lifecycle status of the volume.
	//
	//   - AVAILABLE - The volume is fully available for use.
	//
	//   - CREATED - The volume has been created.
	//
	//   - CREATING - Amazon FSx is creating the new volume.
	//
	//   - DELETING - Amazon FSx is deleting an existing volume.
	//
	//   - FAILED - Amazon FSx was unable to create the volume.
	//
	//   - MISCONFIGURED - The volume is in a failed but recoverable state.
	//
	//   - PENDING - Amazon FSx hasn't started creating the volume.
	Lifecycle VolumeLifecycle

	// The reason why the volume lifecycle status changed.
	LifecycleTransitionReason *LifecycleTransitionReason

	// The name of the volume.
	Name *string

	// The configuration of an Amazon FSx for NetApp ONTAP volume.
	OntapConfiguration *OntapVolumeConfiguration

	// The configuration of an Amazon FSx for OpenZFS volume.
	OpenZFSConfiguration *OpenZFSVolumeConfiguration

	// The Amazon Resource Name (ARN) for a given resource. ARNs uniquely identify
	// Amazon Web Services resources. We require an ARN when you need to specify a
	// resource unambiguously across all of Amazon Web Services. For more information,
	// see [Amazon Resource Names (ARNs)]in the Amazon Web Services General Reference.
	//
	// [Amazon Resource Names (ARNs)]: https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html
	ResourceARN *string

	// A list of Tag values, with a maximum of 50 elements.
	Tags []Tag

	// The system-generated, unique ID of the volume.
	VolumeId *string

	// The type of the volume.
	VolumeType VolumeType

	noSmithyDocumentSerde
}

// A filter used to restrict the results of describe calls for Amazon FSx for
// NetApp ONTAP or Amazon FSx for OpenZFS volumes. You can use multiple filters to
// return results that meet all applied filter requirements.
type VolumeFilter struct {

	// The name for this filter.
	Name VolumeFilterName

	// The values of the filter. These are all the values for any of the applied
	// filters.
	Values []string

	noSmithyDocumentSerde
}

// The configuration that Amazon FSx for Windows File Server uses to audit and log
// user accesses of files, folders, and file shares on the Amazon FSx for Windows
// File Server file system. For more information, see [File access auditing].
//
// [File access auditing]: https://docs.aws.amazon.com/fsx/latest/WindowsGuide/file-access-auditing.html
type WindowsAuditLogConfiguration struct {

	// Sets which attempt type is logged by Amazon FSx for file and folder accesses.
	//
	//   - SUCCESS_ONLY - only successful attempts to access files or folders are
	//   logged.
	//
	//   - FAILURE_ONLY - only failed attempts to access files or folders are logged.
	//
	//   - SUCCESS_AND_FAILURE - both successful attempts and failed attempts to access
	//   files or folders are logged.
	//
	//   - DISABLED - access auditing of files and folders is turned off.
	//
	// This member is required.
	FileAccessAuditLogLevel WindowsAccessAuditLogLevel

	// Sets which attempt type is logged by Amazon FSx for file share accesses.
	//
	//   - SUCCESS_ONLY - only successful attempts to access file shares are logged.
	//
	//   - FAILURE_ONLY - only failed attempts to access file shares are logged.
	//
	//   - SUCCESS_AND_FAILURE - both successful attempts and failed attempts to access
	//   file shares are logged.
	//
	//   - DISABLED - access auditing of file shares is turned off.
	//
	// This member is required.
	FileShareAccessAuditLogLevel WindowsAccessAuditLogLevel

	// The Amazon Resource Name (ARN) for the destination of the audit logs. The
	// destination can be any Amazon CloudWatch Logs log group ARN or Amazon Kinesis
	// Data Firehose delivery stream ARN.
	//
	// The name of the Amazon CloudWatch Logs log group must begin with the /aws/fsx
	// prefix. The name of the Amazon Kinesis Data Firehose delivery stream must begin
	// with the aws-fsx prefix.
	//
	// The destination ARN (either CloudWatch Logs log group or Kinesis Data Firehose
	// delivery stream) must be in the same Amazon Web Services partition, Amazon Web
	// Services Region, and Amazon Web Services account as your Amazon FSx file system.
	AuditLogDestination *string

	noSmithyDocumentSerde
}

// The Windows file access auditing configuration used when creating or updating
// an Amazon FSx for Windows File Server file system.
type WindowsAuditLogCreateConfiguration struct {

	// Sets which attempt type is logged by Amazon FSx for file and folder accesses.
	//
	//   - SUCCESS_ONLY - only successful attempts to access files or folders are
	//   logged.
	//
	//   - FAILURE_ONLY - only failed attempts to access files or folders are logged.
	//
	//   - SUCCESS_AND_FAILURE - both successful attempts and failed attempts to access
	//   files or folders are logged.
	//
	//   - DISABLED - access auditing of files and folders is turned off.
	//
	// This member is required.
	FileAccessAuditLogLevel WindowsAccessAuditLogLevel

	// Sets which attempt type is logged by Amazon FSx for file share accesses.
	//
	//   - SUCCESS_ONLY - only successful attempts to access file shares are logged.
	//
	//   - FAILURE_ONLY - only failed attempts to access file shares are logged.
	//
	//   - SUCCESS_AND_FAILURE - both successful attempts and failed attempts to access
	//   file shares are logged.
	//
	//   - DISABLED - access auditing of file shares is turned off.
	//
	// This member is required.
	FileShareAccessAuditLogLevel WindowsAccessAuditLogLevel

	// The Amazon Resource Name (ARN) that specifies the destination of the audit logs.
	//
	// The destination can be any Amazon CloudWatch Logs log group ARN or Amazon
	// Kinesis Data Firehose delivery stream ARN, with the following requirements:
	//
	//   - The destination ARN that you provide (either CloudWatch Logs log group or
	//   Kinesis Data Firehose delivery stream) must be in the same Amazon Web Services
	//   partition, Amazon Web Services Region, and Amazon Web Services account as your
	//   Amazon FSx file system.
	//
	//   - The name of the Amazon CloudWatch Logs log group must begin with the
	//   /aws/fsx prefix. The name of the Amazon Kinesis Data Firehose delivery stream
	//   must begin with the aws-fsx prefix.
	//
	//   - If you do not provide a destination in AuditLogDestination , Amazon FSx will
	//   create and use a log stream in the CloudWatch Logs /aws/fsx/windows log group.
	//
	//   - If AuditLogDestination is provided and the resource does not exist, the
	//   request will fail with a BadRequest error.
	//
	//   - If FileAccessAuditLogLevel and FileShareAccessAuditLogLevel are both set to
	//   DISABLED , you cannot specify a destination in AuditLogDestination .
	AuditLogDestination *string

	noSmithyDocumentSerde
}

// The configuration for this Microsoft Windows file system.
type WindowsFileSystemConfiguration struct {

	// The ID for an existing Amazon Web Services Managed Microsoft Active Directory
	// instance that the file system is joined to.
	ActiveDirectoryId *string

	// An array of one or more DNS aliases that are currently associated with the
	// Amazon FSx file system. Aliases allow you to use existing DNS names to access
	// the data in your Amazon FSx file system. You can associate up to 50 aliases with
	// a file system at any time. You can associate additional DNS aliases after you
	// create the file system using the AssociateFileSystemAliases operation. You can
	// remove DNS aliases from the file system after it is created using the
	// DisassociateFileSystemAliases operation. You only need to specify the alias name
	// in the request payload. For more information, see [DNS aliases].
	//
	// [DNS aliases]: https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-dns-aliases.html
	Aliases []Alias

	// The configuration that Amazon FSx for Windows File Server uses to audit and log
	// user accesses of files, folders, and file shares on the Amazon FSx for Windows
	// File Server file system.
	AuditLogConfiguration *WindowsAuditLogConfiguration

	// The number of days to retain automatic backups. Setting this to 0 disables
	// automatic backups. You can retain automatic backups for a maximum of 90 days.
	AutomaticBackupRetentionDays *int32

	// A boolean flag indicating whether tags on the file system should be copied to
	// backups. This value defaults to false. If it's set to true, all tags on the file
	// system are copied to all automatic backups and any user-initiated backups where
	// the user doesn't specify any tags. If this value is true, and you specify one or
	// more tags, only the specified tags are copied to backups. If you specify one or
	// more tags when creating a user-initiated backup, no tags are copied from the
	// file system, regardless of this value.
	CopyTagsToBackups *bool

	// The preferred time to take daily automatic backups, in the UTC time zone.
	DailyAutomaticBackupStartTime *string

	// Specifies the file system deployment type, valid values are the following:
	//
	//   - MULTI_AZ_1 - Specifies a high availability file system that is configured
	//   for Multi-AZ redundancy to tolerate temporary Availability Zone (AZ)
	//   unavailability, and supports SSD and HDD storage.
	//
	//   - SINGLE_AZ_1 - (Default) Specifies a file system that is configured for
	//   single AZ redundancy, only supports SSD storage.
	//
	//   - SINGLE_AZ_2 - Latest generation Single AZ file system. Specifies a file
	//   system that is configured for single AZ redundancy and supports SSD and HDD
	//   storage.
	//
	// For more information, see [Single-AZ and Multi-AZ File Systems].
	//
	// [Single-AZ and Multi-AZ File Systems]: https://docs.aws.amazon.com/fsx/latest/WindowsGuide/high-availability-multiAZ.html
	DeploymentType WindowsDeploymentType

	// The SSD IOPS (input/output operations per second) configuration for an Amazon
	// FSx for Windows file system. By default, Amazon FSx automatically provisions 3
	// IOPS per GiB of storage capacity. You can provision additional IOPS per GiB of
	// storage, up to the maximum limit associated with your chosen throughput
	// capacity.
	DiskIopsConfiguration *DiskIopsConfiguration

	// The list of maintenance operations in progress for this file system.
	MaintenanceOperationsInProgress []FileSystemMaintenanceOperation

	// For MULTI_AZ_1 deployment types, the IP address of the primary, or preferred,
	// file server.
	//
	// Use this IP address when mounting the file system on Linux SMB clients or
	// Windows SMB clients that are not joined to a Microsoft Active Directory.
	// Applicable for all Windows file system deployment types. This IP address is
	// temporarily unavailable when the file system is undergoing maintenance. For
	// Linux and Windows SMB clients that are joined to an Active Directory, use the
	// file system's DNSName instead. For more information on mapping and mounting file
	// shares, see [Accessing File Shares].
	//
	// [Accessing File Shares]: https://docs.aws.amazon.com/fsx/latest/WindowsGuide/accessing-file-shares.html
	PreferredFileServerIp *string

	// For MULTI_AZ_1 deployment types, it specifies the ID of the subnet where the
	// preferred file server is located. Must be one of the two subnet IDs specified in
	// SubnetIds property. Amazon FSx serves traffic from this subnet except in the
	// event of a failover to the secondary file server.
	//
	// For SINGLE_AZ_1 and SINGLE_AZ_2 deployment types, this value is the same as
	// that for SubnetIDs . For more information, see [Availability and durability: Single-AZ and Multi-AZ file systems].
	//
	// [Availability and durability: Single-AZ and Multi-AZ file systems]: https://docs.aws.amazon.com/fsx/latest/WindowsGuide/high-availability-multiAZ.html#single-multi-az-resources
	PreferredSubnetId *string

	// For MULTI_AZ_1 deployment types, use this endpoint when performing
	// administrative tasks on the file system using Amazon FSx Remote PowerShell.
	//
	// For SINGLE_AZ_1 and SINGLE_AZ_2 deployment types, this is the DNS name of the
	// file system.
	//
	// This endpoint is temporarily unavailable when the file system is undergoing
	// maintenance.
	RemoteAdministrationEndpoint *string

	// The configuration of the self-managed Microsoft Active Directory (AD) directory
	// to which the Windows File Server or ONTAP storage virtual machine (SVM) instance
	// is joined.
	SelfManagedActiveDirectoryConfiguration *SelfManagedActiveDirectoryAttributes

	// The throughput of the Amazon FSx file system, measured in megabytes per second.
	ThroughputCapacity *int32

	// The preferred start time to perform weekly maintenance, formatted d:HH:MM in
	// the UTC time zone. d is the weekday number, from 1 through 7, beginning with
	// Monday and ending with Sunday.
	WeeklyMaintenanceStartTime *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
