// Code generated by smithy-go-codegen DO NOT EDIT.

package gamelift

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/gamelift/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Requests authorization to remotely connect to an instance in an Amazon GameLift
// managed fleet. Use this operation to connect to instances with game servers that
// use Amazon GameLift server SDK 4.x or earlier. To connect to instances with game
// servers that use server SDK 5.x or later, call [https://docs.aws.amazon.com/gamelift/latest/apireference/API_GetComputeAccess].
//
// To request access to an instance, specify IDs for the instance and the fleet it
// belongs to. You can retrieve instance IDs for a fleet by calling [DescribeInstances]with the fleet
// ID.
//
// If successful, this operation returns an IP address and credentials. The
// returned credentials match the operating system of the instance, as follows:
//
//   - For a Windows instance: returns a user name and secret (password) for use
//     with a Windows Remote Desktop client.
//
//   - For a Linux instance: returns a user name and secret (RSA private key) for
//     use with an SSH client. You must save the secret to a .pem file. If you're
//     using the CLI, see the example [Get credentials for a Linux instance]for tips on automatically saving the secret to
//     a .pem file.
//
// # Learn more
//
// [Remotely connect to fleet instances]
//
// [Debug fleet issues]
//
// # Related actions
//
// [All APIs by task]
//
// [Remotely connect to fleet instances]: https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-remote-access.html
// [https://docs.aws.amazon.com/gamelift/latest/apireference/API_GetComputeAccess]: https://docs.aws.amazon.com/gamelift/latest/apireference/API_GetComputeAccess
// [DescribeInstances]: https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeInstances.html
// [Get credentials for a Linux instance]: https://docs.aws.amazon.com/gamelift/latest/apireference/API_GetInstanceAccess.html#API_GetInstanceAccess_Examples
// [Debug fleet issues]: https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-creating-debug.html
// [All APIs by task]: https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets
func (c *Client) GetInstanceAccess(ctx context.Context, params *GetInstanceAccessInput, optFns ...func(*Options)) (*GetInstanceAccessOutput, error) {
	if params == nil {
		params = &GetInstanceAccessInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetInstanceAccess", params, optFns, c.addOperationGetInstanceAccessMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetInstanceAccessOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetInstanceAccessInput struct {

	// A unique identifier for the fleet that contains the instance you want to
	// access. You can request access to instances in EC2 fleets with the following
	// statuses: ACTIVATING , ACTIVE , or ERROR . Use either a fleet ID or an ARN
	// value.
	//
	// You can access fleets in ERROR status for a short period of time before Amazon
	// GameLift deletes them.
	//
	// This member is required.
	FleetId *string

	// A unique identifier for the instance you want to access. You can access an
	// instance in any status.
	//
	// This member is required.
	InstanceId *string

	noSmithyDocumentSerde
}

type GetInstanceAccessOutput struct {

	// The connection information for a fleet instance, including IP address and
	// access credentials.
	InstanceAccess *types.InstanceAccess

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetInstanceAccessMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpGetInstanceAccess{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpGetInstanceAccess{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetInstanceAccess"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpGetInstanceAccessValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetInstanceAccess(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetInstanceAccess(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetInstanceAccess",
	}
}
