// Code generated by smithy-go-codegen DO NOT EDIT.

package geomaps

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/geomaps/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns the map's sprites.
func (c *Client) GetSprites(ctx context.Context, params *GetSpritesInput, optFns ...func(*Options)) (*GetSpritesOutput, error) {
	if params == nil {
		params = &GetSpritesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetSprites", params, optFns, c.addOperationGetSpritesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetSpritesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetSpritesInput struct {

	// Sets color tone for map such as dark and light for specific map styles. It
	// applies to only vector map styles such as Standard and Monochrome.
	//
	// Example: Light
	//
	// Default value: Light
	//
	// Valid values for ColorScheme are case sensitive.
	//
	// This member is required.
	ColorScheme types.ColorScheme

	// Sprites API: The name of the sprite ﬁle to retrieve, following pattern
	// sprites(@2x)?\.(png|json) .
	//
	// Example: sprites.png
	//
	// This member is required.
	FileName *string

	// Style specifies the desired map style for the Sprites APIs.
	//
	// This member is required.
	Style types.MapStyle

	// Optimizes map styles for specific use case or industry. You can choose allowed
	// variant only with Standard map style.
	//
	// Example: Default
	//
	// Valid values for Variant are case sensitive.
	//
	// This member is required.
	Variant types.Variant

	noSmithyDocumentSerde
}

type GetSpritesOutput struct {

	// The body of the sprite sheet or JSON offset file (image/png or
	// application/json, depending on input).
	Blob []byte

	// Header that instructs caching configuration for the client.
	CacheControl *string

	// Header that represents the format of the response. The response returns the
	// following as the HTTP body.
	ContentType *string

	// The sprite's Etag.
	ETag *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetSpritesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetSprites{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetSprites{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetSprites"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpGetSpritesValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetSprites(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetSprites(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetSprites",
	}
}
