// Code generated by smithy-go-codegen DO NOT EDIT.

package geomaps

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/geomaps/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Provides high-quality static map images with customizable options. You can
// modify the map's appearance and overlay additional information. It's an ideal
// solution for applications requiring tailored static map snapshots.
func (c *Client) GetStaticMap(ctx context.Context, params *GetStaticMapInput, optFns ...func(*Options)) (*GetStaticMapOutput, error) {
	if params == nil {
		params = &GetStaticMapInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetStaticMap", params, optFns, c.addOperationGetStaticMapMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetStaticMapOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetStaticMapInput struct {

	// The map scaling parameter to size the image, icons, and labels. It follows the
	// pattern of ^map(@2x)?$ .
	//
	// Example: map, map@2x
	//
	// This member is required.
	FileName *string

	// Specifies the height of the map image.
	//
	// This member is required.
	Height *int32

	// Specifies the width of the map image.
	//
	// This member is required.
	Width *int32

	// Takes in two or more pair of coordinates, [Lon, Lat], with each coordinate
	// separated by a comma. The API will generate an image to encompass all of the
	// provided coordinates.
	//
	// Cannot be used with Zoom and or Radius
	//
	// Example: 97.170451,78.039098,99.045536,27.176178
	BoundedPositions *string

	// Takes in two pairs of coordinates, [Lon, Lat], denoting south-westerly and
	// north-easterly edges of the image. The underlying area becomes the view of the
	// image.
	//
	// Example: -123.17075,49.26959,-123.08125,49.31429
	BoundingBox *string

	// Takes in a pair of coordinates, [Lon, Lat], which becomes the center point of
	// the image. This parameter requires that either zoom or radius is set.
	//
	// Cannot be used with Zoom and or Radius
	//
	// Example: 49.295,-123.108
	Center *string

	// Takes in a string to draw geometries on the image. The input is a comma
	// separated format as follows format: [Lon, Lat]
	//
	// Example:
	// line:-122.407653,37.798557,-122.413291,37.802443;color=%23DD0000;width=7;outline-color=#00DD00;outline-width=5yd|point:-122.40572,37.80004;label=Fog
	// Hill Market;size=large;text-color=%23DD0000;color=#EE4B2B
	//
	// Currently it supports the following geometry types: point, line and polygon. It
	// does not support multiPoint , multiLine and multiPolgyon.
	CompactOverlay *string

	// Takes in a string to draw geometries on the image. The input is a valid GeoJSON
	// collection object.
	//
	// Example: {"type":"FeatureCollection","features":
	// [{"type":"Feature","geometry":{"type":"MultiPoint","coordinates":
	// [[-90.076345,51.504107],[-0.074451,51.506892]]},"properties":
	// {"color":"#00DD00"}}]}
	GeoJsonOverlay *string

	// Optional: The API key to be used for authorization. Either an API key or valid
	// SigV4 signature must be provided when making a request.
	Key *string

	// Applies additional space (in pixels) around overlay feature to prevent them
	// from being cut or obscured.
	//
	// Value for max and min is determined by:
	//
	// Min: 1
	//
	// Max: min(height, width)/4
	//
	// Example: 100
	Padding *int32

	// Used with center parameter, it specifies the zoom of the image where you can
	// control it on a granular level. Takes in any value >= 1 .
	//
	// Example: 1500
	//
	// Cannot be used with Zoom .
	//
	// Unit: Meters
	Radius *int64

	// Displays a scale on the bottom right of the map image with the unit specified
	// in the input.
	//
	// Example: KilometersMiles, Miles, Kilometers, MilesKilometers
	ScaleBarUnit types.ScaleBarUnit

	// Style specifies the desired map style for the Style APIs.
	Style types.StaticMapStyle

	// Specifies the zoom level of the map image.
	//
	// Cannot be used with Radius .
	Zoom *float32

	noSmithyDocumentSerde
}

type GetStaticMapOutput struct {

	// The pricing bucket for which the request is charged at.
	//
	// This member is required.
	PricingBucket *string

	// The blob represents a map image as a jpeg for the GetStaticMap API.
	Blob []byte

	// Header that instructs caching configuration for the client.
	CacheControl *string

	// Header that represents the format of the response. The response returns the
	// following as the HTTP body.
	ContentType *string

	// The static map's Etag.
	ETag *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetStaticMapMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetStaticMap{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetStaticMap{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetStaticMap"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpGetStaticMapValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetStaticMap(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetStaticMap(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetStaticMap",
	}
}
