// Code generated by smithy-go-codegen DO NOT EDIT.

package geomaps

import (
	"context"
	"fmt"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	"github.com/aws/smithy-go/middleware"
	"github.com/aws/smithy-go/tracing"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

type awsRestjson1_serializeOpGetGlyphs struct {
}

func (*awsRestjson1_serializeOpGetGlyphs) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetGlyphs) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetGlyphsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/glyphs/{FontStack}/{FontUnicodeRange}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetGlyphsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetGlyphsInput(v *GetGlyphsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FontStack == nil || len(*v.FontStack) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member FontStack must not be empty")}
	}
	if v.FontStack != nil {
		if err := encoder.SetURI("FontStack").String(*v.FontStack); err != nil {
			return err
		}
	}

	if v.FontUnicodeRange == nil || len(*v.FontUnicodeRange) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member FontUnicodeRange must not be empty")}
	}
	if v.FontUnicodeRange != nil {
		if err := encoder.SetURI("FontUnicodeRange").String(*v.FontUnicodeRange); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetSprites struct {
}

func (*awsRestjson1_serializeOpGetSprites) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetSprites) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetSpritesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/styles/{Style}/{ColorScheme}/{Variant}/sprites/{FileName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetSpritesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetSpritesInput(v *GetSpritesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if len(v.ColorScheme) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ColorScheme must not be empty")}
	}
	if len(v.ColorScheme) > 0 {
		if err := encoder.SetURI("ColorScheme").String(string(v.ColorScheme)); err != nil {
			return err
		}
	}

	if v.FileName == nil || len(*v.FileName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member FileName must not be empty")}
	}
	if v.FileName != nil {
		if err := encoder.SetURI("FileName").String(*v.FileName); err != nil {
			return err
		}
	}

	if len(v.Style) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Style must not be empty")}
	}
	if len(v.Style) > 0 {
		if err := encoder.SetURI("Style").String(string(v.Style)); err != nil {
			return err
		}
	}

	if len(v.Variant) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Variant must not be empty")}
	}
	if len(v.Variant) > 0 {
		if err := encoder.SetURI("Variant").String(string(v.Variant)); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetStaticMap struct {
}

func (*awsRestjson1_serializeOpGetStaticMap) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetStaticMap) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetStaticMapInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/static/{FileName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetStaticMapInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetStaticMapInput(v *GetStaticMapInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BoundedPositions != nil {
		encoder.SetQuery("bounded-positions").String(*v.BoundedPositions)
	}

	if v.BoundingBox != nil {
		encoder.SetQuery("bounding-box").String(*v.BoundingBox)
	}

	if v.Center != nil {
		encoder.SetQuery("center").String(*v.Center)
	}

	if v.CompactOverlay != nil {
		encoder.SetQuery("compact-overlay").String(*v.CompactOverlay)
	}

	if v.FileName == nil || len(*v.FileName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member FileName must not be empty")}
	}
	if v.FileName != nil {
		if err := encoder.SetURI("FileName").String(*v.FileName); err != nil {
			return err
		}
	}

	if v.GeoJsonOverlay != nil {
		encoder.SetQuery("geojson-overlay").String(*v.GeoJsonOverlay)
	}

	if v.Height != nil {
		encoder.SetQuery("height").Integer(*v.Height)
	}

	if v.Key != nil {
		encoder.SetQuery("key").String(*v.Key)
	}

	if v.Padding != nil {
		encoder.SetQuery("padding").Integer(*v.Padding)
	}

	if v.Radius != nil {
		encoder.SetQuery("radius").Long(*v.Radius)
	}

	if len(v.ScaleBarUnit) > 0 {
		encoder.SetQuery("scale-unit").String(string(v.ScaleBarUnit))
	}

	if len(v.Style) > 0 {
		encoder.SetQuery("style").String(string(v.Style))
	}

	if v.Width != nil {
		encoder.SetQuery("width").Integer(*v.Width)
	}

	if v.Zoom != nil {
		encoder.SetQuery("zoom").Float(*v.Zoom)
	}

	return nil
}

type awsRestjson1_serializeOpGetStyleDescriptor struct {
}

func (*awsRestjson1_serializeOpGetStyleDescriptor) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetStyleDescriptor) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetStyleDescriptorInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/styles/{Style}/descriptor")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetStyleDescriptorInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetStyleDescriptorInput(v *GetStyleDescriptorInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if len(v.ColorScheme) > 0 {
		encoder.SetQuery("color-scheme").String(string(v.ColorScheme))
	}

	if v.Key != nil {
		encoder.SetQuery("key").String(*v.Key)
	}

	if v.PoliticalView != nil {
		encoder.SetQuery("political-view").String(*v.PoliticalView)
	}

	if len(v.Style) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Style must not be empty")}
	}
	if len(v.Style) > 0 {
		if err := encoder.SetURI("Style").String(string(v.Style)); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetTile struct {
}

func (*awsRestjson1_serializeOpGetTile) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetTile) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetTileInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tiles/{Tileset}/{Z}/{X}/{Y}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetTileInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetTileInput(v *GetTileInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Key != nil {
		encoder.SetQuery("key").String(*v.Key)
	}

	if v.Tileset == nil || len(*v.Tileset) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Tileset must not be empty")}
	}
	if v.Tileset != nil {
		if err := encoder.SetURI("Tileset").String(*v.Tileset); err != nil {
			return err
		}
	}

	if v.X == nil || len(*v.X) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member X must not be empty")}
	}
	if v.X != nil {
		if err := encoder.SetURI("X").String(*v.X); err != nil {
			return err
		}
	}

	if v.Y == nil || len(*v.Y) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Y must not be empty")}
	}
	if v.Y != nil {
		if err := encoder.SetURI("Y").String(*v.Y); err != nil {
			return err
		}
	}

	if v.Z == nil || len(*v.Z) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Z must not be empty")}
	}
	if v.Z != nil {
		if err := encoder.SetURI("Z").String(*v.Z); err != nil {
			return err
		}
	}

	return nil
}
