// Code generated by smithy-go-codegen DO NOT EDIT.

package globalaccelerator

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/globalaccelerator/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// List the cross-account resources available to work with.
func (c *Client) ListCrossAccountResources(ctx context.Context, params *ListCrossAccountResourcesInput, optFns ...func(*Options)) (*ListCrossAccountResourcesOutput, error) {
	if params == nil {
		params = &ListCrossAccountResourcesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListCrossAccountResources", params, optFns, c.addOperationListCrossAccountResourcesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListCrossAccountResourcesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListCrossAccountResourcesInput struct {

	// The account ID of a resource owner in a cross-account attachment.
	//
	// This member is required.
	ResourceOwnerAwsAccountId *string

	// The Amazon Resource Name (ARN) of an accelerator in a cross-account attachment.
	AcceleratorArn *string

	// The number of cross-account resource objects that you want to return with this
	// call. The default value is 10.
	MaxResults *int32

	// The token for the next set of results. You receive this token from a previous
	// call.
	NextToken *string

	noSmithyDocumentSerde
}

type ListCrossAccountResourcesOutput struct {

	// The cross-account resources used with an accelerator.
	CrossAccountResources []types.CrossAccountResource

	// The token for the next set of results. You receive this token from a previous
	// call.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListCrossAccountResourcesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpListCrossAccountResources{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpListCrossAccountResources{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListCrossAccountResources"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpListCrossAccountResourcesValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListCrossAccountResources(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListCrossAccountResourcesPaginatorOptions is the paginator options for
// ListCrossAccountResources
type ListCrossAccountResourcesPaginatorOptions struct {
	// The number of cross-account resource objects that you want to return with this
	// call. The default value is 10.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListCrossAccountResourcesPaginator is a paginator for ListCrossAccountResources
type ListCrossAccountResourcesPaginator struct {
	options   ListCrossAccountResourcesPaginatorOptions
	client    ListCrossAccountResourcesAPIClient
	params    *ListCrossAccountResourcesInput
	nextToken *string
	firstPage bool
}

// NewListCrossAccountResourcesPaginator returns a new
// ListCrossAccountResourcesPaginator
func NewListCrossAccountResourcesPaginator(client ListCrossAccountResourcesAPIClient, params *ListCrossAccountResourcesInput, optFns ...func(*ListCrossAccountResourcesPaginatorOptions)) *ListCrossAccountResourcesPaginator {
	if params == nil {
		params = &ListCrossAccountResourcesInput{}
	}

	options := ListCrossAccountResourcesPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListCrossAccountResourcesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListCrossAccountResourcesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListCrossAccountResources page.
func (p *ListCrossAccountResourcesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListCrossAccountResourcesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListCrossAccountResources(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListCrossAccountResourcesAPIClient is a client that implements the
// ListCrossAccountResources operation.
type ListCrossAccountResourcesAPIClient interface {
	ListCrossAccountResources(context.Context, *ListCrossAccountResourcesInput, ...func(*Options)) (*ListCrossAccountResourcesOutput, error)
}

var _ ListCrossAccountResourcesAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListCrossAccountResources(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListCrossAccountResources",
	}
}
