// Code generated by smithy-go-codegen DO NOT EDIT.

package glue

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/glue/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// This API can be used for setting up the ResourceProperty of the Glue connection
// (for the source) or Glue database ARN (for the target). These properties can
// include the role to access the connection or database. To set both source and
// target properties the same API needs to be invoked with the Glue connection ARN
// as ResourceArn with SourceProcessingProperties and the Glue database ARN as
// ResourceArn with TargetProcessingProperties respectively.
func (c *Client) CreateIntegrationResourceProperty(ctx context.Context, params *CreateIntegrationResourcePropertyInput, optFns ...func(*Options)) (*CreateIntegrationResourcePropertyOutput, error) {
	if params == nil {
		params = &CreateIntegrationResourcePropertyInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateIntegrationResourceProperty", params, optFns, c.addOperationCreateIntegrationResourcePropertyMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateIntegrationResourcePropertyOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateIntegrationResourcePropertyInput struct {

	// The connection ARN of the source, or the database ARN of the target.
	//
	// This member is required.
	ResourceArn *string

	// The resource properties associated with the integration source.
	SourceProcessingProperties *types.SourceProcessingProperties

	// The resource properties associated with the integration target.
	TargetProcessingProperties *types.TargetProcessingProperties

	noSmithyDocumentSerde
}

type CreateIntegrationResourcePropertyOutput struct {

	// The connection ARN of the source, or the database ARN of the target.
	//
	// This member is required.
	ResourceArn *string

	// The resource properties associated with the integration source.
	SourceProcessingProperties *types.SourceProcessingProperties

	// The resource properties associated with the integration target.
	TargetProcessingProperties *types.TargetProcessingProperties

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateIntegrationResourcePropertyMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpCreateIntegrationResourceProperty{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpCreateIntegrationResourceProperty{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateIntegrationResourceProperty"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpCreateIntegrationResourcePropertyValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateIntegrationResourceProperty(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateIntegrationResourceProperty(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateIntegrationResourceProperty",
	}
}
