// Code generated by smithy-go-codegen DO NOT EDIT.

package glue

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/glue/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Retrieves information about all runs associated with the specified table.
func (c *Client) GetColumnStatisticsTaskRuns(ctx context.Context, params *GetColumnStatisticsTaskRunsInput, optFns ...func(*Options)) (*GetColumnStatisticsTaskRunsOutput, error) {
	if params == nil {
		params = &GetColumnStatisticsTaskRunsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetColumnStatisticsTaskRuns", params, optFns, c.addOperationGetColumnStatisticsTaskRunsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetColumnStatisticsTaskRunsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetColumnStatisticsTaskRunsInput struct {

	// The name of the database where the table resides.
	//
	// This member is required.
	DatabaseName *string

	// The name of the table.
	//
	// This member is required.
	TableName *string

	// The maximum size of the response.
	MaxResults *int32

	// A continuation token, if this is a continuation call.
	NextToken *string

	noSmithyDocumentSerde
}

type GetColumnStatisticsTaskRunsOutput struct {

	// A list of column statistics task runs.
	ColumnStatisticsTaskRuns []types.ColumnStatisticsTaskRun

	// A continuation token, if not all task runs have yet been returned.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetColumnStatisticsTaskRunsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpGetColumnStatisticsTaskRuns{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpGetColumnStatisticsTaskRuns{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetColumnStatisticsTaskRuns"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpGetColumnStatisticsTaskRunsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetColumnStatisticsTaskRuns(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// GetColumnStatisticsTaskRunsPaginatorOptions is the paginator options for
// GetColumnStatisticsTaskRuns
type GetColumnStatisticsTaskRunsPaginatorOptions struct {
	// The maximum size of the response.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// GetColumnStatisticsTaskRunsPaginator is a paginator for
// GetColumnStatisticsTaskRuns
type GetColumnStatisticsTaskRunsPaginator struct {
	options   GetColumnStatisticsTaskRunsPaginatorOptions
	client    GetColumnStatisticsTaskRunsAPIClient
	params    *GetColumnStatisticsTaskRunsInput
	nextToken *string
	firstPage bool
}

// NewGetColumnStatisticsTaskRunsPaginator returns a new
// GetColumnStatisticsTaskRunsPaginator
func NewGetColumnStatisticsTaskRunsPaginator(client GetColumnStatisticsTaskRunsAPIClient, params *GetColumnStatisticsTaskRunsInput, optFns ...func(*GetColumnStatisticsTaskRunsPaginatorOptions)) *GetColumnStatisticsTaskRunsPaginator {
	if params == nil {
		params = &GetColumnStatisticsTaskRunsInput{}
	}

	options := GetColumnStatisticsTaskRunsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &GetColumnStatisticsTaskRunsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *GetColumnStatisticsTaskRunsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next GetColumnStatisticsTaskRuns page.
func (p *GetColumnStatisticsTaskRunsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*GetColumnStatisticsTaskRunsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.GetColumnStatisticsTaskRuns(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// GetColumnStatisticsTaskRunsAPIClient is a client that implements the
// GetColumnStatisticsTaskRuns operation.
type GetColumnStatisticsTaskRunsAPIClient interface {
	GetColumnStatisticsTaskRuns(context.Context, *GetColumnStatisticsTaskRunsInput, ...func(*Options)) (*GetColumnStatisticsTaskRunsOutput, error)
}

var _ GetColumnStatisticsTaskRunsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opGetColumnStatisticsTaskRuns(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetColumnStatisticsTaskRuns",
	}
}
