// Code generated by smithy-go-codegen DO NOT EDIT.

package glue

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/glue/document"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// This API is used to query preview data from a given connection type or from a
// native Amazon S3 based Glue Data Catalog.
//
// Returns records as an array of JSON blobs. Each record is formatted using
// Jackson JsonNode based on the field type defined by the DescribeEntity API.
//
// Spark connectors generate schemas according to the same data type mapping as in
// the DescribeEntity API. Spark connectors convert data to the appropriate data
// types matching the schema when returning rows.
func (c *Client) GetEntityRecords(ctx context.Context, params *GetEntityRecordsInput, optFns ...func(*Options)) (*GetEntityRecordsOutput, error) {
	if params == nil {
		params = &GetEntityRecordsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetEntityRecords", params, optFns, c.addOperationGetEntityRecordsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetEntityRecordsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetEntityRecordsInput struct {

	// Name of the entity that we want to query the preview data from the given
	// connection type.
	//
	// This member is required.
	EntityName *string

	// Limits the number of records fetched with the request.
	//
	// This member is required.
	Limit *int64

	// The catalog ID of the catalog that contains the connection. This can be null,
	// By default, the Amazon Web Services Account ID is the catalog ID.
	CatalogId *string

	// The name of the connection that contains the connection type credentials.
	ConnectionName *string

	// Connector options that are required to query the data.
	ConnectionOptions map[string]string

	// The API version of the SaaS connector.
	DataStoreApiVersion *string

	// A filter predicate that you can apply in the query request.
	FilterPredicate *string

	// A continuation token, included if this is a continuation call.
	NextToken *string

	// A parameter that orders the response preview data.
	OrderBy *string

	//  List of fields that we want to fetch as part of preview data.
	SelectedFields []string

	noSmithyDocumentSerde
}

type GetEntityRecordsOutput struct {

	// A continuation token, present if the current segment is not the last.
	NextToken *string

	// A list of the requested objects.
	Records []document.Interface

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetEntityRecordsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpGetEntityRecords{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpGetEntityRecords{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetEntityRecords"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpGetEntityRecordsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetEntityRecords(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetEntityRecords(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetEntityRecords",
	}
}
