// Code generated by smithy-go-codegen DO NOT EDIT.

package glue

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Updates settings for a column statistics task.
func (c *Client) UpdateColumnStatisticsTaskSettings(ctx context.Context, params *UpdateColumnStatisticsTaskSettingsInput, optFns ...func(*Options)) (*UpdateColumnStatisticsTaskSettingsOutput, error) {
	if params == nil {
		params = &UpdateColumnStatisticsTaskSettingsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateColumnStatisticsTaskSettings", params, optFns, c.addOperationUpdateColumnStatisticsTaskSettingsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateColumnStatisticsTaskSettingsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateColumnStatisticsTaskSettingsInput struct {

	// The name of the database where the table resides.
	//
	// This member is required.
	DatabaseName *string

	// The name of the table for which to generate column statistics.
	//
	// This member is required.
	TableName *string

	// The ID of the Data Catalog in which the database resides.
	CatalogID *string

	// A list of column names for which to run statistics.
	ColumnNameList []string

	// The role used for running the column statistics.
	Role *string

	// The percentage of data to sample.
	SampleSize float64

	// A schedule for running the column statistics, specified in CRON syntax.
	Schedule *string

	// Name of the security configuration that is used to encrypt CloudWatch logs.
	SecurityConfiguration *string

	noSmithyDocumentSerde
}

type UpdateColumnStatisticsTaskSettingsOutput struct {
	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateColumnStatisticsTaskSettingsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpUpdateColumnStatisticsTaskSettings{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpUpdateColumnStatisticsTaskSettings{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateColumnStatisticsTaskSettings"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateColumnStatisticsTaskSettingsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateColumnStatisticsTaskSettings(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateColumnStatisticsTaskSettings(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateColumnStatisticsTaskSettings",
	}
}
