// Code generated by smithy-go-codegen DO NOT EDIT.

package grafana

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/grafana/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates a service account for the workspace. A service account can be used to
// call Grafana HTTP APIs, and run automated workloads. After creating the service
// account with the correct GrafanaRole for your use case, use
// CreateWorkspaceServiceAccountToken to create a token that can be used to
// authenticate and authorize Grafana HTTP API calls.
//
// You can only create service accounts for workspaces that are compatible with
// Grafana version 9 and above.
//
// For more information about service accounts, see [Service accounts] in the Amazon Managed Grafana
// User Guide.
//
// For more information about the Grafana HTTP APIs, see [Using Grafana HTTP APIs] in the Amazon Managed
// Grafana User Guide.
//
// [Service accounts]: https://docs.aws.amazon.com/grafana/latest/userguide/service-accounts.html
// [Using Grafana HTTP APIs]: https://docs.aws.amazon.com/grafana/latest/userguide/Using-Grafana-APIs.html
func (c *Client) CreateWorkspaceServiceAccount(ctx context.Context, params *CreateWorkspaceServiceAccountInput, optFns ...func(*Options)) (*CreateWorkspaceServiceAccountOutput, error) {
	if params == nil {
		params = &CreateWorkspaceServiceAccountInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateWorkspaceServiceAccount", params, optFns, c.addOperationCreateWorkspaceServiceAccountMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateWorkspaceServiceAccountOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateWorkspaceServiceAccountInput struct {

	// The permission level to use for this service account.
	//
	// For more information about the roles and the permissions each has, see [User roles] in the
	// Amazon Managed Grafana User Guide.
	//
	// [User roles]: https://docs.aws.amazon.com/grafana/latest/userguide/Grafana-user-roles.html
	//
	// This member is required.
	GrafanaRole types.Role

	// A name for the service account. The name must be unique within the workspace,
	// as it determines the ID associated with the service account.
	//
	// This member is required.
	Name *string

	// The ID of the workspace within which to create the service account.
	//
	// This member is required.
	WorkspaceId *string

	noSmithyDocumentSerde
}

type CreateWorkspaceServiceAccountOutput struct {

	// The permission level given to the service account.
	//
	// This member is required.
	GrafanaRole types.Role

	// The ID of the service account.
	//
	// This member is required.
	Id *string

	// The name of the service account.
	//
	// This member is required.
	Name *string

	// The workspace with which the service account is associated.
	//
	// This member is required.
	WorkspaceId *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateWorkspaceServiceAccountMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateWorkspaceServiceAccount{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateWorkspaceServiceAccount{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateWorkspaceServiceAccount"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpCreateWorkspaceServiceAccountValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateWorkspaceServiceAccount(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateWorkspaceServiceAccount(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateWorkspaceServiceAccount",
	}
}
