// Code generated by smithy-go-codegen DO NOT EDIT.

package guardduty

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/guardduty/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Retrieves the Malware Protection plan details associated with a Malware
// Protection plan ID.
func (c *Client) GetMalwareProtectionPlan(ctx context.Context, params *GetMalwareProtectionPlanInput, optFns ...func(*Options)) (*GetMalwareProtectionPlanOutput, error) {
	if params == nil {
		params = &GetMalwareProtectionPlanInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetMalwareProtectionPlan", params, optFns, c.addOperationGetMalwareProtectionPlanMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetMalwareProtectionPlanOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetMalwareProtectionPlanInput struct {

	// A unique identifier associated with Malware Protection plan resource.
	//
	// This member is required.
	MalwareProtectionPlanId *string

	noSmithyDocumentSerde
}

type GetMalwareProtectionPlanOutput struct {

	// Information about whether the tags will be added to the S3 object after
	// scanning.
	Actions *types.MalwareProtectionPlanActions

	// Amazon Resource Name (ARN) of the protected resource.
	Arn *string

	// The timestamp when the Malware Protection plan resource was created.
	CreatedAt *time.Time

	// Information about the protected resource that is associated with the created
	// Malware Protection plan. Presently, S3Bucket is the only supported protected
	// resource.
	ProtectedResource *types.CreateProtectedResource

	// Amazon Resource Name (ARN) of the IAM role that includes the permissions to
	// scan and add tags to the associated protected resource.
	Role *string

	// Malware Protection plan status.
	Status types.MalwareProtectionPlanStatus

	// Information about the issue code and message associated to the status of your
	// Malware Protection plan.
	StatusReasons []types.MalwareProtectionPlanStatusReason

	// Tags added to the Malware Protection plan resource.
	Tags map[string]string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetMalwareProtectionPlanMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetMalwareProtectionPlan{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetMalwareProtectionPlan{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetMalwareProtectionPlan"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpGetMalwareProtectionPlanValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetMalwareProtectionPlan(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetMalwareProtectionPlan(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetMalwareProtectionPlan",
	}
}
