// Code generated by smithy-go-codegen DO NOT EDIT.

package imagebuilder

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/imagebuilder/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Verify the subscription and perform resource dependency checks on the requested
// Amazon Web Services Marketplace resource. For Amazon Web Services Marketplace
// components, the response contains fields to download the components and their
// artifacts.
func (c *Client) GetMarketplaceResource(ctx context.Context, params *GetMarketplaceResourceInput, optFns ...func(*Options)) (*GetMarketplaceResourceOutput, error) {
	if params == nil {
		params = &GetMarketplaceResourceInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetMarketplaceResource", params, optFns, c.addOperationGetMarketplaceResourceMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetMarketplaceResourceOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetMarketplaceResourceInput struct {

	// The Amazon Resource Name (ARN) that uniquely identifies an Amazon Web Services
	// Marketplace resource.
	//
	// This member is required.
	ResourceArn *string

	// Specifies which type of Amazon Web Services Marketplace resource Image Builder
	// retrieves.
	//
	// This member is required.
	ResourceType types.MarketplaceResourceType

	// The bucket path that you can specify to download the resource from Amazon S3.
	ResourceLocation *string

	noSmithyDocumentSerde
}

type GetMarketplaceResourceOutput struct {

	// Returns obfuscated data that contains the YAML content of the component.
	Data *string

	// The Amazon Resource Name (ARN) for the Amazon Web Services Marketplace resource
	// that was requested.
	ResourceArn *string

	// The obfuscated S3 URL to download the component artifact from.
	Url *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetMarketplaceResourceMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetMarketplaceResource{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetMarketplaceResource{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetMarketplaceResource"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpGetMarketplaceResourceValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetMarketplaceResource(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetMarketplaceResource(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetMarketplaceResource",
	}
}
