// Code generated by smithy-go-codegen DO NOT EDIT.

package imagebuilder

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Import a Windows operating system image from a verified Microsoft ISO disk
// file. The following disk images are supported:
//
//   - Windows 11 Enterprise
func (c *Client) ImportDiskImage(ctx context.Context, params *ImportDiskImageInput, optFns ...func(*Options)) (*ImportDiskImageOutput, error) {
	if params == nil {
		params = &ImportDiskImageInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ImportDiskImage", params, optFns, c.addOperationImportDiskImageMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ImportDiskImageOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ImportDiskImageInput struct {

	// Unique, case-sensitive identifier you provide to ensure idempotency of the
	// request. For more information, see [Ensuring idempotency]in the Amazon EC2 API Reference.
	//
	// [Ensuring idempotency]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html
	//
	// This member is required.
	ClientToken *string

	// The Amazon Resource Name (ARN) of the infrastructure configuration resource
	// that's used for launching the EC2 instance on which the ISO image is built.
	//
	// This member is required.
	InfrastructureConfigurationArn *string

	// The name of the image resource that's created from the import.
	//
	// This member is required.
	Name *string

	// The operating system version for the imported image. Allowed values include the
	// following: Microsoft Windows 11 .
	//
	// This member is required.
	OsVersion *string

	// The operating system platform for the imported image. Allowed values include
	// the following: Windows .
	//
	// This member is required.
	Platform *string

	// The semantic version to attach to the image that's created during the import
	// process. This version follows the semantic version syntax.
	//
	// This member is required.
	SemanticVersion *string

	// The uri of the ISO disk file that's stored in Amazon S3.
	//
	// This member is required.
	Uri *string

	// The description for your disk image import.
	Description *string

	// The name or Amazon Resource Name (ARN) for the IAM role you create that grants
	// Image Builder access to perform workflow actions to import an image from a
	// Microsoft ISO file.
	ExecutionRole *string

	// Tags that are attached to image resources created from the import.
	Tags map[string]string

	noSmithyDocumentSerde
}

type ImportDiskImageOutput struct {

	// The client token that uniquely identifies the request.
	ClientToken *string

	// The Amazon Resource Name (ARN) of the output AMI that was created from the ISO
	// disk file.
	ImageBuildVersionArn *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationImportDiskImageMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpImportDiskImage{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpImportDiskImage{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ImportDiskImage"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opImportDiskImageMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpImportDiskImageValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opImportDiskImage(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpImportDiskImage struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpImportDiskImage) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpImportDiskImage) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*ImportDiskImageInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *ImportDiskImageInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opImportDiskImageMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpImportDiskImage{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opImportDiskImage(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ImportDiskImage",
	}
}
