// Code generated by smithy-go-codegen DO NOT EDIT.

package inspector2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/inspector2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists the Amazon Inspector usage totals over the last 30 days.
func (c *Client) ListUsageTotals(ctx context.Context, params *ListUsageTotalsInput, optFns ...func(*Options)) (*ListUsageTotalsOutput, error) {
	if params == nil {
		params = &ListUsageTotalsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListUsageTotals", params, optFns, c.addOperationListUsageTotalsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListUsageTotalsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListUsageTotalsInput struct {

	// The Amazon Web Services account IDs to retrieve usage totals for.
	AccountIds []string

	// The maximum number of results the response can return. If your request would
	// return more than the maximum the response will return a nextToken value, use
	// this value when you call the action again to get the remaining results.
	MaxResults *int32

	// A token to use for paginating results that are returned in the response. Set
	// the value of this parameter to null for the first request to a list action. If
	// your response returns more than the maxResults maximum value it will also
	// return a nextToken value. For subsequent calls, use the nextToken value
	// returned from the previous request to continue listing results after the first
	// page.
	NextToken *string

	noSmithyDocumentSerde
}

type ListUsageTotalsOutput struct {

	// The pagination parameter to be used on the next list operation to retrieve more
	// items.
	NextToken *string

	// An object with details on the total usage for the requested account.
	Totals []types.UsageTotal

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListUsageTotalsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListUsageTotals{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListUsageTotals{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListUsageTotals"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListUsageTotals(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListUsageTotalsPaginatorOptions is the paginator options for ListUsageTotals
type ListUsageTotalsPaginatorOptions struct {
	// The maximum number of results the response can return. If your request would
	// return more than the maximum the response will return a nextToken value, use
	// this value when you call the action again to get the remaining results.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListUsageTotalsPaginator is a paginator for ListUsageTotals
type ListUsageTotalsPaginator struct {
	options   ListUsageTotalsPaginatorOptions
	client    ListUsageTotalsAPIClient
	params    *ListUsageTotalsInput
	nextToken *string
	firstPage bool
}

// NewListUsageTotalsPaginator returns a new ListUsageTotalsPaginator
func NewListUsageTotalsPaginator(client ListUsageTotalsAPIClient, params *ListUsageTotalsInput, optFns ...func(*ListUsageTotalsPaginatorOptions)) *ListUsageTotalsPaginator {
	if params == nil {
		params = &ListUsageTotalsInput{}
	}

	options := ListUsageTotalsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListUsageTotalsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListUsageTotalsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListUsageTotals page.
func (p *ListUsageTotalsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListUsageTotalsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListUsageTotals(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListUsageTotalsAPIClient is a client that implements the ListUsageTotals
// operation.
type ListUsageTotalsAPIClient interface {
	ListUsageTotals(context.Context, *ListUsageTotalsInput, ...func(*Options)) (*ListUsageTotalsOutput, error)
}

var _ ListUsageTotalsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListUsageTotals(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListUsageTotals",
	}
}
