// Code generated by smithy-go-codegen DO NOT EDIT.

package inspector2

import (
	"bytes"
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/inspector2/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	smithyjson "github.com/aws/smithy-go/encoding/json"
	"github.com/aws/smithy-go/middleware"
	smithytime "github.com/aws/smithy-go/time"
	"github.com/aws/smithy-go/tracing"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"math"
)

type awsRestjson1_serializeOpAssociateMember struct {
}

func (*awsRestjson1_serializeOpAssociateMember) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpAssociateMember) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AssociateMemberInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/members/associate")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentAssociateMemberInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsAssociateMemberInput(v *AssociateMemberInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentAssociateMemberInput(v *AssociateMemberInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AccountId != nil {
		ok := object.Key("accountId")
		ok.String(*v.AccountId)
	}

	return nil
}

type awsRestjson1_serializeOpBatchGetAccountStatus struct {
}

func (*awsRestjson1_serializeOpBatchGetAccountStatus) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpBatchGetAccountStatus) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*BatchGetAccountStatusInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/status/batch/get")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentBatchGetAccountStatusInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsBatchGetAccountStatusInput(v *BatchGetAccountStatusInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentBatchGetAccountStatusInput(v *BatchGetAccountStatusInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AccountIds != nil {
		ok := object.Key("accountIds")
		if err := awsRestjson1_serializeDocumentAccountIdSet(v.AccountIds, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpBatchGetCodeSnippet struct {
}

func (*awsRestjson1_serializeOpBatchGetCodeSnippet) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpBatchGetCodeSnippet) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*BatchGetCodeSnippetInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/codesnippet/batchget")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentBatchGetCodeSnippetInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsBatchGetCodeSnippetInput(v *BatchGetCodeSnippetInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentBatchGetCodeSnippetInput(v *BatchGetCodeSnippetInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FindingArns != nil {
		ok := object.Key("findingArns")
		if err := awsRestjson1_serializeDocumentFindingArns(v.FindingArns, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpBatchGetFindingDetails struct {
}

func (*awsRestjson1_serializeOpBatchGetFindingDetails) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpBatchGetFindingDetails) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*BatchGetFindingDetailsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/findings/details/batch/get")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentBatchGetFindingDetailsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsBatchGetFindingDetailsInput(v *BatchGetFindingDetailsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentBatchGetFindingDetailsInput(v *BatchGetFindingDetailsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FindingArns != nil {
		ok := object.Key("findingArns")
		if err := awsRestjson1_serializeDocumentFindingArnList(v.FindingArns, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpBatchGetFreeTrialInfo struct {
}

func (*awsRestjson1_serializeOpBatchGetFreeTrialInfo) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpBatchGetFreeTrialInfo) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*BatchGetFreeTrialInfoInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/freetrialinfo/batchget")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentBatchGetFreeTrialInfoInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsBatchGetFreeTrialInfoInput(v *BatchGetFreeTrialInfoInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentBatchGetFreeTrialInfoInput(v *BatchGetFreeTrialInfoInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AccountIds != nil {
		ok := object.Key("accountIds")
		if err := awsRestjson1_serializeDocumentMeteringAccountIdList(v.AccountIds, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpBatchGetMemberEc2DeepInspectionStatus struct {
}

func (*awsRestjson1_serializeOpBatchGetMemberEc2DeepInspectionStatus) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpBatchGetMemberEc2DeepInspectionStatus) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*BatchGetMemberEc2DeepInspectionStatusInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/ec2deepinspectionstatus/member/batch/get")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentBatchGetMemberEc2DeepInspectionStatusInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsBatchGetMemberEc2DeepInspectionStatusInput(v *BatchGetMemberEc2DeepInspectionStatusInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentBatchGetMemberEc2DeepInspectionStatusInput(v *BatchGetMemberEc2DeepInspectionStatusInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AccountIds != nil {
		ok := object.Key("accountIds")
		if err := awsRestjson1_serializeDocumentAccountIdSet(v.AccountIds, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpBatchUpdateMemberEc2DeepInspectionStatus struct {
}

func (*awsRestjson1_serializeOpBatchUpdateMemberEc2DeepInspectionStatus) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpBatchUpdateMemberEc2DeepInspectionStatus) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*BatchUpdateMemberEc2DeepInspectionStatusInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/ec2deepinspectionstatus/member/batch/update")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentBatchUpdateMemberEc2DeepInspectionStatusInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsBatchUpdateMemberEc2DeepInspectionStatusInput(v *BatchUpdateMemberEc2DeepInspectionStatusInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentBatchUpdateMemberEc2DeepInspectionStatusInput(v *BatchUpdateMemberEc2DeepInspectionStatusInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AccountIds != nil {
		ok := object.Key("accountIds")
		if err := awsRestjson1_serializeDocumentMemberAccountEc2DeepInspectionStatusList(v.AccountIds, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCancelFindingsReport struct {
}

func (*awsRestjson1_serializeOpCancelFindingsReport) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCancelFindingsReport) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CancelFindingsReportInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/reporting/cancel")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCancelFindingsReportInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCancelFindingsReportInput(v *CancelFindingsReportInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCancelFindingsReportInput(v *CancelFindingsReportInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ReportId != nil {
		ok := object.Key("reportId")
		ok.String(*v.ReportId)
	}

	return nil
}

type awsRestjson1_serializeOpCancelSbomExport struct {
}

func (*awsRestjson1_serializeOpCancelSbomExport) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCancelSbomExport) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CancelSbomExportInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/sbomexport/cancel")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCancelSbomExportInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCancelSbomExportInput(v *CancelSbomExportInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCancelSbomExportInput(v *CancelSbomExportInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ReportId != nil {
		ok := object.Key("reportId")
		ok.String(*v.ReportId)
	}

	return nil
}

type awsRestjson1_serializeOpCreateCisScanConfiguration struct {
}

func (*awsRestjson1_serializeOpCreateCisScanConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateCisScanConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateCisScanConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/cis/scan-configuration/create")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateCisScanConfigurationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateCisScanConfigurationInput(v *CreateCisScanConfigurationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateCisScanConfigurationInput(v *CreateCisScanConfigurationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ScanName != nil {
		ok := object.Key("scanName")
		ok.String(*v.ScanName)
	}

	if v.Schedule != nil {
		ok := object.Key("schedule")
		if err := awsRestjson1_serializeDocumentSchedule(v.Schedule, ok); err != nil {
			return err
		}
	}

	if len(v.SecurityLevel) > 0 {
		ok := object.Key("securityLevel")
		ok.String(string(v.SecurityLevel))
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentCisTagMap(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.Targets != nil {
		ok := object.Key("targets")
		if err := awsRestjson1_serializeDocumentCreateCisTargets(v.Targets, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateFilter struct {
}

func (*awsRestjson1_serializeOpCreateFilter) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateFilter) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateFilterInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/filters/create")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateFilterInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateFilterInput(v *CreateFilterInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateFilterInput(v *CreateFilterInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Action) > 0 {
		ok := object.Key("action")
		ok.String(string(v.Action))
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.FilterCriteria != nil {
		ok := object.Key("filterCriteria")
		if err := awsRestjson1_serializeDocumentFilterCriteria(v.FilterCriteria, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.Reason != nil {
		ok := object.Key("reason")
		ok.String(*v.Reason)
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTagMap(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateFindingsReport struct {
}

func (*awsRestjson1_serializeOpCreateFindingsReport) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateFindingsReport) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateFindingsReportInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/reporting/create")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateFindingsReportInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateFindingsReportInput(v *CreateFindingsReportInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateFindingsReportInput(v *CreateFindingsReportInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FilterCriteria != nil {
		ok := object.Key("filterCriteria")
		if err := awsRestjson1_serializeDocumentFilterCriteria(v.FilterCriteria, ok); err != nil {
			return err
		}
	}

	if len(v.ReportFormat) > 0 {
		ok := object.Key("reportFormat")
		ok.String(string(v.ReportFormat))
	}

	if v.S3Destination != nil {
		ok := object.Key("s3Destination")
		if err := awsRestjson1_serializeDocumentDestination(v.S3Destination, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateSbomExport struct {
}

func (*awsRestjson1_serializeOpCreateSbomExport) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateSbomExport) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateSbomExportInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/sbomexport/create")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateSbomExportInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateSbomExportInput(v *CreateSbomExportInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateSbomExportInput(v *CreateSbomExportInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.ReportFormat) > 0 {
		ok := object.Key("reportFormat")
		ok.String(string(v.ReportFormat))
	}

	if v.ResourceFilterCriteria != nil {
		ok := object.Key("resourceFilterCriteria")
		if err := awsRestjson1_serializeDocumentResourceFilterCriteria(v.ResourceFilterCriteria, ok); err != nil {
			return err
		}
	}

	if v.S3Destination != nil {
		ok := object.Key("s3Destination")
		if err := awsRestjson1_serializeDocumentDestination(v.S3Destination, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteCisScanConfiguration struct {
}

func (*awsRestjson1_serializeOpDeleteCisScanConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteCisScanConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteCisScanConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/cis/scan-configuration/delete")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentDeleteCisScanConfigurationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteCisScanConfigurationInput(v *DeleteCisScanConfigurationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentDeleteCisScanConfigurationInput(v *DeleteCisScanConfigurationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ScanConfigurationArn != nil {
		ok := object.Key("scanConfigurationArn")
		ok.String(*v.ScanConfigurationArn)
	}

	return nil
}

type awsRestjson1_serializeOpDeleteFilter struct {
}

func (*awsRestjson1_serializeOpDeleteFilter) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteFilter) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteFilterInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/filters/delete")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentDeleteFilterInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteFilterInput(v *DeleteFilterInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentDeleteFilterInput(v *DeleteFilterInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Arn != nil {
		ok := object.Key("arn")
		ok.String(*v.Arn)
	}

	return nil
}

type awsRestjson1_serializeOpDescribeOrganizationConfiguration struct {
}

func (*awsRestjson1_serializeOpDescribeOrganizationConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeOrganizationConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeOrganizationConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/organizationconfiguration/describe")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeOrganizationConfigurationInput(v *DescribeOrganizationConfigurationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

type awsRestjson1_serializeOpDisable struct {
}

func (*awsRestjson1_serializeOpDisable) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDisable) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DisableInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/disable")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentDisableInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDisableInput(v *DisableInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentDisableInput(v *DisableInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AccountIds != nil {
		ok := object.Key("accountIds")
		if err := awsRestjson1_serializeDocumentAccountIdSet(v.AccountIds, ok); err != nil {
			return err
		}
	}

	if v.ResourceTypes != nil {
		ok := object.Key("resourceTypes")
		if err := awsRestjson1_serializeDocumentDisableResourceTypeList(v.ResourceTypes, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDisableDelegatedAdminAccount struct {
}

func (*awsRestjson1_serializeOpDisableDelegatedAdminAccount) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDisableDelegatedAdminAccount) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DisableDelegatedAdminAccountInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/delegatedadminaccounts/disable")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentDisableDelegatedAdminAccountInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDisableDelegatedAdminAccountInput(v *DisableDelegatedAdminAccountInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentDisableDelegatedAdminAccountInput(v *DisableDelegatedAdminAccountInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DelegatedAdminAccountId != nil {
		ok := object.Key("delegatedAdminAccountId")
		ok.String(*v.DelegatedAdminAccountId)
	}

	return nil
}

type awsRestjson1_serializeOpDisassociateMember struct {
}

func (*awsRestjson1_serializeOpDisassociateMember) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDisassociateMember) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DisassociateMemberInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/members/disassociate")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentDisassociateMemberInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDisassociateMemberInput(v *DisassociateMemberInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentDisassociateMemberInput(v *DisassociateMemberInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AccountId != nil {
		ok := object.Key("accountId")
		ok.String(*v.AccountId)
	}

	return nil
}

type awsRestjson1_serializeOpEnable struct {
}

func (*awsRestjson1_serializeOpEnable) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpEnable) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*EnableInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/enable")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentEnableInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsEnableInput(v *EnableInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentEnableInput(v *EnableInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AccountIds != nil {
		ok := object.Key("accountIds")
		if err := awsRestjson1_serializeDocumentAccountIdSet(v.AccountIds, ok); err != nil {
			return err
		}
	}

	if v.ClientToken != nil {
		ok := object.Key("clientToken")
		ok.String(*v.ClientToken)
	}

	if v.ResourceTypes != nil {
		ok := object.Key("resourceTypes")
		if err := awsRestjson1_serializeDocumentEnableResourceTypeList(v.ResourceTypes, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpEnableDelegatedAdminAccount struct {
}

func (*awsRestjson1_serializeOpEnableDelegatedAdminAccount) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpEnableDelegatedAdminAccount) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*EnableDelegatedAdminAccountInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/delegatedadminaccounts/enable")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentEnableDelegatedAdminAccountInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsEnableDelegatedAdminAccountInput(v *EnableDelegatedAdminAccountInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentEnableDelegatedAdminAccountInput(v *EnableDelegatedAdminAccountInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientToken != nil {
		ok := object.Key("clientToken")
		ok.String(*v.ClientToken)
	}

	if v.DelegatedAdminAccountId != nil {
		ok := object.Key("delegatedAdminAccountId")
		ok.String(*v.DelegatedAdminAccountId)
	}

	return nil
}

type awsRestjson1_serializeOpGetCisScanReport struct {
}

func (*awsRestjson1_serializeOpGetCisScanReport) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetCisScanReport) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetCisScanReportInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/cis/scan/report/get")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentGetCisScanReportInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetCisScanReportInput(v *GetCisScanReportInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentGetCisScanReportInput(v *GetCisScanReportInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.ReportFormat) > 0 {
		ok := object.Key("reportFormat")
		ok.String(string(v.ReportFormat))
	}

	if v.ScanArn != nil {
		ok := object.Key("scanArn")
		ok.String(*v.ScanArn)
	}

	if v.TargetAccounts != nil {
		ok := object.Key("targetAccounts")
		if err := awsRestjson1_serializeDocumentReportTargetAccounts(v.TargetAccounts, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetCisScanResultDetails struct {
}

func (*awsRestjson1_serializeOpGetCisScanResultDetails) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetCisScanResultDetails) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetCisScanResultDetailsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/cis/scan-result/details/get")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentGetCisScanResultDetailsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetCisScanResultDetailsInput(v *GetCisScanResultDetailsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentGetCisScanResultDetailsInput(v *GetCisScanResultDetailsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AccountId != nil {
		ok := object.Key("accountId")
		ok.String(*v.AccountId)
	}

	if v.FilterCriteria != nil {
		ok := object.Key("filterCriteria")
		if err := awsRestjson1_serializeDocumentCisScanResultDetailsFilterCriteria(v.FilterCriteria, ok); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		ok := object.Key("maxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	if v.ScanArn != nil {
		ok := object.Key("scanArn")
		ok.String(*v.ScanArn)
	}

	if len(v.SortBy) > 0 {
		ok := object.Key("sortBy")
		ok.String(string(v.SortBy))
	}

	if len(v.SortOrder) > 0 {
		ok := object.Key("sortOrder")
		ok.String(string(v.SortOrder))
	}

	if v.TargetResourceId != nil {
		ok := object.Key("targetResourceId")
		ok.String(*v.TargetResourceId)
	}

	return nil
}

type awsRestjson1_serializeOpGetConfiguration struct {
}

func (*awsRestjson1_serializeOpGetConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/configuration/get")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetConfigurationInput(v *GetConfigurationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

type awsRestjson1_serializeOpGetDelegatedAdminAccount struct {
}

func (*awsRestjson1_serializeOpGetDelegatedAdminAccount) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetDelegatedAdminAccount) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetDelegatedAdminAccountInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/delegatedadminaccounts/get")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetDelegatedAdminAccountInput(v *GetDelegatedAdminAccountInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

type awsRestjson1_serializeOpGetEc2DeepInspectionConfiguration struct {
}

func (*awsRestjson1_serializeOpGetEc2DeepInspectionConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetEc2DeepInspectionConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetEc2DeepInspectionConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/ec2deepinspectionconfiguration/get")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetEc2DeepInspectionConfigurationInput(v *GetEc2DeepInspectionConfigurationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

type awsRestjson1_serializeOpGetEncryptionKey struct {
}

func (*awsRestjson1_serializeOpGetEncryptionKey) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetEncryptionKey) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetEncryptionKeyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/encryptionkey/get")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetEncryptionKeyInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetEncryptionKeyInput(v *GetEncryptionKeyInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if len(v.ResourceType) > 0 {
		encoder.SetQuery("resourceType").String(string(v.ResourceType))
	}

	if len(v.ScanType) > 0 {
		encoder.SetQuery("scanType").String(string(v.ScanType))
	}

	return nil
}

type awsRestjson1_serializeOpGetFindingsReportStatus struct {
}

func (*awsRestjson1_serializeOpGetFindingsReportStatus) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetFindingsReportStatus) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetFindingsReportStatusInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/reporting/status/get")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentGetFindingsReportStatusInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetFindingsReportStatusInput(v *GetFindingsReportStatusInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentGetFindingsReportStatusInput(v *GetFindingsReportStatusInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ReportId != nil {
		ok := object.Key("reportId")
		ok.String(*v.ReportId)
	}

	return nil
}

type awsRestjson1_serializeOpGetMember struct {
}

func (*awsRestjson1_serializeOpGetMember) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetMember) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetMemberInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/members/get")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentGetMemberInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetMemberInput(v *GetMemberInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentGetMemberInput(v *GetMemberInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AccountId != nil {
		ok := object.Key("accountId")
		ok.String(*v.AccountId)
	}

	return nil
}

type awsRestjson1_serializeOpGetSbomExport struct {
}

func (*awsRestjson1_serializeOpGetSbomExport) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetSbomExport) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetSbomExportInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/sbomexport/get")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentGetSbomExportInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetSbomExportInput(v *GetSbomExportInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentGetSbomExportInput(v *GetSbomExportInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ReportId != nil {
		ok := object.Key("reportId")
		ok.String(*v.ReportId)
	}

	return nil
}

type awsRestjson1_serializeOpListAccountPermissions struct {
}

func (*awsRestjson1_serializeOpListAccountPermissions) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListAccountPermissions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListAccountPermissionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accountpermissions/list")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListAccountPermissionsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListAccountPermissionsInput(v *ListAccountPermissionsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListAccountPermissionsInput(v *ListAccountPermissionsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("maxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	if len(v.Service) > 0 {
		ok := object.Key("service")
		ok.String(string(v.Service))
	}

	return nil
}

type awsRestjson1_serializeOpListCisScanConfigurations struct {
}

func (*awsRestjson1_serializeOpListCisScanConfigurations) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListCisScanConfigurations) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListCisScanConfigurationsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/cis/scan-configuration/list")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListCisScanConfigurationsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListCisScanConfigurationsInput(v *ListCisScanConfigurationsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListCisScanConfigurationsInput(v *ListCisScanConfigurationsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FilterCriteria != nil {
		ok := object.Key("filterCriteria")
		if err := awsRestjson1_serializeDocumentListCisScanConfigurationsFilterCriteria(v.FilterCriteria, ok); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		ok := object.Key("maxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	if len(v.SortBy) > 0 {
		ok := object.Key("sortBy")
		ok.String(string(v.SortBy))
	}

	if len(v.SortOrder) > 0 {
		ok := object.Key("sortOrder")
		ok.String(string(v.SortOrder))
	}

	return nil
}

type awsRestjson1_serializeOpListCisScanResultsAggregatedByChecks struct {
}

func (*awsRestjson1_serializeOpListCisScanResultsAggregatedByChecks) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListCisScanResultsAggregatedByChecks) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListCisScanResultsAggregatedByChecksInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/cis/scan-result/check/list")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListCisScanResultsAggregatedByChecksInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListCisScanResultsAggregatedByChecksInput(v *ListCisScanResultsAggregatedByChecksInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListCisScanResultsAggregatedByChecksInput(v *ListCisScanResultsAggregatedByChecksInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FilterCriteria != nil {
		ok := object.Key("filterCriteria")
		if err := awsRestjson1_serializeDocumentCisScanResultsAggregatedByChecksFilterCriteria(v.FilterCriteria, ok); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		ok := object.Key("maxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	if v.ScanArn != nil {
		ok := object.Key("scanArn")
		ok.String(*v.ScanArn)
	}

	if len(v.SortBy) > 0 {
		ok := object.Key("sortBy")
		ok.String(string(v.SortBy))
	}

	if len(v.SortOrder) > 0 {
		ok := object.Key("sortOrder")
		ok.String(string(v.SortOrder))
	}

	return nil
}

type awsRestjson1_serializeOpListCisScanResultsAggregatedByTargetResource struct {
}

func (*awsRestjson1_serializeOpListCisScanResultsAggregatedByTargetResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListCisScanResultsAggregatedByTargetResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListCisScanResultsAggregatedByTargetResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/cis/scan-result/resource/list")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListCisScanResultsAggregatedByTargetResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListCisScanResultsAggregatedByTargetResourceInput(v *ListCisScanResultsAggregatedByTargetResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListCisScanResultsAggregatedByTargetResourceInput(v *ListCisScanResultsAggregatedByTargetResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FilterCriteria != nil {
		ok := object.Key("filterCriteria")
		if err := awsRestjson1_serializeDocumentCisScanResultsAggregatedByTargetResourceFilterCriteria(v.FilterCriteria, ok); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		ok := object.Key("maxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	if v.ScanArn != nil {
		ok := object.Key("scanArn")
		ok.String(*v.ScanArn)
	}

	if len(v.SortBy) > 0 {
		ok := object.Key("sortBy")
		ok.String(string(v.SortBy))
	}

	if len(v.SortOrder) > 0 {
		ok := object.Key("sortOrder")
		ok.String(string(v.SortOrder))
	}

	return nil
}

type awsRestjson1_serializeOpListCisScans struct {
}

func (*awsRestjson1_serializeOpListCisScans) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListCisScans) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListCisScansInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/cis/scan/list")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListCisScansInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListCisScansInput(v *ListCisScansInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListCisScansInput(v *ListCisScansInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.DetailLevel) > 0 {
		ok := object.Key("detailLevel")
		ok.String(string(v.DetailLevel))
	}

	if v.FilterCriteria != nil {
		ok := object.Key("filterCriteria")
		if err := awsRestjson1_serializeDocumentListCisScansFilterCriteria(v.FilterCriteria, ok); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		ok := object.Key("maxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	if len(v.SortBy) > 0 {
		ok := object.Key("sortBy")
		ok.String(string(v.SortBy))
	}

	if len(v.SortOrder) > 0 {
		ok := object.Key("sortOrder")
		ok.String(string(v.SortOrder))
	}

	return nil
}

type awsRestjson1_serializeOpListCoverage struct {
}

func (*awsRestjson1_serializeOpListCoverage) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListCoverage) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListCoverageInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/coverage/list")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListCoverageInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListCoverageInput(v *ListCoverageInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListCoverageInput(v *ListCoverageInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FilterCriteria != nil {
		ok := object.Key("filterCriteria")
		if err := awsRestjson1_serializeDocumentCoverageFilterCriteria(v.FilterCriteria, ok); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		ok := object.Key("maxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListCoverageStatistics struct {
}

func (*awsRestjson1_serializeOpListCoverageStatistics) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListCoverageStatistics) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListCoverageStatisticsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/coverage/statistics/list")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListCoverageStatisticsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListCoverageStatisticsInput(v *ListCoverageStatisticsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListCoverageStatisticsInput(v *ListCoverageStatisticsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FilterCriteria != nil {
		ok := object.Key("filterCriteria")
		if err := awsRestjson1_serializeDocumentCoverageFilterCriteria(v.FilterCriteria, ok); err != nil {
			return err
		}
	}

	if len(v.GroupBy) > 0 {
		ok := object.Key("groupBy")
		ok.String(string(v.GroupBy))
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListDelegatedAdminAccounts struct {
}

func (*awsRestjson1_serializeOpListDelegatedAdminAccounts) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListDelegatedAdminAccounts) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListDelegatedAdminAccountsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/delegatedadminaccounts/list")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListDelegatedAdminAccountsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListDelegatedAdminAccountsInput(v *ListDelegatedAdminAccountsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListDelegatedAdminAccountsInput(v *ListDelegatedAdminAccountsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("maxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListFilters struct {
}

func (*awsRestjson1_serializeOpListFilters) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListFilters) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListFiltersInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/filters/list")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListFiltersInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListFiltersInput(v *ListFiltersInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListFiltersInput(v *ListFiltersInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Action) > 0 {
		ok := object.Key("action")
		ok.String(string(v.Action))
	}

	if v.Arns != nil {
		ok := object.Key("arns")
		if err := awsRestjson1_serializeDocumentFilterArnList(v.Arns, ok); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		ok := object.Key("maxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListFindingAggregations struct {
}

func (*awsRestjson1_serializeOpListFindingAggregations) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListFindingAggregations) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListFindingAggregationsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/findings/aggregation/list")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListFindingAggregationsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListFindingAggregationsInput(v *ListFindingAggregationsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListFindingAggregationsInput(v *ListFindingAggregationsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AccountIds != nil {
		ok := object.Key("accountIds")
		if err := awsRestjson1_serializeDocumentStringFilterList(v.AccountIds, ok); err != nil {
			return err
		}
	}

	if v.AggregationRequest != nil {
		ok := object.Key("aggregationRequest")
		if err := awsRestjson1_serializeDocumentAggregationRequest(v.AggregationRequest, ok); err != nil {
			return err
		}
	}

	if len(v.AggregationType) > 0 {
		ok := object.Key("aggregationType")
		ok.String(string(v.AggregationType))
	}

	if v.MaxResults != nil {
		ok := object.Key("maxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListFindings struct {
}

func (*awsRestjson1_serializeOpListFindings) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListFindings) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListFindingsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/findings/list")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListFindingsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListFindingsInput(v *ListFindingsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListFindingsInput(v *ListFindingsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FilterCriteria != nil {
		ok := object.Key("filterCriteria")
		if err := awsRestjson1_serializeDocumentFilterCriteria(v.FilterCriteria, ok); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		ok := object.Key("maxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	if v.SortCriteria != nil {
		ok := object.Key("sortCriteria")
		if err := awsRestjson1_serializeDocumentSortCriteria(v.SortCriteria, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListMembers struct {
}

func (*awsRestjson1_serializeOpListMembers) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListMembers) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListMembersInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/members/list")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListMembersInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListMembersInput(v *ListMembersInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListMembersInput(v *ListMembersInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("maxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	if v.OnlyAssociated != nil {
		ok := object.Key("onlyAssociated")
		ok.Boolean(*v.OnlyAssociated)
	}

	return nil
}

type awsRestjson1_serializeOpListTagsForResource struct {
}

func (*awsRestjson1_serializeOpListTagsForResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListTagsForResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListTagsForResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tags/{resourceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListTagsForResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListTagsForResourceInput(v *ListTagsForResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member resourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("resourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListUsageTotals struct {
}

func (*awsRestjson1_serializeOpListUsageTotals) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListUsageTotals) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListUsageTotalsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/usage/list")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListUsageTotalsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListUsageTotalsInput(v *ListUsageTotalsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListUsageTotalsInput(v *ListUsageTotalsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AccountIds != nil {
		ok := object.Key("accountIds")
		if err := awsRestjson1_serializeDocumentUsageAccountIdList(v.AccountIds, ok); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		ok := object.Key("maxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpResetEncryptionKey struct {
}

func (*awsRestjson1_serializeOpResetEncryptionKey) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpResetEncryptionKey) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ResetEncryptionKeyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/encryptionkey/reset")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentResetEncryptionKeyInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsResetEncryptionKeyInput(v *ResetEncryptionKeyInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentResetEncryptionKeyInput(v *ResetEncryptionKeyInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.ResourceType) > 0 {
		ok := object.Key("resourceType")
		ok.String(string(v.ResourceType))
	}

	if len(v.ScanType) > 0 {
		ok := object.Key("scanType")
		ok.String(string(v.ScanType))
	}

	return nil
}

type awsRestjson1_serializeOpSearchVulnerabilities struct {
}

func (*awsRestjson1_serializeOpSearchVulnerabilities) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpSearchVulnerabilities) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*SearchVulnerabilitiesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/vulnerabilities/search")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentSearchVulnerabilitiesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsSearchVulnerabilitiesInput(v *SearchVulnerabilitiesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentSearchVulnerabilitiesInput(v *SearchVulnerabilitiesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FilterCriteria != nil {
		ok := object.Key("filterCriteria")
		if err := awsRestjson1_serializeDocumentSearchVulnerabilitiesFilterCriteria(v.FilterCriteria, ok); err != nil {
			return err
		}
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpSendCisSessionHealth struct {
}

func (*awsRestjson1_serializeOpSendCisSessionHealth) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpSendCisSessionHealth) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*SendCisSessionHealthInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/cissession/health/send")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentSendCisSessionHealthInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsSendCisSessionHealthInput(v *SendCisSessionHealthInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentSendCisSessionHealthInput(v *SendCisSessionHealthInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ScanJobId != nil {
		ok := object.Key("scanJobId")
		ok.String(*v.ScanJobId)
	}

	if v.SessionToken != nil {
		ok := object.Key("sessionToken")
		ok.String(*v.SessionToken)
	}

	return nil
}

type awsRestjson1_serializeOpSendCisSessionTelemetry struct {
}

func (*awsRestjson1_serializeOpSendCisSessionTelemetry) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpSendCisSessionTelemetry) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*SendCisSessionTelemetryInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/cissession/telemetry/send")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentSendCisSessionTelemetryInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsSendCisSessionTelemetryInput(v *SendCisSessionTelemetryInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentSendCisSessionTelemetryInput(v *SendCisSessionTelemetryInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Messages != nil {
		ok := object.Key("messages")
		if err := awsRestjson1_serializeDocumentCisSessionMessages(v.Messages, ok); err != nil {
			return err
		}
	}

	if v.ScanJobId != nil {
		ok := object.Key("scanJobId")
		ok.String(*v.ScanJobId)
	}

	if v.SessionToken != nil {
		ok := object.Key("sessionToken")
		ok.String(*v.SessionToken)
	}

	return nil
}

type awsRestjson1_serializeOpStartCisSession struct {
}

func (*awsRestjson1_serializeOpStartCisSession) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpStartCisSession) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StartCisSessionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/cissession/start")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentStartCisSessionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsStartCisSessionInput(v *StartCisSessionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentStartCisSessionInput(v *StartCisSessionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Message != nil {
		ok := object.Key("message")
		if err := awsRestjson1_serializeDocumentStartCisSessionMessage(v.Message, ok); err != nil {
			return err
		}
	}

	if v.ScanJobId != nil {
		ok := object.Key("scanJobId")
		ok.String(*v.ScanJobId)
	}

	return nil
}

type awsRestjson1_serializeOpStopCisSession struct {
}

func (*awsRestjson1_serializeOpStopCisSession) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpStopCisSession) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StopCisSessionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/cissession/stop")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentStopCisSessionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsStopCisSessionInput(v *StopCisSessionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentStopCisSessionInput(v *StopCisSessionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Message != nil {
		ok := object.Key("message")
		if err := awsRestjson1_serializeDocumentStopCisSessionMessage(v.Message, ok); err != nil {
			return err
		}
	}

	if v.ScanJobId != nil {
		ok := object.Key("scanJobId")
		ok.String(*v.ScanJobId)
	}

	if v.SessionToken != nil {
		ok := object.Key("sessionToken")
		ok.String(*v.SessionToken)
	}

	return nil
}

type awsRestjson1_serializeOpTagResource struct {
}

func (*awsRestjson1_serializeOpTagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpTagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*TagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tags/{resourceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsTagResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentTagResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsTagResourceInput(v *TagResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member resourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("resourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentTagResourceInput(v *TagResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTagMap(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUntagResource struct {
}

func (*awsRestjson1_serializeOpUntagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUntagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UntagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tags/{resourceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUntagResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUntagResourceInput(v *UntagResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member resourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("resourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	if v.TagKeys != nil {
		for i := range v.TagKeys {
			encoder.AddQuery("tagKeys").String(v.TagKeys[i])
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateCisScanConfiguration struct {
}

func (*awsRestjson1_serializeOpUpdateCisScanConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateCisScanConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateCisScanConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/cis/scan-configuration/update")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateCisScanConfigurationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateCisScanConfigurationInput(v *UpdateCisScanConfigurationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateCisScanConfigurationInput(v *UpdateCisScanConfigurationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ScanConfigurationArn != nil {
		ok := object.Key("scanConfigurationArn")
		ok.String(*v.ScanConfigurationArn)
	}

	if v.ScanName != nil {
		ok := object.Key("scanName")
		ok.String(*v.ScanName)
	}

	if v.Schedule != nil {
		ok := object.Key("schedule")
		if err := awsRestjson1_serializeDocumentSchedule(v.Schedule, ok); err != nil {
			return err
		}
	}

	if len(v.SecurityLevel) > 0 {
		ok := object.Key("securityLevel")
		ok.String(string(v.SecurityLevel))
	}

	if v.Targets != nil {
		ok := object.Key("targets")
		if err := awsRestjson1_serializeDocumentUpdateCisTargets(v.Targets, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateConfiguration struct {
}

func (*awsRestjson1_serializeOpUpdateConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/configuration/update")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateConfigurationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateConfigurationInput(v *UpdateConfigurationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateConfigurationInput(v *UpdateConfigurationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Ec2Configuration != nil {
		ok := object.Key("ec2Configuration")
		if err := awsRestjson1_serializeDocumentEc2Configuration(v.Ec2Configuration, ok); err != nil {
			return err
		}
	}

	if v.EcrConfiguration != nil {
		ok := object.Key("ecrConfiguration")
		if err := awsRestjson1_serializeDocumentEcrConfiguration(v.EcrConfiguration, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateEc2DeepInspectionConfiguration struct {
}

func (*awsRestjson1_serializeOpUpdateEc2DeepInspectionConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateEc2DeepInspectionConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateEc2DeepInspectionConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/ec2deepinspectionconfiguration/update")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateEc2DeepInspectionConfigurationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateEc2DeepInspectionConfigurationInput(v *UpdateEc2DeepInspectionConfigurationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateEc2DeepInspectionConfigurationInput(v *UpdateEc2DeepInspectionConfigurationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ActivateDeepInspection != nil {
		ok := object.Key("activateDeepInspection")
		ok.Boolean(*v.ActivateDeepInspection)
	}

	if v.PackagePaths != nil {
		ok := object.Key("packagePaths")
		if err := awsRestjson1_serializeDocumentPathList(v.PackagePaths, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateEncryptionKey struct {
}

func (*awsRestjson1_serializeOpUpdateEncryptionKey) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateEncryptionKey) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateEncryptionKeyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/encryptionkey/update")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateEncryptionKeyInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateEncryptionKeyInput(v *UpdateEncryptionKeyInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateEncryptionKeyInput(v *UpdateEncryptionKeyInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.KmsKeyId != nil {
		ok := object.Key("kmsKeyId")
		ok.String(*v.KmsKeyId)
	}

	if len(v.ResourceType) > 0 {
		ok := object.Key("resourceType")
		ok.String(string(v.ResourceType))
	}

	if len(v.ScanType) > 0 {
		ok := object.Key("scanType")
		ok.String(string(v.ScanType))
	}

	return nil
}

type awsRestjson1_serializeOpUpdateFilter struct {
}

func (*awsRestjson1_serializeOpUpdateFilter) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateFilter) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateFilterInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/filters/update")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateFilterInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateFilterInput(v *UpdateFilterInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateFilterInput(v *UpdateFilterInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Action) > 0 {
		ok := object.Key("action")
		ok.String(string(v.Action))
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.FilterArn != nil {
		ok := object.Key("filterArn")
		ok.String(*v.FilterArn)
	}

	if v.FilterCriteria != nil {
		ok := object.Key("filterCriteria")
		if err := awsRestjson1_serializeDocumentFilterCriteria(v.FilterCriteria, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.Reason != nil {
		ok := object.Key("reason")
		ok.String(*v.Reason)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateOrganizationConfiguration struct {
}

func (*awsRestjson1_serializeOpUpdateOrganizationConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateOrganizationConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateOrganizationConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/organizationconfiguration/update")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateOrganizationConfigurationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateOrganizationConfigurationInput(v *UpdateOrganizationConfigurationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateOrganizationConfigurationInput(v *UpdateOrganizationConfigurationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AutoEnable != nil {
		ok := object.Key("autoEnable")
		if err := awsRestjson1_serializeDocumentAutoEnable(v.AutoEnable, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateOrgEc2DeepInspectionConfiguration struct {
}

func (*awsRestjson1_serializeOpUpdateOrgEc2DeepInspectionConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateOrgEc2DeepInspectionConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateOrgEc2DeepInspectionConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/ec2deepinspectionconfiguration/org/update")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateOrgEc2DeepInspectionConfigurationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateOrgEc2DeepInspectionConfigurationInput(v *UpdateOrgEc2DeepInspectionConfigurationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateOrgEc2DeepInspectionConfigurationInput(v *UpdateOrgEc2DeepInspectionConfigurationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.OrgPackagePaths != nil {
		ok := object.Key("orgPackagePaths")
		if err := awsRestjson1_serializeDocumentPathList(v.OrgPackagePaths, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAccountAggregation(v *types.AccountAggregation, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.FindingType) > 0 {
		ok := object.Key("findingType")
		ok.String(string(v.FindingType))
	}

	if len(v.ResourceType) > 0 {
		ok := object.Key("resourceType")
		ok.String(string(v.ResourceType))
	}

	if len(v.SortBy) > 0 {
		ok := object.Key("sortBy")
		ok.String(string(v.SortBy))
	}

	if len(v.SortOrder) > 0 {
		ok := object.Key("sortOrder")
		ok.String(string(v.SortOrder))
	}

	return nil
}

func awsRestjson1_serializeDocumentAccountIdFilterList(v []types.CisStringFilter, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentCisStringFilter(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAccountIdSet(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentAggregationRequest(v types.AggregationRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.AggregationRequestMemberAccountAggregation:
		av := object.Key("accountAggregation")
		if err := awsRestjson1_serializeDocumentAccountAggregation(&uv.Value, av); err != nil {
			return err
		}

	case *types.AggregationRequestMemberAmiAggregation:
		av := object.Key("amiAggregation")
		if err := awsRestjson1_serializeDocumentAmiAggregation(&uv.Value, av); err != nil {
			return err
		}

	case *types.AggregationRequestMemberAwsEcrContainerAggregation:
		av := object.Key("awsEcrContainerAggregation")
		if err := awsRestjson1_serializeDocumentAwsEcrContainerAggregation(&uv.Value, av); err != nil {
			return err
		}

	case *types.AggregationRequestMemberEc2InstanceAggregation:
		av := object.Key("ec2InstanceAggregation")
		if err := awsRestjson1_serializeDocumentEc2InstanceAggregation(&uv.Value, av); err != nil {
			return err
		}

	case *types.AggregationRequestMemberFindingTypeAggregation:
		av := object.Key("findingTypeAggregation")
		if err := awsRestjson1_serializeDocumentFindingTypeAggregation(&uv.Value, av); err != nil {
			return err
		}

	case *types.AggregationRequestMemberImageLayerAggregation:
		av := object.Key("imageLayerAggregation")
		if err := awsRestjson1_serializeDocumentImageLayerAggregation(&uv.Value, av); err != nil {
			return err
		}

	case *types.AggregationRequestMemberLambdaFunctionAggregation:
		av := object.Key("lambdaFunctionAggregation")
		if err := awsRestjson1_serializeDocumentLambdaFunctionAggregation(&uv.Value, av); err != nil {
			return err
		}

	case *types.AggregationRequestMemberLambdaLayerAggregation:
		av := object.Key("lambdaLayerAggregation")
		if err := awsRestjson1_serializeDocumentLambdaLayerAggregation(&uv.Value, av); err != nil {
			return err
		}

	case *types.AggregationRequestMemberPackageAggregation:
		av := object.Key("packageAggregation")
		if err := awsRestjson1_serializeDocumentPackageAggregation(&uv.Value, av); err != nil {
			return err
		}

	case *types.AggregationRequestMemberRepositoryAggregation:
		av := object.Key("repositoryAggregation")
		if err := awsRestjson1_serializeDocumentRepositoryAggregation(&uv.Value, av); err != nil {
			return err
		}

	case *types.AggregationRequestMemberTitleAggregation:
		av := object.Key("titleAggregation")
		if err := awsRestjson1_serializeDocumentTitleAggregation(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentAmiAggregation(v *types.AmiAggregation, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Amis != nil {
		ok := object.Key("amis")
		if err := awsRestjson1_serializeDocumentStringFilterList(v.Amis, ok); err != nil {
			return err
		}
	}

	if len(v.SortBy) > 0 {
		ok := object.Key("sortBy")
		ok.String(string(v.SortBy))
	}

	if len(v.SortOrder) > 0 {
		ok := object.Key("sortOrder")
		ok.String(string(v.SortOrder))
	}

	return nil
}

func awsRestjson1_serializeDocumentAutoEnable(v *types.AutoEnable, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Ec2 != nil {
		ok := object.Key("ec2")
		ok.Boolean(*v.Ec2)
	}

	if v.Ecr != nil {
		ok := object.Key("ecr")
		ok.Boolean(*v.Ecr)
	}

	if v.Lambda != nil {
		ok := object.Key("lambda")
		ok.Boolean(*v.Lambda)
	}

	if v.LambdaCode != nil {
		ok := object.Key("lambdaCode")
		ok.Boolean(*v.LambdaCode)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsEcrContainerAggregation(v *types.AwsEcrContainerAggregation, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Architectures != nil {
		ok := object.Key("architectures")
		if err := awsRestjson1_serializeDocumentStringFilterList(v.Architectures, ok); err != nil {
			return err
		}
	}

	if v.ImageShas != nil {
		ok := object.Key("imageShas")
		if err := awsRestjson1_serializeDocumentStringFilterList(v.ImageShas, ok); err != nil {
			return err
		}
	}

	if v.ImageTags != nil {
		ok := object.Key("imageTags")
		if err := awsRestjson1_serializeDocumentStringFilterList(v.ImageTags, ok); err != nil {
			return err
		}
	}

	if v.Repositories != nil {
		ok := object.Key("repositories")
		if err := awsRestjson1_serializeDocumentStringFilterList(v.Repositories, ok); err != nil {
			return err
		}
	}

	if v.ResourceIds != nil {
		ok := object.Key("resourceIds")
		if err := awsRestjson1_serializeDocumentStringFilterList(v.ResourceIds, ok); err != nil {
			return err
		}
	}

	if len(v.SortBy) > 0 {
		ok := object.Key("sortBy")
		ok.String(string(v.SortBy))
	}

	if len(v.SortOrder) > 0 {
		ok := object.Key("sortOrder")
		ok.String(string(v.SortOrder))
	}

	return nil
}

func awsRestjson1_serializeDocumentCheckIdFilterList(v []types.CisStringFilter, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentCisStringFilter(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentCisDateFilter(v *types.CisDateFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EarliestScanStartTime != nil {
		ok := object.Key("earliestScanStartTime")
		ok.Double(smithytime.FormatEpochSeconds(*v.EarliestScanStartTime))
	}

	if v.LatestScanStartTime != nil {
		ok := object.Key("latestScanStartTime")
		ok.Double(smithytime.FormatEpochSeconds(*v.LatestScanStartTime))
	}

	return nil
}

func awsRestjson1_serializeDocumentCisFindingArnFilterList(v []types.CisStringFilter, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentCisStringFilter(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentCisFindingStatusFilter(v *types.CisFindingStatusFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Comparison) > 0 {
		ok := object.Key("comparison")
		ok.String(string(v.Comparison))
	}

	if len(v.Value) > 0 {
		ok := object.Key("value")
		ok.String(string(v.Value))
	}

	return nil
}

func awsRestjson1_serializeDocumentCisFindingStatusFilterList(v []types.CisFindingStatusFilter, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentCisFindingStatusFilter(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentCisNumberFilter(v *types.CisNumberFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.LowerInclusive != nil {
		ok := object.Key("lowerInclusive")
		ok.Integer(*v.LowerInclusive)
	}

	if v.UpperInclusive != nil {
		ok := object.Key("upperInclusive")
		ok.Integer(*v.UpperInclusive)
	}

	return nil
}

func awsRestjson1_serializeDocumentCisNumberFilterList(v []types.CisNumberFilter, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentCisNumberFilter(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentCisResultStatusFilter(v *types.CisResultStatusFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Comparison) > 0 {
		ok := object.Key("comparison")
		ok.String(string(v.Comparison))
	}

	if len(v.Value) > 0 {
		ok := object.Key("value")
		ok.String(string(v.Value))
	}

	return nil
}

func awsRestjson1_serializeDocumentCisResultStatusFilterList(v []types.CisResultStatusFilter, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentCisResultStatusFilter(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentCisScanArnFilterList(v []types.CisStringFilter, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentCisStringFilter(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentCisScanConfigurationArnFilterList(v []types.CisStringFilter, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentCisStringFilter(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentCisScanDateFilterList(v []types.CisDateFilter, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentCisDateFilter(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentCisScanNameFilterList(v []types.CisStringFilter, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentCisStringFilter(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentCisScanResultDetailsFilterCriteria(v *types.CisScanResultDetailsFilterCriteria, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CheckIdFilters != nil {
		ok := object.Key("checkIdFilters")
		if err := awsRestjson1_serializeDocumentCheckIdFilterList(v.CheckIdFilters, ok); err != nil {
			return err
		}
	}

	if v.FindingArnFilters != nil {
		ok := object.Key("findingArnFilters")
		if err := awsRestjson1_serializeDocumentCisFindingArnFilterList(v.FindingArnFilters, ok); err != nil {
			return err
		}
	}

	if v.FindingStatusFilters != nil {
		ok := object.Key("findingStatusFilters")
		if err := awsRestjson1_serializeDocumentCisFindingStatusFilterList(v.FindingStatusFilters, ok); err != nil {
			return err
		}
	}

	if v.SecurityLevelFilters != nil {
		ok := object.Key("securityLevelFilters")
		if err := awsRestjson1_serializeDocumentCisSecurityLevelFilterList(v.SecurityLevelFilters, ok); err != nil {
			return err
		}
	}

	if v.TitleFilters != nil {
		ok := object.Key("titleFilters")
		if err := awsRestjson1_serializeDocumentTitleFilterList(v.TitleFilters, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentCisScanResultsAggregatedByChecksFilterCriteria(v *types.CisScanResultsAggregatedByChecksFilterCriteria, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AccountIdFilters != nil {
		ok := object.Key("accountIdFilters")
		if err := awsRestjson1_serializeDocumentOneAccountIdFilterList(v.AccountIdFilters, ok); err != nil {
			return err
		}
	}

	if v.CheckIdFilters != nil {
		ok := object.Key("checkIdFilters")
		if err := awsRestjson1_serializeDocumentCheckIdFilterList(v.CheckIdFilters, ok); err != nil {
			return err
		}
	}

	if v.FailedResourcesFilters != nil {
		ok := object.Key("failedResourcesFilters")
		if err := awsRestjson1_serializeDocumentCisNumberFilterList(v.FailedResourcesFilters, ok); err != nil {
			return err
		}
	}

	if v.PlatformFilters != nil {
		ok := object.Key("platformFilters")
		if err := awsRestjson1_serializeDocumentPlatformFilterList(v.PlatformFilters, ok); err != nil {
			return err
		}
	}

	if v.SecurityLevelFilters != nil {
		ok := object.Key("securityLevelFilters")
		if err := awsRestjson1_serializeDocumentCisSecurityLevelFilterList(v.SecurityLevelFilters, ok); err != nil {
			return err
		}
	}

	if v.TitleFilters != nil {
		ok := object.Key("titleFilters")
		if err := awsRestjson1_serializeDocumentTitleFilterList(v.TitleFilters, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentCisScanResultsAggregatedByTargetResourceFilterCriteria(v *types.CisScanResultsAggregatedByTargetResourceFilterCriteria, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AccountIdFilters != nil {
		ok := object.Key("accountIdFilters")
		if err := awsRestjson1_serializeDocumentAccountIdFilterList(v.AccountIdFilters, ok); err != nil {
			return err
		}
	}

	if v.CheckIdFilters != nil {
		ok := object.Key("checkIdFilters")
		if err := awsRestjson1_serializeDocumentCheckIdFilterList(v.CheckIdFilters, ok); err != nil {
			return err
		}
	}

	if v.FailedChecksFilters != nil {
		ok := object.Key("failedChecksFilters")
		if err := awsRestjson1_serializeDocumentCisNumberFilterList(v.FailedChecksFilters, ok); err != nil {
			return err
		}
	}

	if v.PlatformFilters != nil {
		ok := object.Key("platformFilters")
		if err := awsRestjson1_serializeDocumentPlatformFilterList(v.PlatformFilters, ok); err != nil {
			return err
		}
	}

	if v.StatusFilters != nil {
		ok := object.Key("statusFilters")
		if err := awsRestjson1_serializeDocumentCisResultStatusFilterList(v.StatusFilters, ok); err != nil {
			return err
		}
	}

	if v.TargetResourceIdFilters != nil {
		ok := object.Key("targetResourceIdFilters")
		if err := awsRestjson1_serializeDocumentResourceIdFilterList(v.TargetResourceIdFilters, ok); err != nil {
			return err
		}
	}

	if v.TargetResourceTagFilters != nil {
		ok := object.Key("targetResourceTagFilters")
		if err := awsRestjson1_serializeDocumentResourceTagFilterList(v.TargetResourceTagFilters, ok); err != nil {
			return err
		}
	}

	if v.TargetStatusFilters != nil {
		ok := object.Key("targetStatusFilters")
		if err := awsRestjson1_serializeDocumentTargetStatusFilterList(v.TargetStatusFilters, ok); err != nil {
			return err
		}
	}

	if v.TargetStatusReasonFilters != nil {
		ok := object.Key("targetStatusReasonFilters")
		if err := awsRestjson1_serializeDocumentTargetStatusReasonFilterList(v.TargetStatusReasonFilters, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentCisScanStatusFilter(v *types.CisScanStatusFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Comparison) > 0 {
		ok := object.Key("comparison")
		ok.String(string(v.Comparison))
	}

	if len(v.Value) > 0 {
		ok := object.Key("value")
		ok.String(string(v.Value))
	}

	return nil
}

func awsRestjson1_serializeDocumentCisScanStatusFilterList(v []types.CisScanStatusFilter, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentCisScanStatusFilter(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentCisScheduledByFilterList(v []types.CisStringFilter, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentCisStringFilter(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentCisSecurityLevelFilter(v *types.CisSecurityLevelFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Comparison) > 0 {
		ok := object.Key("comparison")
		ok.String(string(v.Comparison))
	}

	if len(v.Value) > 0 {
		ok := object.Key("value")
		ok.String(string(v.Value))
	}

	return nil
}

func awsRestjson1_serializeDocumentCisSecurityLevelFilterList(v []types.CisSecurityLevelFilter, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentCisSecurityLevelFilter(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentCisSessionMessage(v *types.CisSessionMessage, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CisRuleDetails != nil {
		ok := object.Key("cisRuleDetails")
		ok.Base64EncodeBytes(v.CisRuleDetails)
	}

	if v.RuleId != nil {
		ok := object.Key("ruleId")
		ok.String(*v.RuleId)
	}

	if len(v.Status) > 0 {
		ok := object.Key("status")
		ok.String(string(v.Status))
	}

	return nil
}

func awsRestjson1_serializeDocumentCisSessionMessages(v []types.CisSessionMessage, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentCisSessionMessage(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentCisStringFilter(v *types.CisStringFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Comparison) > 0 {
		ok := object.Key("comparison")
		ok.String(string(v.Comparison))
	}

	if v.Value != nil {
		ok := object.Key("value")
		ok.String(*v.Value)
	}

	return nil
}

func awsRestjson1_serializeDocumentCisTagMap(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentCisTargetStatusFilter(v *types.CisTargetStatusFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Comparison) > 0 {
		ok := object.Key("comparison")
		ok.String(string(v.Comparison))
	}

	if len(v.Value) > 0 {
		ok := object.Key("value")
		ok.String(string(v.Value))
	}

	return nil
}

func awsRestjson1_serializeDocumentCisTargetStatusReasonFilter(v *types.CisTargetStatusReasonFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Comparison) > 0 {
		ok := object.Key("comparison")
		ok.String(string(v.Comparison))
	}

	if len(v.Value) > 0 {
		ok := object.Key("value")
		ok.String(string(v.Value))
	}

	return nil
}

func awsRestjson1_serializeDocumentComputePlatform(v *types.ComputePlatform, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Product != nil {
		ok := object.Key("product")
		ok.String(*v.Product)
	}

	if v.Vendor != nil {
		ok := object.Key("vendor")
		ok.String(*v.Vendor)
	}

	if v.Version != nil {
		ok := object.Key("version")
		ok.String(*v.Version)
	}

	return nil
}

func awsRestjson1_serializeDocumentCoverageDateFilter(v *types.CoverageDateFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EndInclusive != nil {
		ok := object.Key("endInclusive")
		ok.Double(smithytime.FormatEpochSeconds(*v.EndInclusive))
	}

	if v.StartInclusive != nil {
		ok := object.Key("startInclusive")
		ok.Double(smithytime.FormatEpochSeconds(*v.StartInclusive))
	}

	return nil
}

func awsRestjson1_serializeDocumentCoverageDateFilterList(v []types.CoverageDateFilter, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentCoverageDateFilter(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentCoverageFilterCriteria(v *types.CoverageFilterCriteria, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AccountId != nil {
		ok := object.Key("accountId")
		if err := awsRestjson1_serializeDocumentCoverageStringFilterList(v.AccountId, ok); err != nil {
			return err
		}
	}

	if v.Ec2InstanceTags != nil {
		ok := object.Key("ec2InstanceTags")
		if err := awsRestjson1_serializeDocumentCoverageMapFilterList(v.Ec2InstanceTags, ok); err != nil {
			return err
		}
	}

	if v.EcrImageTags != nil {
		ok := object.Key("ecrImageTags")
		if err := awsRestjson1_serializeDocumentCoverageStringFilterList(v.EcrImageTags, ok); err != nil {
			return err
		}
	}

	if v.EcrRepositoryName != nil {
		ok := object.Key("ecrRepositoryName")
		if err := awsRestjson1_serializeDocumentCoverageStringFilterList(v.EcrRepositoryName, ok); err != nil {
			return err
		}
	}

	if v.ImagePulledAt != nil {
		ok := object.Key("imagePulledAt")
		if err := awsRestjson1_serializeDocumentCoverageDateFilterList(v.ImagePulledAt, ok); err != nil {
			return err
		}
	}

	if v.LambdaFunctionName != nil {
		ok := object.Key("lambdaFunctionName")
		if err := awsRestjson1_serializeDocumentCoverageStringFilterList(v.LambdaFunctionName, ok); err != nil {
			return err
		}
	}

	if v.LambdaFunctionRuntime != nil {
		ok := object.Key("lambdaFunctionRuntime")
		if err := awsRestjson1_serializeDocumentCoverageStringFilterList(v.LambdaFunctionRuntime, ok); err != nil {
			return err
		}
	}

	if v.LambdaFunctionTags != nil {
		ok := object.Key("lambdaFunctionTags")
		if err := awsRestjson1_serializeDocumentCoverageMapFilterList(v.LambdaFunctionTags, ok); err != nil {
			return err
		}
	}

	if v.LastScannedAt != nil {
		ok := object.Key("lastScannedAt")
		if err := awsRestjson1_serializeDocumentCoverageDateFilterList(v.LastScannedAt, ok); err != nil {
			return err
		}
	}

	if v.ResourceId != nil {
		ok := object.Key("resourceId")
		if err := awsRestjson1_serializeDocumentCoverageStringFilterList(v.ResourceId, ok); err != nil {
			return err
		}
	}

	if v.ResourceType != nil {
		ok := object.Key("resourceType")
		if err := awsRestjson1_serializeDocumentCoverageStringFilterList(v.ResourceType, ok); err != nil {
			return err
		}
	}

	if v.ScanMode != nil {
		ok := object.Key("scanMode")
		if err := awsRestjson1_serializeDocumentCoverageStringFilterList(v.ScanMode, ok); err != nil {
			return err
		}
	}

	if v.ScanStatusCode != nil {
		ok := object.Key("scanStatusCode")
		if err := awsRestjson1_serializeDocumentCoverageStringFilterList(v.ScanStatusCode, ok); err != nil {
			return err
		}
	}

	if v.ScanStatusReason != nil {
		ok := object.Key("scanStatusReason")
		if err := awsRestjson1_serializeDocumentCoverageStringFilterList(v.ScanStatusReason, ok); err != nil {
			return err
		}
	}

	if v.ScanType != nil {
		ok := object.Key("scanType")
		if err := awsRestjson1_serializeDocumentCoverageStringFilterList(v.ScanType, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentCoverageMapFilter(v *types.CoverageMapFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Comparison) > 0 {
		ok := object.Key("comparison")
		ok.String(string(v.Comparison))
	}

	if v.Key != nil {
		ok := object.Key("key")
		ok.String(*v.Key)
	}

	if v.Value != nil {
		ok := object.Key("value")
		ok.String(*v.Value)
	}

	return nil
}

func awsRestjson1_serializeDocumentCoverageMapFilterList(v []types.CoverageMapFilter, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentCoverageMapFilter(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentCoverageStringFilter(v *types.CoverageStringFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Comparison) > 0 {
		ok := object.Key("comparison")
		ok.String(string(v.Comparison))
	}

	if v.Value != nil {
		ok := object.Key("value")
		ok.String(*v.Value)
	}

	return nil
}

func awsRestjson1_serializeDocumentCoverageStringFilterList(v []types.CoverageStringFilter, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentCoverageStringFilter(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentCreateCisTargets(v *types.CreateCisTargets, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AccountIds != nil {
		ok := object.Key("accountIds")
		if err := awsRestjson1_serializeDocumentTargetAccountList(v.AccountIds, ok); err != nil {
			return err
		}
	}

	if v.TargetResourceTags != nil {
		ok := object.Key("targetResourceTags")
		if err := awsRestjson1_serializeDocumentTargetResourceTags(v.TargetResourceTags, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentDailySchedule(v *types.DailySchedule, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.StartTime != nil {
		ok := object.Key("startTime")
		if err := awsRestjson1_serializeDocumentTime(v.StartTime, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentDateFilter(v *types.DateFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EndInclusive != nil {
		ok := object.Key("endInclusive")
		ok.Double(smithytime.FormatEpochSeconds(*v.EndInclusive))
	}

	if v.StartInclusive != nil {
		ok := object.Key("startInclusive")
		ok.Double(smithytime.FormatEpochSeconds(*v.StartInclusive))
	}

	return nil
}

func awsRestjson1_serializeDocumentDateFilterList(v []types.DateFilter, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentDateFilter(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentDaysList(v []types.Day, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocumentDestination(v *types.Destination, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BucketName != nil {
		ok := object.Key("bucketName")
		ok.String(*v.BucketName)
	}

	if v.KeyPrefix != nil {
		ok := object.Key("keyPrefix")
		ok.String(*v.KeyPrefix)
	}

	if v.KmsKeyArn != nil {
		ok := object.Key("kmsKeyArn")
		ok.String(*v.KmsKeyArn)
	}

	return nil
}

func awsRestjson1_serializeDocumentDisableResourceTypeList(v []types.ResourceScanType, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocumentEc2Configuration(v *types.Ec2Configuration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.ScanMode) > 0 {
		ok := object.Key("scanMode")
		ok.String(string(v.ScanMode))
	}

	return nil
}

func awsRestjson1_serializeDocumentEc2InstanceAggregation(v *types.Ec2InstanceAggregation, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Amis != nil {
		ok := object.Key("amis")
		if err := awsRestjson1_serializeDocumentStringFilterList(v.Amis, ok); err != nil {
			return err
		}
	}

	if v.InstanceIds != nil {
		ok := object.Key("instanceIds")
		if err := awsRestjson1_serializeDocumentStringFilterList(v.InstanceIds, ok); err != nil {
			return err
		}
	}

	if v.InstanceTags != nil {
		ok := object.Key("instanceTags")
		if err := awsRestjson1_serializeDocumentMapFilterList(v.InstanceTags, ok); err != nil {
			return err
		}
	}

	if v.OperatingSystems != nil {
		ok := object.Key("operatingSystems")
		if err := awsRestjson1_serializeDocumentStringFilterList(v.OperatingSystems, ok); err != nil {
			return err
		}
	}

	if len(v.SortBy) > 0 {
		ok := object.Key("sortBy")
		ok.String(string(v.SortBy))
	}

	if len(v.SortOrder) > 0 {
		ok := object.Key("sortOrder")
		ok.String(string(v.SortOrder))
	}

	return nil
}

func awsRestjson1_serializeDocumentEcrConfiguration(v *types.EcrConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.PullDateRescanDuration) > 0 {
		ok := object.Key("pullDateRescanDuration")
		ok.String(string(v.PullDateRescanDuration))
	}

	if len(v.RescanDuration) > 0 {
		ok := object.Key("rescanDuration")
		ok.String(string(v.RescanDuration))
	}

	return nil
}

func awsRestjson1_serializeDocumentEnableResourceTypeList(v []types.ResourceScanType, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocumentFilterArnList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentFilterCriteria(v *types.FilterCriteria, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AwsAccountId != nil {
		ok := object.Key("awsAccountId")
		if err := awsRestjson1_serializeDocumentStringFilterList(v.AwsAccountId, ok); err != nil {
			return err
		}
	}

	if v.CodeVulnerabilityDetectorName != nil {
		ok := object.Key("codeVulnerabilityDetectorName")
		if err := awsRestjson1_serializeDocumentStringFilterList(v.CodeVulnerabilityDetectorName, ok); err != nil {
			return err
		}
	}

	if v.CodeVulnerabilityDetectorTags != nil {
		ok := object.Key("codeVulnerabilityDetectorTags")
		if err := awsRestjson1_serializeDocumentStringFilterList(v.CodeVulnerabilityDetectorTags, ok); err != nil {
			return err
		}
	}

	if v.CodeVulnerabilityFilePath != nil {
		ok := object.Key("codeVulnerabilityFilePath")
		if err := awsRestjson1_serializeDocumentStringFilterList(v.CodeVulnerabilityFilePath, ok); err != nil {
			return err
		}
	}

	if v.ComponentId != nil {
		ok := object.Key("componentId")
		if err := awsRestjson1_serializeDocumentStringFilterList(v.ComponentId, ok); err != nil {
			return err
		}
	}

	if v.ComponentType != nil {
		ok := object.Key("componentType")
		if err := awsRestjson1_serializeDocumentStringFilterList(v.ComponentType, ok); err != nil {
			return err
		}
	}

	if v.Ec2InstanceImageId != nil {
		ok := object.Key("ec2InstanceImageId")
		if err := awsRestjson1_serializeDocumentStringFilterList(v.Ec2InstanceImageId, ok); err != nil {
			return err
		}
	}

	if v.Ec2InstanceSubnetId != nil {
		ok := object.Key("ec2InstanceSubnetId")
		if err := awsRestjson1_serializeDocumentStringFilterList(v.Ec2InstanceSubnetId, ok); err != nil {
			return err
		}
	}

	if v.Ec2InstanceVpcId != nil {
		ok := object.Key("ec2InstanceVpcId")
		if err := awsRestjson1_serializeDocumentStringFilterList(v.Ec2InstanceVpcId, ok); err != nil {
			return err
		}
	}

	if v.EcrImageArchitecture != nil {
		ok := object.Key("ecrImageArchitecture")
		if err := awsRestjson1_serializeDocumentStringFilterList(v.EcrImageArchitecture, ok); err != nil {
			return err
		}
	}

	if v.EcrImageHash != nil {
		ok := object.Key("ecrImageHash")
		if err := awsRestjson1_serializeDocumentStringFilterList(v.EcrImageHash, ok); err != nil {
			return err
		}
	}

	if v.EcrImagePushedAt != nil {
		ok := object.Key("ecrImagePushedAt")
		if err := awsRestjson1_serializeDocumentDateFilterList(v.EcrImagePushedAt, ok); err != nil {
			return err
		}
	}

	if v.EcrImageRegistry != nil {
		ok := object.Key("ecrImageRegistry")
		if err := awsRestjson1_serializeDocumentStringFilterList(v.EcrImageRegistry, ok); err != nil {
			return err
		}
	}

	if v.EcrImageRepositoryName != nil {
		ok := object.Key("ecrImageRepositoryName")
		if err := awsRestjson1_serializeDocumentStringFilterList(v.EcrImageRepositoryName, ok); err != nil {
			return err
		}
	}

	if v.EcrImageTags != nil {
		ok := object.Key("ecrImageTags")
		if err := awsRestjson1_serializeDocumentStringFilterList(v.EcrImageTags, ok); err != nil {
			return err
		}
	}

	if v.EpssScore != nil {
		ok := object.Key("epssScore")
		if err := awsRestjson1_serializeDocumentNumberFilterList(v.EpssScore, ok); err != nil {
			return err
		}
	}

	if v.ExploitAvailable != nil {
		ok := object.Key("exploitAvailable")
		if err := awsRestjson1_serializeDocumentStringFilterList(v.ExploitAvailable, ok); err != nil {
			return err
		}
	}

	if v.FindingArn != nil {
		ok := object.Key("findingArn")
		if err := awsRestjson1_serializeDocumentStringFilterList(v.FindingArn, ok); err != nil {
			return err
		}
	}

	if v.FindingStatus != nil {
		ok := object.Key("findingStatus")
		if err := awsRestjson1_serializeDocumentStringFilterList(v.FindingStatus, ok); err != nil {
			return err
		}
	}

	if v.FindingType != nil {
		ok := object.Key("findingType")
		if err := awsRestjson1_serializeDocumentStringFilterList(v.FindingType, ok); err != nil {
			return err
		}
	}

	if v.FirstObservedAt != nil {
		ok := object.Key("firstObservedAt")
		if err := awsRestjson1_serializeDocumentDateFilterList(v.FirstObservedAt, ok); err != nil {
			return err
		}
	}

	if v.FixAvailable != nil {
		ok := object.Key("fixAvailable")
		if err := awsRestjson1_serializeDocumentStringFilterList(v.FixAvailable, ok); err != nil {
			return err
		}
	}

	if v.InspectorScore != nil {
		ok := object.Key("inspectorScore")
		if err := awsRestjson1_serializeDocumentNumberFilterList(v.InspectorScore, ok); err != nil {
			return err
		}
	}

	if v.LambdaFunctionExecutionRoleArn != nil {
		ok := object.Key("lambdaFunctionExecutionRoleArn")
		if err := awsRestjson1_serializeDocumentStringFilterList(v.LambdaFunctionExecutionRoleArn, ok); err != nil {
			return err
		}
	}

	if v.LambdaFunctionLastModifiedAt != nil {
		ok := object.Key("lambdaFunctionLastModifiedAt")
		if err := awsRestjson1_serializeDocumentDateFilterList(v.LambdaFunctionLastModifiedAt, ok); err != nil {
			return err
		}
	}

	if v.LambdaFunctionLayers != nil {
		ok := object.Key("lambdaFunctionLayers")
		if err := awsRestjson1_serializeDocumentStringFilterList(v.LambdaFunctionLayers, ok); err != nil {
			return err
		}
	}

	if v.LambdaFunctionName != nil {
		ok := object.Key("lambdaFunctionName")
		if err := awsRestjson1_serializeDocumentStringFilterList(v.LambdaFunctionName, ok); err != nil {
			return err
		}
	}

	if v.LambdaFunctionRuntime != nil {
		ok := object.Key("lambdaFunctionRuntime")
		if err := awsRestjson1_serializeDocumentStringFilterList(v.LambdaFunctionRuntime, ok); err != nil {
			return err
		}
	}

	if v.LastObservedAt != nil {
		ok := object.Key("lastObservedAt")
		if err := awsRestjson1_serializeDocumentDateFilterList(v.LastObservedAt, ok); err != nil {
			return err
		}
	}

	if v.NetworkProtocol != nil {
		ok := object.Key("networkProtocol")
		if err := awsRestjson1_serializeDocumentStringFilterList(v.NetworkProtocol, ok); err != nil {
			return err
		}
	}

	if v.PortRange != nil {
		ok := object.Key("portRange")
		if err := awsRestjson1_serializeDocumentPortRangeFilterList(v.PortRange, ok); err != nil {
			return err
		}
	}

	if v.RelatedVulnerabilities != nil {
		ok := object.Key("relatedVulnerabilities")
		if err := awsRestjson1_serializeDocumentStringFilterList(v.RelatedVulnerabilities, ok); err != nil {
			return err
		}
	}

	if v.ResourceId != nil {
		ok := object.Key("resourceId")
		if err := awsRestjson1_serializeDocumentStringFilterList(v.ResourceId, ok); err != nil {
			return err
		}
	}

	if v.ResourceTags != nil {
		ok := object.Key("resourceTags")
		if err := awsRestjson1_serializeDocumentMapFilterList(v.ResourceTags, ok); err != nil {
			return err
		}
	}

	if v.ResourceType != nil {
		ok := object.Key("resourceType")
		if err := awsRestjson1_serializeDocumentStringFilterList(v.ResourceType, ok); err != nil {
			return err
		}
	}

	if v.Severity != nil {
		ok := object.Key("severity")
		if err := awsRestjson1_serializeDocumentStringFilterList(v.Severity, ok); err != nil {
			return err
		}
	}

	if v.Title != nil {
		ok := object.Key("title")
		if err := awsRestjson1_serializeDocumentStringFilterList(v.Title, ok); err != nil {
			return err
		}
	}

	if v.UpdatedAt != nil {
		ok := object.Key("updatedAt")
		if err := awsRestjson1_serializeDocumentDateFilterList(v.UpdatedAt, ok); err != nil {
			return err
		}
	}

	if v.VendorSeverity != nil {
		ok := object.Key("vendorSeverity")
		if err := awsRestjson1_serializeDocumentStringFilterList(v.VendorSeverity, ok); err != nil {
			return err
		}
	}

	if v.VulnerabilityId != nil {
		ok := object.Key("vulnerabilityId")
		if err := awsRestjson1_serializeDocumentStringFilterList(v.VulnerabilityId, ok); err != nil {
			return err
		}
	}

	if v.VulnerabilitySource != nil {
		ok := object.Key("vulnerabilitySource")
		if err := awsRestjson1_serializeDocumentStringFilterList(v.VulnerabilitySource, ok); err != nil {
			return err
		}
	}

	if v.VulnerablePackages != nil {
		ok := object.Key("vulnerablePackages")
		if err := awsRestjson1_serializeDocumentPackageFilterList(v.VulnerablePackages, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentFindingArnList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentFindingArns(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentFindingTypeAggregation(v *types.FindingTypeAggregation, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.FindingType) > 0 {
		ok := object.Key("findingType")
		ok.String(string(v.FindingType))
	}

	if len(v.ResourceType) > 0 {
		ok := object.Key("resourceType")
		ok.String(string(v.ResourceType))
	}

	if len(v.SortBy) > 0 {
		ok := object.Key("sortBy")
		ok.String(string(v.SortBy))
	}

	if len(v.SortOrder) > 0 {
		ok := object.Key("sortOrder")
		ok.String(string(v.SortOrder))
	}

	return nil
}

func awsRestjson1_serializeDocumentImageLayerAggregation(v *types.ImageLayerAggregation, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.LayerHashes != nil {
		ok := object.Key("layerHashes")
		if err := awsRestjson1_serializeDocumentStringFilterList(v.LayerHashes, ok); err != nil {
			return err
		}
	}

	if v.Repositories != nil {
		ok := object.Key("repositories")
		if err := awsRestjson1_serializeDocumentStringFilterList(v.Repositories, ok); err != nil {
			return err
		}
	}

	if v.ResourceIds != nil {
		ok := object.Key("resourceIds")
		if err := awsRestjson1_serializeDocumentStringFilterList(v.ResourceIds, ok); err != nil {
			return err
		}
	}

	if len(v.SortBy) > 0 {
		ok := object.Key("sortBy")
		ok.String(string(v.SortBy))
	}

	if len(v.SortOrder) > 0 {
		ok := object.Key("sortOrder")
		ok.String(string(v.SortOrder))
	}

	return nil
}

func awsRestjson1_serializeDocumentLambdaFunctionAggregation(v *types.LambdaFunctionAggregation, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FunctionNames != nil {
		ok := object.Key("functionNames")
		if err := awsRestjson1_serializeDocumentStringFilterList(v.FunctionNames, ok); err != nil {
			return err
		}
	}

	if v.FunctionTags != nil {
		ok := object.Key("functionTags")
		if err := awsRestjson1_serializeDocumentMapFilterList(v.FunctionTags, ok); err != nil {
			return err
		}
	}

	if v.ResourceIds != nil {
		ok := object.Key("resourceIds")
		if err := awsRestjson1_serializeDocumentStringFilterList(v.ResourceIds, ok); err != nil {
			return err
		}
	}

	if v.Runtimes != nil {
		ok := object.Key("runtimes")
		if err := awsRestjson1_serializeDocumentStringFilterList(v.Runtimes, ok); err != nil {
			return err
		}
	}

	if len(v.SortBy) > 0 {
		ok := object.Key("sortBy")
		ok.String(string(v.SortBy))
	}

	if len(v.SortOrder) > 0 {
		ok := object.Key("sortOrder")
		ok.String(string(v.SortOrder))
	}

	return nil
}

func awsRestjson1_serializeDocumentLambdaLayerAggregation(v *types.LambdaLayerAggregation, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FunctionNames != nil {
		ok := object.Key("functionNames")
		if err := awsRestjson1_serializeDocumentStringFilterList(v.FunctionNames, ok); err != nil {
			return err
		}
	}

	if v.LayerArns != nil {
		ok := object.Key("layerArns")
		if err := awsRestjson1_serializeDocumentStringFilterList(v.LayerArns, ok); err != nil {
			return err
		}
	}

	if v.ResourceIds != nil {
		ok := object.Key("resourceIds")
		if err := awsRestjson1_serializeDocumentStringFilterList(v.ResourceIds, ok); err != nil {
			return err
		}
	}

	if len(v.SortBy) > 0 {
		ok := object.Key("sortBy")
		ok.String(string(v.SortBy))
	}

	if len(v.SortOrder) > 0 {
		ok := object.Key("sortOrder")
		ok.String(string(v.SortOrder))
	}

	return nil
}

func awsRestjson1_serializeDocumentListCisScanConfigurationsFilterCriteria(v *types.ListCisScanConfigurationsFilterCriteria, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ScanConfigurationArnFilters != nil {
		ok := object.Key("scanConfigurationArnFilters")
		if err := awsRestjson1_serializeDocumentCisScanConfigurationArnFilterList(v.ScanConfigurationArnFilters, ok); err != nil {
			return err
		}
	}

	if v.ScanNameFilters != nil {
		ok := object.Key("scanNameFilters")
		if err := awsRestjson1_serializeDocumentCisScanNameFilterList(v.ScanNameFilters, ok); err != nil {
			return err
		}
	}

	if v.TargetResourceTagFilters != nil {
		ok := object.Key("targetResourceTagFilters")
		if err := awsRestjson1_serializeDocumentResourceTagFilterList(v.TargetResourceTagFilters, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentListCisScansFilterCriteria(v *types.ListCisScansFilterCriteria, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FailedChecksFilters != nil {
		ok := object.Key("failedChecksFilters")
		if err := awsRestjson1_serializeDocumentCisNumberFilterList(v.FailedChecksFilters, ok); err != nil {
			return err
		}
	}

	if v.ScanArnFilters != nil {
		ok := object.Key("scanArnFilters")
		if err := awsRestjson1_serializeDocumentCisScanArnFilterList(v.ScanArnFilters, ok); err != nil {
			return err
		}
	}

	if v.ScanAtFilters != nil {
		ok := object.Key("scanAtFilters")
		if err := awsRestjson1_serializeDocumentCisScanDateFilterList(v.ScanAtFilters, ok); err != nil {
			return err
		}
	}

	if v.ScanConfigurationArnFilters != nil {
		ok := object.Key("scanConfigurationArnFilters")
		if err := awsRestjson1_serializeDocumentCisScanConfigurationArnFilterList(v.ScanConfigurationArnFilters, ok); err != nil {
			return err
		}
	}

	if v.ScanNameFilters != nil {
		ok := object.Key("scanNameFilters")
		if err := awsRestjson1_serializeDocumentCisScanNameFilterList(v.ScanNameFilters, ok); err != nil {
			return err
		}
	}

	if v.ScanStatusFilters != nil {
		ok := object.Key("scanStatusFilters")
		if err := awsRestjson1_serializeDocumentCisScanStatusFilterList(v.ScanStatusFilters, ok); err != nil {
			return err
		}
	}

	if v.ScheduledByFilters != nil {
		ok := object.Key("scheduledByFilters")
		if err := awsRestjson1_serializeDocumentCisScheduledByFilterList(v.ScheduledByFilters, ok); err != nil {
			return err
		}
	}

	if v.TargetAccountIdFilters != nil {
		ok := object.Key("targetAccountIdFilters")
		if err := awsRestjson1_serializeDocumentAccountIdFilterList(v.TargetAccountIdFilters, ok); err != nil {
			return err
		}
	}

	if v.TargetResourceIdFilters != nil {
		ok := object.Key("targetResourceIdFilters")
		if err := awsRestjson1_serializeDocumentResourceIdFilterList(v.TargetResourceIdFilters, ok); err != nil {
			return err
		}
	}

	if v.TargetResourceTagFilters != nil {
		ok := object.Key("targetResourceTagFilters")
		if err := awsRestjson1_serializeDocumentResourceTagFilterList(v.TargetResourceTagFilters, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentMapFilter(v *types.MapFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Comparison) > 0 {
		ok := object.Key("comparison")
		ok.String(string(v.Comparison))
	}

	if v.Key != nil {
		ok := object.Key("key")
		ok.String(*v.Key)
	}

	if v.Value != nil {
		ok := object.Key("value")
		ok.String(*v.Value)
	}

	return nil
}

func awsRestjson1_serializeDocumentMapFilterList(v []types.MapFilter, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentMapFilter(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentMemberAccountEc2DeepInspectionStatus(v *types.MemberAccountEc2DeepInspectionStatus, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AccountId != nil {
		ok := object.Key("accountId")
		ok.String(*v.AccountId)
	}

	if v.ActivateDeepInspection != nil {
		ok := object.Key("activateDeepInspection")
		ok.Boolean(*v.ActivateDeepInspection)
	}

	return nil
}

func awsRestjson1_serializeDocumentMemberAccountEc2DeepInspectionStatusList(v []types.MemberAccountEc2DeepInspectionStatus, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentMemberAccountEc2DeepInspectionStatus(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentMeteringAccountIdList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentMonthlySchedule(v *types.MonthlySchedule, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Day) > 0 {
		ok := object.Key("day")
		ok.String(string(v.Day))
	}

	if v.StartTime != nil {
		ok := object.Key("startTime")
		if err := awsRestjson1_serializeDocumentTime(v.StartTime, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentNumberFilter(v *types.NumberFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.LowerInclusive != nil {
		ok := object.Key("lowerInclusive")
		switch {
		case math.IsNaN(*v.LowerInclusive):
			ok.String("NaN")

		case math.IsInf(*v.LowerInclusive, 1):
			ok.String("Infinity")

		case math.IsInf(*v.LowerInclusive, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.LowerInclusive)

		}
	}

	if v.UpperInclusive != nil {
		ok := object.Key("upperInclusive")
		switch {
		case math.IsNaN(*v.UpperInclusive):
			ok.String("NaN")

		case math.IsInf(*v.UpperInclusive, 1):
			ok.String("Infinity")

		case math.IsInf(*v.UpperInclusive, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.UpperInclusive)

		}
	}

	return nil
}

func awsRestjson1_serializeDocumentNumberFilterList(v []types.NumberFilter, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentNumberFilter(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentOneAccountIdFilterList(v []types.CisStringFilter, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentCisStringFilter(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentOneTimeSchedule(v *types.OneTimeSchedule, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	return nil
}

func awsRestjson1_serializeDocumentPackageAggregation(v *types.PackageAggregation, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.PackageNames != nil {
		ok := object.Key("packageNames")
		if err := awsRestjson1_serializeDocumentStringFilterList(v.PackageNames, ok); err != nil {
			return err
		}
	}

	if len(v.SortBy) > 0 {
		ok := object.Key("sortBy")
		ok.String(string(v.SortBy))
	}

	if len(v.SortOrder) > 0 {
		ok := object.Key("sortOrder")
		ok.String(string(v.SortOrder))
	}

	return nil
}

func awsRestjson1_serializeDocumentPackageFilter(v *types.PackageFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Architecture != nil {
		ok := object.Key("architecture")
		if err := awsRestjson1_serializeDocumentStringFilter(v.Architecture, ok); err != nil {
			return err
		}
	}

	if v.Epoch != nil {
		ok := object.Key("epoch")
		if err := awsRestjson1_serializeDocumentNumberFilter(v.Epoch, ok); err != nil {
			return err
		}
	}

	if v.FilePath != nil {
		ok := object.Key("filePath")
		if err := awsRestjson1_serializeDocumentStringFilter(v.FilePath, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("name")
		if err := awsRestjson1_serializeDocumentStringFilter(v.Name, ok); err != nil {
			return err
		}
	}

	if v.Release != nil {
		ok := object.Key("release")
		if err := awsRestjson1_serializeDocumentStringFilter(v.Release, ok); err != nil {
			return err
		}
	}

	if v.SourceLambdaLayerArn != nil {
		ok := object.Key("sourceLambdaLayerArn")
		if err := awsRestjson1_serializeDocumentStringFilter(v.SourceLambdaLayerArn, ok); err != nil {
			return err
		}
	}

	if v.SourceLayerHash != nil {
		ok := object.Key("sourceLayerHash")
		if err := awsRestjson1_serializeDocumentStringFilter(v.SourceLayerHash, ok); err != nil {
			return err
		}
	}

	if v.Version != nil {
		ok := object.Key("version")
		if err := awsRestjson1_serializeDocumentStringFilter(v.Version, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentPackageFilterList(v []types.PackageFilter, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentPackageFilter(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentPathList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentPlatformFilterList(v []types.CisStringFilter, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentCisStringFilter(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentPortRangeFilter(v *types.PortRangeFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BeginInclusive != nil {
		ok := object.Key("beginInclusive")
		ok.Integer(*v.BeginInclusive)
	}

	if v.EndInclusive != nil {
		ok := object.Key("endInclusive")
		ok.Integer(*v.EndInclusive)
	}

	return nil
}

func awsRestjson1_serializeDocumentPortRangeFilterList(v []types.PortRangeFilter, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentPortRangeFilter(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentReportTargetAccounts(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentRepositoryAggregation(v *types.RepositoryAggregation, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Repositories != nil {
		ok := object.Key("repositories")
		if err := awsRestjson1_serializeDocumentStringFilterList(v.Repositories, ok); err != nil {
			return err
		}
	}

	if len(v.SortBy) > 0 {
		ok := object.Key("sortBy")
		ok.String(string(v.SortBy))
	}

	if len(v.SortOrder) > 0 {
		ok := object.Key("sortOrder")
		ok.String(string(v.SortOrder))
	}

	return nil
}

func awsRestjson1_serializeDocumentResourceFilterCriteria(v *types.ResourceFilterCriteria, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AccountId != nil {
		ok := object.Key("accountId")
		if err := awsRestjson1_serializeDocumentResourceStringFilterList(v.AccountId, ok); err != nil {
			return err
		}
	}

	if v.Ec2InstanceTags != nil {
		ok := object.Key("ec2InstanceTags")
		if err := awsRestjson1_serializeDocumentResourceMapFilterList(v.Ec2InstanceTags, ok); err != nil {
			return err
		}
	}

	if v.EcrImageTags != nil {
		ok := object.Key("ecrImageTags")
		if err := awsRestjson1_serializeDocumentResourceStringFilterList(v.EcrImageTags, ok); err != nil {
			return err
		}
	}

	if v.EcrRepositoryName != nil {
		ok := object.Key("ecrRepositoryName")
		if err := awsRestjson1_serializeDocumentResourceStringFilterList(v.EcrRepositoryName, ok); err != nil {
			return err
		}
	}

	if v.LambdaFunctionName != nil {
		ok := object.Key("lambdaFunctionName")
		if err := awsRestjson1_serializeDocumentResourceStringFilterList(v.LambdaFunctionName, ok); err != nil {
			return err
		}
	}

	if v.LambdaFunctionTags != nil {
		ok := object.Key("lambdaFunctionTags")
		if err := awsRestjson1_serializeDocumentResourceMapFilterList(v.LambdaFunctionTags, ok); err != nil {
			return err
		}
	}

	if v.ResourceId != nil {
		ok := object.Key("resourceId")
		if err := awsRestjson1_serializeDocumentResourceStringFilterList(v.ResourceId, ok); err != nil {
			return err
		}
	}

	if v.ResourceType != nil {
		ok := object.Key("resourceType")
		if err := awsRestjson1_serializeDocumentResourceStringFilterList(v.ResourceType, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentResourceIdFilterList(v []types.CisStringFilter, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentCisStringFilter(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentResourceMapFilter(v *types.ResourceMapFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Comparison) > 0 {
		ok := object.Key("comparison")
		ok.String(string(v.Comparison))
	}

	if v.Key != nil {
		ok := object.Key("key")
		ok.String(*v.Key)
	}

	if v.Value != nil {
		ok := object.Key("value")
		ok.String(*v.Value)
	}

	return nil
}

func awsRestjson1_serializeDocumentResourceMapFilterList(v []types.ResourceMapFilter, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentResourceMapFilter(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentResourceStringFilter(v *types.ResourceStringFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Comparison) > 0 {
		ok := object.Key("comparison")
		ok.String(string(v.Comparison))
	}

	if v.Value != nil {
		ok := object.Key("value")
		ok.String(*v.Value)
	}

	return nil
}

func awsRestjson1_serializeDocumentResourceStringFilterList(v []types.ResourceStringFilter, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentResourceStringFilter(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentResourceTagFilterList(v []types.TagFilter, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentTagFilter(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentSchedule(v types.Schedule, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.ScheduleMemberDaily:
		av := object.Key("daily")
		if err := awsRestjson1_serializeDocumentDailySchedule(&uv.Value, av); err != nil {
			return err
		}

	case *types.ScheduleMemberMonthly:
		av := object.Key("monthly")
		if err := awsRestjson1_serializeDocumentMonthlySchedule(&uv.Value, av); err != nil {
			return err
		}

	case *types.ScheduleMemberOneTime:
		av := object.Key("oneTime")
		if err := awsRestjson1_serializeDocumentOneTimeSchedule(&uv.Value, av); err != nil {
			return err
		}

	case *types.ScheduleMemberWeekly:
		av := object.Key("weekly")
		if err := awsRestjson1_serializeDocumentWeeklySchedule(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentSearchVulnerabilitiesFilterCriteria(v *types.SearchVulnerabilitiesFilterCriteria, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.VulnerabilityIds != nil {
		ok := object.Key("vulnerabilityIds")
		if err := awsRestjson1_serializeDocumentVulnIdList(v.VulnerabilityIds, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentSortCriteria(v *types.SortCriteria, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Field) > 0 {
		ok := object.Key("field")
		ok.String(string(v.Field))
	}

	if len(v.SortOrder) > 0 {
		ok := object.Key("sortOrder")
		ok.String(string(v.SortOrder))
	}

	return nil
}

func awsRestjson1_serializeDocumentStartCisSessionMessage(v *types.StartCisSessionMessage, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SessionToken != nil {
		ok := object.Key("sessionToken")
		ok.String(*v.SessionToken)
	}

	return nil
}

func awsRestjson1_serializeDocumentStopCisMessageProgress(v *types.StopCisMessageProgress, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ErrorChecks != 0 {
		ok := object.Key("errorChecks")
		ok.Integer(v.ErrorChecks)
	}

	if v.FailedChecks != 0 {
		ok := object.Key("failedChecks")
		ok.Integer(v.FailedChecks)
	}

	if v.InformationalChecks != 0 {
		ok := object.Key("informationalChecks")
		ok.Integer(v.InformationalChecks)
	}

	if v.NotApplicableChecks != 0 {
		ok := object.Key("notApplicableChecks")
		ok.Integer(v.NotApplicableChecks)
	}

	if v.NotEvaluatedChecks != 0 {
		ok := object.Key("notEvaluatedChecks")
		ok.Integer(v.NotEvaluatedChecks)
	}

	if v.SuccessfulChecks != 0 {
		ok := object.Key("successfulChecks")
		ok.Integer(v.SuccessfulChecks)
	}

	if v.TotalChecks != 0 {
		ok := object.Key("totalChecks")
		ok.Integer(v.TotalChecks)
	}

	if v.UnknownChecks != 0 {
		ok := object.Key("unknownChecks")
		ok.Integer(v.UnknownChecks)
	}

	return nil
}

func awsRestjson1_serializeDocumentStopCisSessionMessage(v *types.StopCisSessionMessage, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BenchmarkProfile != nil {
		ok := object.Key("benchmarkProfile")
		ok.String(*v.BenchmarkProfile)
	}

	if v.BenchmarkVersion != nil {
		ok := object.Key("benchmarkVersion")
		ok.String(*v.BenchmarkVersion)
	}

	if v.ComputePlatform != nil {
		ok := object.Key("computePlatform")
		if err := awsRestjson1_serializeDocumentComputePlatform(v.ComputePlatform, ok); err != nil {
			return err
		}
	}

	if v.Progress != nil {
		ok := object.Key("progress")
		if err := awsRestjson1_serializeDocumentStopCisMessageProgress(v.Progress, ok); err != nil {
			return err
		}
	}

	if v.Reason != nil {
		ok := object.Key("reason")
		ok.String(*v.Reason)
	}

	if len(v.Status) > 0 {
		ok := object.Key("status")
		ok.String(string(v.Status))
	}

	return nil
}

func awsRestjson1_serializeDocumentStringFilter(v *types.StringFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Comparison) > 0 {
		ok := object.Key("comparison")
		ok.String(string(v.Comparison))
	}

	if v.Value != nil {
		ok := object.Key("value")
		ok.String(*v.Value)
	}

	return nil
}

func awsRestjson1_serializeDocumentStringFilterList(v []types.StringFilter, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentStringFilter(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentTagFilter(v *types.TagFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Comparison) > 0 {
		ok := object.Key("comparison")
		ok.String(string(v.Comparison))
	}

	if v.Key != nil {
		ok := object.Key("key")
		ok.String(*v.Key)
	}

	if v.Value != nil {
		ok := object.Key("value")
		ok.String(*v.Value)
	}

	return nil
}

func awsRestjson1_serializeDocumentTagMap(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentTagValueList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentTargetAccountList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentTargetResourceTags(v map[string][]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		if vv := v[key]; vv == nil {
			continue
		}
		if err := awsRestjson1_serializeDocumentTagValueList(v[key], om); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentTargetStatusFilterList(v []types.CisTargetStatusFilter, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentCisTargetStatusFilter(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentTargetStatusReasonFilterList(v []types.CisTargetStatusReasonFilter, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentCisTargetStatusReasonFilter(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentTime(v *types.Time, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.TimeOfDay != nil {
		ok := object.Key("timeOfDay")
		ok.String(*v.TimeOfDay)
	}

	if v.Timezone != nil {
		ok := object.Key("timezone")
		ok.String(*v.Timezone)
	}

	return nil
}

func awsRestjson1_serializeDocumentTitleAggregation(v *types.TitleAggregation, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.FindingType) > 0 {
		ok := object.Key("findingType")
		ok.String(string(v.FindingType))
	}

	if len(v.ResourceType) > 0 {
		ok := object.Key("resourceType")
		ok.String(string(v.ResourceType))
	}

	if len(v.SortBy) > 0 {
		ok := object.Key("sortBy")
		ok.String(string(v.SortBy))
	}

	if len(v.SortOrder) > 0 {
		ok := object.Key("sortOrder")
		ok.String(string(v.SortOrder))
	}

	if v.Titles != nil {
		ok := object.Key("titles")
		if err := awsRestjson1_serializeDocumentStringFilterList(v.Titles, ok); err != nil {
			return err
		}
	}

	if v.VulnerabilityIds != nil {
		ok := object.Key("vulnerabilityIds")
		if err := awsRestjson1_serializeDocumentStringFilterList(v.VulnerabilityIds, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentTitleFilterList(v []types.CisStringFilter, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentCisStringFilter(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentUpdateCisTargets(v *types.UpdateCisTargets, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AccountIds != nil {
		ok := object.Key("accountIds")
		if err := awsRestjson1_serializeDocumentTargetAccountList(v.AccountIds, ok); err != nil {
			return err
		}
	}

	if v.TargetResourceTags != nil {
		ok := object.Key("targetResourceTags")
		if err := awsRestjson1_serializeDocumentTargetResourceTags(v.TargetResourceTags, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentUsageAccountIdList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentVulnIdList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentWeeklySchedule(v *types.WeeklySchedule, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Days != nil {
		ok := object.Key("days")
		if err := awsRestjson1_serializeDocumentDaysList(v.Days, ok); err != nil {
			return err
		}
	}

	if v.StartTime != nil {
		ok := object.Key("startTime")
		if err := awsRestjson1_serializeDocumentTime(v.StartTime, ok); err != nil {
			return err
		}
	}

	return nil
}
