// Code generated by smithy-go-codegen DO NOT EDIT.

package invoicing

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/invoicing/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// This fetches a list of all invoice unit definitions for a given account, as of
// the provided AsOf date.
func (c *Client) ListInvoiceUnits(ctx context.Context, params *ListInvoiceUnitsInput, optFns ...func(*Options)) (*ListInvoiceUnitsOutput, error) {
	if params == nil {
		params = &ListInvoiceUnitsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListInvoiceUnits", params, optFns, c.addOperationListInvoiceUnitsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListInvoiceUnitsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListInvoiceUnitsInput struct {

	//  The state of an invoice unit at a specified time. You can see legacy invoice
	// units that are currently deleted if the AsOf time is set to before it was
	// deleted. If an AsOf is not provided, the default value is the current time.
	AsOf *time.Time

	//  An optional input to the list API. If multiple filters are specified, the
	// returned list will be a configuration that match all of the provided filters.
	// Supported filter types are InvoiceReceivers , Names , and Accounts .
	Filters *types.Filters

	// The maximum number of invoice units that can be returned.
	MaxResults *int32

	// The next token used to indicate where the returned list should start from.
	NextToken *string

	noSmithyDocumentSerde
}

type ListInvoiceUnitsOutput struct {

	//  An invoice unit is a set of mutually exclusive accounts that correspond to
	// your business entity.
	InvoiceUnits []types.InvoiceUnit

	// The next token used to indicate where the returned list should start from.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListInvoiceUnitsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpListInvoiceUnits{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpListInvoiceUnits{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListInvoiceUnits"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListInvoiceUnits(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListInvoiceUnitsPaginatorOptions is the paginator options for ListInvoiceUnits
type ListInvoiceUnitsPaginatorOptions struct {
	// The maximum number of invoice units that can be returned.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListInvoiceUnitsPaginator is a paginator for ListInvoiceUnits
type ListInvoiceUnitsPaginator struct {
	options   ListInvoiceUnitsPaginatorOptions
	client    ListInvoiceUnitsAPIClient
	params    *ListInvoiceUnitsInput
	nextToken *string
	firstPage bool
}

// NewListInvoiceUnitsPaginator returns a new ListInvoiceUnitsPaginator
func NewListInvoiceUnitsPaginator(client ListInvoiceUnitsAPIClient, params *ListInvoiceUnitsInput, optFns ...func(*ListInvoiceUnitsPaginatorOptions)) *ListInvoiceUnitsPaginator {
	if params == nil {
		params = &ListInvoiceUnitsInput{}
	}

	options := ListInvoiceUnitsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListInvoiceUnitsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListInvoiceUnitsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListInvoiceUnits page.
func (p *ListInvoiceUnitsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListInvoiceUnitsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListInvoiceUnits(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListInvoiceUnitsAPIClient is a client that implements the ListInvoiceUnits
// operation.
type ListInvoiceUnitsAPIClient interface {
	ListInvoiceUnits(context.Context, *ListInvoiceUnitsInput, ...func(*Options)) (*ListInvoiceUnitsOutput, error)
}

var _ ListInvoiceUnitsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListInvoiceUnits(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListInvoiceUnits",
	}
}
