// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// An optional input to the list API. If multiple filters are specified, the
// returned list will be a configuration that match all of the provided filters.
// Supported filter types are InvoiceReceivers , Names , and Accounts .
type Filters struct {

	//  You can specify a list of Amazon Web Services account IDs inside filters to
	// return invoice units that match only the specified accounts. If multiple
	// accounts are provided, the result is an OR condition (match any) of the
	// specified accounts. The specified account IDs are matched with either the
	// receiver or the linked accounts in the rules.
	Accounts []string

	//  You can specify a list of Amazon Web Services account IDs inside filters to
	// return invoice units that match only the specified accounts. If multiple
	// accounts are provided, the result is an OR condition (match any) of the
	// specified accounts. This filter only matches the specified accounts on the
	// invoice receivers of the invoice units.
	InvoiceReceivers []string

	//  An optional input to the list API. You can specify a list of invoice unit
	// names inside filters to return invoice units that match only the specified
	// invoice unit names. If multiple names are provided, the result is an OR
	// condition (match any) of the specified invoice unit names.
	Names []string

	noSmithyDocumentSerde
}

// Contains high-level information about the invoice receiver.
type InvoiceProfile struct {

	//  The account ID the invoice profile is generated for.
	AccountId *string

	//  This specifies the issuing entity of the invoice.
	Issuer *string

	// The address of the receiver that will be printed on the invoice.
	ReceiverAddress *ReceiverAddress

	// The email address for the invoice profile receiver.
	ReceiverEmail *string

	//  The name of the person receiving the invoice profile.
	ReceiverName *string

	//  Your Tax Registration Number (TRN) information.
	TaxRegistrationNumber *string

	noSmithyDocumentSerde
}

// An invoice unit is a set of mutually exclusive accounts that correspond to your
// business entity. Invoice units allow you separate Amazon Web Services account
// costs and configures your invoice for each business entity going forward.
type InvoiceUnit struct {

	// The assigned description for an invoice unit. This information can't be
	// modified or deleted.
	Description *string

	// The account that receives invoices related to the invoice unit.
	InvoiceReceiver *string

	// ARN to identify an invoice unit. This information can't be modified or deleted.
	InvoiceUnitArn *string

	//  The last time the invoice unit was updated. This is important to determine the
	// version of invoice unit configuration used to create the invoices. Any invoice
	// created after this modified time will use this invoice unit configuration.
	LastModified *time.Time

	//  A unique name that is distinctive within your Amazon Web Services.
	Name *string

	//  An InvoiceUnitRule object used the categorize invoice units.
	Rule *InvoiceUnitRule

	// Whether the invoice unit based tax inheritance is/ should be enabled or
	// disabled.
	TaxInheritanceDisabled *bool

	noSmithyDocumentSerde
}

//	This is used to categorize the invoice unit. Values are Amazon Web Services
//
// account IDs. Currently, the only supported rule is LINKED_ACCOUNT .
type InvoiceUnitRule struct {

	// The list of LINKED_ACCOUNT IDs where charges are included within the invoice
	// unit.
	LinkedAccounts []string

	noSmithyDocumentSerde
}

// The details of the address associated with the receiver.
type ReceiverAddress struct {

	//  The first line of the address.
	AddressLine1 *string

	//  The second line of the address, if applicable.
	AddressLine2 *string

	//  The third line of the address, if applicable.
	AddressLine3 *string

	//  The city that the address is in.
	City *string

	//  A unique company name.
	CompanyName *string

	//  The country code for the country the address is in.
	CountryCode *string

	//  The district or country the address is located in.
	DistrictOrCounty *string

	//  The postal code associated with the address.
	PostalCode *string

	//  The state, region, or province the address is located.
	StateOrRegion *string

	noSmithyDocumentSerde
}

// The tag structure that contains a tag key and value.
type ResourceTag struct {

	// The object key of your of your resource tag.
	//
	// This member is required.
	Key *string

	//  The specific value of the resource tag.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

//	The input fails to satisfy the constraints specified by an Amazon Web Services
//
// service.
type ValidationExceptionField struct {

	//  The input fails to satisfy the constraints specified by an Amazon Web Services
	// service.
	//
	// This member is required.
	Message *string

	//  The input fails to satisfy the constraints specified by an Amazon Web Services
	// service.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
