// Code generated by smithy-go-codegen DO NOT EDIT.

package iotfleetwise

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Retrieves information about a state template.
//
// Access to certain Amazon Web Services IoT FleetWise features is currently
// gated. For more information, see [Amazon Web Services Region and feature availability]in the Amazon Web Services IoT FleetWise
// Developer Guide.
//
// [Amazon Web Services Region and feature availability]: https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/fleetwise-regions.html
func (c *Client) GetStateTemplate(ctx context.Context, params *GetStateTemplateInput, optFns ...func(*Options)) (*GetStateTemplateOutput, error) {
	if params == nil {
		params = &GetStateTemplateInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetStateTemplate", params, optFns, c.addOperationGetStateTemplateMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetStateTemplateOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetStateTemplateInput struct {

	// A unique, service-generated identifier.
	//
	// This member is required.
	Identifier *string

	noSmithyDocumentSerde
}

type GetStateTemplateOutput struct {

	// The Amazon Resource Name (ARN) of the state template.
	Arn *string

	// The time the state template was created in seconds since epoch (January 1, 1970
	// at midnight UTC time).
	CreationTime *time.Time

	// A list of vehicle attributes associated with the payload published on the state
	// template's MQTT topic.
	//
	// Default: An empty array
	DataExtraDimensions []string

	// A brief description of the state template.
	Description *string

	// The unique ID of the state template.
	Id *string

	// The time the state template was last updated in seconds since epoch (January 1,
	// 1970 at midnight UTC time).
	LastModificationTime *time.Time

	// A list of vehicle attributes to associate with user properties of the messages
	// published on the state template's MQTT topic.
	//
	// Default: An empty array
	MetadataExtraDimensions []string

	// The name of the state template.
	Name *string

	// The ARN of the signal catalog associated with the state template.
	SignalCatalogArn *string

	// A list of signals from which data is collected. The state template properties
	// contain the fully qualified names of the signals.
	StateTemplateProperties []string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetStateTemplateMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpGetStateTemplate{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpGetStateTemplate{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetStateTemplate"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpGetStateTemplateValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetStateTemplate(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetStateTemplate(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetStateTemplate",
	}
}
