// Code generated by smithy-go-codegen DO NOT EDIT.

package iotfleetwise

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/iotfleetwise/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates or updates the encryption configuration. Amazon Web Services IoT
// FleetWise can encrypt your data and resources using an Amazon Web Services
// managed key. Or, you can use a KMS key that you own and manage. For more
// information, see [Data encryption]in the Amazon Web Services IoT FleetWise Developer Guide.
//
// [Data encryption]: https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/data-encryption.html
func (c *Client) PutEncryptionConfiguration(ctx context.Context, params *PutEncryptionConfigurationInput, optFns ...func(*Options)) (*PutEncryptionConfigurationOutput, error) {
	if params == nil {
		params = &PutEncryptionConfigurationInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "PutEncryptionConfiguration", params, optFns, c.addOperationPutEncryptionConfigurationMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*PutEncryptionConfigurationOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type PutEncryptionConfigurationInput struct {

	// The type of encryption. Choose KMS_BASED_ENCRYPTION to use a KMS key or
	// FLEETWISE_DEFAULT_ENCRYPTION to use an Amazon Web Services managed key.
	//
	// This member is required.
	EncryptionType types.EncryptionType

	// The ID of the KMS key that is used for encryption.
	KmsKeyId *string

	noSmithyDocumentSerde
}

type PutEncryptionConfigurationOutput struct {

	// The encryption status.
	//
	// This member is required.
	EncryptionStatus types.EncryptionStatus

	// The type of encryption. Set to KMS_BASED_ENCRYPTION to use an KMS key that you
	// own and manage. Set to FLEETWISE_DEFAULT_ENCRYPTION to use an Amazon Web
	// Services managed key that is owned by the Amazon Web Services IoT FleetWise
	// service account.
	//
	// This member is required.
	EncryptionType types.EncryptionType

	// The ID of the KMS key that is used for encryption.
	KmsKeyId *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationPutEncryptionConfigurationMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpPutEncryptionConfiguration{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpPutEncryptionConfiguration{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "PutEncryptionConfiguration"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpPutEncryptionConfigurationValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opPutEncryptionConfiguration(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opPutEncryptionConfiguration(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "PutEncryptionConfiguration",
	}
}
