// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// A signal that represents a vehicle device such as the engine, heater, and door
// locks. Data from an actuator reports the state of a certain vehicle device.
//
// Updating actuator data can change the state of a device. For example, you can
// turn on or off the heater by updating its actuator data.
type Actuator struct {

	// The specified data type of the actuator.
	//
	// This member is required.
	DataType NodeDataType

	// The fully qualified name of the actuator. For example, the fully qualified name
	// of an actuator might be Vehicle.Front.Left.Door.Lock .
	//
	// This member is required.
	FullyQualifiedName *string

	// A list of possible values an actuator can take.
	AllowedValues []string

	// A specified value for the actuator.
	//
	// Deprecated: assignedValue is no longer in use
	AssignedValue *string

	// A comment in addition to the description.
	Comment *string

	// The deprecation message for the node or the branch that was moved or deleted.
	DeprecationMessage *string

	// A brief description of the actuator.
	Description *string

	// The specified possible maximum value of an actuator.
	Max *float64

	// The specified possible minimum value of an actuator.
	Min *float64

	// The fully qualified name of the struct node for the actuator if the data type
	// of the actuator is Struct or StructArray . For example, the struct fully
	// qualified name of an actuator might be Vehicle.Door.LockStruct .
	StructFullyQualifiedName *string

	// The scientific unit for the actuator.
	Unit *string

	noSmithyDocumentSerde
}

// A signal that represents static information about the vehicle, such as engine
// type or manufacturing date.
type Attribute struct {

	// The specified data type of the attribute.
	//
	// This member is required.
	DataType NodeDataType

	// The fully qualified name of the attribute. For example, the fully qualified
	// name of an attribute might be Vehicle.Body.Engine.Type .
	//
	// This member is required.
	FullyQualifiedName *string

	// A list of possible values an attribute can be assigned.
	AllowedValues []string

	// A specified value for the attribute.
	//
	// Deprecated: assignedValue is no longer in use
	AssignedValue *string

	// A comment in addition to the description.
	Comment *string

	// The default value of the attribute.
	DefaultValue *string

	// The deprecation message for the node or the branch that was moved or deleted.
	DeprecationMessage *string

	// A brief description of the attribute.
	Description *string

	// The specified possible maximum value of the attribute.
	Max *float64

	// The specified possible minimum value of the attribute.
	Min *float64

	// The scientific unit for the attribute.
	Unit *string

	noSmithyDocumentSerde
}

// A group of signals that are defined in a hierarchical structure.
type Branch struct {

	// The fully qualified name of the branch. For example, the fully qualified name
	// of a branch might be Vehicle.Body.Engine .
	//
	// This member is required.
	FullyQualifiedName *string

	// A comment in addition to the description.
	Comment *string

	// The deprecation message for the node or the branch that was moved or deleted.
	DeprecationMessage *string

	// A brief description of the branch.
	Description *string

	noSmithyDocumentSerde
}

// Information about a campaign.
//
// You can use the API operation to return this information about multiple created
// campaigns.
type CampaignSummary struct {

	// The time the campaign was created.
	//
	// This member is required.
	CreationTime *time.Time

	// The last time the campaign was modified.
	//
	// This member is required.
	LastModificationTime *time.Time

	// The Amazon Resource Name (ARN) of a campaign.
	Arn *string

	// The description of the campaign.
	Description *string

	// The name of a campaign.
	Name *string

	// The ARN of the signal catalog associated with the campaign.
	SignalCatalogArn *string

	// The state of a campaign. The status can be one of the following:
	//
	//   - CREATING - Amazon Web Services IoT FleetWise is processing your request to
	//   create the campaign.
	//
	//   - WAITING_FOR_APPROVAL - After a campaign is created, it enters the
	//   WAITING_FOR_APPROVAL state. To allow Amazon Web Services IoT FleetWise to
	//   deploy the campaign to the target vehicle or fleet, use the API operation to
	//   approve the campaign.
	//
	//   - RUNNING - The campaign is active.
	//
	//   - SUSPENDED - The campaign is suspended. To resume the campaign, use the API
	//   operation.
	Status CampaignStatus

	// The ARN of a vehicle or fleet to which the campaign is deployed.
	TargetArn *string

	noSmithyDocumentSerde
}

// Configurations used to create a decoder manifest.
type CanDbcDefinition struct {

	// A list of DBC files. You can upload only one DBC file for each network
	// interface and specify up to five (inclusive) files in the list. The DBC file can
	// be a maximum size of 200 MB.
	//
	// This member is required.
	CanDbcFiles [][]byte

	// Contains information about a network interface.
	//
	// This member is required.
	NetworkInterface *string

	// Pairs every signal specified in your vehicle model with a signal decoder.
	SignalsMap map[string]string

	noSmithyDocumentSerde
}

// A single controller area network (CAN) device interface.
type CanInterface struct {

	// The unique name of the interface.
	//
	// This member is required.
	Name *string

	// The name of the communication protocol for the interface.
	ProtocolName *string

	// The version of the communication protocol for the interface.
	ProtocolVersion *string

	noSmithyDocumentSerde
}

// Information about a single controller area network (CAN) signal and the
// messages it receives and transmits.
type CanSignal struct {

	// A multiplier used to decode the CAN message.
	//
	// This member is required.
	Factor *float64

	// Whether the byte ordering of a CAN message is big-endian.
	//
	// This member is required.
	IsBigEndian bool

	// Whether the message data is specified as a signed value.
	//
	// This member is required.
	IsSigned bool

	// How many bytes of data are in the message.
	//
	// This member is required.
	Length int32

	// The ID of the message.
	//
	// This member is required.
	MessageId int32

	// The offset used to calculate the signal value. Combined with factor, the
	// calculation is value = raw_value * factor + offset .
	//
	// This member is required.
	Offset *float64

	// Indicates the beginning of the CAN signal. This should always be the least
	// significant bit (LSB).
	//
	// This value might be different from the value in a DBC file. For little endian
	// signals, startBit is the same value as in the DBC file. For big endian signals
	// in a DBC file, the start bit is the most significant bit (MSB). You will have to
	// calculate the LSB instead and pass it as the startBit .
	//
	// This member is required.
	StartBit int32

	// The name of the signal.
	Name *string

	noSmithyDocumentSerde
}

// The log delivery option to send data to Amazon CloudWatch Logs.
type CloudWatchLogDeliveryOptions struct {

	// The type of log to send data to Amazon CloudWatch Logs.
	//
	// This member is required.
	LogType LogType

	// The Amazon CloudWatch Logs group the operation sends data to.
	LogGroupName *string

	noSmithyDocumentSerde
}

// Specifies what data to collect and how often or when to collect it.
//
// The following types satisfy this interface:
//
//	CollectionSchemeMemberConditionBasedCollectionScheme
//	CollectionSchemeMemberTimeBasedCollectionScheme
type CollectionScheme interface {
	isCollectionScheme()
}

// Information about a collection scheme that uses a simple logical expression to
// recognize what data to collect.
type CollectionSchemeMemberConditionBasedCollectionScheme struct {
	Value ConditionBasedCollectionScheme

	noSmithyDocumentSerde
}

func (*CollectionSchemeMemberConditionBasedCollectionScheme) isCollectionScheme() {}

// Information about a collection scheme that uses a time period to decide how
// often to collect data.
type CollectionSchemeMemberTimeBasedCollectionScheme struct {
	Value TimeBasedCollectionScheme

	noSmithyDocumentSerde
}

func (*CollectionSchemeMemberTimeBasedCollectionScheme) isCollectionScheme() {}

// Information about a collection scheme that uses a simple logical expression to
// recognize what data to collect.
type ConditionBasedCollectionScheme struct {

	// The logical expression used to recognize what data to collect. For example,
	// $variable.`Vehicle.OutsideAirTemperature` >= 105.0 .
	//
	// This member is required.
	Expression *string

	// Specifies the version of the conditional expression language.
	ConditionLanguageVersion *int32

	// The minimum duration of time between two triggering events to collect data, in
	// milliseconds.
	//
	// If a signal changes often, you might want to collect data at a slower rate.
	MinimumTriggerIntervalMs *int64

	// Whether to collect data for all triggering events ( ALWAYS ). Specify (
	// RISING_EDGE ), or specify only when the condition first evaluates to false. For
	// example, triggering on "AirbagDeployed"; Users aren't interested on triggering
	// when the airbag is already exploded; they only care about the change from not
	// deployed => deployed.
	TriggerMode TriggerMode

	noSmithyDocumentSerde
}

// Specifies the condition under which a signal fetch occurs.
type ConditionBasedSignalFetchConfig struct {

	// The condition that must be satisfied to trigger a signal fetch.
	//
	// This member is required.
	ConditionExpression *string

	// Indicates the mode in which the signal fetch is triggered.
	//
	// This member is required.
	TriggerMode TriggerMode

	noSmithyDocumentSerde
}

// An HTTP error resulting from creating a vehicle.
type CreateVehicleError struct {

	// An HTTP error code.
	Code *string

	// A description of the HTTP error.
	Message *string

	// The ID of the vehicle with the error.
	VehicleName *string

	noSmithyDocumentSerde
}

// Information about the vehicle to create.
type CreateVehicleRequestItem struct {

	// The Amazon Resource Name (ARN) of a decoder manifest associated with the
	// vehicle to create.
	//
	// This member is required.
	DecoderManifestArn *string

	// The ARN of the vehicle model (model manifest) to create the vehicle from.
	//
	// This member is required.
	ModelManifestArn *string

	// The unique ID of the vehicle to create.
	//
	// This member is required.
	VehicleName *string

	// An option to create a new Amazon Web Services IoT thing when creating a
	// vehicle, or to validate an existing thing as a vehicle.
	AssociationBehavior VehicleAssociationBehavior

	// Static information about a vehicle in a key-value pair. For example: "engine
	// Type" : "v6"
	Attributes map[string]string

	// Associate state templates to track the state of the vehicle. State templates
	// determine which signal updates the vehicle sends to the cloud.
	StateTemplates []StateTemplateAssociation

	// Metadata which can be used to manage the vehicle.
	Tags []Tag

	noSmithyDocumentSerde
}

// Information about a created vehicle.
type CreateVehicleResponseItem struct {

	// The ARN of the created vehicle.
	Arn *string

	// The ARN of a created or validated Amazon Web Services IoT thing.
	ThingArn *string

	// The unique ID of the vehicle to create.
	VehicleName *string

	noSmithyDocumentSerde
}

// Represents a custom network interface as defined by the customer.
//
// Access to certain Amazon Web Services IoT FleetWise features is currently
// gated. For more information, see [Amazon Web Services Region and feature availability]in the Amazon Web Services IoT FleetWise
// Developer Guide.
//
// [Amazon Web Services Region and feature availability]: https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/fleetwise-regions.html
type CustomDecodingInterface struct {

	// The name of the interface.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

// Information about signals using a custom decoding protocol as defined by the
// customer.
//
// Access to certain Amazon Web Services IoT FleetWise features is currently
// gated. For more information, see [Amazon Web Services Region and feature availability]in the Amazon Web Services IoT FleetWise
// Developer Guide.
//
// [Amazon Web Services Region and feature availability]: https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/fleetwise-regions.html
type CustomDecodingSignal struct {

	// The ID of the signal.
	//
	// This member is required.
	Id *string

	noSmithyDocumentSerde
}

// Represents a member of the complex data structure. The data type of the
// property can be either primitive or another struct .
type CustomProperty struct {

	// The data type for the custom property.
	//
	// This member is required.
	DataType NodeDataType

	// The fully qualified name of the custom property. For example, the fully
	// qualified name of a custom property might be
	// ComplexDataTypes.VehicleDataTypes.SVMCamera.FPS .
	//
	// This member is required.
	FullyQualifiedName *string

	// A comment in addition to the description.
	Comment *string

	// Indicates whether the property is binary data.
	DataEncoding NodeDataEncoding

	// The deprecation message for the node or the branch that was moved or deleted.
	DeprecationMessage *string

	// A brief description of the custom property.
	Description *string

	// The fully qualified name of the struct node for the custom property if the data
	// type of the custom property is Struct or StructArray .
	StructFullyQualifiedName *string

	noSmithyDocumentSerde
}

// The custom structure represents a complex or higher-order data structure.
type CustomStruct struct {

	// The fully qualified name of the custom structure. For example, the fully
	// qualified name of a custom structure might be
	// ComplexDataTypes.VehicleDataTypes.SVMCamera .
	//
	// This member is required.
	FullyQualifiedName *string

	// A comment in addition to the description.
	Comment *string

	// The deprecation message for the node or the branch that was moved or deleted.
	DeprecationMessage *string

	// A brief description of the custom structure.
	Description *string

	noSmithyDocumentSerde
}

// The destination where the campaign sends data. You can send data to an MQTT
// topic, or store it in Amazon S3 or Amazon Timestream.
//
// The following types satisfy this interface:
//
//	DataDestinationConfigMemberMqttTopicConfig
//	DataDestinationConfigMemberS3Config
//	DataDestinationConfigMemberTimestreamConfig
type DataDestinationConfig interface {
	isDataDestinationConfig()
}

// The MQTT topic to which the Amazon Web Services IoT FleetWise campaign routes
// data.
//
// Access to certain Amazon Web Services IoT FleetWise features is currently
// gated. For more information, see [Amazon Web Services Region and feature availability]in the Amazon Web Services IoT FleetWise
// Developer Guide.
//
// [Amazon Web Services Region and feature availability]: https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/fleetwise-regions.html
type DataDestinationConfigMemberMqttTopicConfig struct {
	Value MqttTopicConfig

	noSmithyDocumentSerde
}

func (*DataDestinationConfigMemberMqttTopicConfig) isDataDestinationConfig() {}

// The Amazon S3 bucket where the Amazon Web Services IoT FleetWise campaign sends
// data.
type DataDestinationConfigMemberS3Config struct {
	Value S3Config

	noSmithyDocumentSerde
}

func (*DataDestinationConfigMemberS3Config) isDataDestinationConfig() {}

// The Amazon Timestream table where the campaign sends data.
type DataDestinationConfigMemberTimestreamConfig struct {
	Value TimestreamConfig

	noSmithyDocumentSerde
}

func (*DataDestinationConfigMemberTimestreamConfig) isDataDestinationConfig() {}

// The configuration for signal data storage and upload options. You can only
// specify these options when the campaign's spooling mode is TO_DISK .
//
// Access to certain Amazon Web Services IoT FleetWise features is currently
// gated. For more information, see [Amazon Web Services Region and feature availability]in the Amazon Web Services IoT FleetWise
// Developer Guide.
//
// [Amazon Web Services Region and feature availability]: https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/fleetwise-regions.html
type DataPartition struct {

	// The ID of the data partition. The data partition ID must be unique within a
	// campaign. You can establish a data partition as the default partition for a
	// campaign by using default as the ID.
	//
	// This member is required.
	Id *string

	// The storage options for a data partition.
	//
	// This member is required.
	StorageOptions *DataPartitionStorageOptions

	// The upload options for the data partition.
	UploadOptions *DataPartitionUploadOptions

	noSmithyDocumentSerde
}

// Size, time, and location options for the data partition.
type DataPartitionStorageOptions struct {

	// The maximum storage size of the data stored in the data partition.
	//
	// Newer data overwrites older data when the partition reaches the maximum size.
	//
	// This member is required.
	MaximumSize *StorageMaximumSize

	// The amount of time that data in this partition will be kept on disk.
	//
	//   - After the designated amount of time passes, the data can be removed, but
	//   it's not guaranteed to be removed.
	//
	//   - Before the time expires, data in this partition can still be deleted if the
	//   partition reaches its configured maximum size.
	//
	//   - Newer data will overwrite older data when the partition reaches the maximum
	//   size.
	//
	// This member is required.
	MinimumTimeToLive *StorageMinimumTimeToLive

	// The folder name for the data partition under the campaign storage folder.
	//
	// This member is required.
	StorageLocation *string

	noSmithyDocumentSerde
}

// The upload options for the data partition. If upload options are specified, you
// must also specify storage options. See [DataPartitionStorageOptions].
//
// Access to certain Amazon Web Services IoT FleetWise features is currently
// gated. For more information, see [Amazon Web Services Region and feature availability]in the Amazon Web Services IoT FleetWise
// Developer Guide.
//
// [DataPartitionStorageOptions]: https://docs.aws.amazon.com/iot-fleetwise/latest/APIReference/API_DataPartitionStorageOptions.html
// [Amazon Web Services Region and feature availability]: https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/fleetwise-regions.html
type DataPartitionUploadOptions struct {

	// The logical expression used to recognize what data to collect. For example,
	// $variable.`Vehicle.OutsideAirTemperature` >= 105.0 .
	//
	// This member is required.
	Expression *string

	// The version of the condition language. Defaults to the most recent condition
	// language version.
	ConditionLanguageVersion *int32

	noSmithyDocumentSerde
}

// Information about a created decoder manifest. You can use the API operation to
// return this information about multiple decoder manifests.
type DecoderManifestSummary struct {

	// The time the decoder manifest was created in seconds since epoch (January 1,
	// 1970 at midnight UTC time).
	//
	// This member is required.
	CreationTime *time.Time

	// The time the decoder manifest was last updated in seconds since epoch (January
	// 1, 1970 at midnight UTC time).
	//
	// This member is required.
	LastModificationTime *time.Time

	// The ARN of a vehicle model (model manifest) associated with the decoder
	// manifest.
	Arn *string

	// A brief description of the decoder manifest.
	Description *string

	// The detailed message for the decoder manifest. When a decoder manifest is in an
	// INVALID status, the message contains detailed reason and help information.
	Message *string

	// The ARN of a vehicle model (model manifest) associated with the decoder
	// manifest.
	ModelManifestArn *string

	// The name of the decoder manifest.
	Name *string

	// The state of the decoder manifest. If the status is ACTIVE , the decoder
	// manifest can't be edited. If the status is marked DRAFT , you can edit the
	// decoder manifest.
	Status ManifestStatus

	noSmithyDocumentSerde
}

// Information about a fleet.
//
// You can use the API operation to return this information about multiple fleets.
type FleetSummary struct {

	// The Amazon Resource Name (ARN) of the fleet.
	//
	// This member is required.
	Arn *string

	// The time the fleet was created, in seconds since epoch (January 1, 1970 at
	// midnight UTC time).
	//
	// This member is required.
	CreationTime *time.Time

	// The unique ID of the fleet.
	//
	// This member is required.
	Id *string

	// The ARN of the signal catalog associated with the fleet.
	//
	// This member is required.
	SignalCatalogArn *string

	// A brief description of the fleet.
	Description *string

	// The time the fleet was last updated in seconds since epoch (January 1, 1970 at
	// midnight UTC time).
	LastModificationTime *time.Time

	noSmithyDocumentSerde
}

// [Vehicle Signal Specification (VSS)] is a precise language used to describe and model signals in vehicle networks.
// The JSON file collects signal specificiations in a VSS format.
//
// The following types satisfy this interface:
//
//	FormattedVssMemberVssJson
//
// [Vehicle Signal Specification (VSS)]: https://www.w3.org/auto/wg/wiki/Vehicle_Signal_Specification_(VSS)/Vehicle_Data_Spec
type FormattedVss interface {
	isFormattedVss()
}

// Provides the VSS in JSON format.
type FormattedVssMemberVssJson struct {
	Value string

	noSmithyDocumentSerde
}

func (*FormattedVssMemberVssJson) isFormattedVss() {}

// Information about registering an Identity and Access Management (IAM) resource
// so Amazon Web Services IoT FleetWise edge agent software can transfer your
// vehicle data to Amazon Timestream.
type IamRegistrationResponse struct {

	// The status of registering your IAM resource. The status can be one of
	// REGISTRATION_SUCCESS , REGISTRATION_PENDING , REGISTRATION_FAILURE .
	//
	// This member is required.
	RegistrationStatus RegistrationStatus

	// The Amazon Resource Name (ARN) of the IAM role to register.
	//
	// This member is required.
	RoleArn *string

	// A message associated with a registration error.
	ErrorMessage *string

	noSmithyDocumentSerde
}

// The IAM resource that enables Amazon Web Services IoT FleetWise edge agent
// software to send data to Amazon Timestream.
//
// For more information, see [IAM roles] in the Identity and Access Management User Guide.
//
// [IAM roles]: https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles.html
type IamResources struct {

	// The Amazon Resource Name (ARN) of the IAM resource that allows Amazon Web
	// Services IoT FleetWise to send data to Amazon Timestream. For example,
	// arn:aws:iam::123456789012:role/SERVICE-ROLE-ARN .
	//
	// This member is required.
	RoleArn *string

	noSmithyDocumentSerde
}

// A reason a vehicle network interface isn't valid.
type InvalidNetworkInterface struct {

	// The ID of the interface that isn't valid.
	InterfaceId *string

	// A message about why the interface isn't valid.
	Reason NetworkInterfaceFailureReason

	noSmithyDocumentSerde
}

// A reason that a signal isn't valid.
type InvalidSignal struct {

	// The name of the signal that isn't valid.
	Name *string

	// A message about why the signal isn't valid.
	Reason *string

	noSmithyDocumentSerde
}

// A reason that a signal decoder isn't valid.
type InvalidSignalDecoder struct {

	// The possible cause for the invalid signal decoder.
	Hint *string

	// The name of a signal decoder that isn't valid.
	Name *string

	// A message about why the signal decoder isn't valid.
	Reason SignalDecoderFailureReason

	noSmithyDocumentSerde
}

// The decoding information for a specific message which support higher order data
// types.
type MessageSignal struct {

	// The structured message for the message signal. It can be defined with either a
	// primitiveMessageDefinition , structuredMessageListDefinition , or
	// structuredMessageDefinition recursively.
	//
	// This member is required.
	StructuredMessage StructuredMessage

	// The topic name for the message signal. It corresponds to topics in ROS 2.
	//
	// This member is required.
	TopicName *string

	noSmithyDocumentSerde
}

// Information about a vehicle model (model manifest). You can use the API
// operation to return this information about multiple vehicle models.
type ModelManifestSummary struct {

	// The time the vehicle model was created, in seconds since epoch (January 1, 1970
	// at midnight UTC time).
	//
	// This member is required.
	CreationTime *time.Time

	// The time the vehicle model was last updated, in seconds since epoch (January 1,
	// 1970 at midnight UTC time).
	//
	// This member is required.
	LastModificationTime *time.Time

	// The Amazon Resource Name (ARN) of the vehicle model.
	Arn *string

	// A brief description of the vehicle model.
	Description *string

	// The name of the vehicle model.
	Name *string

	// The ARN of the signal catalog associated with the vehicle model.
	SignalCatalogArn *string

	// The state of the vehicle model. If the status is ACTIVE , the vehicle model
	// can't be edited. If the status is DRAFT , you can edit the vehicle model.
	Status ManifestStatus

	noSmithyDocumentSerde
}

// The MQTT topic to which the Amazon Web Services IoT FleetWise campaign routes
// data. For more information, see [Device communication protocols]in the Amazon Web Services IoT Core Developer
// Guide.
//
// Access to certain Amazon Web Services IoT FleetWise features is currently
// gated. For more information, see [Amazon Web Services Region and feature availability]in the Amazon Web Services IoT FleetWise
// Developer Guide.
//
// [Device communication protocols]: https://docs.aws.amazon.com/iot/latest/developerguide/protocols.html
// [Amazon Web Services Region and feature availability]: https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/fleetwise-regions.html
type MqttTopicConfig struct {

	// The ARN of the role that grants Amazon Web Services IoT FleetWise permission to
	// access and act on messages sent to the MQTT topic.
	//
	// This member is required.
	ExecutionRoleArn *string

	// The ARN of the MQTT topic.
	//
	// This member is required.
	MqttTopicArn *string

	noSmithyDocumentSerde
}

// Specifications for defining a vehicle network.
//
// The following types satisfy this interface:
//
//	NetworkFileDefinitionMemberCanDbc
type NetworkFileDefinition interface {
	isNetworkFileDefinition()
}

// Information, including CAN DBC files, about the configurations used to create a
// decoder manifest.
type NetworkFileDefinitionMemberCanDbc struct {
	Value CanDbcDefinition

	noSmithyDocumentSerde
}

func (*NetworkFileDefinitionMemberCanDbc) isNetworkFileDefinition() {}

// Represents a node and its specifications in an in-vehicle communication
// network. All signal decoders must be associated with a network node.
//
// To return this information about all the network interfaces specified in a
// decoder manifest, use the API operation.
type NetworkInterface struct {

	// The ID of the network interface.
	//
	// This member is required.
	InterfaceId *string

	// The network protocol for the vehicle. For example, CAN_SIGNAL specifies a
	// protocol that defines how data is communicated between electronic control units
	// (ECUs). OBD_SIGNAL specifies a protocol that defines how self-diagnostic data
	// is communicated between ECUs.
	//
	// This member is required.
	Type NetworkInterfaceType

	// Information about a network interface specified by the Controller Area Network
	// (CAN) protocol.
	CanInterface *CanInterface

	// Information about a [custom network interface].
	//
	// [custom network interface]: https://docs.aws.amazon.com/iot-fleetwise/latest/APIReference/API_CustomDecodingInterface.html
	CustomDecodingInterface *CustomDecodingInterface

	// Information about a network interface specified by the on-board diagnostic
	// (OBD) II protocol.
	ObdInterface *ObdInterface

	// The vehicle middleware defined as a type of network interface. Examples of
	// vehicle middleware include ROS2 and SOME/IP .
	VehicleMiddleware *VehicleMiddleware

	noSmithyDocumentSerde
}

// A general abstraction of a signal. A node can be specified as an actuator,
// attribute, branch, or sensor.
//
// The following types satisfy this interface:
//
//	NodeMemberActuator
//	NodeMemberAttribute
//	NodeMemberBranch
//	NodeMemberProperty
//	NodeMemberSensor
//	NodeMemberStruct
type Node interface {
	isNode()
}

// Information about a node specified as an actuator.
//
// An actuator is a digital representation of a vehicle device.
type NodeMemberActuator struct {
	Value Actuator

	noSmithyDocumentSerde
}

func (*NodeMemberActuator) isNode() {}

// Information about a node specified as an attribute.
//
// An attribute represents static information about a vehicle.
type NodeMemberAttribute struct {
	Value Attribute

	noSmithyDocumentSerde
}

func (*NodeMemberAttribute) isNode() {}

// Information about a node specified as a branch.
//
// A group of signals that are defined in a hierarchical structure.
type NodeMemberBranch struct {
	Value Branch

	noSmithyDocumentSerde
}

func (*NodeMemberBranch) isNode() {}

// Represents a member of the complex data structure. The datatype of the property
// can be either primitive or another struct .
type NodeMemberProperty struct {
	Value CustomProperty

	noSmithyDocumentSerde
}

func (*NodeMemberProperty) isNode() {}

// An input component that reports the environmental condition of a vehicle.
//
// You can collect data about fluid levels, temperatures, vibrations, or battery
// voltage from sensors.
type NodeMemberSensor struct {
	Value Sensor

	noSmithyDocumentSerde
}

func (*NodeMemberSensor) isNode() {}

// Represents a complex or higher-order data structure.
type NodeMemberStruct struct {
	Value CustomStruct

	noSmithyDocumentSerde
}

func (*NodeMemberStruct) isNode() {}

// Information about the number of nodes and node types in a vehicle network.
type NodeCounts struct {

	// The total number of nodes in a vehicle network that represent actuators.
	TotalActuators int32

	// The total number of nodes in a vehicle network that represent attributes.
	TotalAttributes int32

	// The total number of nodes in a vehicle network that represent branches.
	TotalBranches int32

	// The total number of nodes in a vehicle network.
	TotalNodes int32

	// The total properties for the node.
	TotalProperties int32

	// The total number of nodes in a vehicle network that represent sensors.
	TotalSensors int32

	// The total structure for the node.
	TotalStructs int32

	noSmithyDocumentSerde
}

// A network interface that specifies the on-board diagnostic (OBD) II network
// protocol.
type ObdInterface struct {

	// The name of the interface.
	//
	// This member is required.
	Name *string

	// The ID of the message requesting vehicle data.
	//
	// This member is required.
	RequestMessageId int32

	// The maximum number message requests per diagnostic trouble code per second.
	DtcRequestIntervalSeconds int32

	// Whether the vehicle has a transmission control module (TCM).
	HasTransmissionEcu bool

	// The standard OBD II PID.
	ObdStandard *string

	// The maximum number message requests per second.
	PidRequestIntervalSeconds int32

	// Whether to use extended IDs in the message.
	UseExtendedIds bool

	noSmithyDocumentSerde
}

// Information about signal messages using the on-board diagnostics (OBD) II
// protocol in a vehicle.
type ObdSignal struct {

	// The length of a message.
	//
	// This member is required.
	ByteLength *int32

	// The offset used to calculate the signal value. Combined with scaling, the
	// calculation is value = raw_value * scaling + offset .
	//
	// This member is required.
	Offset *float64

	// The diagnostic code used to request data from a vehicle for this signal.
	//
	// This member is required.
	Pid int32

	// The length of the requested data.
	//
	// This member is required.
	PidResponseLength *int32

	// A multiplier used to decode the message.
	//
	// This member is required.
	Scaling *float64

	// The mode of operation (diagnostic service) in a message.
	//
	// This member is required.
	ServiceMode int32

	// Indicates the beginning of the message.
	//
	// This member is required.
	StartByte int32

	// The number of bits to mask in a message.
	BitMaskLength *int32

	// The number of positions to shift bits in the message.
	BitRightShift int32

	noSmithyDocumentSerde
}

// Vehicles associated with the state template will stream telemetry data when
// there is a change.
type OnChangeStateTemplateUpdateStrategy struct {
	noSmithyDocumentSerde
}

// Vehicles associated with the state template will stream telemetry data during a
// specified time period.
type PeriodicStateTemplateUpdateStrategy struct {

	// The length of time between state template updates.
	//
	// This member is required.
	StateTemplateUpdateRate *TimePeriod

	noSmithyDocumentSerde
}

// Represents a primitive type node of the complex data structure.
//
// The following types satisfy this interface:
//
//	PrimitiveMessageDefinitionMemberRos2PrimitiveMessageDefinition
type PrimitiveMessageDefinition interface {
	isPrimitiveMessageDefinition()
}

// Information about a PrimitiveMessage using a ROS 2 compliant primitive type
// message of the complex data structure.
type PrimitiveMessageDefinitionMemberRos2PrimitiveMessageDefinition struct {
	Value ROS2PrimitiveMessageDefinition

	noSmithyDocumentSerde
}

func (*PrimitiveMessageDefinitionMemberRos2PrimitiveMessageDefinition) isPrimitiveMessageDefinition() {
}

// Represents a ROS 2 compliant primitive type message of the complex data
// structure.
type ROS2PrimitiveMessageDefinition struct {

	// The primitive type (integer, floating point, boolean, etc.) for the ROS 2
	// primitive message definition.
	//
	// This member is required.
	PrimitiveType ROS2PrimitiveType

	// The offset used to calculate the signal value. Combined with scaling, the
	// calculation is value = raw_value * scaling + offset .
	Offset *float64

	// A multiplier used to decode the message.
	Scaling *float64

	// An optional attribute specifying the upper bound for STRING and WSTRING .
	UpperBound *int64

	noSmithyDocumentSerde
}

// The Amazon S3 bucket where the Amazon Web Services IoT FleetWise campaign sends
// data. Amazon S3 is an object storage service that stores data as objects within
// buckets. For more information, see [Creating, configuring, and working with Amazon S3 buckets]in the Amazon Simple Storage Service User
// Guide.
//
// [Creating, configuring, and working with Amazon S3 buckets]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/creating-buckets-s3.html
type S3Config struct {

	// The Amazon Resource Name (ARN) of the Amazon S3 bucket.
	//
	// This member is required.
	BucketArn *string

	// Specify the format that files are saved in the Amazon S3 bucket. You can save
	// files in an Apache Parquet or JSON format.
	//
	//   - Parquet - Store data in a columnar storage file format. Parquet is optimal
	//   for fast data retrieval and can reduce costs. This option is selected by
	//   default.
	//
	//   - JSON - Store data in a standard text-based JSON file format.
	DataFormat DataFormat

	// Enter an S3 bucket prefix. The prefix is the string of characters after the
	// bucket name and before the object name. You can use the prefix to organize data
	// stored in Amazon S3 buckets. For more information, see [Organizing objects using prefixes]in the Amazon Simple
	// Storage Service User Guide.
	//
	// By default, Amazon Web Services IoT FleetWise sets the prefix
	// processed-data/year=YY/month=MM/date=DD/hour=HH/ (in UTC) to data it delivers to
	// Amazon S3. You can enter a prefix to append it to this default prefix. For
	// example, if you enter the prefix vehicles , the prefix will be
	// vehicles/processed-data/year=YY/month=MM/date=DD/hour=HH/ .
	//
	// [Organizing objects using prefixes]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-prefixes.html
	Prefix *string

	// By default, stored data is compressed as a .gzip file. Compressed files have a
	// reduced file size, which can optimize the cost of data storage.
	StorageCompressionFormat StorageCompressionFormat

	noSmithyDocumentSerde
}

// An input component that reports the environmental condition of a vehicle.
//
// You can collect data about fluid levels, temperatures, vibrations, or battery
// voltage from sensors.
type Sensor struct {

	// The specified data type of the sensor.
	//
	// This member is required.
	DataType NodeDataType

	// The fully qualified name of the sensor. For example, the fully qualified name
	// of a sensor might be Vehicle.Body.Engine.Battery .
	//
	// This member is required.
	FullyQualifiedName *string

	// A list of possible values a sensor can take.
	AllowedValues []string

	// A comment in addition to the description.
	Comment *string

	// The deprecation message for the node or the branch that was moved or deleted.
	DeprecationMessage *string

	// A brief description of a sensor.
	Description *string

	// The specified possible maximum value of the sensor.
	Max *float64

	// The specified possible minimum value of the sensor.
	Min *float64

	// The fully qualified name of the struct node for a sensor if the data type of
	// the actuator is Struct or StructArray . For example, the struct fully qualified
	// name of a sensor might be Vehicle.ADAS.CameraStruct .
	StructFullyQualifiedName *string

	// The scientific unit of measurement for data collected by the sensor.
	Unit *string

	noSmithyDocumentSerde
}

// Information about a collection of standardized signals, which can be
// attributes, branches, sensors, or actuators.
type SignalCatalogSummary struct {

	// The Amazon Resource Name (ARN) of the signal catalog.
	Arn *string

	// The time the signal catalog was created in seconds since epoch (January 1, 1970
	// at midnight UTC time).
	CreationTime *time.Time

	// The time the signal catalog was last updated in seconds since epoch (January 1,
	// 1970 at midnight UTC time).
	LastModificationTime *time.Time

	// The name of the signal catalog.
	Name *string

	noSmithyDocumentSerde
}

// Information about a signal decoder.
type SignalDecoder struct {

	// The fully qualified name of a signal decoder as defined in a vehicle model.
	//
	// This member is required.
	FullyQualifiedName *string

	// The ID of a network interface that specifies what network protocol a vehicle
	// follows.
	//
	// This member is required.
	InterfaceId *string

	// The network protocol for the vehicle. For example, CAN_SIGNAL specifies a
	// protocol that defines how data is communicated between electronic control units
	// (ECUs). OBD_SIGNAL specifies a protocol that defines how self-diagnostic data
	// is communicated between ECUs.
	//
	// This member is required.
	Type SignalDecoderType

	// Information about signal decoder using the Controller Area Network (CAN)
	// protocol.
	CanSignal *CanSignal

	// Information about a [custom signal decoder].
	//
	// Access to certain Amazon Web Services IoT FleetWise features is currently
	// gated. For more information, see [Amazon Web Services Region and feature availability]in the Amazon Web Services IoT FleetWise
	// Developer Guide.
	//
	// [custom signal decoder]: https://docs.aws.amazon.com/iot-fleetwise/latest/APIReference/API_CustomDecodingSignal.html
	// [Amazon Web Services Region and feature availability]: https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/fleetwise-regions.html
	CustomDecodingSignal *CustomDecodingSignal

	// The decoding information for a specific message which supports higher order
	// data types.
	MessageSignal *MessageSignal

	// Information about signal decoder using the on-board diagnostic (OBD) II
	// protocol.
	ObdSignal *ObdSignal

	noSmithyDocumentSerde
}

// The configuration of the signal fetch operation.
//
// Access to certain Amazon Web Services IoT FleetWise features is currently
// gated. For more information, see [Amazon Web Services Region and feature availability]in the Amazon Web Services IoT FleetWise
// Developer Guide.
//
// The following types satisfy this interface:
//
//	SignalFetchConfigMemberConditionBased
//	SignalFetchConfigMemberTimeBased
//
// [Amazon Web Services Region and feature availability]: https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/fleetwise-regions.html
type SignalFetchConfig interface {
	isSignalFetchConfig()
}

// The configuration of a condition-based signal fetch operation.
type SignalFetchConfigMemberConditionBased struct {
	Value ConditionBasedSignalFetchConfig

	noSmithyDocumentSerde
}

func (*SignalFetchConfigMemberConditionBased) isSignalFetchConfig() {}

// The configuration of a time-based signal fetch operation.
type SignalFetchConfigMemberTimeBased struct {
	Value TimeBasedSignalFetchConfig

	noSmithyDocumentSerde
}

func (*SignalFetchConfigMemberTimeBased) isSignalFetchConfig() {}

// Information about the signal to be fetched.
//
// Access to certain Amazon Web Services IoT FleetWise features is currently
// gated. For more information, see [Amazon Web Services Region and feature availability]in the Amazon Web Services IoT FleetWise
// Developer Guide.
//
// [Amazon Web Services Region and feature availability]: https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/fleetwise-regions.html
type SignalFetchInformation struct {

	// The actions to be performed by the signal fetch.
	//
	// This member is required.
	Actions []string

	// The fully qualified name of the signal to be fetched.
	//
	// This member is required.
	FullyQualifiedName *string

	// The configuration of the signal fetch operation.
	//
	// This member is required.
	SignalFetchConfig SignalFetchConfig

	// The version of the condition language used.
	ConditionLanguageVersion *int32

	noSmithyDocumentSerde
}

// Information about a signal.
type SignalInformation struct {

	// The name of the signal.
	//
	// This member is required.
	Name *string

	// The ID of the data partition this signal is associated with.
	//
	// The ID must match one of the IDs provided in dataPartitions . This is
	// accomplished either by specifying a particular data partition ID or by using
	// default for an established default partition. You can establish a default
	// partition in the DataPartition data type.
	//
	// If you upload a signal as a condition for a campaign's data partition, the same
	// signal must be included in signalsToCollect .
	//
	// Access to certain Amazon Web Services IoT FleetWise features is currently
	// gated. For more information, see [Amazon Web Services Region and feature availability]in the Amazon Web Services IoT FleetWise
	// Developer Guide.
	//
	// [Amazon Web Services Region and feature availability]: https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/fleetwise-regions.html
	DataPartitionId *string

	// The maximum number of samples to collect.
	MaxSampleCount *int64

	// The minimum duration of time (in milliseconds) between two triggering events to
	// collect data.
	//
	// If a signal changes often, you might want to collect data at a slower rate.
	MinimumSamplingIntervalMs *int64

	noSmithyDocumentSerde
}

// The state template associated with a vehicle. State templates contain state
// properties, which are signals that belong to a signal catalog that is
// synchronized between the Amazon Web Services IoT FleetWise Edge and the Amazon
// Web Services Cloud.
//
// Access to certain Amazon Web Services IoT FleetWise features is currently
// gated. For more information, see [Amazon Web Services Region and feature availability]in the Amazon Web Services IoT FleetWise
// Developer Guide.
//
// [Amazon Web Services Region and feature availability]: https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/fleetwise-regions.html
type StateTemplateAssociation struct {

	// A unique, service-generated identifier.
	//
	// This member is required.
	Identifier *string

	// The update strategy for the state template. Vehicles associated with the state
	// template can stream telemetry data with either an onChange or periodic update
	// strategy.
	//
	// Access to certain Amazon Web Services IoT FleetWise features is currently
	// gated. For more information, see [Amazon Web Services Region and feature availability]in the Amazon Web Services IoT FleetWise
	// Developer Guide.
	//
	// [Amazon Web Services Region and feature availability]: https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/fleetwise-regions.html
	//
	// This member is required.
	StateTemplateUpdateStrategy StateTemplateUpdateStrategy

	noSmithyDocumentSerde
}

// Information about a state template.
//
// Access to certain Amazon Web Services IoT FleetWise features is currently
// gated. For more information, see [Amazon Web Services Region and feature availability]in the Amazon Web Services IoT FleetWise
// Developer Guide.
//
// [Amazon Web Services Region and feature availability]: https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/fleetwise-regions.html
type StateTemplateSummary struct {

	// The Amazon Resource Name (ARN) of the state template.
	Arn *string

	// The time the state template was created, in seconds since epoch (January 1,
	// 1970 at midnight UTC time).
	CreationTime *time.Time

	// A brief description of the state template.
	Description *string

	// The unique ID of the state template.
	Id *string

	// The time the state template was last updated, in seconds since epoch (January
	// 1, 1970 at midnight UTC time).
	LastModificationTime *time.Time

	// The name of the state template.
	Name *string

	// The Amazon Resource Name (ARN) of the signal catalog associated with the state
	// template.
	SignalCatalogArn *string

	noSmithyDocumentSerde
}

// The update strategy for the state template. Vehicles associated with the state
// template can stream telemetry data with either an onChange or periodic update
// strategy.
//
// Access to certain Amazon Web Services IoT FleetWise features is currently
// gated. For more information, see [Amazon Web Services Region and feature availability]in the Amazon Web Services IoT FleetWise
// Developer Guide.
//
// The following types satisfy this interface:
//
//	StateTemplateUpdateStrategyMemberOnChange
//	StateTemplateUpdateStrategyMemberPeriodic
//
// [Amazon Web Services Region and feature availability]: https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/fleetwise-regions.html
type StateTemplateUpdateStrategy interface {
	isStateTemplateUpdateStrategy()
}

// Vehicles associated with the state template will stream telemetry data when
// there is a change.
type StateTemplateUpdateStrategyMemberOnChange struct {
	Value OnChangeStateTemplateUpdateStrategy

	noSmithyDocumentSerde
}

func (*StateTemplateUpdateStrategyMemberOnChange) isStateTemplateUpdateStrategy() {}

// Vehicles associated with the state template will stream telemetry data during a
// specified time period.
type StateTemplateUpdateStrategyMemberPeriodic struct {
	Value PeriodicStateTemplateUpdateStrategy

	noSmithyDocumentSerde
}

func (*StateTemplateUpdateStrategyMemberPeriodic) isStateTemplateUpdateStrategy() {}

// The maximum storage size for the data partition.
//
// Access to certain Amazon Web Services IoT FleetWise features is currently
// gated. For more information, see [Amazon Web Services Region and feature availability]in the Amazon Web Services IoT FleetWise
// Developer Guide.
//
// [Amazon Web Services Region and feature availability]: https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/fleetwise-regions.html
type StorageMaximumSize struct {

	// The data type of the data to store.
	//
	// This member is required.
	Unit StorageMaximumSizeUnit

	// The maximum amount of time to store data.
	//
	// This member is required.
	Value *int32

	noSmithyDocumentSerde
}

// Information about the minimum amount of time that data will be kept.
//
// Access to certain Amazon Web Services IoT FleetWise features is currently
// gated. For more information, see [Amazon Web Services Region and feature availability]in the Amazon Web Services IoT FleetWise
// Developer Guide.
//
// [Amazon Web Services Region and feature availability]: https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/fleetwise-regions.html
type StorageMinimumTimeToLive struct {

	// The time increment type.
	//
	// This member is required.
	Unit StorageMinimumTimeToLiveUnit

	// The minimum amount of time to store the data.
	//
	// This member is required.
	Value *int32

	noSmithyDocumentSerde
}

// The structured message for the message signal. It can be defined with either a
// primitiveMessageDefinition , structuredMessageListDefinition , or
// structuredMessageDefinition recursively.
//
// The following types satisfy this interface:
//
//	StructuredMessageMemberPrimitiveMessageDefinition
//	StructuredMessageMemberStructuredMessageDefinition
//	StructuredMessageMemberStructuredMessageListDefinition
type StructuredMessage interface {
	isStructuredMessage()
}

// Represents a primitive type node of the complex data structure.
type StructuredMessageMemberPrimitiveMessageDefinition struct {
	Value PrimitiveMessageDefinition

	noSmithyDocumentSerde
}

func (*StructuredMessageMemberPrimitiveMessageDefinition) isStructuredMessage() {}

// Represents a struct type node of the complex data structure.
type StructuredMessageMemberStructuredMessageDefinition struct {
	Value []StructuredMessageFieldNameAndDataTypePair

	noSmithyDocumentSerde
}

func (*StructuredMessageMemberStructuredMessageDefinition) isStructuredMessage() {}

// Represents a list type node of the complex data structure.
type StructuredMessageMemberStructuredMessageListDefinition struct {
	Value StructuredMessageListDefinition

	noSmithyDocumentSerde
}

func (*StructuredMessageMemberStructuredMessageListDefinition) isStructuredMessage() {}

// Represents a StructureMessageName to DataType map element.
type StructuredMessageFieldNameAndDataTypePair struct {

	// The data type.
	//
	// This member is required.
	DataType StructuredMessage

	// The field name of the structured message. It determines how a data value is
	// referenced in the target language.
	//
	// This member is required.
	FieldName *string

	noSmithyDocumentSerde
}

// Represents a list type node of the complex data structure.
type StructuredMessageListDefinition struct {

	// The type of list of the structured message list definition.
	//
	// This member is required.
	ListType StructuredMessageListType

	// The member type of the structured message list definition.
	//
	// This member is required.
	MemberType StructuredMessage

	// The name of the structured message list definition.
	//
	// This member is required.
	Name *string

	// The capacity of the structured message list definition when the list type is
	// FIXED_CAPACITY or DYNAMIC_BOUNDED_CAPACITY .
	Capacity int32

	noSmithyDocumentSerde
}

// A set of key/value pairs that are used to manage the resource.
type Tag struct {

	// The tag's key.
	//
	// This member is required.
	Key *string

	// The tag's value.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// Information about a collection scheme that uses a time period to decide how
// often to collect data.
type TimeBasedCollectionScheme struct {

	// The time period (in milliseconds) to decide how often to collect data. For
	// example, if the time period is 60000 , the Edge Agent software collects data
	// once every minute.
	//
	// This member is required.
	PeriodMs *int64

	noSmithyDocumentSerde
}

// Used to configure a frequency-based vehicle signal fetch.
type TimeBasedSignalFetchConfig struct {

	// The frequency with which the signal fetch will be executed.
	//
	// This member is required.
	ExecutionFrequencyMs *int64

	noSmithyDocumentSerde
}

// The length of time between state template updates.
type TimePeriod struct {

	// A unit of time.
	//
	// This member is required.
	Unit TimeUnit

	// A number of time units.
	//
	// This member is required.
	Value *int32

	noSmithyDocumentSerde
}

// The Amazon Timestream table where the Amazon Web Services IoT FleetWise
// campaign sends data. Timestream stores and organizes data to optimize query
// processing time and to reduce storage costs. For more information, see [Data modeling]in the
// Amazon Timestream Developer Guide.
//
// [Data modeling]: https://docs.aws.amazon.com/timestream/latest/developerguide/data-modeling.html
type TimestreamConfig struct {

	// The Amazon Resource Name (ARN) of the task execution role that grants Amazon
	// Web Services IoT FleetWise permission to deliver data to the Amazon Timestream
	// table.
	//
	// This member is required.
	ExecutionRoleArn *string

	// The Amazon Resource Name (ARN) of the Amazon Timestream table.
	//
	// This member is required.
	TimestreamTableArn *string

	noSmithyDocumentSerde
}

// Information about the registered Amazon Timestream resources or errors, if any.
type TimestreamRegistrationResponse struct {

	// The status of registering your Amazon Timestream resources. The status can be
	// one of REGISTRATION_SUCCESS , REGISTRATION_PENDING , REGISTRATION_FAILURE .
	//
	// This member is required.
	RegistrationStatus RegistrationStatus

	// The name of the Timestream database.
	//
	// This member is required.
	TimestreamDatabaseName *string

	// The name of the Timestream database table.
	//
	// This member is required.
	TimestreamTableName *string

	// A message associated with a registration error.
	ErrorMessage *string

	// The Amazon Resource Name (ARN) of the Timestream database.
	TimestreamDatabaseArn *string

	// The ARN of the Timestream database table.
	TimestreamTableArn *string

	noSmithyDocumentSerde
}

// The registered Amazon Timestream resources that Amazon Web Services IoT
// FleetWise edge agent software can transfer your vehicle data to.
type TimestreamResources struct {

	// The name of the registered Amazon Timestream database.
	//
	// This member is required.
	TimestreamDatabaseName *string

	// The name of the registered Amazon Timestream database table.
	//
	// This member is required.
	TimestreamTableName *string

	noSmithyDocumentSerde
}

// An HTTP error resulting from updating the description for a vehicle.
type UpdateVehicleError struct {

	// The relevant HTTP error code (400+).
	Code int32

	// A message associated with the error.
	Message *string

	// The ID of the vehicle with the error.
	VehicleName *string

	noSmithyDocumentSerde
}

// Information about the vehicle to update.
type UpdateVehicleRequestItem struct {

	// The unique ID of the vehicle to update.
	//
	// This member is required.
	VehicleName *string

	// The method the specified attributes will update the existing attributes on the
	// vehicle. Use Overwite to replace the vehicle attributes with the specified
	// attributes. Or use Merge to combine all attributes.
	//
	// This is required if attributes are present in the input.
	AttributeUpdateMode UpdateMode

	// Static information about a vehicle in a key-value pair. For example:
	//
	// "engineType" : "1.3 L R2"
	Attributes map[string]string

	// The ARN of the signal decoder manifest associated with the vehicle to update.
	DecoderManifestArn *string

	// The ARN of the vehicle model (model manifest) associated with the vehicle to
	// update.
	ModelManifestArn *string

	// Associate additional state templates to track the state of the vehicle. State
	// templates determine which signal updates the vehicle sends to the cloud.
	StateTemplatesToAdd []StateTemplateAssociation

	// Remove existing state template associations from the vehicle.
	StateTemplatesToRemove []string

	noSmithyDocumentSerde
}

// Information about the updated vehicle.
type UpdateVehicleResponseItem struct {

	// The Amazon Resource Name (ARN) of the updated vehicle.
	Arn *string

	// The unique ID of the updated vehicle.
	VehicleName *string

	noSmithyDocumentSerde
}

// A validation error due to mismatch between the expected data type, length, or
// pattern of the parameter and the input.
type ValidationExceptionField struct {

	// A message about the validation error.
	//
	// This member is required.
	Message *string

	// The name of the parameter field with the validation error.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

// The vehicle middleware defined as a type of network interface. Examples of
// vehicle middleware include ROS2 and SOME/IP .
type VehicleMiddleware struct {

	// The name of the vehicle middleware.
	//
	// This member is required.
	Name *string

	// The protocol name of the vehicle middleware.
	//
	// This member is required.
	ProtocolName VehicleMiddlewareProtocol

	noSmithyDocumentSerde
}

// Information about a campaign associated with a vehicle.
type VehicleStatus struct {

	// The name of a campaign.
	CampaignName *string

	// The status of a campaign, which can be one of the following:
	//
	//   - CREATED - The campaign has been created successfully but has not been
	//   approved.
	//
	//   - READY - The campaign has been approved but has not been deployed to the
	//   vehicle.
	//
	//   - HEALTHY - The campaign has been deployed to the vehicle.
	//
	//   - SUSPENDED - The campaign has been suspended and data collection is paused.
	//
	//   - DELETING - The campaign is being removed from the vehicle.
	Status VehicleState

	// The unique ID of the vehicle.
	VehicleName *string

	noSmithyDocumentSerde
}

// Information about a vehicle.
//
// To return this information about vehicles in your account, you can use the API
// operation.
type VehicleSummary struct {

	// The Amazon Resource Name (ARN) of the vehicle.
	//
	// This member is required.
	Arn *string

	// The time the vehicle was created in seconds since epoch (January 1, 1970 at
	// midnight UTC time).
	//
	// This member is required.
	CreationTime *time.Time

	// The ARN of a decoder manifest associated with the vehicle.
	//
	// This member is required.
	DecoderManifestArn *string

	// The time the vehicle was last updated in seconds since epoch (January 1, 1970
	// at midnight UTC time).
	//
	// This member is required.
	LastModificationTime *time.Time

	// The ARN of a vehicle model (model manifest) associated with the vehicle.
	//
	// This member is required.
	ModelManifestArn *string

	// The unique ID of the vehicle.
	//
	// This member is required.
	VehicleName *string

	// Static information about a vehicle in a key-value pair. For example:
	//
	// "engineType" : "1.3 L R2"
	Attributes map[string]string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde

// UnknownUnionMember is returned when a union member is returned over the wire,
// but has an unknown tag.
type UnknownUnionMember struct {
	Tag   string
	Value []byte

	noSmithyDocumentSerde
}

func (*UnknownUnionMember) isCollectionScheme()            {}
func (*UnknownUnionMember) isDataDestinationConfig()       {}
func (*UnknownUnionMember) isFormattedVss()                {}
func (*UnknownUnionMember) isNetworkFileDefinition()       {}
func (*UnknownUnionMember) isNode()                        {}
func (*UnknownUnionMember) isPrimitiveMessageDefinition()  {}
func (*UnknownUnionMember) isSignalFetchConfig()           {}
func (*UnknownUnionMember) isStateTemplateUpdateStrategy() {}
func (*UnknownUnionMember) isStructuredMessage()           {}
