// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Contains an access policy that defines an identity's access to an IoT SiteWise
// Monitor resource.
type AccessPolicySummary struct {

	// The ID of the access policy.
	//
	// This member is required.
	Id *string

	// The identity (an IAM Identity Center user, an IAM Identity Center group, or an
	// IAM user).
	//
	// This member is required.
	Identity *Identity

	// The permissions for the access policy. Note that a project ADMINISTRATOR is
	// also known as a project owner.
	//
	// This member is required.
	Permission Permission

	// The IoT SiteWise Monitor resource (a portal or project).
	//
	// This member is required.
	Resource *Resource

	// The date the access policy was created, in Unix epoch time.
	CreationDate *time.Time

	// The date the access policy was last updated, in Unix epoch time.
	LastUpdateDate *time.Time

	noSmithyDocumentSerde
}

// Contains a definition for an action.
type ActionDefinition struct {

	// The ID of the action definition.
	//
	// This member is required.
	ActionDefinitionId *string

	// The name of the action definition.
	//
	// This member is required.
	ActionName *string

	// The type of the action definition.
	//
	// This member is required.
	ActionType *string

	noSmithyDocumentSerde
}

// The JSON payload of the action.
type ActionPayload struct {

	// The payload of the action in a JSON string.
	//
	// This member is required.
	StringValue *string

	noSmithyDocumentSerde
}

// Contains the summary of the actions.
type ActionSummary struct {

	// The ID of the action definition.
	ActionDefinitionId *string

	// The ID of the action.
	ActionId *string

	// The resource the action will be taken on.
	TargetResource *TargetResource

	noSmithyDocumentSerde
}

// Contains aggregated asset property values (for example, average, minimum, and
// maximum).
type AggregatedValue struct {

	// The date the aggregating computations occurred, in Unix epoch time.
	//
	// This member is required.
	Timestamp *time.Time

	// The value of the aggregates.
	//
	// This member is required.
	Value *Aggregates

	// The quality of the aggregated data.
	Quality Quality

	noSmithyDocumentSerde
}

// Contains the (pre-calculated) aggregate values for an asset property.
type Aggregates struct {

	// The average (mean) value of the time series over a time interval window.
	Average *float64

	// The count of data points in the time series over a time interval window.
	Count *float64

	// The maximum value of the time series over a time interval window.
	Maximum *float64

	// The minimum value of the time series over a time interval window.
	Minimum *float64

	// The standard deviation of the time series over a time interval window.
	StandardDeviation *float64

	// The sum of the time series over a time interval window.
	Sum *float64

	noSmithyDocumentSerde
}

// Contains the configuration information of an alarm created in an IoT SiteWise
// Monitor portal. You can use the alarm to monitor an asset property and get
// notified when the asset property value is outside a specified range. For more
// information, see [Monitoring with alarms]in the IoT SiteWise Application Guide.
//
// [Monitoring with alarms]: https://docs.aws.amazon.com/iot-sitewise/latest/appguide/monitor-alarms.html
type Alarms struct {

	// The [ARN] of the IAM role that allows the alarm to perform actions and access Amazon
	// Web Services resources and services, such as IoT Events.
	//
	// [ARN]: https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html
	//
	// This member is required.
	AlarmRoleArn *string

	// The [ARN] of the Lambda function that manages alarm notifications. For more
	// information, see [Managing alarm notifications]in the IoT Events Developer Guide.
	//
	// [Managing alarm notifications]: https://docs.aws.amazon.com/iotevents/latest/developerguide/lambda-support.html
	// [ARN]: https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html
	NotificationLambdaArn *string

	noSmithyDocumentSerde
}

// Contains information about a composite model in an asset. This object contains
// the asset's properties that you define in the composite model.
type AssetCompositeModel struct {

	// The name of the composite model.
	//
	// This member is required.
	Name *string

	// The asset properties that this composite model defines.
	//
	// This member is required.
	Properties []AssetProperty

	// The type of the composite model. For alarm composite models, this type is
	// AWS/ALARM .
	//
	// This member is required.
	Type *string

	// The description of the composite model.
	Description *string

	// The external ID of the asset composite model. For more information, see [Using external IDs] in the
	// IoT SiteWise User Guide.
	//
	// [Using external IDs]: https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids
	ExternalId *string

	//  The ID of the asset composite model.
	Id *string

	noSmithyDocumentSerde
}

// Represents one level between a composite model and the root of the asset.
type AssetCompositeModelPathSegment struct {

	// The ID of the path segment.
	Id *string

	// The name of the path segment.
	Name *string

	noSmithyDocumentSerde
}

// Contains a summary of the composite model for a specific asset.
type AssetCompositeModelSummary struct {

	// A description of the composite model that this summary describes.
	//
	// This member is required.
	Description *string

	// The ID of the composite model that this summary describes.
	//
	// This member is required.
	Id *string

	// The name of the composite model that this summary describes.
	//
	// This member is required.
	Name *string

	// The path that includes all the components of the asset model for the asset.
	//
	// This member is required.
	Path []AssetCompositeModelPathSegment

	// The type of asset model.
	//
	//   - ASSET_MODEL – (default) An asset model that you can use to create assets.
	//   Can't be included as a component in another asset model.
	//
	//   - COMPONENT_MODEL – A reusable component that you can include in the
	//   composite models of other asset models. You can't create assets directly from
	//   this type of asset model.
	//
	// This member is required.
	Type *string

	// An external ID to assign to the asset model.
	//
	// If the composite model is a derived composite model, or one nested inside a
	// component model, you can only set the external ID using
	// UpdateAssetModelCompositeModel and specifying the derived ID of the model or
	// property from the created model it's a part of.
	ExternalId *string

	noSmithyDocumentSerde
}

// Contains error details for the requested associate project asset action.
type AssetErrorDetails struct {

	// The ID of the asset, in UUID format.
	//
	// This member is required.
	AssetId *string

	// The error code.
	//
	// This member is required.
	Code AssetErrorCode

	// The error message.
	//
	// This member is required.
	Message *string

	noSmithyDocumentSerde
}

// Describes an asset hierarchy that contains a hierarchy's name and ID.
type AssetHierarchy struct {

	// The hierarchy name provided in the [CreateAssetModel] or [UpdateAssetModel] API operation.
	//
	// [CreateAssetModel]: https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_CreateAssetModel.html
	// [UpdateAssetModel]: https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetModel.html
	//
	// This member is required.
	Name *string

	// The external ID of the hierarchy, if it has one. When you update an asset
	// hierarchy, you may assign an external ID if it doesn't already have one. You
	// can't change the external ID of an asset hierarchy that already has one. For
	// more information, see [Using external IDs]in the IoT SiteWise User Guide.
	//
	// [Using external IDs]: https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids
	ExternalId *string

	// The ID of the hierarchy. This ID is a hierarchyId .
	Id *string

	noSmithyDocumentSerde
}

// Contains information about a parent asset and a child asset that are related
// through an asset hierarchy.
type AssetHierarchyInfo struct {

	// The ID of the child asset in this asset relationship.
	ChildAssetId *string

	// The ID of the parent asset in this asset relationship.
	ParentAssetId *string

	noSmithyDocumentSerde
}

// Contains information about a composite model in an asset model. This object
// contains the asset property definitions that you define in the composite model.
type AssetModelCompositeModel struct {

	// The name of the composite model.
	//
	// This member is required.
	Name *string

	// The type of the composite model. For alarm composite models, this type is
	// AWS/ALARM .
	//
	// This member is required.
	Type *string

	// The description of the composite model.
	Description *string

	// The external ID of the asset model composite model. For more information, see [Using external IDs]
	// in the IoT SiteWise User Guide.
	//
	// [Using external IDs]: https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids
	ExternalId *string

	//  The ID of the asset model composite model.
	Id *string

	// The asset property definitions for this composite model.
	Properties []AssetModelProperty

	noSmithyDocumentSerde
}

// Contains a composite model definition in an asset model. This composite model
// definition is applied to all assets created from the asset model.
type AssetModelCompositeModelDefinition struct {

	// The name of the composite model.
	//
	// This member is required.
	Name *string

	// The type of the composite model. For alarm composite models, this type is
	// AWS/ALARM .
	//
	// This member is required.
	Type *string

	// The description of the composite model.
	Description *string

	// An external ID to assign to the composite model. The external ID must be unique
	// among composite models within this asset model. For more information, see [Using external IDs]in
	// the IoT SiteWise User Guide.
	//
	// [Using external IDs]: https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids
	ExternalId *string

	// The ID to assign to the composite model, if desired. IoT SiteWise automatically
	// generates a unique ID for you, so this parameter is never required. However, if
	// you prefer to supply your own ID instead, you can specify it here in UUID
	// format. If you specify your own ID, it must be globally unique.
	Id *string

	// The asset property definitions for this composite model.
	Properties []AssetModelPropertyDefinition

	noSmithyDocumentSerde
}

// Represents one level between a composite model and the root of the asset model.
type AssetModelCompositeModelPathSegment struct {

	// The ID of the path segment.
	Id *string

	// The name of the path segment.
	Name *string

	noSmithyDocumentSerde
}

// Contains a summary of the composite model.
type AssetModelCompositeModelSummary struct {

	// The ID of the composite model that this summary describes..
	//
	// This member is required.
	Id *string

	// The name of the composite model that this summary describes..
	//
	// This member is required.
	Name *string

	// The composite model type. Valid values are AWS/ALARM , CUSTOM , or
	// AWS/L4E_ANOMALY .
	//
	// This member is required.
	Type *string

	// The description of the composite model that this summary describes..
	Description *string

	// The external ID of a composite model on this asset model. For more information,
	// see [Using external IDs]in the IoT SiteWise User Guide.
	//
	// [Using external IDs]: https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids
	ExternalId *string

	// The path that includes all the pieces that make up the composite model.
	Path []AssetModelCompositeModelPathSegment

	noSmithyDocumentSerde
}

// Describes an asset hierarchy that contains a hierarchy's name, ID, and child
// asset model ID that specifies the type of asset that can be in this hierarchy.
type AssetModelHierarchy struct {

	// The ID of the asset model, in UUID format. All assets in this hierarchy must be
	// instances of the childAssetModelId asset model. IoT SiteWise will always return
	// the actual asset model ID for this value. However, when you are specifying this
	// value as part of a call to [UpdateAssetModel], you may provide either the asset model ID or else
	// externalId: followed by the asset model's external ID. For more information, see [Using external IDs]
	// in the IoT SiteWise User Guide.
	//
	// [UpdateAssetModel]: https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetModel.html
	// [Using external IDs]: https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids
	//
	// This member is required.
	ChildAssetModelId *string

	// The name of the asset model hierarchy that you specify by using the [CreateAssetModel] or [UpdateAssetModel] API
	// operation.
	//
	// [CreateAssetModel]: https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_CreateAssetModel.html
	// [UpdateAssetModel]: https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetModel.html
	//
	// This member is required.
	Name *string

	// The external ID (if any) provided in the [CreateAssetModel] or [UpdateAssetModel] operation. You can assign an
	// external ID by specifying this value as part of a call to [UpdateAssetModel]. However, you can't
	// change the external ID if one is already assigned. For more information, see [Using external IDs]in
	// the IoT SiteWise User Guide.
	//
	// [CreateAssetModel]: https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_CreateAssetModel.html
	// [UpdateAssetModel]: https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetModel.html
	// [Using external IDs]: https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids
	ExternalId *string

	// The ID of the asset model hierarchy. This ID is a hierarchyId .
	//
	//   - If you are callling [UpdateAssetModel]to create a new hierarchy: You can specify its ID here,
	//   if desired. IoT SiteWise automatically generates a unique ID for you, so this
	//   parameter is never required. However, if you prefer to supply your own ID
	//   instead, you can specify it here in UUID format. If you specify your own ID, it
	//   must be globally unique.
	//
	//   - If you are calling UpdateAssetModel to modify an existing hierarchy: This
	//   can be either the actual ID in UUID format, or else externalId: followed by
	//   the external ID, if it has one. For more information, see [Referencing objects with external IDs]in the IoT SiteWise
	//   User Guide.
	//
	// [UpdateAssetModel]: https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetModel.html
	// [Referencing objects with external IDs]: https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references
	Id *string

	noSmithyDocumentSerde
}

// Contains an asset model hierarchy used in asset model creation. An asset model
// hierarchy determines the kind (or type) of asset that can belong to a hierarchy.
type AssetModelHierarchyDefinition struct {

	// The ID of an asset model for this hierarchy. This can be either the actual ID
	// in UUID format, or else externalId: followed by the external ID, if it has one.
	// For more information, see [Referencing objects with external IDs]in the IoT SiteWise User Guide.
	//
	// [Referencing objects with external IDs]: https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references
	//
	// This member is required.
	ChildAssetModelId *string

	// The name of the asset model hierarchy definition (as specified in the [CreateAssetModel] or [UpdateAssetModel] API
	// operation).
	//
	// [CreateAssetModel]: https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_CreateAssetModel.html
	// [UpdateAssetModel]: https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetModel.html
	//
	// This member is required.
	Name *string

	// An external ID to assign to the asset model hierarchy. The external ID must be
	// unique among asset model hierarchies within this asset model. For more
	// information, see [Using external IDs]in the IoT SiteWise User Guide.
	//
	// [Using external IDs]: https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids
	ExternalId *string

	// The ID to assign to the asset model hierarchy, if desired. IoT SiteWise
	// automatically generates a unique ID for you, so this parameter is never
	// required. However, if you prefer to supply your own ID instead, you can specify
	// it here in UUID format. If you specify your own ID, it must be globally unique.
	Id *string

	noSmithyDocumentSerde
}

// Contains information about an asset model property.
type AssetModelProperty struct {

	// The data type of the asset model property.
	//
	// If you specify STRUCT , you must also specify dataTypeSpec to identify the type
	// of the structure for this property.
	//
	// This member is required.
	DataType PropertyDataType

	// The name of the asset model property.
	//
	// This member is required.
	Name *string

	// The property type (see PropertyType ).
	//
	// This member is required.
	Type *PropertyType

	// The data type of the structure for this property. This parameter exists on
	// properties that have the STRUCT data type.
	DataTypeSpec *string

	// The external ID (if any) provided in the [CreateAssetModel] or [UpdateAssetModel] operation. You can assign an
	// external ID by specifying this value as part of a call to [UpdateAssetModel]. However, you can't
	// change the external ID if one is already assigned. For more information, see [Using external IDs]in
	// the IoT SiteWise User Guide.
	//
	// [CreateAssetModel]: https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_CreateAssetModel.html
	// [UpdateAssetModel]: https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetModel.html
	// [Using external IDs]: https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids
	ExternalId *string

	// The ID of the asset model property.
	//
	//   - If you are callling [UpdateAssetModel]to create a new property: You can specify its ID here,
	//   if desired. IoT SiteWise automatically generates a unique ID for you, so this
	//   parameter is never required. However, if you prefer to supply your own ID
	//   instead, you can specify it here in UUID format. If you specify your own ID, it
	//   must be globally unique.
	//
	//   - If you are calling UpdateAssetModel to modify an existing property: This
	//   can be either the actual ID in UUID format, or else externalId: followed by
	//   the external ID, if it has one. For more information, see [Referencing objects with external IDs]in the IoT SiteWise
	//   User Guide.
	//
	// [UpdateAssetModel]: https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetModel.html
	// [Referencing objects with external IDs]: https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references
	Id *string

	// The structured path to the property from the root of the asset model.
	Path []AssetModelPropertyPathSegment

	// The unit of the asset model property, such as Newtons or RPM .
	Unit *string

	noSmithyDocumentSerde
}

// Contains an asset model property definition. This property definition is
// applied to all assets created from the asset model.
type AssetModelPropertyDefinition struct {

	// The data type of the property definition.
	//
	// If you specify STRUCT , you must also specify dataTypeSpec to identify the type
	// of the structure for this property.
	//
	// This member is required.
	DataType PropertyDataType

	// The name of the property definition.
	//
	// This member is required.
	Name *string

	// The property definition type (see PropertyType ). You can only specify one type
	// in a property definition.
	//
	// This member is required.
	Type *PropertyType

	// The data type of the structure for this property. This parameter is required on
	// properties that have the STRUCT data type.
	//
	// The options for this parameter depend on the type of the composite model in
	// which you define this property. Use AWS/ALARM_STATE for alarm state in alarm
	// composite models.
	DataTypeSpec *string

	// An external ID to assign to the property definition. The external ID must be
	// unique among property definitions within this asset model. For more information,
	// see [Using external IDs]in the IoT SiteWise User Guide.
	//
	// [Using external IDs]: https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids
	ExternalId *string

	// The ID to assign to the asset model property, if desired. IoT SiteWise
	// automatically generates a unique ID for you, so this parameter is never
	// required. However, if you prefer to supply your own ID instead, you can specify
	// it here in UUID format. If you specify your own ID, it must be globally unique.
	Id *string

	// The unit of the property definition, such as Newtons or RPM .
	Unit *string

	noSmithyDocumentSerde
}

// Represents one level between a property and the root of the asset model.
type AssetModelPropertyPathSegment struct {

	// The ID of the path segment.
	Id *string

	// The name of the path segment.
	Name *string

	noSmithyDocumentSerde
}

// Contains a summary of a property associated with a model.
type AssetModelPropertySummary struct {

	// The data type of the property.
	//
	// This member is required.
	DataType PropertyDataType

	// The name of the property.
	//
	// This member is required.
	Name *string

	// Contains a property type, which can be one of attribute , measurement , metric ,
	// or transform .
	//
	// This member is required.
	Type *PropertyType

	//  The ID of the composite model that contains the asset model property.
	AssetModelCompositeModelId *string

	// The data type of the structure for this property. This parameter exists on
	// properties that have the STRUCT data type.
	DataTypeSpec *string

	// The external ID of the property. For more information, see [Using external IDs] in the IoT SiteWise
	// User Guide.
	//
	// [Using external IDs]: https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids
	ExternalId *string

	// The ID of the property.
	Id *string

	// The structured path to the property from the root of the asset model.
	Path []AssetModelPropertyPathSegment

	// The unit (such as Newtons or RPM ) of the property.
	Unit *string

	noSmithyDocumentSerde
}

// Contains current status information for an asset model. For more information,
// see [Asset and model states]in the IoT SiteWise User Guide.
//
// [Asset and model states]: https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-and-model-states.html
type AssetModelStatus struct {

	// The current state of the asset model.
	//
	// This member is required.
	State AssetModelState

	// Contains associated error information, if any.
	Error *ErrorDetails

	noSmithyDocumentSerde
}

// Contains a summary of an asset model.
type AssetModelSummary struct {

	// The [ARN] of the asset model, which has the following format.
	//
	//     arn:${Partition}:iotsitewise:${Region}:${Account}:asset-model/${AssetModelId}
	//
	// [ARN]: https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html
	//
	// This member is required.
	Arn *string

	// The date the asset model was created, in Unix epoch time.
	//
	// This member is required.
	CreationDate *time.Time

	// The asset model description.
	//
	// This member is required.
	Description *string

	// The ID of the asset model (used with IoT SiteWise API operations).
	//
	// This member is required.
	Id *string

	// The date the asset model was last updated, in Unix epoch time.
	//
	// This member is required.
	LastUpdateDate *time.Time

	// The name of the asset model.
	//
	// This member is required.
	Name *string

	// The current status of the asset model.
	//
	// This member is required.
	Status *AssetModelStatus

	// The type of asset model.
	//
	//   - ASSET_MODEL – (default) An asset model that you can use to create assets.
	//   Can't be included as a component in another asset model.
	//
	//   - COMPONENT_MODEL – A reusable component that you can include in the
	//   composite models of other asset models. You can't create assets directly from
	//   this type of asset model.
	AssetModelType AssetModelType

	// The external ID of the asset model. For more information, see [Using external IDs] in the IoT
	// SiteWise User Guide.
	//
	// [Using external IDs]: https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids
	ExternalId *string

	// The version number of the asset model.
	Version *string

	noSmithyDocumentSerde
}

// Contains asset property information.
type AssetProperty struct {

	// The data type of the asset property.
	//
	// This member is required.
	DataType PropertyDataType

	// The ID of the asset property.
	//
	// This member is required.
	Id *string

	// The name of the property.
	//
	// This member is required.
	Name *string

	// The alias that identifies the property, such as an OPC-UA server data stream
	// path (for example, /company/windfarm/3/turbine/7/temperature ). For more
	// information, see [Mapping industrial data streams to asset properties]in the IoT SiteWise User Guide.
	//
	// [Mapping industrial data streams to asset properties]: https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html
	Alias *string

	// The data type of the structure for this property. This parameter exists on
	// properties that have the STRUCT data type.
	DataTypeSpec *string

	// The external ID of the asset property. For more information, see [Using external IDs] in the IoT
	// SiteWise User Guide.
	//
	// [Using external IDs]: https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids
	ExternalId *string

	// The asset property's notification topic and state. For more information, see [UpdateAssetProperty].
	//
	// [UpdateAssetProperty]: https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html
	Notification *PropertyNotification

	// The structured path to the property from the root of the asset.
	Path []AssetPropertyPathSegment

	// The unit (such as Newtons or RPM ) of the asset property.
	Unit *string

	noSmithyDocumentSerde
}

// Represents one level between a property and the root of the asset.
type AssetPropertyPathSegment struct {

	// The ID of the path segment.
	Id *string

	// The name of the path segment.
	Name *string

	noSmithyDocumentSerde
}

// Contains a summary of a property associated with an asset.
type AssetPropertySummary struct {

	// The ID of the property.
	//
	// This member is required.
	Id *string

	// The alias that identifies the property, such as an OPC-UA server data stream
	// path (for example, /company/windfarm/3/turbine/7/temperature ). For more
	// information, see [Mapping industrial data streams to asset properties]in the IoT SiteWise User Guide.
	//
	// [Mapping industrial data streams to asset properties]: https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html
	Alias *string

	//  The ID of the composite model that contains the asset property.
	AssetCompositeModelId *string

	// The external ID of the property. For more information, see [Using external IDs] in the IoT SiteWise
	// User Guide.
	//
	// [Using external IDs]: https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids
	ExternalId *string

	// Contains asset property value notification information. When the notification
	// state is enabled, IoT SiteWise publishes property value updates to a unique MQTT
	// topic. For more information, see [Interacting with other services]in the IoT SiteWise User Guide.
	//
	// [Interacting with other services]: https://docs.aws.amazon.com/iot-sitewise/latest/userguide/interact-with-other-services.html
	Notification *PropertyNotification

	// The structured path to the property from the root of the asset.
	Path []AssetPropertyPathSegment

	//  The unit of measure (such as Newtons or RPM) of the asset property.
	Unit *string

	noSmithyDocumentSerde
}

// Contains asset property value information.
type AssetPropertyValue struct {

	// The timestamp of the asset property value.
	//
	// This member is required.
	Timestamp *TimeInNanos

	// The value of the asset property (see Variant ).
	//
	// This member is required.
	Value *Variant

	// The quality of the asset property value.
	Quality Quality

	noSmithyDocumentSerde
}

// Contains information about assets that are related to one another.
type AssetRelationshipSummary struct {

	// The relationship type of the assets in this relationship. This value is one of
	// the following:
	//
	//   - HIERARCHY – The assets are related through an asset hierarchy. If you
	//   specify this relationship type, this asset relationship includes the
	//   hierarchyInfo object.
	//
	// This member is required.
	RelationshipType AssetRelationshipType

	// The assets that are related through an asset hierarchy.
	//
	// This object is present if the relationshipType is HIERARCHY .
	HierarchyInfo *AssetHierarchyInfo

	noSmithyDocumentSerde
}

// Contains information about the current status of an asset. For more
// information, see [Asset and model states]in the IoT SiteWise User Guide.
//
// [Asset and model states]: https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-and-model-states.html
type AssetStatus struct {

	// The current status of the asset.
	//
	// This member is required.
	State AssetState

	// Contains associated error information, if any.
	Error *ErrorDetails

	noSmithyDocumentSerde
}

// Contains a summary of an asset.
type AssetSummary struct {

	// The [ARN] of the asset, which has the following format.
	//
	//     arn:${Partition}:iotsitewise:${Region}:${Account}:asset/${AssetId}
	//
	// [ARN]: https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html
	//
	// This member is required.
	Arn *string

	// The ID of the asset model used to create this asset.
	//
	// This member is required.
	AssetModelId *string

	// The date the asset was created, in Unix epoch time.
	//
	// This member is required.
	CreationDate *time.Time

	// A list of asset hierarchies that each contain a hierarchyId . A hierarchy
	// specifies allowed parent/child asset relationships.
	//
	// This member is required.
	Hierarchies []AssetHierarchy

	// The ID of the asset, in UUID format.
	//
	// This member is required.
	Id *string

	// The date the asset was last updated, in Unix epoch time.
	//
	// This member is required.
	LastUpdateDate *time.Time

	// The name of the asset.
	//
	// This member is required.
	Name *string

	// The current status of the asset.
	//
	// This member is required.
	Status *AssetStatus

	// A description for the asset.
	Description *string

	// The external ID of the asset. For more information, see [Using external IDs] in the IoT SiteWise
	// User Guide.
	//
	// [Using external IDs]: https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids
	ExternalId *string

	noSmithyDocumentSerde
}

// Contains a summary of an associated asset.
type AssociatedAssetsSummary struct {

	// The [ARN] of the asset, which has the following format.
	//
	//     arn:${Partition}:iotsitewise:${Region}:${Account}:asset/${AssetId}
	//
	// [ARN]: https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html
	//
	// This member is required.
	Arn *string

	// The ID of the asset model used to create the asset.
	//
	// This member is required.
	AssetModelId *string

	// The date the asset was created, in Unix epoch time.
	//
	// This member is required.
	CreationDate *time.Time

	// A list of asset hierarchies that each contain a hierarchyId . A hierarchy
	// specifies allowed parent/child asset relationships.
	//
	// This member is required.
	Hierarchies []AssetHierarchy

	// The ID of the asset, in UUID format.
	//
	// This member is required.
	Id *string

	// The date the asset was last updated, in Unix epoch time.
	//
	// This member is required.
	LastUpdateDate *time.Time

	// The name of the asset.
	//
	// This member is required.
	Name *string

	// The current status of the asset.
	//
	// This member is required.
	Status *AssetStatus

	// A description for the asset.
	Description *string

	// The external ID of the asset. For more information, see [Using external IDs] in the IoT SiteWise
	// User Guide.
	//
	// [Using external IDs]: https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids
	ExternalId *string

	noSmithyDocumentSerde
}

// Contains an asset attribute property. For more information, see [Attributes] in the IoT
// SiteWise User Guide.
//
// [Attributes]: https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-properties.html#attributes
type Attribute struct {

	// The default value of the asset model property attribute. All assets that you
	// create from the asset model contain this attribute value. You can update an
	// attribute's value after you create an asset. For more information, see [Updating attribute values]in the
	// IoT SiteWise User Guide.
	//
	// [Updating attribute values]: https://docs.aws.amazon.com/iot-sitewise/latest/userguide/update-attribute-values.html
	DefaultValue *string

	noSmithyDocumentSerde
}

// Contains information for an asset property aggregate entry that is associated
// with the [BatchGetAssetPropertyAggregates]API.
//
// To identify an asset property, you must specify one of the following:
//
//   - The assetId and propertyId of an asset property.
//
//   - A propertyAlias , which is a data stream alias (for example,
//     /company/windfarm/3/turbine/7/temperature ). To define an asset property's
//     alias, see [UpdateAssetProperty].
//
// [BatchGetAssetPropertyAggregates]: https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_BatchGetAssetPropertyAggregates.html
// [UpdateAssetProperty]: https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html
type BatchGetAssetPropertyAggregatesEntry struct {

	// The data aggregating function.
	//
	// This member is required.
	AggregateTypes []AggregateType

	// The inclusive end of the range from which to query historical data, expressed
	// in seconds in Unix epoch time.
	//
	// This member is required.
	EndDate *time.Time

	// The ID of the entry.
	//
	// This member is required.
	EntryId *string

	// The time interval over which to aggregate data.
	//
	// This member is required.
	Resolution *string

	// The exclusive start of the range from which to query historical data, expressed
	// in seconds in Unix epoch time.
	//
	// This member is required.
	StartDate *time.Time

	// The ID of the asset in which the asset property was created.
	AssetId *string

	// The alias that identifies the property, such as an OPC-UA server data stream
	// path (for example, /company/windfarm/3/turbine/7/temperature ). For more
	// information, see [Mapping industrial data streams to asset properties]in the IoT SiteWise User Guide.
	//
	// [Mapping industrial data streams to asset properties]: https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html
	PropertyAlias *string

	// The ID of the asset property, in UUID format.
	PropertyId *string

	// The quality by which to filter asset data.
	Qualities []Quality

	// The chronological sorting order of the requested information.
	//
	// Default: ASCENDING
	TimeOrdering TimeOrdering

	noSmithyDocumentSerde
}

// Contains error information for an asset property aggregate entry that is
// associated with the [BatchGetAssetPropertyAggregates]API.
//
// [BatchGetAssetPropertyAggregates]: https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_BatchGetAssetPropertyAggregates.html
type BatchGetAssetPropertyAggregatesErrorEntry struct {

	// The ID of the entry.
	//
	// This member is required.
	EntryId *string

	// The error code.
	//
	// This member is required.
	ErrorCode BatchGetAssetPropertyAggregatesErrorCode

	// The associated error message.
	//
	// This member is required.
	ErrorMessage *string

	noSmithyDocumentSerde
}

// Contains the error code and the timestamp for an asset property aggregate entry
// that is associated with the [BatchGetAssetPropertyAggregates]API.
//
// [BatchGetAssetPropertyAggregates]: https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_BatchGetAssetPropertyAggregates.html
type BatchGetAssetPropertyAggregatesErrorInfo struct {

	// The error code.
	//
	// This member is required.
	ErrorCode BatchGetAssetPropertyAggregatesErrorCode

	// The date the error occurred, in Unix epoch time.
	//
	// This member is required.
	ErrorTimestamp *time.Time

	noSmithyDocumentSerde
}

// Contains information for an entry that has been processed by the previous [BatchGetAssetPropertyAggregates]
// request.
//
// [BatchGetAssetPropertyAggregates]: https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_BatchGetAssetPropertyAggregates.html
type BatchGetAssetPropertyAggregatesSkippedEntry struct {

	// The completion status of each entry that is associated with the [BatchGetAssetPropertyAggregates] API.
	//
	// [BatchGetAssetPropertyAggregates]: https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_BatchGetAssetPropertyAggregates.html
	//
	// This member is required.
	CompletionStatus BatchEntryCompletionStatus

	// The ID of the entry.
	//
	// This member is required.
	EntryId *string

	// The error information, such as the error code and the timestamp.
	ErrorInfo *BatchGetAssetPropertyAggregatesErrorInfo

	noSmithyDocumentSerde
}

// Contains success information for an entry that is associated with the [BatchGetAssetPropertyAggregates] API.
//
// [BatchGetAssetPropertyAggregates]: https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_BatchGetAssetPropertyAggregates.html
type BatchGetAssetPropertyAggregatesSuccessEntry struct {

	// The requested aggregated asset property values (for example, average, minimum,
	// and maximum).
	//
	// This member is required.
	AggregatedValues []AggregatedValue

	// The ID of the entry.
	//
	// This member is required.
	EntryId *string

	noSmithyDocumentSerde
}

// Contains information for an asset property value entry that is associated with
// the [BatchGetAssetPropertyValue]API.
//
// To identify an asset property, you must specify one of the following:
//
//   - The assetId and propertyId of an asset property.
//
//   - A propertyAlias , which is a data stream alias (for example,
//     /company/windfarm/3/turbine/7/temperature ). To define an asset property's
//     alias, see [UpdateAssetProperty].
//
// [BatchGetAssetPropertyValue]: https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_BatchGetAssetPropertyValue.html
// [UpdateAssetProperty]: https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html
type BatchGetAssetPropertyValueEntry struct {

	// The ID of the entry.
	//
	// This member is required.
	EntryId *string

	// The ID of the asset in which the asset property was created.
	AssetId *string

	// The alias that identifies the property, such as an OPC-UA server data stream
	// path (for example, /company/windfarm/3/turbine/7/temperature ). For more
	// information, see [Mapping industrial data streams to asset properties]in the IoT SiteWise User Guide.
	//
	// [Mapping industrial data streams to asset properties]: https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html
	PropertyAlias *string

	// The ID of the asset property, in UUID format.
	PropertyId *string

	noSmithyDocumentSerde
}

// Contains error information for an asset property value entry that is associated
// with the [BatchGetAssetPropertyValue]API.
//
// [BatchGetAssetPropertyValue]: https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_BatchGetAssetPropertyValue.html
type BatchGetAssetPropertyValueErrorEntry struct {

	// The ID of the entry.
	//
	// This member is required.
	EntryId *string

	// The error code.
	//
	// This member is required.
	ErrorCode BatchGetAssetPropertyValueErrorCode

	// The associated error message.
	//
	// This member is required.
	ErrorMessage *string

	noSmithyDocumentSerde
}

// The error information, such as the error code and the timestamp.
type BatchGetAssetPropertyValueErrorInfo struct {

	// The error code.
	//
	// This member is required.
	ErrorCode BatchGetAssetPropertyValueErrorCode

	// The date the error occurred, in Unix epoch time.
	//
	// This member is required.
	ErrorTimestamp *time.Time

	noSmithyDocumentSerde
}

// Contains information for an asset property historical value entry that is
// associated with the [BatchGetAssetPropertyValueHistory]API.
//
// To identify an asset property, you must specify one of the following:
//
//   - The assetId and propertyId of an asset property.
//
//   - A propertyAlias , which is a data stream alias (for example,
//     /company/windfarm/3/turbine/7/temperature ). To define an asset property's
//     alias, see [UpdateAssetProperty].
//
// [UpdateAssetProperty]: https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html
// [BatchGetAssetPropertyValueHistory]: https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_BatchGetAssetPropertyValue.html
type BatchGetAssetPropertyValueHistoryEntry struct {

	// The ID of the entry.
	//
	// This member is required.
	EntryId *string

	// The ID of the asset in which the asset property was created.
	AssetId *string

	// The inclusive end of the range from which to query historical data, expressed
	// in seconds in Unix epoch time.
	EndDate *time.Time

	// The alias that identifies the property, such as an OPC-UA server data stream
	// path (for example, /company/windfarm/3/turbine/7/temperature ). For more
	// information, see [Mapping industrial data streams to asset properties]in the IoT SiteWise User Guide.
	//
	// [Mapping industrial data streams to asset properties]: https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html
	PropertyAlias *string

	// The ID of the asset property, in UUID format.
	PropertyId *string

	// The quality by which to filter asset data.
	Qualities []Quality

	// The exclusive start of the range from which to query historical data, expressed
	// in seconds in Unix epoch time.
	StartDate *time.Time

	// The chronological sorting order of the requested information.
	//
	// Default: ASCENDING
	TimeOrdering TimeOrdering

	noSmithyDocumentSerde
}

// A list of the errors (if any) associated with the batch request. Each error
// entry contains the entryId of the entry that failed.
type BatchGetAssetPropertyValueHistoryErrorEntry struct {

	// The ID of the entry.
	//
	// This member is required.
	EntryId *string

	// The error code.
	//
	// This member is required.
	ErrorCode BatchGetAssetPropertyValueHistoryErrorCode

	// The associated error message.
	//
	// This member is required.
	ErrorMessage *string

	noSmithyDocumentSerde
}

// The error information, such as the error code and the timestamp.
type BatchGetAssetPropertyValueHistoryErrorInfo struct {

	// The error code.
	//
	// This member is required.
	ErrorCode BatchGetAssetPropertyValueHistoryErrorCode

	// The date the error occurred, in Unix epoch time.
	//
	// This member is required.
	ErrorTimestamp *time.Time

	noSmithyDocumentSerde
}

// Contains information for an entry that has been processed by the previous [BatchGetAssetPropertyValueHistory]
// request.
//
// [BatchGetAssetPropertyValueHistory]: https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_BatchGetAssetPropertyValue.html
type BatchGetAssetPropertyValueHistorySkippedEntry struct {

	// The completion status of each entry that is associated with the [BatchGetAssetPropertyValueHistory] API.
	//
	// [BatchGetAssetPropertyValueHistory]: https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_BatchGetAssetPropertyValueHistory.html
	//
	// This member is required.
	CompletionStatus BatchEntryCompletionStatus

	// The ID of the entry.
	//
	// This member is required.
	EntryId *string

	// The error information, such as the error code and the timestamp.
	ErrorInfo *BatchGetAssetPropertyValueHistoryErrorInfo

	noSmithyDocumentSerde
}

// Contains success information for an entry that is associated with the [BatchGetAssetPropertyValueHistory] API.
//
// [BatchGetAssetPropertyValueHistory]: https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_BatchGetAssetPropertyValue.html
type BatchGetAssetPropertyValueHistorySuccessEntry struct {

	// The requested historical values for the specified asset property.
	//
	// This member is required.
	AssetPropertyValueHistory []AssetPropertyValue

	// The ID of the entry.
	//
	// This member is required.
	EntryId *string

	noSmithyDocumentSerde
}

// Contains information for an entry that has been processed by the previous [BatchGetAssetPropertyValue]
// request.
//
// [BatchGetAssetPropertyValue]: https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_BatchGetAssetPropertyValue.html
type BatchGetAssetPropertyValueSkippedEntry struct {

	// The completion status of each entry that is associated with the [BatchGetAssetPropertyValue] request.
	//
	// [BatchGetAssetPropertyValue]: https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_BatchGetAssetPropertyValue.html
	//
	// This member is required.
	CompletionStatus BatchEntryCompletionStatus

	// The ID of the entry.
	//
	// This member is required.
	EntryId *string

	// The error information, such as the error code and the timestamp.
	ErrorInfo *BatchGetAssetPropertyValueErrorInfo

	noSmithyDocumentSerde
}

// Contains success information for an entry that is associated with the [BatchGetAssetPropertyValue] API.
//
// [BatchGetAssetPropertyValue]: https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_BatchGetAssetPropertyValue.html
type BatchGetAssetPropertyValueSuccessEntry struct {

	// The ID of the entry.
	//
	// This member is required.
	EntryId *string

	// Contains asset property value information.
	AssetPropertyValue *AssetPropertyValue

	noSmithyDocumentSerde
}

// Contains error information from updating a batch of asset property values.
type BatchPutAssetPropertyError struct {

	// The error code.
	//
	// This member is required.
	ErrorCode BatchPutAssetPropertyValueErrorCode

	// The associated error message.
	//
	// This member is required.
	ErrorMessage *string

	// A list of timestamps for each error, if any.
	//
	// This member is required.
	Timestamps []TimeInNanos

	noSmithyDocumentSerde
}

// Contains error information for asset property value entries that are associated
// with the [BatchPutAssetPropertyValue]API.
//
// [BatchPutAssetPropertyValue]: https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_BatchPutAssetPropertyValue.html
type BatchPutAssetPropertyErrorEntry struct {

	// The ID of the failed entry.
	//
	// This member is required.
	EntryId *string

	// The list of update property value errors.
	//
	// This member is required.
	Errors []BatchPutAssetPropertyError

	noSmithyDocumentSerde
}

// Contains text content to which the SiteWise Assistant refers to, and generate
// the final response. It also contains information about the source.
type Citation struct {

	// Contains the cited text from the data source.
	Content *Content

	// Contains information about the data source.
	Reference *Reference

	noSmithyDocumentSerde
}

// A description of the column in the query results.
type ColumnInfo struct {

	// The name of the column description.
	Name *string

	// The type of the column description.
	Type *ColumnType

	noSmithyDocumentSerde
}

// The data type of the column.
type ColumnType struct {

	// The allowed data types that the column has as it's value.
	ScalarType ScalarType

	noSmithyDocumentSerde
}

// Contains information about a composite model property on an asset.
type CompositeModelProperty struct {

	// Contains asset property information.
	//
	// This member is required.
	AssetProperty *Property

	// The name of the property.
	//
	// This member is required.
	Name *string

	// The type of the composite model that defines this property.
	//
	// This member is required.
	Type *string

	// The external ID of the composite model that contains the property. For more
	// information, see [Using external IDs]in the IoT SiteWise User Guide.
	//
	// [Using external IDs]: https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids
	ExternalId *string

	//  The ID of the composite model that contains the property.
	Id *string

	noSmithyDocumentSerde
}

// Metadata for the composition relationship established by using
// composedAssetModelId in [CreateAssetModelCompositeModel]CreateAssetModelCompositeModel .
//
// [CreateAssetModelCompositeModel]: https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_CreateAssetModelCompositeModel.html
type CompositionDetails struct {

	// An array detailing the composition relationship for this composite model.
	CompositionRelationship []CompositionRelationshipItem

	noSmithyDocumentSerde
}

// Represents a composite model that composed an asset model of type
// COMPONENT_MODEL .
type CompositionRelationshipItem struct {

	// The ID of the component.
	Id *string

	noSmithyDocumentSerde
}

// Contains a summary of the components of the composite model.
type CompositionRelationshipSummary struct {

	// The ID of a composite model on this asset model.
	//
	// This member is required.
	AssetModelCompositeModelId *string

	// The composite model type. Valid values are AWS/ALARM , CUSTOM , or
	// AWS/L4E_ANOMALY .
	//
	// This member is required.
	AssetModelCompositeModelType *string

	// The ID of the asset model, in UUID format.
	//
	// This member is required.
	AssetModelId *string

	noSmithyDocumentSerde
}

// Contains the details of an IoT SiteWise configuration error.
type ConfigurationErrorDetails struct {

	// The error code.
	//
	// This member is required.
	Code ErrorCode

	// The error message.
	//
	// This member is required.
	Message *string

	noSmithyDocumentSerde
}

// Contains current status information for the configuration.
type ConfigurationStatus struct {

	// The current state of the configuration.
	//
	// This member is required.
	State ConfigurationState

	// Contains associated error information, if any.
	Error *ConfigurationErrorDetails

	noSmithyDocumentSerde
}

// Contains the cited text from the data source.
type Content struct {

	// The cited text from the data source.
	Text *string

	noSmithyDocumentSerde
}

// A .CSV file.
type Csv struct {

	// The column names specified in the .csv file.
	//
	// This member is required.
	ColumnNames []ColumnName

	noSmithyDocumentSerde
}

// Contains information about a customer managed Amazon S3 bucket.
type CustomerManagedS3Storage struct {

	// The [ARN] of the Identity and Access Management role that allows IoT SiteWise to
	// send data to Amazon S3.
	//
	// [ARN]: https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html
	//
	// This member is required.
	RoleArn *string

	// The [ARN] of the Amazon S3 object. For more information about how to find the ARN
	// for an Amazon S3 object, see [Amazon S3 resources]in the Amazon Simple Storage Service User Guide.
	//
	// [Amazon S3 resources]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-arn-format.html
	// [ARN]: https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html
	//
	// This member is required.
	S3ResourceArn *string

	noSmithyDocumentSerde
}

// Contains a dashboard summary.
type DashboardSummary struct {

	// The ID of the dashboard.
	//
	// This member is required.
	Id *string

	// The name of the dashboard
	//
	// This member is required.
	Name *string

	// The date the dashboard was created, in Unix epoch time.
	CreationDate *time.Time

	// The dashboard's description.
	Description *string

	// The date the dashboard was last updated, in Unix epoch time.
	LastUpdateDate *time.Time

	noSmithyDocumentSerde
}

// Contains information about the dataset use and it's source.
type DataSetReference struct {

	// The [ARN] of the dataset. The format is
	// arn:${Partition}:iotsitewise:${Region}:${Account}:dataset/${DatasetId} .
	//
	// [ARN]: https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html
	DatasetArn *string

	// The data source for the dataset.
	Source *Source

	noSmithyDocumentSerde
}

// The data source for the dataset.
type DatasetSource struct {

	// The format of the dataset source associated with the dataset.
	//
	// This member is required.
	SourceFormat DatasetSourceFormat

	// The type of data source for the dataset.
	//
	// This member is required.
	SourceType DatasetSourceType

	// The details of the dataset source associated with the dataset.
	SourceDetail *SourceDetail

	noSmithyDocumentSerde
}

// The status of the dataset. This contains the state and any error messages. The
// state is ACTIVE when ready to use.
type DatasetStatus struct {

	// The current status of the dataset.
	//
	// This member is required.
	State DatasetState

	// Contains the details of an IoT SiteWise error.
	Error *ErrorDetails

	noSmithyDocumentSerde
}

// The summary details for the dataset.
type DatasetSummary struct {

	// The [ARN] of the dataset. The format is
	// arn:${Partition}:iotsitewise:${Region}:${Account}:dataset/${DatasetId} .
	//
	// [ARN]: https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html
	//
	// This member is required.
	Arn *string

	// The dataset creation date, in Unix epoch time.
	//
	// This member is required.
	CreationDate *time.Time

	// A description about the dataset, and its functionality.
	//
	// This member is required.
	Description *string

	// The ID of the dataset.
	//
	// This member is required.
	Id *string

	// The date the dataset was last updated, in Unix epoch time.
	//
	// This member is required.
	LastUpdateDate *time.Time

	// The name of the dataset.
	//
	// This member is required.
	Name *string

	// The status of the dataset. This contains the state and any error messages. The
	// state is ACTIVE when ready to use.
	//
	// This member is required.
	Status *DatasetStatus

	noSmithyDocumentSerde
}

// Represents a single data point in a query result.
type Datum struct {

	// Indicates if the data point is an array.
	ArrayValue []Datum

	// Indicates if the data point is null.
	NullValue *bool

	// Indicates if the data point is a row.
	RowValue *Row

	// Indicates if the data point is a scalar value such as integer, string, double,
	// or Boolean.
	ScalarValue *string

	noSmithyDocumentSerde
}

// Contains detailed error information.
type DetailedError struct {

	// The error code.
	//
	// This member is required.
	Code DetailedErrorCode

	// The error message.
	//
	// This member is required.
	Message *string

	noSmithyDocumentSerde
}

// Contains the details of an IoT SiteWise error.
type ErrorDetails struct {

	// The error code.
	//
	// This member is required.
	Code ErrorCode

	// The error message.
	//
	// This member is required.
	Message *string

	//  A list of detailed errors.
	Details []DetailedError

	noSmithyDocumentSerde
}

// The Amazon S3 destination where errors associated with the job creation request
// are saved.
type ErrorReportLocation struct {

	// The name of the Amazon S3 bucket to which errors associated with the bulk
	// import job are sent.
	//
	// This member is required.
	Bucket *string

	// Amazon S3 uses the prefix as a folder name to organize data in the bucket. Each
	// Amazon S3 object has a key that is its unique identifier in the bucket. Each
	// object in a bucket has exactly one key. The prefix must end with a forward slash
	// (/). For more information, see [Organizing objects using prefixes]in the Amazon Simple Storage Service User Guide.
	//
	// [Organizing objects using prefixes]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-prefixes.html
	//
	// This member is required.
	Prefix *string

	noSmithyDocumentSerde
}

// Contains expression variable information.
type ExpressionVariable struct {

	// The friendly name of the variable to be used in the expression.
	//
	// This member is required.
	Name *string

	// The variable that identifies an asset property from which to use values.
	//
	// This member is required.
	Value *VariableValue

	noSmithyDocumentSerde
}

// The file in Amazon S3 where your data is saved.
type File struct {

	// The name of the Amazon S3 bucket from which data is imported.
	//
	// This member is required.
	Bucket *string

	// The key of the Amazon S3 object that contains your data. Each object has a key
	// that is a unique identifier. Each object has exactly one key.
	//
	// This member is required.
	Key *string

	// The version ID to identify a specific version of the Amazon S3 object that
	// contains your data.
	VersionId *string

	noSmithyDocumentSerde
}

// The file format of the data in S3.
type FileFormat struct {

	// The file is in .CSV format.
	Csv *Csv

	// The file is in parquet format.
	Parquet *Parquet

	noSmithyDocumentSerde
}

// The forwarding configuration for a given property.
type ForwardingConfig struct {

	// The forwarding state for the given property.
	//
	// This member is required.
	State ForwardingConfigState

	noSmithyDocumentSerde
}

// Contains a summary of a gateway capability configuration.
type GatewayCapabilitySummary struct {

	// The namespace of the capability configuration. For example, if you configure
	// OPC-UA sources from the IoT SiteWise console, your OPC-UA capability
	// configuration has the namespace iotsitewise:opcuacollector:version , where
	// version is a number such as 1 .
	//
	// This member is required.
	CapabilityNamespace *string

	// The synchronization status of the capability configuration. The sync status can
	// be one of the following:
	//
	//   - IN_SYNC – The gateway is running the capability configuration.
	//
	//   - NOT_APPLICABLE – Synchronization is not required for this capability
	//   configuration. This is most common when integrating partner data sources,
	//   because the data integration is handled externally by the partner.
	//
	//   - OUT_OF_SYNC – The gateway hasn't received the capability configuration.
	//
	//   - SYNC_FAILED – The gateway rejected the capability configuration.
	//
	//   - UNKNOWN – The synchronization status is currently unknown due to an
	//   undetermined or temporary error.
	//
	// This member is required.
	CapabilitySyncStatus CapabilitySyncStatus

	noSmithyDocumentSerde
}

// Contains a gateway's platform information.
type GatewayPlatform struct {

	// A gateway that runs on IoT Greengrass.
	Greengrass *Greengrass

	// A gateway that runs on IoT Greengrass V2.
	GreengrassV2 *GreengrassV2

	// A SiteWise Edge gateway that runs on a Siemens Industrial Edge Device.
	SiemensIE *SiemensIE

	noSmithyDocumentSerde
}

// Contains a summary of a gateway.
type GatewaySummary struct {

	// The date the gateway was created, in Unix epoch time.
	//
	// This member is required.
	CreationDate *time.Time

	// The ID of the gateway device.
	//
	// This member is required.
	GatewayId *string

	// The name of the gateway.
	//
	// This member is required.
	GatewayName *string

	// The date the gateway was last updated, in Unix epoch time.
	//
	// This member is required.
	LastUpdateDate *time.Time

	// A list of gateway capability summaries that each contain a namespace and
	// status. Each gateway capability defines data sources for the gateway. To
	// retrieve a capability configuration's definition, use [DescribeGatewayCapabilityConfiguration].
	//
	// [DescribeGatewayCapabilityConfiguration]: https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeGatewayCapabilityConfiguration.html
	GatewayCapabilitySummaries []GatewayCapabilitySummary

	// Contains a gateway's platform information.
	GatewayPlatform *GatewayPlatform

	noSmithyDocumentSerde
}

// Contains details for a gateway that runs on IoT Greengrass. To create a gateway
// that runs on IoT Greengrass, you must add the IoT SiteWise connector to a
// Greengrass group and deploy it. Your Greengrass group must also have permissions
// to upload data to IoT SiteWise. For more information, see [Ingesting data using a gateway]in the IoT SiteWise
// User Guide.
//
// [Ingesting data using a gateway]: https://docs.aws.amazon.com/iot-sitewise/latest/userguide/gateway-connector.html
type Greengrass struct {

	// The [ARN] of the Greengrass group. For more information about how to find a group's
	// ARN, see [ListGroups]and [GetGroup] in the IoT Greengrass V1 API Reference.
	//
	// [GetGroup]: https://docs.aws.amazon.com/greengrass/v1/apireference/getgroup-get.html
	// [ListGroups]: https://docs.aws.amazon.com/greengrass/v1/apireference/listgroups-get.html
	// [ARN]: https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html
	//
	// This member is required.
	GroupArn *string

	noSmithyDocumentSerde
}

// Contains details for a gateway that runs on IoT Greengrass V2. To create a
// gateway that runs on IoT Greengrass V2, you must deploy the IoT SiteWise Edge
// component to your gateway device. Your [Greengrass device role]must use the AWSIoTSiteWiseEdgeAccess
// policy. For more information, see [Using IoT SiteWise at the edge]in the IoT SiteWise User Guide.
//
// [Using IoT SiteWise at the edge]: https://docs.aws.amazon.com/iot-sitewise/latest/userguide/sw-gateways.html
// [Greengrass device role]: https://docs.aws.amazon.com/greengrass/v2/developerguide/device-service-role.html
type GreengrassV2 struct {

	// The name of the IoT thing for your IoT Greengrass V2 core device.
	//
	// This member is required.
	CoreDeviceThingName *string

	noSmithyDocumentSerde
}

// Contains information for a group identity in an access policy.
type GroupIdentity struct {

	// The IAM Identity Center ID of the group.
	//
	// This member is required.
	Id *string

	noSmithyDocumentSerde
}

// Contains information about an Identity and Access Management role. For more
// information, see [IAM roles]in the IAM User Guide.
//
// [IAM roles]: https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles.html
type IAMRoleIdentity struct {

	// The ARN of the IAM role. For more information, see [IAM ARNs] in the IAM User Guide.
	//
	// [IAM ARNs]: https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html
	//
	// This member is required.
	Arn *string

	noSmithyDocumentSerde
}

// Contains information about an Identity and Access Management user.
type IAMUserIdentity struct {

	// The ARN of the IAM user. For more information, see [IAM ARNs] in the IAM User Guide.
	//
	// If you delete the IAM user, access policies that contain this identity include
	// an empty arn . You can delete the access policy for the IAM user that no longer
	// exists.
	//
	// [IAM ARNs]: https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html
	//
	// This member is required.
	Arn *string

	noSmithyDocumentSerde
}

// Contains an identity that can access an IoT SiteWise Monitor resource.
//
// Currently, you can't use Amazon Web Services API operations to retrieve IAM
// Identity Center identity IDs. You can find the IAM Identity Center identity IDs
// in the URL of user and group pages in the [IAM Identity Center console].
//
// [IAM Identity Center console]: https://console.aws.amazon.com/singlesignon
type Identity struct {

	// An IAM Identity Center group identity.
	Group *GroupIdentity

	// An IAM role identity.
	IamRole *IAMRoleIdentity

	// An IAM user identity.
	IamUser *IAMUserIdentity

	// An IAM Identity Center user identity.
	User *UserIdentity

	noSmithyDocumentSerde
}

// Contains an image that is one of the following:
//
//   - An image file. Choose this option to upload a new image.
//
//   - The ID of an existing image. Choose this option to keep an existing image.
type Image struct {

	// Contains an image file.
	File *ImageFile

	// The ID of an existing image. Specify this parameter to keep an existing image.
	Id *string

	noSmithyDocumentSerde
}

// Contains an image file.
type ImageFile struct {

	// The image file contents, represented as a base64-encoded string. The file size
	// must be less than 1 MB.
	//
	// This member is required.
	Data []byte

	// The file type of the image.
	//
	// This member is required.
	Type ImageFileType

	noSmithyDocumentSerde
}

// Contains an image that is uploaded to IoT SiteWise and available at a URL.
type ImageLocation struct {

	// The ID of the image.
	//
	// This member is required.
	Id *string

	// The URL where the image is available. The URL is valid for 15 minutes so that
	// you can view and download the image
	//
	// This member is required.
	Url *string

	noSmithyDocumentSerde
}

// Contains information about an interpolated asset property value.
type InterpolatedAssetPropertyValue struct {

	// Contains a timestamp with optional nanosecond granularity.
	//
	// This member is required.
	Timestamp *TimeInNanos

	// Contains an asset property value (of a single type only).
	//
	// This member is required.
	Value *Variant

	noSmithyDocumentSerde
}

// This contains the SiteWise Assistant's response and the corresponding citation.
type InvocationOutput struct {

	// A list of citations, and related information for the SiteWise Assistant's
	// response.
	Citations []Citation

	// The text message of the SiteWise Assistant's response.
	Message *string

	noSmithyDocumentSerde
}

// Contains the configuration information of a job, such as the file format used
// to save data in Amazon S3.
type JobConfiguration struct {

	// The file format of the data in S3.
	//
	// This member is required.
	FileFormat *FileFormat

	noSmithyDocumentSerde
}

// Contains the job summary information.
type JobSummary struct {

	// The ID of the job.
	//
	// This member is required.
	Id *string

	// The unique name that helps identify the job request.
	//
	// This member is required.
	Name *string

	// The status of the bulk import job can be one of following values:
	//
	//   - PENDING – IoT SiteWise is waiting for the current bulk import job to finish.
	//
	//   - CANCELLED – The bulk import job has been canceled.
	//
	//   - RUNNING – IoT SiteWise is processing your request to import your data from
	//   Amazon S3.
	//
	//   - COMPLETED – IoT SiteWise successfully completed your request to import data
	//   from Amazon S3.
	//
	//   - FAILED – IoT SiteWise couldn't process your request to import data from
	//   Amazon S3. You can use logs saved in the specified error report location in
	//   Amazon S3 to troubleshoot issues.
	//
	//   - COMPLETED_WITH_FAILURES – IoT SiteWise completed your request to import data
	//   from Amazon S3 with errors. You can use logs saved in the specified error report
	//   location in Amazon S3 to troubleshoot issues.
	//
	// This member is required.
	Status JobStatus

	noSmithyDocumentSerde
}

// The source details for the Kendra dataset source.
type KendraSourceDetail struct {

	// The knowledgeBaseArn details for the Kendra dataset source.
	//
	// This member is required.
	KnowledgeBaseArn *string

	// The roleARN details for the Kendra dataset source.
	//
	// This member is required.
	RoleArn *string

	noSmithyDocumentSerde
}

// Contains location information about the cited text and where it's stored.
type Location struct {

	// The URI of the location.
	Uri *string

	noSmithyDocumentSerde
}

// Contains logging options.
type LoggingOptions struct {

	// The IoT SiteWise logging verbosity level.
	//
	// This member is required.
	Level LoggingLevel

	noSmithyDocumentSerde
}

// Contains an asset measurement property. For more information, see [Measurements] in the IoT
// SiteWise User Guide.
//
// [Measurements]: https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-properties.html#measurements
type Measurement struct {

	// The processing configuration for the given measurement property. You can
	// configure measurements to be kept at the edge or forwarded to the Amazon Web
	// Services Cloud. By default, measurements are forwarded to the cloud.
	ProcessingConfig *MeasurementProcessingConfig

	noSmithyDocumentSerde
}

// The processing configuration for the given measurement property. You can
// configure measurements to be kept at the edge or forwarded to the Amazon Web
// Services Cloud. By default, measurements are forwarded to the cloud.
type MeasurementProcessingConfig struct {

	// The forwarding configuration for the given measurement property.
	//
	// This member is required.
	ForwardingConfig *ForwardingConfig

	noSmithyDocumentSerde
}

// Contains an asset metric property. With metrics, you can calculate aggregate
// functions, such as an average, maximum, or minimum, as specified through an
// expression. A metric maps several values to a single value (such as a sum).
//
// The maximum number of dependent/cascading variables used in any one metric
// calculation is 10. Therefore, a root metric can have up to 10 cascading metrics
// in its computational dependency tree. Additionally, a metric can only have a
// data type of DOUBLE and consume properties with data types of INTEGER or DOUBLE .
//
// For more information, see [Metrics] in the IoT SiteWise User Guide.
//
// [Metrics]: https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-properties.html#metrics
type Metric struct {

	// The mathematical expression that defines the metric aggregation function. You
	// can specify up to 10 variables per expression. You can specify up to 10
	// functions per expression.
	//
	// For more information, see [Quotas] in the IoT SiteWise User Guide.
	//
	// [Quotas]: https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html
	//
	// This member is required.
	Expression *string

	// The list of variables used in the expression.
	//
	// This member is required.
	Variables []ExpressionVariable

	// The window (time interval) over which IoT SiteWise computes the metric's
	// aggregation expression. IoT SiteWise computes one data point per window .
	//
	// This member is required.
	Window *MetricWindow

	// The processing configuration for the given metric property. You can configure
	// metrics to be computed at the edge or in the Amazon Web Services Cloud. By
	// default, metrics are forwarded to the cloud.
	ProcessingConfig *MetricProcessingConfig

	noSmithyDocumentSerde
}

// The processing configuration for the given metric property. You can configure
// metrics to be computed at the edge or in the Amazon Web Services Cloud. By
// default, metrics are forwarded to the cloud.
type MetricProcessingConfig struct {

	// The compute location for the given metric property.
	//
	// This member is required.
	ComputeLocation ComputeLocation

	noSmithyDocumentSerde
}

// Contains a time interval window used for data aggregate computations (for
// example, average, sum, count, and so on).
type MetricWindow struct {

	// The tumbling time interval window.
	Tumbling *TumblingWindow

	noSmithyDocumentSerde
}

// Contains IoT SiteWise Monitor error details.
type MonitorErrorDetails struct {

	// The error code.
	Code MonitorErrorCode

	// The error message.
	Message *string

	noSmithyDocumentSerde
}

// Contains information about the storage destination.
type MultiLayerStorage struct {

	// Contains information about a customer managed Amazon S3 bucket.
	//
	// This member is required.
	CustomerManagedS3Storage *CustomerManagedS3Storage

	noSmithyDocumentSerde
}

// A parquet file.
type Parquet struct {
	noSmithyDocumentSerde
}

// Identifies an IoT SiteWise Monitor portal.
type PortalResource struct {

	// The ID of the portal.
	//
	// This member is required.
	Id *string

	noSmithyDocumentSerde
}

// Contains information about the current status of a portal.
type PortalStatus struct {

	// The current state of the portal.
	//
	// This member is required.
	State PortalState

	// Contains associated error information, if any.
	Error *MonitorErrorDetails

	noSmithyDocumentSerde
}

// Contains a portal summary.
type PortalSummary struct {

	// The ID of the portal.
	//
	// This member is required.
	Id *string

	// The name of the portal.
	//
	// This member is required.
	Name *string

	// The URL for the IoT SiteWise Monitor portal. You can use this URL to access
	// portals that use IAM Identity Center for authentication. For portals that use
	// IAM for authentication, you must use the IoT SiteWise console to get a URL that
	// you can use to access the portal.
	//
	// This member is required.
	StartUrl *string

	// Contains information about the current status of a portal.
	//
	// This member is required.
	Status *PortalStatus

	// The date the portal was created, in Unix epoch time.
	CreationDate *time.Time

	// The portal's description.
	Description *string

	// The date the portal was last updated, in Unix epoch time.
	LastUpdateDate *time.Time

	// Define the type of portal. The value for IoT SiteWise Monitor (Classic) is
	// SITEWISE_PORTAL_V1 . The value for IoT SiteWise Monitor (AI-aware) is
	// SITEWISE_PORTAL_V2 .
	PortalType PortalType

	// The [ARN] of the service role that allows the portal's users to access your IoT
	// SiteWise resources on your behalf. For more information, see [Using service roles for IoT SiteWise Monitor]in the IoT
	// SiteWise User Guide.
	//
	// [Using service roles for IoT SiteWise Monitor]: https://docs.aws.amazon.com/iot-sitewise/latest/userguide/monitor-service-role.html
	// [ARN]: https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html
	RoleArn *string

	noSmithyDocumentSerde
}

// The configuration entry associated with the specific portal type. The
// portalTypeConfiguration is a map of the portalTypeKey to the PortalTypeEntry .
type PortalTypeEntry struct {

	// The array of tools associated with the specified portal type. The possible
	// values are ASSISTANT and DASHBOARD .
	PortalTools []string

	noSmithyDocumentSerde
}

// Identifies a specific IoT SiteWise Monitor project.
type ProjectResource struct {

	// The ID of the project.
	//
	// This member is required.
	Id *string

	noSmithyDocumentSerde
}

// Contains project summary information.
type ProjectSummary struct {

	// The ID of the project.
	//
	// This member is required.
	Id *string

	// The name of the project.
	//
	// This member is required.
	Name *string

	// The date the project was created, in Unix epoch time.
	CreationDate *time.Time

	// The project's description.
	Description *string

	// The date the project was last updated, in Unix epoch time.
	LastUpdateDate *time.Time

	noSmithyDocumentSerde
}

// Contains asset property information.
type Property struct {

	// The property data type.
	//
	// This member is required.
	DataType PropertyDataType

	// The ID of the asset property.
	//
	// This member is required.
	Id *string

	// The name of the property.
	//
	// This member is required.
	Name *string

	// The alias that identifies the property, such as an OPC-UA server data stream
	// path (for example, /company/windfarm/3/turbine/7/temperature ). For more
	// information, see [Mapping industrial data streams to asset properties]in the IoT SiteWise User Guide.
	//
	// [Mapping industrial data streams to asset properties]: https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html
	Alias *string

	// The external ID of the asset property. For more information, see [Using external IDs] in the IoT
	// SiteWise User Guide.
	//
	// [Using external IDs]: https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids
	ExternalId *string

	// The asset property's notification topic and state. For more information, see [UpdateAssetProperty].
	//
	// [UpdateAssetProperty]: https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html
	Notification *PropertyNotification

	// The structured path to the property from the root of the asset.
	Path []AssetPropertyPathSegment

	// The property type (see PropertyType ). A property contains one type.
	Type *PropertyType

	// The unit (such as Newtons or RPM ) of the asset property.
	Unit *string

	noSmithyDocumentSerde
}

// Contains asset property value notification information. When the notification
// state is enabled, IoT SiteWise publishes property value updates to a unique MQTT
// topic. For more information, see [Interacting with other services]in the IoT SiteWise User Guide.
//
// [Interacting with other services]: https://docs.aws.amazon.com/iot-sitewise/latest/userguide/interact-with-other-services.html
type PropertyNotification struct {

	// The current notification state.
	//
	// This member is required.
	State PropertyNotificationState

	// The MQTT topic to which IoT SiteWise publishes property value update
	// notifications.
	//
	// This member is required.
	Topic *string

	noSmithyDocumentSerde
}

// Contains a property type, which can be one of attribute , measurement , metric ,
// or transform .
type PropertyType struct {

	// Specifies an asset attribute property. An attribute generally contains static
	// information, such as the serial number of an [IIoT]wind turbine.
	//
	// [IIoT]: https://en.wikipedia.org/wiki/Internet_of_things#Industrial_applications
	Attribute *Attribute

	// Specifies an asset measurement property. A measurement represents a device's
	// raw sensor data stream, such as timestamped temperature values or timestamped
	// power values.
	Measurement *Measurement

	// Specifies an asset metric property. A metric contains a mathematical expression
	// that uses aggregate functions to process all input data points over a time
	// interval and output a single data point, such as to calculate the average hourly
	// temperature.
	Metric *Metric

	// Specifies an asset transform property. A transform contains a mathematical
	// expression that maps a property's data points from one form to another, such as
	// a unit conversion from Celsius to Fahrenheit.
	Transform *Transform

	noSmithyDocumentSerde
}

// The value type of null asset property data with BAD and UNCERTAIN qualities.
type PropertyValueNullValue struct {

	// The type of null asset property data.
	//
	// This member is required.
	ValueType RawValueType

	noSmithyDocumentSerde
}

// Contains a list of value updates for an asset property in the list of asset
// entries consumed by the [BatchPutAssetPropertyValue]API operation.
//
// [BatchPutAssetPropertyValue]: https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_BatchPutAssetPropertyValue.html
type PutAssetPropertyValueEntry struct {

	// The user specified ID for the entry. You can use this ID to identify which
	// entries failed.
	//
	// This member is required.
	EntryId *string

	// The list of property values to upload. You can specify up to 10 propertyValues
	// array elements.
	//
	// This member is required.
	PropertyValues []AssetPropertyValue

	// The ID of the asset to update.
	AssetId *string

	// The alias that identifies the property, such as an OPC-UA server data stream
	// path (for example, /company/windfarm/3/turbine/7/temperature ). For more
	// information, see [Mapping industrial data streams to asset properties]in the IoT SiteWise User Guide.
	//
	// [Mapping industrial data streams to asset properties]: https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html
	PropertyAlias *string

	// The ID of the asset property for this entry.
	PropertyId *string

	noSmithyDocumentSerde
}

// Contains the reference information.
type Reference struct {

	// Contains the dataset reference information.
	Dataset *DataSetReference

	noSmithyDocumentSerde
}

// Contains an IoT SiteWise Monitor resource ID for a portal or project.
type Resource struct {

	// A portal resource.
	Portal *PortalResource

	// A project resource.
	Project *ProjectResource

	noSmithyDocumentSerde
}

// Contains the response, citation, and trace from the SiteWise Assistant.
//
// The following types satisfy this interface:
//
//	ResponseStreamMemberOutput
//	ResponseStreamMemberTrace
type ResponseStream interface {
	isResponseStream()
}

// Contains the SiteWise Assistant's response.
type ResponseStreamMemberOutput struct {
	Value InvocationOutput

	noSmithyDocumentSerde
}

func (*ResponseStreamMemberOutput) isResponseStream() {}

// Contains tracing information of the SiteWise Assistant's reasoning and data
// access.
type ResponseStreamMemberTrace struct {
	Value Trace

	noSmithyDocumentSerde
}

func (*ResponseStreamMemberTrace) isResponseStream() {}

// The number of days your data is kept in the hot tier. By default, your data is
// kept indefinitely in the hot tier.
type RetentionPeriod struct {

	// The number of days that your data is kept.
	//
	// If you specified a value for this parameter, the unlimited parameter must be
	// false .
	NumberOfDays *int32

	// If true, your data is kept indefinitely.
	//
	// If configured to true , you must not specify a value for the numberOfDays
	// parameter.
	Unlimited *bool

	noSmithyDocumentSerde
}

// Represents a single row in the query results.
type Row struct {

	// List of data points in a single row of the result set.
	//
	// This member is required.
	Data []Datum

	noSmithyDocumentSerde
}

// Contains details for a SiteWise Edge gateway that runs on a Siemens Industrial
// Edge Device.
type SiemensIE struct {

	// The name of the IoT Thing for your SiteWise Edge gateway.
	//
	// This member is required.
	IotCoreThingName *string

	noSmithyDocumentSerde
}

// The data source for the dataset.
type Source struct {

	// Contains the ARN of the dataset. If the source is Kendra, it's the ARN of the
	// Kendra index.
	Arn *string

	// Contains the location information where the cited text is originally stored.
	// For example, if the data source is Kendra, and the text synchronized is from an
	// S3 bucket, then the location refers to an S3 object.
	Location *Location

	noSmithyDocumentSerde
}

// The details of the dataset source associated with the dataset.
type SourceDetail struct {

	// Contains details about the Kendra dataset source.
	Kendra *KendraSourceDetail

	noSmithyDocumentSerde
}

// The resource the action will be taken on.
type TargetResource struct {

	// The ID of the asset, in UUID format.
	//
	// This member is required.
	AssetId *string

	noSmithyDocumentSerde
}

// Contains a timestamp with optional nanosecond granularity.
type TimeInNanos struct {

	// The timestamp date, in seconds, in the Unix epoch format. Fractional nanosecond
	// data is provided by offsetInNanos .
	//
	// This member is required.
	TimeInSeconds *int64

	// The nanosecond offset from timeInSeconds .
	OffsetInNanos *int32

	noSmithyDocumentSerde
}

// Contains a summary of a time series (data stream).
type TimeSeriesSummary struct {

	// The data type of the time series.
	//
	// If you specify STRUCT , you must also specify dataTypeSpec to identify the type
	// of the structure for this time series.
	//
	// This member is required.
	DataType PropertyDataType

	// The [ARN] of the time series, which has the following format.
	//
	//     arn:${Partition}:iotsitewise:${Region}:${Account}:time-series/${TimeSeriesId}
	//
	// [ARN]: https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html
	//
	// This member is required.
	TimeSeriesArn *string

	// The date that the time series was created, in Unix epoch time.
	//
	// This member is required.
	TimeSeriesCreationDate *time.Time

	// The ID of the time series.
	//
	// This member is required.
	TimeSeriesId *string

	// The date that the time series was last updated, in Unix epoch time.
	//
	// This member is required.
	TimeSeriesLastUpdateDate *time.Time

	// The alias that identifies the time series.
	Alias *string

	// The ID of the asset in which the asset property was created.
	AssetId *string

	// The data type of the structure for this time series. This parameter is required
	// for time series that have the STRUCT data type.
	//
	// The options for this parameter depend on the type of the composite model in
	// which you created the asset property that is associated with your time series.
	// Use AWS/ALARM_STATE for alarm state in alarm composite models.
	DataTypeSpec *string

	// The ID of the asset property, in UUID format.
	PropertyId *string

	noSmithyDocumentSerde
}

// Contains tracing information of the SiteWise Assistant's reasoning and data
// access.
type Trace struct {

	// The cited text from the data source.
	Text *string

	noSmithyDocumentSerde
}

// Contains an asset transform property. A transform is a one-to-one mapping of a
// property's data points from one form to another. For example, you can use a
// transform to convert a Celsius data stream to Fahrenheit by applying the
// transformation expression to each data point of the Celsius stream. A transform
// can only have a data type of DOUBLE and consume properties with data types of
// INTEGER or DOUBLE .
//
// For more information, see [Transforms] in the IoT SiteWise User Guide.
//
// [Transforms]: https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-properties.html#transforms
type Transform struct {

	// The mathematical expression that defines the transformation function. You can
	// specify up to 10 variables per expression. You can specify up to 10 functions
	// per expression.
	//
	// For more information, see [Quotas] in the IoT SiteWise User Guide.
	//
	// [Quotas]: https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html
	//
	// This member is required.
	Expression *string

	// The list of variables used in the expression.
	//
	// This member is required.
	Variables []ExpressionVariable

	// The processing configuration for the given transform property. You can
	// configure transforms to be kept at the edge or forwarded to the Amazon Web
	// Services Cloud. You can also configure transforms to be computed at the edge or
	// in the cloud.
	ProcessingConfig *TransformProcessingConfig

	noSmithyDocumentSerde
}

// The processing configuration for the given transform property. You can
// configure transforms to be kept at the edge or forwarded to the Amazon Web
// Services Cloud. You can also configure transforms to be computed at the edge or
// in the cloud.
type TransformProcessingConfig struct {

	// The compute location for the given transform property.
	//
	// This member is required.
	ComputeLocation ComputeLocation

	// The forwarding configuration for a given property.
	ForwardingConfig *ForwardingConfig

	noSmithyDocumentSerde
}

// Contains a tumbling window, which is a repeating fixed-sized, non-overlapping,
// and contiguous time window. You can use this window in metrics to aggregate data
// from properties and other assets.
//
// You can use m , h , d , and w when you specify an interval or offset. Note that
// m represents minutes, h represents hours, d represents days, and w represents
// weeks. You can also use s to represent seconds in offset .
//
// The interval and offset parameters support the [ISO 8601 format]. For example, PT5S represents 5
// seconds, PT5M represents 5 minutes, and PT5H represents 5 hours.
//
// [ISO 8601 format]: https://en.wikipedia.org/wiki/ISO_8601
type TumblingWindow struct {

	// The time interval for the tumbling window. The interval time must be between 1
	// minute and 1 week.
	//
	// IoT SiteWise computes the 1w interval the end of Sunday at midnight each week
	// (UTC), the 1d interval at the end of each day at midnight (UTC), the 1h
	// interval at the end of each hour, and so on.
	//
	// When IoT SiteWise aggregates data points for metric computations, the start of
	// each interval is exclusive and the end of each interval is inclusive. IoT
	// SiteWise places the computed data point at the end of the interval.
	//
	// This member is required.
	Interval *string

	// The offset for the tumbling window. The offset parameter accepts the following:
	//
	//   - The offset time.
	//
	// For example, if you specify 18h for offset and 1d for interval , IoT SiteWise
	//   aggregates data in one of the following ways:
	//
	//   - If you create the metric before or at 6 PM (UTC), you get the first
	//   aggregation result at 6 PM (UTC) on the day when you create the metric.
	//
	//   - If you create the metric after 6 PM (UTC), you get the first aggregation
	//   result at 6 PM (UTC) the next day.
	//
	//   - The ISO 8601 format.
	//
	// For example, if you specify PT18H for offset and 1d for interval , IoT SiteWise
	//   aggregates data in one of the following ways:
	//
	//   - If you create the metric before or at 6 PM (UTC), you get the first
	//   aggregation result at 6 PM (UTC) on the day when you create the metric.
	//
	//   - If you create the metric after 6 PM (UTC), you get the first aggregation
	//   result at 6 PM (UTC) the next day.
	//
	//   - The 24-hour clock.
	//
	// For example, if you specify 00:03:00 for offset , 5m for interval , and you
	//   create the metric at 2 PM (UTC), you get the first aggregation result at 2:03 PM
	//   (UTC). You get the second aggregation result at 2:08 PM (UTC).
	//
	//   - The offset time zone.
	//
	// For example, if you specify 2021-07-23T18:00-08 for offset and 1d for interval ,
	//   IoT SiteWise aggregates data in one of the following ways:
	//
	//   - If you create the metric before or at 6 PM (PST), you get the first
	//   aggregation result at 6 PM (PST) on the day when you create the metric.
	//
	//   - If you create the metric after 6 PM (PST), you get the first aggregation
	//   result at 6 PM (PST) the next day.
	Offset *string

	noSmithyDocumentSerde
}

// Contains information for a user identity in an access policy.
type UserIdentity struct {

	// The IAM Identity Center ID of the user.
	//
	// This member is required.
	Id *string

	noSmithyDocumentSerde
}

// Identifies a property value used in an expression.
type VariableValue struct {

	// The ID of the hierarchy to query for the property ID. You can use the
	// hierarchy's name instead of the hierarchy's ID. If the hierarchy has an external
	// ID, you can specify externalId: followed by the external ID. For more
	// information, see [Using external IDs]in the IoT SiteWise User Guide.
	//
	// You use a hierarchy ID instead of a model ID because you can have several
	// hierarchies using the same model and therefore the same propertyId . For
	// example, you might have separately grouped assets that come from the same asset
	// model. For more information, see [Asset hierarchies]in the IoT SiteWise User Guide.
	//
	// [Asset hierarchies]: https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html
	// [Using external IDs]: https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids
	HierarchyId *string

	// The ID of the property to use as the variable. You can use the property name if
	// it's from the same asset model. If the property has an external ID, you can
	// specify externalId: followed by the external ID. For more information, see [Using external IDs] in
	// the IoT SiteWise User Guide.
	//
	// [Using external IDs]: https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids
	PropertyId *string

	// The path of the property.
	PropertyPath []AssetModelPropertyPathSegment

	noSmithyDocumentSerde
}

// Contains an asset property value (of a single type only).
type Variant struct {

	// Asset property data of type Boolean (true or false).
	BooleanValue *bool

	//  Asset property data of type double (floating point number). The min value is
	// -10^10. The max value is 10^10. Double.NaN is allowed.
	DoubleValue *float64

	// Asset property data of type integer (whole number).
	IntegerValue *int32

	// The type of null asset property data with BAD and UNCERTAIN qualities.
	NullValue *PropertyValueNullValue

	//  Asset property data of type string (sequence of characters). The allowed
	// pattern: "^$|[^\u0000-\u001F\u007F]+". The max length is 1024.
	StringValue *string

	noSmithyDocumentSerde
}

// Set this period to specify how long your data is stored in the warm tier before
// it is deleted. You can set this only if cold tier is enabled.
type WarmTierRetentionPeriod struct {

	// The number of days the data is stored in the warm tier.
	NumberOfDays *int32

	// If set to true, the data is stored indefinitely in the warm tier.
	Unlimited *bool

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde

// UnknownUnionMember is returned when a union member is returned over the wire,
// but has an unknown tag.
type UnknownUnionMember struct {
	Tag   string
	Value []byte

	noSmithyDocumentSerde
}

func (*UnknownUnionMember) isResponseStream() {}
