// Code generated by smithy-go-codegen DO NOT EDIT.

package ivs

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/ivs/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Updates a channel's configuration. Live channels cannot be updated. You must
// stop the ongoing stream, update the channel, and restart the stream for the
// changes to take effect.
func (c *Client) UpdateChannel(ctx context.Context, params *UpdateChannelInput, optFns ...func(*Options)) (*UpdateChannelOutput, error) {
	if params == nil {
		params = &UpdateChannelInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateChannel", params, optFns, c.addOperationUpdateChannelMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateChannelOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateChannelInput struct {

	// ARN of the channel to be updated.
	//
	// This member is required.
	Arn *string

	// Whether the channel is private (enabled for playback authorization).
	Authorized bool

	// Indicates which content-packaging format is used (MPEG-TS or fMP4). If
	// multitrackInputConfiguration is specified and enabled is true , then
	// containerFormat is required and must be set to FRAGMENTED_MP4 . Otherwise,
	// containerFormat may be set to TS or FRAGMENTED_MP4 . Default: TS .
	ContainerFormat types.ContainerFormat

	// Whether the channel allows insecure RTMP and SRT ingest. Default: false .
	InsecureIngest bool

	// Channel latency mode. Use NORMAL to broadcast and deliver live video up to Full
	// HD. Use LOW for near-real-time interaction with viewers.
	LatencyMode types.ChannelLatencyMode

	// Object specifying multitrack input configuration. Default: no multitrack input
	// configuration is specified.
	MultitrackInputConfiguration *types.MultitrackInputConfiguration

	// Channel name.
	Name *string

	// Playback-restriction-policy ARN. A valid ARN value here both specifies the ARN
	// and enables playback restriction. If this is set to an empty string, playback
	// restriction policy is disabled.
	PlaybackRestrictionPolicyArn *string

	// Optional transcode preset for the channel. This is selectable only for
	// ADVANCED_HD and ADVANCED_SD channel types. For those channel types, the default
	// preset is HIGHER_BANDWIDTH_DELIVERY . For other channel types ( BASIC and
	// STANDARD ), preset is the empty string ( "" ).
	Preset types.TranscodePreset

	// Recording-configuration ARN. A valid ARN value here both specifies the ARN and
	// enables recording. If this is set to an empty string, recording is disabled.
	RecordingConfigurationArn *string

	// Channel type, which determines the allowable resolution and bitrate. If you
	// exceed the allowable input resolution or bitrate, the stream probably will
	// disconnect immediately. Default: STANDARD . For details, see [Channel Types].
	//
	// [Channel Types]: https://docs.aws.amazon.com/ivs/latest/LowLatencyAPIReference/channel-types.html
	Type types.ChannelType

	noSmithyDocumentSerde
}

type UpdateChannelOutput struct {

	// Object specifying the updated channel.
	Channel *types.Channel

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateChannelMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpUpdateChannel{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpUpdateChannel{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateChannel"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateChannelValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateChannel(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateChannel(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateChannel",
	}
}
