// Code generated by smithy-go-codegen DO NOT EDIT.

package ivsrealtime

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/ivsrealtime/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Gets summary information about all EncoderConfigurations in your account, in
// the AWS region where the API request is processed.
func (c *Client) ListEncoderConfigurations(ctx context.Context, params *ListEncoderConfigurationsInput, optFns ...func(*Options)) (*ListEncoderConfigurationsOutput, error) {
	if params == nil {
		params = &ListEncoderConfigurationsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListEncoderConfigurations", params, optFns, c.addOperationListEncoderConfigurationsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListEncoderConfigurationsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListEncoderConfigurationsInput struct {

	// Maximum number of results to return. Default: 100.
	MaxResults *int32

	// The first encoder configuration to retrieve. This is used for pagination; see
	// the nextToken response field.
	NextToken *string

	noSmithyDocumentSerde
}

type ListEncoderConfigurationsOutput struct {

	// List of the matching EncoderConfigurations (summary information only).
	//
	// This member is required.
	EncoderConfigurations []types.EncoderConfigurationSummary

	// If there are more encoder configurations than maxResults , use nextToken in the
	// request to get the next set.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListEncoderConfigurationsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListEncoderConfigurations{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListEncoderConfigurations{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListEncoderConfigurations"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListEncoderConfigurations(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListEncoderConfigurationsPaginatorOptions is the paginator options for
// ListEncoderConfigurations
type ListEncoderConfigurationsPaginatorOptions struct {
	// Maximum number of results to return. Default: 100.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListEncoderConfigurationsPaginator is a paginator for ListEncoderConfigurations
type ListEncoderConfigurationsPaginator struct {
	options   ListEncoderConfigurationsPaginatorOptions
	client    ListEncoderConfigurationsAPIClient
	params    *ListEncoderConfigurationsInput
	nextToken *string
	firstPage bool
}

// NewListEncoderConfigurationsPaginator returns a new
// ListEncoderConfigurationsPaginator
func NewListEncoderConfigurationsPaginator(client ListEncoderConfigurationsAPIClient, params *ListEncoderConfigurationsInput, optFns ...func(*ListEncoderConfigurationsPaginatorOptions)) *ListEncoderConfigurationsPaginator {
	if params == nil {
		params = &ListEncoderConfigurationsInput{}
	}

	options := ListEncoderConfigurationsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListEncoderConfigurationsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListEncoderConfigurationsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListEncoderConfigurations page.
func (p *ListEncoderConfigurationsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListEncoderConfigurationsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListEncoderConfigurations(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListEncoderConfigurationsAPIClient is a client that implements the
// ListEncoderConfigurations operation.
type ListEncoderConfigurationsAPIClient interface {
	ListEncoderConfigurations(context.Context, *ListEncoderConfigurationsInput, ...func(*Options)) (*ListEncoderConfigurationsOutput, error)
}

var _ ListEncoderConfigurationsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListEncoderConfigurations(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListEncoderConfigurations",
	}
}
