// Code generated by smithy-go-codegen DO NOT EDIT.

package keyspaces

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/keyspaces/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

//	The GetType operation returns information about the type, for example the
//
// field definitions, the timestamp when the type was last modified, the level of
// nesting, the status, and details about if the type is used in other types and
// tables.
//
// To read keyspace metadata using GetType , the IAM principal needs Select action
// permissions for the system keyspace. To configure the required permissions, see [Permissions to view a UDT]
// in the Amazon Keyspaces Developer Guide.
//
// [Permissions to view a UDT]: https://docs.aws.amazon.com/keyspaces/latest/devguide/configure-udt-permissions.html#udt-permissions-view
func (c *Client) GetType(ctx context.Context, params *GetTypeInput, optFns ...func(*Options)) (*GetTypeOutput, error) {
	if params == nil {
		params = &GetTypeInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetType", params, optFns, c.addOperationGetTypeMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetTypeOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetTypeInput struct {

	//  The name of the keyspace that contains this type.
	//
	// This member is required.
	KeyspaceName *string

	// The formatted name of the type. For example, if the name of the type was
	// created without double quotes, Amazon Keyspaces saved the name in lower-case
	// characters. If the name was created in double quotes, you must use double quotes
	// to specify the type name.
	//
	// This member is required.
	TypeName *string

	noSmithyDocumentSerde
}

type GetTypeOutput struct {

	//  The unique identifier of the keyspace that contains this type in the format of
	// an Amazon Resource Name (ARN).
	//
	// This member is required.
	KeyspaceArn *string

	//  The name of the keyspace that contains this type.
	//
	// This member is required.
	KeyspaceName *string

	//  The name of the type.
	//
	// This member is required.
	TypeName *string

	//  The types that use this type.
	DirectParentTypes []string

	//  The tables that use this type.
	DirectReferringTables []string

	//  The names and types that define this type.
	FieldDefinitions []types.FieldDefinition

	//  The timestamp that shows when this type was last modified.
	LastModifiedTimestamp *time.Time

	//  The level of nesting implemented for this type.
	MaxNestingDepth int32

	//  The status of this type.
	Status types.TypeStatus

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetTypeMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpGetType{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpGetType{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetType"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpGetTypeValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetType(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetType(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetType",
	}
}
