// Code generated by smithy-go-codegen DO NOT EDIT.

package kinesisanalyticsv2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/kinesisanalyticsv2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists information about the current application snapshots.
func (c *Client) ListApplicationSnapshots(ctx context.Context, params *ListApplicationSnapshotsInput, optFns ...func(*Options)) (*ListApplicationSnapshotsOutput, error) {
	if params == nil {
		params = &ListApplicationSnapshotsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListApplicationSnapshots", params, optFns, c.addOperationListApplicationSnapshotsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListApplicationSnapshotsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListApplicationSnapshotsInput struct {

	// The name of an existing application.
	//
	// This member is required.
	ApplicationName *string

	// The maximum number of application snapshots to list.
	Limit *int32

	// Use this parameter if you receive a NextToken response in a previous request
	// that indicates that there is more output available. Set it to the value of the
	// previous call's NextToken response to indicate where the output should continue
	// from.
	NextToken *string

	noSmithyDocumentSerde
}

type ListApplicationSnapshotsOutput struct {

	// The token for the next set of results, or null if there are no additional
	// results.
	NextToken *string

	// A collection of objects containing information about the application snapshots.
	SnapshotSummaries []types.SnapshotDetails

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListApplicationSnapshotsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpListApplicationSnapshots{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpListApplicationSnapshots{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListApplicationSnapshots"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpListApplicationSnapshotsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListApplicationSnapshots(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListApplicationSnapshotsPaginatorOptions is the paginator options for
// ListApplicationSnapshots
type ListApplicationSnapshotsPaginatorOptions struct {
	// The maximum number of application snapshots to list.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListApplicationSnapshotsPaginator is a paginator for ListApplicationSnapshots
type ListApplicationSnapshotsPaginator struct {
	options   ListApplicationSnapshotsPaginatorOptions
	client    ListApplicationSnapshotsAPIClient
	params    *ListApplicationSnapshotsInput
	nextToken *string
	firstPage bool
}

// NewListApplicationSnapshotsPaginator returns a new
// ListApplicationSnapshotsPaginator
func NewListApplicationSnapshotsPaginator(client ListApplicationSnapshotsAPIClient, params *ListApplicationSnapshotsInput, optFns ...func(*ListApplicationSnapshotsPaginatorOptions)) *ListApplicationSnapshotsPaginator {
	if params == nil {
		params = &ListApplicationSnapshotsInput{}
	}

	options := ListApplicationSnapshotsPaginatorOptions{}
	if params.Limit != nil {
		options.Limit = *params.Limit
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListApplicationSnapshotsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListApplicationSnapshotsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListApplicationSnapshots page.
func (p *ListApplicationSnapshotsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListApplicationSnapshotsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.Limit = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListApplicationSnapshots(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListApplicationSnapshotsAPIClient is a client that implements the
// ListApplicationSnapshots operation.
type ListApplicationSnapshotsAPIClient interface {
	ListApplicationSnapshots(context.Context, *ListApplicationSnapshotsInput, ...func(*Options)) (*ListApplicationSnapshotsOutput, error)
}

var _ ListApplicationSnapshotsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListApplicationSnapshots(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListApplicationSnapshots",
	}
}
