// Code generated by smithy-go-codegen DO NOT EDIT.

package kinesisvideo

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/kinesisvideo/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns an array of edge configurations associated with the specified Edge
// Agent.
//
// In the request, you must specify the Edge Agent HubDeviceArn .
func (c *Client) ListEdgeAgentConfigurations(ctx context.Context, params *ListEdgeAgentConfigurationsInput, optFns ...func(*Options)) (*ListEdgeAgentConfigurationsOutput, error) {
	if params == nil {
		params = &ListEdgeAgentConfigurationsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListEdgeAgentConfigurations", params, optFns, c.addOperationListEdgeAgentConfigurationsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListEdgeAgentConfigurationsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListEdgeAgentConfigurationsInput struct {

	// The "Internet of Things (IoT) Thing" Arn of the edge agent.
	//
	// This member is required.
	HubDeviceArn *string

	// The maximum number of edge configurations to return in the response. The
	// default is 5.
	MaxResults *int32

	// If you specify this parameter, when the result of a ListEdgeAgentConfigurations
	// operation is truncated, the call returns the NextToken in the response. To get
	// another batch of edge configurations, provide this token in your next request.
	NextToken *string

	noSmithyDocumentSerde
}

type ListEdgeAgentConfigurationsOutput struct {

	// A description of a single stream's edge configuration.
	EdgeConfigs []types.ListEdgeAgentConfigurationsEdgeConfig

	// If the response is truncated, the call returns this element with a given token.
	// To get the next batch of edge configurations, use this token in your next
	// request.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListEdgeAgentConfigurationsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListEdgeAgentConfigurations{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListEdgeAgentConfigurations{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListEdgeAgentConfigurations"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpListEdgeAgentConfigurationsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListEdgeAgentConfigurations(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListEdgeAgentConfigurationsPaginatorOptions is the paginator options for
// ListEdgeAgentConfigurations
type ListEdgeAgentConfigurationsPaginatorOptions struct {
	// The maximum number of edge configurations to return in the response. The
	// default is 5.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListEdgeAgentConfigurationsPaginator is a paginator for
// ListEdgeAgentConfigurations
type ListEdgeAgentConfigurationsPaginator struct {
	options   ListEdgeAgentConfigurationsPaginatorOptions
	client    ListEdgeAgentConfigurationsAPIClient
	params    *ListEdgeAgentConfigurationsInput
	nextToken *string
	firstPage bool
}

// NewListEdgeAgentConfigurationsPaginator returns a new
// ListEdgeAgentConfigurationsPaginator
func NewListEdgeAgentConfigurationsPaginator(client ListEdgeAgentConfigurationsAPIClient, params *ListEdgeAgentConfigurationsInput, optFns ...func(*ListEdgeAgentConfigurationsPaginatorOptions)) *ListEdgeAgentConfigurationsPaginator {
	if params == nil {
		params = &ListEdgeAgentConfigurationsInput{}
	}

	options := ListEdgeAgentConfigurationsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListEdgeAgentConfigurationsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListEdgeAgentConfigurationsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListEdgeAgentConfigurations page.
func (p *ListEdgeAgentConfigurationsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListEdgeAgentConfigurationsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListEdgeAgentConfigurations(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListEdgeAgentConfigurationsAPIClient is a client that implements the
// ListEdgeAgentConfigurations operation.
type ListEdgeAgentConfigurationsAPIClient interface {
	ListEdgeAgentConfigurations(context.Context, *ListEdgeAgentConfigurationsInput, ...func(*Options)) (*ListEdgeAgentConfigurationsOutput, error)
}

var _ ListEdgeAgentConfigurationsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListEdgeAgentConfigurations(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListEdgeAgentConfigurations",
	}
}
