// Code generated by smithy-go-codegen DO NOT EDIT.

package lakeformation

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/lakeformation/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Retrieves the work units generated by the StartQueryPlanning operation.
func (c *Client) GetWorkUnits(ctx context.Context, params *GetWorkUnitsInput, optFns ...func(*Options)) (*GetWorkUnitsOutput, error) {
	if params == nil {
		params = &GetWorkUnitsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetWorkUnits", params, optFns, c.addOperationGetWorkUnitsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetWorkUnitsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetWorkUnitsInput struct {

	// The ID of the plan query operation.
	//
	// This member is required.
	QueryId *string

	// A continuation token, if this is a continuation call.
	NextToken *string

	// The size of each page to get in the Amazon Web Services service call. This does
	// not affect the number of items returned in the command's output. Setting a
	// smaller page size results in more calls to the Amazon Web Services service,
	// retrieving fewer items in each call. This can help prevent the Amazon Web
	// Services service calls from timing out.
	PageSize *int32

	noSmithyDocumentSerde
}

// A structure for the output.
type GetWorkUnitsOutput struct {

	// The ID of the plan query operation.
	//
	// This member is required.
	QueryId *string

	// A WorkUnitRangeList object that specifies the valid range of work unit IDs for
	// querying the execution service.
	//
	// This member is required.
	WorkUnitRanges []types.WorkUnitRange

	// A continuation token for paginating the returned list of tokens, returned if
	// the current segment of the list is not the last.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetWorkUnitsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetWorkUnits{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetWorkUnits{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetWorkUnits"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addEndpointPrefix_opGetWorkUnitsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpGetWorkUnitsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetWorkUnits(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// GetWorkUnitsPaginatorOptions is the paginator options for GetWorkUnits
type GetWorkUnitsPaginatorOptions struct {
	// The size of each page to get in the Amazon Web Services service call. This does
	// not affect the number of items returned in the command's output. Setting a
	// smaller page size results in more calls to the Amazon Web Services service,
	// retrieving fewer items in each call. This can help prevent the Amazon Web
	// Services service calls from timing out.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// GetWorkUnitsPaginator is a paginator for GetWorkUnits
type GetWorkUnitsPaginator struct {
	options   GetWorkUnitsPaginatorOptions
	client    GetWorkUnitsAPIClient
	params    *GetWorkUnitsInput
	nextToken *string
	firstPage bool
}

// NewGetWorkUnitsPaginator returns a new GetWorkUnitsPaginator
func NewGetWorkUnitsPaginator(client GetWorkUnitsAPIClient, params *GetWorkUnitsInput, optFns ...func(*GetWorkUnitsPaginatorOptions)) *GetWorkUnitsPaginator {
	if params == nil {
		params = &GetWorkUnitsInput{}
	}

	options := GetWorkUnitsPaginatorOptions{}
	if params.PageSize != nil {
		options.Limit = *params.PageSize
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &GetWorkUnitsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *GetWorkUnitsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next GetWorkUnits page.
func (p *GetWorkUnitsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*GetWorkUnitsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.PageSize = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.GetWorkUnits(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

type endpointPrefix_opGetWorkUnitsMiddleware struct {
}

func (*endpointPrefix_opGetWorkUnitsMiddleware) ID() string {
	return "EndpointHostPrefix"
}

func (m *endpointPrefix_opGetWorkUnitsMiddleware) HandleFinalize(ctx context.Context, in middleware.FinalizeInput, next middleware.FinalizeHandler) (
	out middleware.FinalizeOutput, metadata middleware.Metadata, err error,
) {
	if smithyhttp.GetHostnameImmutable(ctx) || smithyhttp.IsEndpointHostPrefixDisabled(ctx) {
		return next.HandleFinalize(ctx, in)
	}

	req, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, fmt.Errorf("unknown transport type %T", in.Request)
	}

	req.URL.Host = "query-" + req.URL.Host

	return next.HandleFinalize(ctx, in)
}
func addEndpointPrefix_opGetWorkUnitsMiddleware(stack *middleware.Stack) error {
	return stack.Finalize.Insert(&endpointPrefix_opGetWorkUnitsMiddleware{}, "ResolveEndpointV2", middleware.After)
}

// GetWorkUnitsAPIClient is a client that implements the GetWorkUnits operation.
type GetWorkUnitsAPIClient interface {
	GetWorkUnits(context.Context, *GetWorkUnitsInput, ...func(*Options)) (*GetWorkUnitsOutput, error)
}

var _ GetWorkUnitsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opGetWorkUnits(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetWorkUnits",
	}
}
