// Code generated by smithy-go-codegen DO NOT EDIT.

package lexmodelsv2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/lexmodelsv2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Retrieves summary metrics for the stages within intents in your bot. The
// following fields are required:
//
//   - metrics – A list of [AnalyticsIntentStageMetric]objects. In each object, use the name field to specify
//     the metric to calculate, the statistic field to specify whether to calculate
//     the Sum , Average , or Max number, and the order field to specify whether to
//     sort the results in Ascending or Descending order.
//
//   - startDateTime and endDateTime – Define a time range for which you want to
//     retrieve results.
//
// Of the optional fields, you can organize the results in the following ways:
//
//   - Use the filters field to filter the results, the groupBy field to specify
//     categories by which to group the results, and the binBy field to specify time
//     intervals by which to group the results.
//
//   - Use the maxResults field to limit the number of results to return in a
//     single response and the nextToken field to return the next batch of results if
//     the response does not return the full set of results.
//
// Note that an order field exists in both binBy and metrics . You can only specify
// one order in a given request.
//
// [AnalyticsIntentStageMetric]: https://docs.aws.amazon.com/lexv2/latest/APIReference/API_AnalyticsIntentStageMetric.html
func (c *Client) ListIntentStageMetrics(ctx context.Context, params *ListIntentStageMetricsInput, optFns ...func(*Options)) (*ListIntentStageMetricsOutput, error) {
	if params == nil {
		params = &ListIntentStageMetricsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListIntentStageMetrics", params, optFns, c.addOperationListIntentStageMetricsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListIntentStageMetricsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListIntentStageMetricsInput struct {

	// The identifier for the bot for which you want to retrieve intent stage metrics.
	//
	// This member is required.
	BotId *string

	// The date and time that marks the end of the range of time for which you want to
	// see intent stage metrics.
	//
	// This member is required.
	EndDateTime *time.Time

	// A list of objects, each of which contains a metric you want to list, the
	// statistic for the metric you want to return, and the method by which to organize
	// the results.
	//
	// This member is required.
	Metrics []types.AnalyticsIntentStageMetric

	// The date and time that marks the beginning of the range of time for which you
	// want to see intent stage metrics.
	//
	// This member is required.
	StartDateTime *time.Time

	// A list of objects, each of which contains specifications for organizing the
	// results by time.
	BinBy []types.AnalyticsBinBySpecification

	// A list of objects, each of which describes a condition by which you want to
	// filter the results.
	Filters []types.AnalyticsIntentStageFilter

	// A list of objects, each of which specifies how to group the results. You can
	// group by the following criteria:
	//
	//   - IntentStageName – The name of the intent stage.
	//
	//   - SwitchedToIntent – The intent to which the conversation was switched (if
	//   any).
	GroupBy []types.AnalyticsIntentStageGroupBySpecification

	// The maximum number of results to return in each page of results. If there are
	// fewer results than the maximum page size, only the actual number of results are
	// returned.
	MaxResults *int32

	// If the response from the ListIntentStageMetrics operation contains more results
	// than specified in the maxResults parameter, a token is returned in the response.
	//
	// Use the returned token in the nextToken parameter of a ListIntentStageMetrics
	// request to return the next page of results. For a complete set of results, call
	// the ListIntentStageMetrics operation until the nextToken returned in the
	// response is null.
	NextToken *string

	noSmithyDocumentSerde
}

type ListIntentStageMetricsOutput struct {

	// The identifier for the bot for which you retrieved intent stage metrics.
	BotId *string

	// If the response from the ListIntentStageMetrics operation contains more results
	// than specified in the maxResults parameter, a token is returned in the response.
	//
	// Use the returned token in the nextToken parameter of a ListIntentStageMetrics
	// request to return the next page of results. For a complete set of results, call
	// the ListIntentStageMetrics operation until the nextToken returned in the
	// response is null.
	NextToken *string

	// The results for the intent stage metrics.
	Results []types.AnalyticsIntentStageResult

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListIntentStageMetricsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListIntentStageMetrics{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListIntentStageMetrics{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListIntentStageMetrics"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpListIntentStageMetricsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListIntentStageMetrics(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListIntentStageMetricsPaginatorOptions is the paginator options for
// ListIntentStageMetrics
type ListIntentStageMetricsPaginatorOptions struct {
	// The maximum number of results to return in each page of results. If there are
	// fewer results than the maximum page size, only the actual number of results are
	// returned.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListIntentStageMetricsPaginator is a paginator for ListIntentStageMetrics
type ListIntentStageMetricsPaginator struct {
	options   ListIntentStageMetricsPaginatorOptions
	client    ListIntentStageMetricsAPIClient
	params    *ListIntentStageMetricsInput
	nextToken *string
	firstPage bool
}

// NewListIntentStageMetricsPaginator returns a new ListIntentStageMetricsPaginator
func NewListIntentStageMetricsPaginator(client ListIntentStageMetricsAPIClient, params *ListIntentStageMetricsInput, optFns ...func(*ListIntentStageMetricsPaginatorOptions)) *ListIntentStageMetricsPaginator {
	if params == nil {
		params = &ListIntentStageMetricsInput{}
	}

	options := ListIntentStageMetricsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListIntentStageMetricsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListIntentStageMetricsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListIntentStageMetrics page.
func (p *ListIntentStageMetricsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListIntentStageMetricsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListIntentStageMetrics(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListIntentStageMetricsAPIClient is a client that implements the
// ListIntentStageMetrics operation.
type ListIntentStageMetricsAPIClient interface {
	ListIntentStageMetrics(context.Context, *ListIntentStageMetricsInput, ...func(*Options)) (*ListIntentStageMetricsOutput, error)
}

var _ ListIntentStageMetricsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListIntentStageMetrics(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListIntentStageMetrics",
	}
}
