// Code generated by smithy-go-codegen DO NOT EDIT.

package lightsail

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/lightsail/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Copies a manual snapshot of an instance or disk as another manual snapshot, or
// copies an automatic snapshot of an instance or disk as a manual snapshot. This
// operation can also be used to copy a manual or automatic snapshot of an instance
// or a disk from one Amazon Web Services Region to another in Amazon Lightsail.
//
// When copying a manual snapshot, be sure to define the source region , source
// snapshot name , and target snapshot name parameters.
//
// When copying an automatic snapshot, be sure to define the source region ,
// source resource name , target snapshot name , and either the restore date or
// the use latest restorable auto snapshot parameters.
func (c *Client) CopySnapshot(ctx context.Context, params *CopySnapshotInput, optFns ...func(*Options)) (*CopySnapshotOutput, error) {
	if params == nil {
		params = &CopySnapshotInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CopySnapshot", params, optFns, c.addOperationCopySnapshotMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CopySnapshotOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CopySnapshotInput struct {

	// The Amazon Web Services Region where the source manual or automatic snapshot is
	// located.
	//
	// This member is required.
	SourceRegion types.RegionName

	// The name of the new manual snapshot to be created as a copy.
	//
	// This member is required.
	TargetSnapshotName *string

	// The date of the source automatic snapshot to copy. Use the get auto snapshots
	// operation to identify the dates of the available automatic snapshots.
	//
	// Constraints:
	//
	//   - Must be specified in YYYY-MM-DD format.
	//
	//   - This parameter cannot be defined together with the use latest restorable
	//   auto snapshot parameter. The restore date and use latest restorable auto
	//   snapshot parameters are mutually exclusive.
	//
	//   - Define this parameter only when copying an automatic snapshot as a manual
	//   snapshot. For more information, see the [Amazon Lightsail Developer Guide].
	//
	// [Amazon Lightsail Developer Guide]: https://docs.aws.amazon.com/lightsail/latest/userguide/amazon-lightsail-keeping-automatic-snapshots
	RestoreDate *string

	// The name of the source instance or disk from which the source automatic
	// snapshot was created.
	//
	// Constraint:
	//
	//   - Define this parameter only when copying an automatic snapshot as a manual
	//   snapshot. For more information, see the [Amazon Lightsail Developer Guide].
	//
	// [Amazon Lightsail Developer Guide]: https://docs.aws.amazon.com/lightsail/latest/userguide/amazon-lightsail-keeping-automatic-snapshots
	SourceResourceName *string

	// The name of the source manual snapshot to copy.
	//
	// Constraint:
	//
	//   - Define this parameter only when copying a manual snapshot as another manual
	//   snapshot.
	SourceSnapshotName *string

	// A Boolean value to indicate whether to use the latest available automatic
	// snapshot of the specified source instance or disk.
	//
	// Constraints:
	//
	//   - This parameter cannot be defined together with the restore date parameter.
	//   The use latest restorable auto snapshot and restore date parameters are
	//   mutually exclusive.
	//
	//   - Define this parameter only when copying an automatic snapshot as a manual
	//   snapshot. For more information, see the [Amazon Lightsail Developer Guide].
	//
	// [Amazon Lightsail Developer Guide]: https://docs.aws.amazon.com/lightsail/latest/userguide/amazon-lightsail-keeping-automatic-snapshots
	UseLatestRestorableAutoSnapshot *bool

	noSmithyDocumentSerde
}

type CopySnapshotOutput struct {

	// An array of objects that describe the result of the action, such as the status
	// of the request, the timestamp of the request, and the resources affected by the
	// request.
	Operations []types.Operation

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCopySnapshotMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpCopySnapshot{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpCopySnapshot{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CopySnapshot"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpCopySnapshotValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCopySnapshot(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCopySnapshot(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CopySnapshot",
	}
}
