// Code generated by smithy-go-codegen DO NOT EDIT.

package lightsail

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/lightsail/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Modifies the Amazon Lightsail instance metadata parameters on a running or
// stopped instance. When you modify the parameters on a running instance, the
// GetInstance or GetInstances API operation initially responds with a state of
// pending . After the parameter modifications are successfully applied, the state
// changes to applied in subsequent GetInstance or GetInstances API calls. For
// more information, see [Use IMDSv2 with an Amazon Lightsail instance]in the Amazon Lightsail Developer Guide.
//
// [Use IMDSv2 with an Amazon Lightsail instance]: https://docs.aws.amazon.com/lightsail/latest/userguide/amazon-lightsail-configuring-instance-metadata-service
func (c *Client) UpdateInstanceMetadataOptions(ctx context.Context, params *UpdateInstanceMetadataOptionsInput, optFns ...func(*Options)) (*UpdateInstanceMetadataOptionsOutput, error) {
	if params == nil {
		params = &UpdateInstanceMetadataOptionsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateInstanceMetadataOptions", params, optFns, c.addOperationUpdateInstanceMetadataOptionsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateInstanceMetadataOptionsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateInstanceMetadataOptionsInput struct {

	// The name of the instance for which to update metadata parameters.
	//
	// This member is required.
	InstanceName *string

	// Enables or disables the HTTP metadata endpoint on your instances. If this
	// parameter is not specified, the existing state is maintained.
	//
	// If you specify a value of disabled , you cannot access your instance metadata.
	HttpEndpoint types.HttpEndpoint

	// Enables or disables the IPv6 endpoint for the instance metadata service. This
	// setting applies only when the HTTP metadata endpoint is enabled.
	//
	// This parameter is available only for instances in the Europe (Stockholm) Amazon
	// Web Services Region ( eu-north-1 ).
	HttpProtocolIpv6 types.HttpProtocolIpv6

	// The desired HTTP PUT response hop limit for instance metadata requests. A
	// larger number means that the instance metadata requests can travel farther. If
	// no parameter is specified, the existing state is maintained.
	HttpPutResponseHopLimit *int32

	// The state of token usage for your instance metadata requests. If the parameter
	// is not specified in the request, the default state is optional .
	//
	// If the state is optional , you can choose whether to retrieve instance metadata
	// with a signed token header on your request. If you retrieve the IAM role
	// credentials without a token, the version 1.0 role credentials are returned. If
	// you retrieve the IAM role credentials by using a valid signed token, the version
	// 2.0 role credentials are returned.
	//
	// If the state is required , you must send a signed token header with all instance
	// metadata retrieval requests. In this state, retrieving the IAM role credential
	// always returns the version 2.0 credentials. The version 1.0 credentials are not
	// available.
	HttpTokens types.HttpTokens

	noSmithyDocumentSerde
}

type UpdateInstanceMetadataOptionsOutput struct {

	// An array of objects that describe the result of the action, such as the status
	// of the request, the timestamp of the request, and the resources affected by the
	// request.
	Operation *types.Operation

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateInstanceMetadataOptionsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpUpdateInstanceMetadataOptions{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpUpdateInstanceMetadataOptions{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateInstanceMetadataOptions"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateInstanceMetadataOptionsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateInstanceMetadataOptions(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateInstanceMetadataOptions(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateInstanceMetadataOptions",
	}
}
