// Code generated by smithy-go-codegen DO NOT EDIT.

package location

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/location/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Retrieves the tracker resource details.
func (c *Client) DescribeTracker(ctx context.Context, params *DescribeTrackerInput, optFns ...func(*Options)) (*DescribeTrackerOutput, error) {
	if params == nil {
		params = &DescribeTrackerInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeTracker", params, optFns, c.addOperationDescribeTrackerMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeTrackerOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeTrackerInput struct {

	// The name of the tracker resource.
	//
	// This member is required.
	TrackerName *string

	noSmithyDocumentSerde
}

type DescribeTrackerOutput struct {

	// The timestamp for when the tracker resource was created in [ISO 8601] format:
	// YYYY-MM-DDThh:mm:ss.sssZ .
	//
	// [ISO 8601]: https://www.iso.org/iso-8601-date-and-time-format.html
	//
	// This member is required.
	CreateTime *time.Time

	// The optional description for the tracker resource.
	//
	// This member is required.
	Description *string

	// The Amazon Resource Name (ARN) for the tracker resource. Used when you need to
	// specify a resource across all Amazon Web Services.
	//
	//   - Format example: arn:aws:geo:region:account-id:tracker/ExampleTracker
	//
	// This member is required.
	TrackerArn *string

	// The name of the tracker resource.
	//
	// This member is required.
	TrackerName *string

	// The timestamp for when the tracker resource was last updated in [ISO 8601] format:
	// YYYY-MM-DDThh:mm:ss.sssZ .
	//
	// [ISO 8601]: https://www.iso.org/iso-8601-date-and-time-format.html
	//
	// This member is required.
	UpdateTime *time.Time

	// Whether UPDATE events from this tracker in EventBridge are enabled. If set to
	// true these events will be sent to EventBridge.
	EventBridgeEnabled *bool

	// Enables GeospatialQueries for a tracker that uses a [Amazon Web Services KMS customer managed key].
	//
	// This parameter is only used if you are using a KMS customer managed key.
	//
	// If you wish to encrypt your data using your own KMS customer managed key, then
	// the Bounding Polygon Queries feature will be disabled by default. This is
	// because by using this feature, a representation of your device positions will
	// not be encrypted using the your KMS managed key. The exact device position,
	// however; is still encrypted using your managed key.
	//
	// You can choose to opt-in to the Bounding Polygon Quseries feature. This is done
	// by setting the KmsKeyEnableGeospatialQueries parameter to true when creating or
	// updating a Tracker.
	//
	// [Amazon Web Services KMS customer managed key]: https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html
	KmsKeyEnableGeospatialQueries *bool

	// A key identifier for an [Amazon Web Services KMS customer managed key] assigned to the Amazon Location resource.
	//
	// [Amazon Web Services KMS customer managed key]: https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html
	KmsKeyId *string

	// The position filtering method of the tracker resource.
	PositionFiltering types.PositionFiltering

	// Always returns RequestBasedUsage .
	//
	// Deprecated: Deprecated. Always returns RequestBasedUsage.
	PricingPlan types.PricingPlan

	// No longer used. Always returns an empty string.
	//
	// Deprecated: Deprecated. Unused.
	PricingPlanDataSource *string

	// The tags associated with the tracker resource.
	Tags map[string]string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeTrackerMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpDescribeTracker{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpDescribeTracker{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DescribeTracker"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addEndpointPrefix_opDescribeTrackerMiddleware(stack); err != nil {
		return err
	}
	if err = addOpDescribeTrackerValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeTracker(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

type endpointPrefix_opDescribeTrackerMiddleware struct {
}

func (*endpointPrefix_opDescribeTrackerMiddleware) ID() string {
	return "EndpointHostPrefix"
}

func (m *endpointPrefix_opDescribeTrackerMiddleware) HandleFinalize(ctx context.Context, in middleware.FinalizeInput, next middleware.FinalizeHandler) (
	out middleware.FinalizeOutput, metadata middleware.Metadata, err error,
) {
	if smithyhttp.GetHostnameImmutable(ctx) || smithyhttp.IsEndpointHostPrefixDisabled(ctx) {
		return next.HandleFinalize(ctx, in)
	}

	req, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, fmt.Errorf("unknown transport type %T", in.Request)
	}

	req.URL.Host = "cp.tracking." + req.URL.Host

	return next.HandleFinalize(ctx, in)
}
func addEndpointPrefix_opDescribeTrackerMiddleware(stack *middleware.Stack) error {
	return stack.Finalize.Insert(&endpointPrefix_opDescribeTrackerMiddleware{}, "ResolveEndpointV2", middleware.After)
}

func newServiceMetadataMiddleware_opDescribeTracker(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DescribeTracker",
	}
}
