// Code generated by smithy-go-codegen DO NOT EDIT.

package lookoutequipment

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Sets the active model version for a given machine learning model.
func (c *Client) UpdateActiveModelVersion(ctx context.Context, params *UpdateActiveModelVersionInput, optFns ...func(*Options)) (*UpdateActiveModelVersionOutput, error) {
	if params == nil {
		params = &UpdateActiveModelVersionInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateActiveModelVersion", params, optFns, c.addOperationUpdateActiveModelVersionMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateActiveModelVersionOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateActiveModelVersionInput struct {

	// The name of the machine learning model for which the active model version is
	// being set.
	//
	// This member is required.
	ModelName *string

	// The version of the machine learning model for which the active model version is
	// being set.
	//
	// This member is required.
	ModelVersion *int64

	noSmithyDocumentSerde
}

type UpdateActiveModelVersionOutput struct {

	// The version that is currently active of the machine learning model for which
	// the active model version was set.
	CurrentActiveVersion *int64

	// The Amazon Resource Name (ARN) of the machine learning model version that is
	// the current active model version.
	CurrentActiveVersionArn *string

	// The Amazon Resource Name (ARN) of the machine learning model for which the
	// active model version was set.
	ModelArn *string

	// The name of the machine learning model for which the active model version was
	// set.
	ModelName *string

	// The previous version that was active of the machine learning model for which
	// the active model version was set.
	PreviousActiveVersion *int64

	// The Amazon Resource Name (ARN) of the machine learning model version that was
	// the previous active model version.
	PreviousActiveVersionArn *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateActiveModelVersionMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpUpdateActiveModelVersion{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpUpdateActiveModelVersion{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateActiveModelVersion"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateActiveModelVersionValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateActiveModelVersion(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateActiveModelVersion(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateActiveModelVersion",
	}
}
