// Code generated by smithy-go-codegen DO NOT EDIT.

package lookoutmetrics

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/lookoutmetrics/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Updates a dataset.
func (c *Client) UpdateMetricSet(ctx context.Context, params *UpdateMetricSetInput, optFns ...func(*Options)) (*UpdateMetricSetOutput, error) {
	if params == nil {
		params = &UpdateMetricSetInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateMetricSet", params, optFns, c.addOperationUpdateMetricSetMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateMetricSetOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateMetricSetInput struct {

	// The ARN of the dataset to update.
	//
	// This member is required.
	MetricSetArn *string

	// Describes a list of filters for choosing specific dimensions and specific
	// values. Each filter consists of the dimension and one of its values that you
	// want to include. When multiple dimensions or values are specified, the
	// dimensions are joined with an AND operation and the values are joined with an OR
	// operation.
	DimensionFilterList []types.MetricSetDimensionFilter

	// The dimension list.
	DimensionList []string

	// The metric list.
	MetricList []types.Metric

	// The dataset's description.
	MetricSetDescription *string

	// The dataset's interval.
	MetricSetFrequency types.Frequency

	// Contains information about source data used to generate metrics.
	MetricSource *types.MetricSource

	// After an interval ends, the amount of seconds that the detector waits before
	// importing data. Offset is only supported for S3, Redshift, Athena and
	// datasources.
	Offset *int32

	// The timestamp column.
	TimestampColumn *types.TimestampColumn

	noSmithyDocumentSerde
}

type UpdateMetricSetOutput struct {

	// The ARN of the dataset.
	MetricSetArn *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateMetricSetMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpUpdateMetricSet{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpUpdateMetricSet{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateMetricSet"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateMetricSetValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateMetricSet(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateMetricSet(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateMetricSet",
	}
}
