// Code generated by smithy-go-codegen DO NOT EDIT.

package m2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/m2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Describes a specific runtime environment.
func (c *Client) GetEnvironment(ctx context.Context, params *GetEnvironmentInput, optFns ...func(*Options)) (*GetEnvironmentOutput, error) {
	if params == nil {
		params = &GetEnvironmentInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetEnvironment", params, optFns, c.addOperationGetEnvironmentMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetEnvironmentOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetEnvironmentInput struct {

	// The unique identifier of the runtime environment.
	//
	// This member is required.
	EnvironmentId *string

	noSmithyDocumentSerde
}

type GetEnvironmentOutput struct {

	// The timestamp when the runtime environment was created.
	//
	// This member is required.
	CreationTime *time.Time

	// The target platform for the runtime environment.
	//
	// This member is required.
	EngineType types.EngineType

	// The version of the runtime engine.
	//
	// This member is required.
	EngineVersion *string

	// The Amazon Resource Name (ARN) of the runtime environment.
	//
	// This member is required.
	EnvironmentArn *string

	// The unique identifier of the runtime environment.
	//
	// This member is required.
	EnvironmentId *string

	// The type of instance underlying the runtime environment.
	//
	// This member is required.
	InstanceType *string

	// The name of the runtime environment. Must be unique within the account.
	//
	// This member is required.
	Name *string

	// The unique identifiers of the security groups assigned to this runtime
	// environment.
	//
	// This member is required.
	SecurityGroupIds []string

	// The status of the runtime environment. If the Amazon Web Services Mainframe
	// Modernization environment is missing a connection to the customer owned
	// dependent resource, the status will be Unhealthy .
	//
	// This member is required.
	Status types.EnvironmentLifecycle

	// The unique identifiers of the subnets assigned to this runtime environment.
	//
	// This member is required.
	SubnetIds []string

	// The unique identifier for the VPC used with this runtime environment.
	//
	// This member is required.
	VpcId *string

	// The number of instances included in the runtime environment. A standalone
	// runtime environment has a maximum of one instance. Currently, a high
	// availability runtime environment has a maximum of two instances.
	ActualCapacity *int32

	// The description of the runtime environment.
	Description *string

	// The desired capacity of the high availability configuration for the runtime
	// environment.
	HighAvailabilityConfig *types.HighAvailabilityConfig

	// The identifier of a customer managed key.
	KmsKeyId *string

	// The Amazon Resource Name (ARN) for the load balancer used with the runtime
	// environment.
	LoadBalancerArn *string

	// The network type supported by the runtime environment.
	NetworkType types.NetworkType

	// Indicates the pending maintenance scheduled on this environment.
	PendingMaintenance *types.PendingMaintenance

	// The maintenance window for the runtime environment. If you don't provide a
	// value for the maintenance window, the service assigns a random value.
	PreferredMaintenanceWindow *string

	// Whether applications running in this runtime environment are publicly
	// accessible.
	PubliclyAccessible bool

	// The reason for the reported status.
	StatusReason *string

	// The storage configurations defined for the runtime environment.
	StorageConfigurations []types.StorageConfiguration

	// The tags defined for this runtime environment.
	Tags map[string]string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetEnvironmentMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetEnvironment{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetEnvironment{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetEnvironment"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpGetEnvironmentValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetEnvironment(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetEnvironment(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetEnvironment",
	}
}
