// Code generated by smithy-go-codegen DO NOT EDIT.

package mailmanager

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/mailmanager/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists address lists for this account.
func (c *Client) ListAddressLists(ctx context.Context, params *ListAddressListsInput, optFns ...func(*Options)) (*ListAddressListsOutput, error) {
	if params == nil {
		params = &ListAddressListsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListAddressLists", params, optFns, c.addOperationListAddressListsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListAddressListsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListAddressListsInput struct {

	// If you received a pagination token from a previous call to this API, you can
	// provide it here to continue paginating through the next page of results.
	NextToken *string

	// The maximum number of address list resources that are returned per call. You
	// can use NextToken to retrieve the next page of address lists.
	PageSize *int32

	noSmithyDocumentSerde
}

type ListAddressListsOutput struct {

	// The list of address lists.
	//
	// This member is required.
	AddressLists []types.AddressList

	// If NextToken is returned, there are more results available. The value of
	// NextToken is a unique pagination token for each page. Make the call again using
	// the returned token to retrieve the next page.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListAddressListsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpListAddressLists{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpListAddressLists{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListAddressLists"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListAddressLists(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListAddressListsPaginatorOptions is the paginator options for ListAddressLists
type ListAddressListsPaginatorOptions struct {
	// The maximum number of address list resources that are returned per call. You
	// can use NextToken to retrieve the next page of address lists.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListAddressListsPaginator is a paginator for ListAddressLists
type ListAddressListsPaginator struct {
	options   ListAddressListsPaginatorOptions
	client    ListAddressListsAPIClient
	params    *ListAddressListsInput
	nextToken *string
	firstPage bool
}

// NewListAddressListsPaginator returns a new ListAddressListsPaginator
func NewListAddressListsPaginator(client ListAddressListsAPIClient, params *ListAddressListsInput, optFns ...func(*ListAddressListsPaginatorOptions)) *ListAddressListsPaginator {
	if params == nil {
		params = &ListAddressListsInput{}
	}

	options := ListAddressListsPaginatorOptions{}
	if params.PageSize != nil {
		options.Limit = *params.PageSize
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListAddressListsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListAddressListsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListAddressLists page.
func (p *ListAddressListsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListAddressListsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.PageSize = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListAddressLists(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListAddressListsAPIClient is a client that implements the ListAddressLists
// operation.
type ListAddressListsAPIClient interface {
	ListAddressLists(context.Context, *ListAddressListsInput, ...func(*Options)) (*ListAddressListsOutput, error)
}

var _ ListAddressListsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListAddressLists(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListAddressLists",
	}
}
