// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// The action to add a header to a message. When executed, this action will add
// the given header to the message.
type AddHeaderAction struct {

	// The name of the header to add to an email. The header must be prefixed with
	// "X-". Headers are added regardless of whether the header name pre-existed in the
	// email.
	//
	// This member is required.
	HeaderName *string

	// The value of the header to add to the email.
	//
	// This member is required.
	HeaderValue *string

	noSmithyDocumentSerde
}

// An Add On instance represents a specific configuration of an Add On.
type AddonInstance struct {

	// The Amazon Resource Name (ARN) of the Add On instance.
	AddonInstanceArn *string

	// The unique ID of the Add On instance.
	AddonInstanceId *string

	// The name of the Add On for the instance.
	AddonName *string

	// The subscription ID for the instance.
	AddonSubscriptionId *string

	// The timestamp of when the Add On instance was created.
	CreatedTimestamp *time.Time

	noSmithyDocumentSerde
}

// A subscription for an Add On representing the acceptance of its terms of use
// and additional pricing.
type AddonSubscription struct {

	// The name of the Add On.
	AddonName *string

	// The Amazon Resource Name (ARN) of the Add On subscription.
	AddonSubscriptionArn *string

	// The unique ID of the Add On subscription.
	AddonSubscriptionId *string

	// The timestamp of when the Add On subscription was created.
	CreatedTimestamp *time.Time

	noSmithyDocumentSerde
}

// Filtering options for ListMembersOfAddressList operation.
type AddressFilter struct {

	// Filter to limit the results to addresses having the provided prefix.
	AddressPrefix *string

	noSmithyDocumentSerde
}

// An address list contains a list of emails and domains that are used in
// MailManager Ingress endpoints and Rules for email management.
type AddressList struct {

	// The Amazon Resource Name (ARN) of the address list.
	//
	// This member is required.
	AddressListArn *string

	// The identifier of the address list.
	//
	// This member is required.
	AddressListId *string

	// The user-friendly name of the address list.
	//
	// This member is required.
	AddressListName *string

	// The timestamp of when the address list was created.
	//
	// This member is required.
	CreatedTimestamp *time.Time

	// The timestamp of when the address list was last updated.
	//
	// This member is required.
	LastUpdatedTimestamp *time.Time

	noSmithyDocumentSerde
}

// The result of an analysis can be used in conditions to trigger actions.
// Analyses can inspect the email content and report a certain aspect of the email.
type Analysis struct {

	// The Amazon Resource Name (ARN) of an Add On.
	//
	// This member is required.
	Analyzer *string

	// The returned value from an Add On.
	//
	// This member is required.
	ResultField *string

	noSmithyDocumentSerde
}

// An archive resource for storing and retaining emails.
type Archive struct {

	// The unique identifier of the archive.
	//
	// This member is required.
	ArchiveId *string

	// The unique name assigned to the archive.
	ArchiveName *string

	// The current state of the archive:
	//
	//   - ACTIVE – The archive is ready and available for use.
	//
	//   - PENDING_DELETION – The archive has been marked for deletion and will be
	//   permanently deleted in 30 days. No further modifications can be made in this
	//   state.
	ArchiveState ArchiveState

	// The timestamp of when the archive was last updated.
	LastUpdatedTimestamp *time.Time

	noSmithyDocumentSerde
}

// The action to archive the email by delivering the email to an Amazon SES
// archive.
type ArchiveAction struct {

	// The identifier of the archive to send the email to.
	//
	// This member is required.
	TargetArchive *string

	// A policy that states what to do in the case of failure. The action will fail if
	// there are configuration errors. For example, the specified archive has been
	// deleted.
	ActionFailurePolicy ActionFailurePolicy

	noSmithyDocumentSerde
}

// A boolean expression to evaluate email attribute values.
type ArchiveBooleanExpression struct {

	// The email attribute value to evaluate.
	//
	// This member is required.
	Evaluate ArchiveBooleanToEvaluate

	// The boolean operator to use for evaluation.
	//
	// This member is required.
	Operator ArchiveBooleanOperator

	noSmithyDocumentSerde
}

// The attribute to evaluate in a boolean expression.
//
// The following types satisfy this interface:
//
//	ArchiveBooleanToEvaluateMemberAttribute
type ArchiveBooleanToEvaluate interface {
	isArchiveBooleanToEvaluate()
}

// The name of the email attribute to evaluate.
type ArchiveBooleanToEvaluateMemberAttribute struct {
	Value ArchiveBooleanEmailAttribute

	noSmithyDocumentSerde
}

func (*ArchiveBooleanToEvaluateMemberAttribute) isArchiveBooleanToEvaluate() {}

// A filter condition used to include or exclude emails when exporting from or
// searching an archive.
//
// The following types satisfy this interface:
//
//	ArchiveFilterConditionMemberBooleanExpression
//	ArchiveFilterConditionMemberStringExpression
type ArchiveFilterCondition interface {
	isArchiveFilterCondition()
}

// A boolean expression to evaluate against email attributes.
type ArchiveFilterConditionMemberBooleanExpression struct {
	Value ArchiveBooleanExpression

	noSmithyDocumentSerde
}

func (*ArchiveFilterConditionMemberBooleanExpression) isArchiveFilterCondition() {}

// A string expression to evaluate against email attributes.
type ArchiveFilterConditionMemberStringExpression struct {
	Value ArchiveStringExpression

	noSmithyDocumentSerde
}

func (*ArchiveFilterConditionMemberStringExpression) isArchiveFilterCondition() {}

// A set of filter conditions to include and/or exclude emails.
type ArchiveFilters struct {

	// The filter conditions for emails to include.
	Include []ArchiveFilterCondition

	// The filter conditions for emails to exclude.
	Unless []ArchiveFilterCondition

	noSmithyDocumentSerde
}

// The retention policy for an email archive that specifies how long emails are
// kept before being automatically deleted.
//
// The following types satisfy this interface:
//
//	ArchiveRetentionMemberRetentionPeriod
type ArchiveRetention interface {
	isArchiveRetention()
}

// The enum value sets the period for retaining emails in an archive.
type ArchiveRetentionMemberRetentionPeriod struct {
	Value RetentionPeriod

	noSmithyDocumentSerde
}

func (*ArchiveRetentionMemberRetentionPeriod) isArchiveRetention() {}

// A string expression to evaluate an email attribute value against one or more
// string values.
type ArchiveStringExpression struct {

	// The attribute of the email to evaluate.
	//
	// This member is required.
	Evaluate ArchiveStringToEvaluate

	// The operator to use when evaluating the string values.
	//
	// This member is required.
	Operator ArchiveStringOperator

	// The list of string values to evaluate the email attribute against.
	//
	// This member is required.
	Values []string

	noSmithyDocumentSerde
}

// Specifies the email attribute to evaluate in a string expression.
//
// The following types satisfy this interface:
//
//	ArchiveStringToEvaluateMemberAttribute
type ArchiveStringToEvaluate interface {
	isArchiveStringToEvaluate()
}

// The name of the email attribute to evaluate.
type ArchiveStringToEvaluateMemberAttribute struct {
	Value ArchiveStringEmailAttribute

	noSmithyDocumentSerde
}

func (*ArchiveStringToEvaluateMemberAttribute) isArchiveStringToEvaluate() {}

// This action to delivers an email to a mailbox.
type DeliverToMailboxAction struct {

	// The Amazon Resource Name (ARN) of a WorkMail organization to deliver the email
	// to.
	//
	// This member is required.
	MailboxArn *string

	// The Amazon Resource Name (ARN) of an IAM role to use to execute this action.
	// The role must have access to the workmail:DeliverToMailbox API.
	//
	// This member is required.
	RoleArn *string

	// A policy that states what to do in the case of failure. The action will fail if
	// there are configuration errors. For example, the mailbox ARN is no longer valid.
	ActionFailurePolicy ActionFailurePolicy

	noSmithyDocumentSerde
}

// The action to deliver incoming emails to an Amazon Q Business application for
// indexing.
type DeliverToQBusinessAction struct {

	// The unique identifier of the Amazon Q Business application instance where the
	// email content will be delivered.
	//
	// This member is required.
	ApplicationId *string

	// The identifier of the knowledge base index within the Amazon Q Business
	// application where the email content will be stored and indexed.
	//
	// This member is required.
	IndexId *string

	// The Amazon Resource Name (ARN) of the IAM Role to use while delivering to
	// Amazon Q Business. This role must have access to the qbusiness:BatchPutDocument
	// API for the given application and index.
	//
	// This member is required.
	RoleArn *string

	// A policy that states what to do in the case of failure. The action will fail if
	// there are configuration errors. For example, the specified application has been
	// deleted or the role lacks necessary permissions to call the
	// qbusiness:BatchPutDocument API.
	ActionFailurePolicy ActionFailurePolicy

	noSmithyDocumentSerde
}

// This action causes processing to stop and the email to be dropped. If the
// action applies only to certain recipients, only those recipients are dropped,
// and processing continues for other recipients.
type DropAction struct {
	noSmithyDocumentSerde
}

// The SMTP envelope information of the email.
type Envelope struct {

	// The RCPT FROM given by the host from which the email was received.
	From *string

	// The HELO used by the host from which the email was received.
	Helo *string

	// All SMTP TO entries given by the host from which the email was received.
	To []string

	noSmithyDocumentSerde
}

// The destination configuration for delivering exported email data.
//
// The following types satisfy this interface:
//
//	ExportDestinationConfigurationMemberS3
type ExportDestinationConfiguration interface {
	isExportDestinationConfiguration()
}

// Configuration for delivering to an Amazon S3 bucket.
type ExportDestinationConfigurationMemberS3 struct {
	Value S3ExportDestinationConfiguration

	noSmithyDocumentSerde
}

func (*ExportDestinationConfigurationMemberS3) isExportDestinationConfiguration() {}

// The current status of an archive export job.
type ExportStatus struct {

	// The timestamp of when the export job completed (if finished).
	CompletionTimestamp *time.Time

	// An error message if the export job failed.
	ErrorMessage *string

	// The current state of the export job.
	State ExportState

	// The timestamp of when the export job was submitted.
	SubmissionTimestamp *time.Time

	noSmithyDocumentSerde
}

// Summary statuses of an archive export job.
type ExportSummary struct {

	// The unique identifier of the export job.
	ExportId *string

	// The current status of the export job.
	Status *ExportStatus

	noSmithyDocumentSerde
}

// The import data format contains the specifications of the input file that would
// be passed to the address list import job.
type ImportDataFormat struct {

	// The type of file that would be passed as an input for the address list import
	// job.
	//
	// This member is required.
	ImportDataType ImportDataType

	noSmithyDocumentSerde
}

// Details about an import job.
type ImportJob struct {

	// The unique identifier of the address list the import job was created for.
	//
	// This member is required.
	AddressListId *string

	// The timestamp of when the import job was created.
	//
	// This member is required.
	CreatedTimestamp *time.Time

	// The format of the input for the import job.
	//
	// This member is required.
	ImportDataFormat *ImportDataFormat

	// The identifier of the import job.
	//
	// This member is required.
	JobId *string

	// A user-friendly name for the import job.
	//
	// This member is required.
	Name *string

	// The pre-signed URL target for uploading the input file.
	//
	// This member is required.
	PreSignedUrl *string

	// The status of the import job.
	//
	// This member is required.
	Status ImportJobStatus

	// The timestamp of when the import job was completed.
	CompletedTimestamp *time.Time

	// The reason for failure of an import job.
	Error *string

	// The number of addresses in the input that failed to get imported into address
	// list.
	FailedItemsCount *int32

	// The number of addresses in the input that were successfully imported into the
	// address list.
	ImportedItemsCount *int32

	// The timestamp of when the import job was started.
	StartTimestamp *time.Time

	noSmithyDocumentSerde
}

// The Add On ARN and its returned value that is evaluated in a policy statement's
// conditional expression to either deny or block the incoming email.
type IngressAnalysis struct {

	// The Amazon Resource Name (ARN) of an Add On.
	//
	// This member is required.
	Analyzer *string

	// The returned value from an Add On.
	//
	// This member is required.
	ResultField *string

	noSmithyDocumentSerde
}

// The structure for a boolean condition matching on the incoming mail.
type IngressBooleanExpression struct {

	// The operand on which to perform a boolean condition operation.
	//
	// This member is required.
	Evaluate IngressBooleanToEvaluate

	// The matching operator for a boolean condition expression.
	//
	// This member is required.
	Operator IngressBooleanOperator

	noSmithyDocumentSerde
}

// The union type representing the allowed types of operands for a boolean
// condition.
//
// The following types satisfy this interface:
//
//	IngressBooleanToEvaluateMemberAnalysis
//	IngressBooleanToEvaluateMemberIsInAddressList
type IngressBooleanToEvaluate interface {
	isIngressBooleanToEvaluate()
}

// The structure type for a boolean condition stating the Add On ARN and its
// returned value.
type IngressBooleanToEvaluateMemberAnalysis struct {
	Value IngressAnalysis

	noSmithyDocumentSerde
}

func (*IngressBooleanToEvaluateMemberAnalysis) isIngressBooleanToEvaluate() {}

// The structure type for a boolean condition that provides the address lists to
// evaluate incoming traffic on.
type IngressBooleanToEvaluateMemberIsInAddressList struct {
	Value IngressIsInAddressList

	noSmithyDocumentSerde
}

func (*IngressBooleanToEvaluateMemberIsInAddressList) isIngressBooleanToEvaluate() {}

// The structure for an IP based condition matching on the incoming mail.
//
// The following types satisfy this interface:
//
//	IngressIpToEvaluateMemberAttribute
type IngressIpToEvaluate interface {
	isIngressIpToEvaluate()
}

// An enum type representing the allowed attribute types for an IP condition.
type IngressIpToEvaluateMemberAttribute struct {
	Value IngressIpv4Attribute

	noSmithyDocumentSerde
}

func (*IngressIpToEvaluateMemberAttribute) isIngressIpToEvaluate() {}

// The union type representing the allowed types for the left hand side of an IP
// condition.
type IngressIpv4Expression struct {

	// The left hand side argument of an IP condition expression.
	//
	// This member is required.
	Evaluate IngressIpToEvaluate

	// The matching operator for an IP condition expression.
	//
	// This member is required.
	Operator IngressIpOperator

	// The right hand side argument of an IP condition expression.
	//
	// This member is required.
	Values []string

	noSmithyDocumentSerde
}

// The address lists and the address list attribute value that is evaluated in a
// policy statement's conditional expression to either deny or block the incoming
// email.
type IngressIsInAddressList struct {

	// The address lists that will be used for evaluation.
	//
	// This member is required.
	AddressLists []string

	// The email attribute that needs to be evaluated against the address list.
	//
	// This member is required.
	Attribute IngressAddressListEmailAttribute

	noSmithyDocumentSerde
}

// The structure of an ingress endpoint resource.
type IngressPoint struct {

	// The identifier of the ingress endpoint resource.
	//
	// This member is required.
	IngressPointId *string

	// A user friendly name for the ingress endpoint resource.
	//
	// This member is required.
	IngressPointName *string

	// The status of the ingress endpoint resource.
	//
	// This member is required.
	Status IngressPointStatus

	// The type of ingress endpoint resource.
	//
	// This member is required.
	Type IngressPointType

	//  The DNS A Record that identifies your ingress endpoint. Configure your DNS
	// Mail Exchange (MX) record with this value to route emails to Mail Manager.
	ARecord *string

	noSmithyDocumentSerde
}

// The authentication configuration for the ingress endpoint resource.
type IngressPointAuthConfiguration struct {

	// The ingress endpoint password configuration for the ingress endpoint resource.
	IngressPointPasswordConfiguration *IngressPointPasswordConfiguration

	// The ingress endpoint SecretsManager::Secret ARN configuration for the ingress
	// endpoint resource.
	SecretArn *string

	noSmithyDocumentSerde
}

// The configuration of the ingress endpoint resource.
//
// The following types satisfy this interface:
//
//	IngressPointConfigurationMemberSecretArn
//	IngressPointConfigurationMemberSmtpPassword
type IngressPointConfiguration interface {
	isIngressPointConfiguration()
}

// The SecretsManager::Secret ARN of the ingress endpoint resource.
type IngressPointConfigurationMemberSecretArn struct {
	Value string

	noSmithyDocumentSerde
}

func (*IngressPointConfigurationMemberSecretArn) isIngressPointConfiguration() {}

// The password of the ingress endpoint resource.
type IngressPointConfigurationMemberSmtpPassword struct {
	Value string

	noSmithyDocumentSerde
}

func (*IngressPointConfigurationMemberSmtpPassword) isIngressPointConfiguration() {}

// The password configuration of the ingress endpoint resource.
type IngressPointPasswordConfiguration struct {

	// The previous password expiry timestamp of the ingress endpoint resource.
	PreviousSmtpPasswordExpiryTimestamp *time.Time

	// The previous password version of the ingress endpoint resource.
	PreviousSmtpPasswordVersion *string

	// The current password expiry timestamp of the ingress endpoint resource.
	SmtpPasswordVersion *string

	noSmithyDocumentSerde
}

// The structure for a string based condition matching on the incoming mail.
type IngressStringExpression struct {

	// The left hand side argument of a string condition expression.
	//
	// This member is required.
	Evaluate IngressStringToEvaluate

	// The matching operator for a string condition expression.
	//
	// This member is required.
	Operator IngressStringOperator

	// The right hand side argument of a string condition expression.
	//
	// This member is required.
	Values []string

	noSmithyDocumentSerde
}

// The union type representing the allowed types for the left hand side of a
// string condition.
//
// The following types satisfy this interface:
//
//	IngressStringToEvaluateMemberAttribute
type IngressStringToEvaluate interface {
	isIngressStringToEvaluate()
}

// The enum type representing the allowed attribute types for a string condition.
type IngressStringToEvaluateMemberAttribute struct {
	Value IngressStringEmailAttribute

	noSmithyDocumentSerde
}

func (*IngressStringToEvaluateMemberAttribute) isIngressStringToEvaluate() {}

// The structure for a TLS related condition matching on the incoming mail.
type IngressTlsProtocolExpression struct {

	// The left hand side argument of a TLS condition expression.
	//
	// This member is required.
	Evaluate IngressTlsProtocolToEvaluate

	// The matching operator for a TLS condition expression.
	//
	// This member is required.
	Operator IngressTlsProtocolOperator

	// The right hand side argument of a TLS condition expression.
	//
	// This member is required.
	Value IngressTlsProtocolAttribute

	noSmithyDocumentSerde
}

// The union type representing the allowed types for the left hand side of a TLS
// condition.
//
// The following types satisfy this interface:
//
//	IngressTlsProtocolToEvaluateMemberAttribute
type IngressTlsProtocolToEvaluate interface {
	isIngressTlsProtocolToEvaluate()
}

// The enum type representing the allowed attribute types for the TLS condition.
type IngressTlsProtocolToEvaluateMemberAttribute struct {
	Value IngressTlsAttribute

	noSmithyDocumentSerde
}

func (*IngressTlsProtocolToEvaluateMemberAttribute) isIngressTlsProtocolToEvaluate() {}

// The textual body content of an email message.
type MessageBody struct {

	// The HTML body content of the message.
	Html *string

	// A flag indicating if the email was malformed.
	MessageMalformed *bool

	// The plain text body content of the message.
	Text *string

	noSmithyDocumentSerde
}

// The metadata about the email.
type Metadata struct {

	// The name of the configuration set used when sent through a configuration set
	// with archiving enabled.
	ConfigurationSet *string

	// The ID of the ingress endpoint through which the email was received.
	IngressPointId *string

	// The ID of the rule set that processed the email.
	RuleSetId *string

	// The name of the host from which the email was received.
	SenderHostname *string

	// The IP address of the host from which the email was received.
	SenderIpAddress *string

	// The name of the API call used when sent through a configuration set with
	// archiving enabled.
	SendingMethod *string

	// The name of the dedicated IP pool used when sent through a configuration set
	// with archiving enabled.
	SendingPool *string

	// Specifies the archived email source, identified by either a Rule Set's ARN with
	// an Archive action, or a Configuration Set's Archive ARN.
	SourceArn *string

	// The identity name used to authorize the sending action when sent through a
	// configuration set with archiving enabled.
	SourceIdentity *string

	// The timestamp of when the email was received.
	Timestamp *time.Time

	// The TLS cipher suite used to communicate with the host from which the email was
	// received.
	TlsCipherSuite *string

	// The TLS protocol used to communicate with the host from which the email was
	// received.
	TlsProtocol *string

	// The ID of the traffic policy that was in effect when the email was received.
	TrafficPolicyId *string

	noSmithyDocumentSerde
}

// Explicitly indicate that the relay destination server does not require SMTP
// credential authentication.
type NoAuthentication struct {
	noSmithyDocumentSerde
}

// The email traffic filtering conditions which are contained in a traffic policy
// resource.
//
// The following types satisfy this interface:
//
//	PolicyConditionMemberBooleanExpression
//	PolicyConditionMemberIpExpression
//	PolicyConditionMemberStringExpression
//	PolicyConditionMemberTlsExpression
type PolicyCondition interface {
	isPolicyCondition()
}

// This represents a boolean type condition matching on the incoming mail. It
// performs the boolean operation configured in 'Operator' and evaluates the
// 'Protocol' object against the 'Value'.
type PolicyConditionMemberBooleanExpression struct {
	Value IngressBooleanExpression

	noSmithyDocumentSerde
}

func (*PolicyConditionMemberBooleanExpression) isPolicyCondition() {}

// This represents an IP based condition matching on the incoming mail. It
// performs the operation configured in 'Operator' and evaluates the 'Protocol'
// object against the 'Value'.
type PolicyConditionMemberIpExpression struct {
	Value IngressIpv4Expression

	noSmithyDocumentSerde
}

func (*PolicyConditionMemberIpExpression) isPolicyCondition() {}

// This represents a string based condition matching on the incoming mail. It
// performs the string operation configured in 'Operator' and evaluates the
// 'Protocol' object against the 'Value'.
type PolicyConditionMemberStringExpression struct {
	Value IngressStringExpression

	noSmithyDocumentSerde
}

func (*PolicyConditionMemberStringExpression) isPolicyCondition() {}

// This represents a TLS based condition matching on the incoming mail. It
// performs the operation configured in 'Operator' and evaluates the 'Protocol'
// object against the 'Value'.
type PolicyConditionMemberTlsExpression struct {
	Value IngressTlsProtocolExpression

	noSmithyDocumentSerde
}

func (*PolicyConditionMemberTlsExpression) isPolicyCondition() {}

// The structure containing traffic policy conditions and actions.
type PolicyStatement struct {

	// The action that informs a traffic policy resource to either allow or block the
	// email if it matches a condition in the policy statement.
	//
	// This member is required.
	Action AcceptAction

	// The list of conditions to apply to incoming messages for filtering email
	// traffic.
	//
	// This member is required.
	Conditions []PolicyCondition

	noSmithyDocumentSerde
}

// The relay resource that can be used as a rule to relay receiving emails to the
// destination relay server.
type Relay struct {

	// The timestamp of when the relay was last modified.
	LastModifiedTimestamp *time.Time

	// The unique relay identifier.
	RelayId *string

	// The unique relay name.
	RelayName *string

	noSmithyDocumentSerde
}

// The action relays the email via SMTP to another specific SMTP server.
type RelayAction struct {

	// The identifier of the relay resource to be used when relaying an email.
	//
	// This member is required.
	Relay *string

	// A policy that states what to do in the case of failure. The action will fail if
	// there are configuration errors. For example, the specified relay has been
	// deleted.
	ActionFailurePolicy ActionFailurePolicy

	// This action specifies whether to preserve or replace original mail from address
	// while relaying received emails to a destination server.
	MailFrom MailFrom

	noSmithyDocumentSerde
}

// Authentication for the relay destination server—specify the secretARN where the
// SMTP credentials are stored, or specify an empty NoAuthentication structure if
// the relay destination server does not require SMTP credential authentication.
//
// The following types satisfy this interface:
//
//	RelayAuthenticationMemberNoAuthentication
//	RelayAuthenticationMemberSecretArn
type RelayAuthentication interface {
	isRelayAuthentication()
}

// Keep an empty structure if the relay destination server does not require SMTP
// credential authentication.
type RelayAuthenticationMemberNoAuthentication struct {
	Value NoAuthentication

	noSmithyDocumentSerde
}

func (*RelayAuthenticationMemberNoAuthentication) isRelayAuthentication() {}

// The ARN of the secret created in secrets manager where the relay server's SMTP
// credentials are stored.
type RelayAuthenticationMemberSecretArn struct {
	Value string

	noSmithyDocumentSerde
}

func (*RelayAuthenticationMemberSecretArn) isRelayAuthentication() {}

// This action replaces the email envelope recipients with the given list of
// recipients. If the condition of this action applies only to a subset of
// recipients, only those recipients are replaced with the recipients specified in
// the action. The message contents and headers are unaffected by this action, only
// the envelope recipients are updated.
type ReplaceRecipientAction struct {

	// This action specifies the replacement recipient email addresses to insert.
	ReplaceWith []string

	noSmithyDocumentSerde
}

// A result row containing metadata for an archived email message.
type Row struct {

	// The unique identifier of the archived message.
	ArchivedMessageId *string

	// The email addresses in the CC header.
	Cc *string

	// The date the email was sent.
	Date *string

	// The SMTP envelope information of the email.
	Envelope *Envelope

	// The email address of the sender.
	From *string

	// A flag indicating if the email has attachments.
	HasAttachments *bool

	// The email message ID this is a reply to.
	InReplyTo *string

	// The ID of the ingress endpoint through which the email was received.
	IngressPointId *string

	// The unique message ID of the email.
	MessageId *string

	// The received headers from the email delivery path.
	ReceivedHeaders []string

	// The timestamp of when the email was received.
	ReceivedTimestamp *time.Time

	// The name of the host from which the email was received.
	SenderHostname *string

	//   - Mail archived with Mail Manager: The IP address of the client that connects
	//   to the ingress endpoint.
	//
	//   - Mail sent through a configuration set with the archiving option enabled:
	//   The IP address of the client that makes the SendEmail API call.
	SenderIpAddress *string

	// Specifies the archived email source, identified by either a Rule Set's ARN with
	// an Archive action, or a Configuration Set's Archive ARN.
	SourceArn *string

	// The subject header value of the email.
	Subject *string

	// The email addresses in the To header.
	To *string

	// The user agent that sent the email.
	XMailer *string

	// The original user agent that sent the email.
	XOriginalMailer *string

	// The priority level of the email.
	XPriority *string

	noSmithyDocumentSerde
}

// A rule contains conditions, "unless conditions" and actions. For each envelope
// recipient of an email, if all conditions match and none of the "unless
// conditions" match, then all of the actions are executed sequentially. If no
// conditions are provided, the rule always applies and the actions are implicitly
// executed. If only "unless conditions" are provided, the rule applies if the
// email does not match the evaluation of the "unless conditions".
type Rule struct {

	// The list of actions to execute when the conditions match the incoming email,
	// and none of the "unless conditions" match.
	//
	// This member is required.
	Actions []RuleAction

	// The conditions of this rule. All conditions must match the email for the
	// actions to be executed. An empty list of conditions means that all emails match,
	// but are still subject to any "unless conditions"
	Conditions []RuleCondition

	// The user-friendly name of the rule.
	Name *string

	// The "unless conditions" of this rule. None of the conditions can match the
	// email for the actions to be executed. If any of these conditions do match the
	// email, then the actions are not executed.
	Unless []RuleCondition

	noSmithyDocumentSerde
}

// The action for a rule to take. Only one of the contained actions can be set.
//
// The following types satisfy this interface:
//
//	RuleActionMemberAddHeader
//	RuleActionMemberArchive
//	RuleActionMemberDeliverToMailbox
//	RuleActionMemberDeliverToQBusiness
//	RuleActionMemberDrop
//	RuleActionMemberRelay
//	RuleActionMemberReplaceRecipient
//	RuleActionMemberSend
//	RuleActionMemberWriteToS3
type RuleAction interface {
	isRuleAction()
}

// This action adds a header. This can be used to add arbitrary email headers.
type RuleActionMemberAddHeader struct {
	Value AddHeaderAction

	noSmithyDocumentSerde
}

func (*RuleActionMemberAddHeader) isRuleAction() {}

// This action archives the email. This can be used to deliver an email to an
// archive.
type RuleActionMemberArchive struct {
	Value ArchiveAction

	noSmithyDocumentSerde
}

func (*RuleActionMemberArchive) isRuleAction() {}

// This action delivers an email to a WorkMail mailbox.
type RuleActionMemberDeliverToMailbox struct {
	Value DeliverToMailboxAction

	noSmithyDocumentSerde
}

func (*RuleActionMemberDeliverToMailbox) isRuleAction() {}

// This action delivers an email to an Amazon Q Business application for ingestion
// into its knowledge base.
type RuleActionMemberDeliverToQBusiness struct {
	Value DeliverToQBusinessAction

	noSmithyDocumentSerde
}

func (*RuleActionMemberDeliverToQBusiness) isRuleAction() {}

// This action terminates the evaluation of rules in the rule set.
type RuleActionMemberDrop struct {
	Value DropAction

	noSmithyDocumentSerde
}

func (*RuleActionMemberDrop) isRuleAction() {}

// This action relays the email to another SMTP server.
type RuleActionMemberRelay struct {
	Value RelayAction

	noSmithyDocumentSerde
}

func (*RuleActionMemberRelay) isRuleAction() {}

// The action replaces certain or all recipients with a different set of
// recipients.
type RuleActionMemberReplaceRecipient struct {
	Value ReplaceRecipientAction

	noSmithyDocumentSerde
}

func (*RuleActionMemberReplaceRecipient) isRuleAction() {}

// This action sends the email to the internet.
type RuleActionMemberSend struct {
	Value SendAction

	noSmithyDocumentSerde
}

func (*RuleActionMemberSend) isRuleAction() {}

// This action writes the MIME content of the email to an S3 bucket.
type RuleActionMemberWriteToS3 struct {
	Value S3Action

	noSmithyDocumentSerde
}

func (*RuleActionMemberWriteToS3) isRuleAction() {}

// A boolean expression to be used in a rule condition.
type RuleBooleanExpression struct {

	// The operand on which to perform a boolean condition operation.
	//
	// This member is required.
	Evaluate RuleBooleanToEvaluate

	// The matching operator for a boolean condition expression.
	//
	// This member is required.
	Operator RuleBooleanOperator

	noSmithyDocumentSerde
}

// The union type representing the allowed types of operands for a boolean
// condition.
//
// The following types satisfy this interface:
//
//	RuleBooleanToEvaluateMemberAttribute
//	RuleBooleanToEvaluateMemberIsInAddressList
type RuleBooleanToEvaluate interface {
	isRuleBooleanToEvaluate()
}

// The boolean type representing the allowed attribute types for an email.
type RuleBooleanToEvaluateMemberAttribute struct {
	Value RuleBooleanEmailAttribute

	noSmithyDocumentSerde
}

func (*RuleBooleanToEvaluateMemberAttribute) isRuleBooleanToEvaluate() {}

// The structure representing the address lists and address list attribute that
// will be used in evaluation of boolean expression.
type RuleBooleanToEvaluateMemberIsInAddressList struct {
	Value RuleIsInAddressList

	noSmithyDocumentSerde
}

func (*RuleBooleanToEvaluateMemberIsInAddressList) isRuleBooleanToEvaluate() {}

// The conditional expression used to evaluate an email for determining if a rule
// action should be taken.
//
// The following types satisfy this interface:
//
//	RuleConditionMemberBooleanExpression
//	RuleConditionMemberDmarcExpression
//	RuleConditionMemberIpExpression
//	RuleConditionMemberNumberExpression
//	RuleConditionMemberStringExpression
//	RuleConditionMemberVerdictExpression
type RuleCondition interface {
	isRuleCondition()
}

// The condition applies to a boolean expression passed in this field.
type RuleConditionMemberBooleanExpression struct {
	Value RuleBooleanExpression

	noSmithyDocumentSerde
}

func (*RuleConditionMemberBooleanExpression) isRuleCondition() {}

// The condition applies to a DMARC policy expression passed in this field.
type RuleConditionMemberDmarcExpression struct {
	Value RuleDmarcExpression

	noSmithyDocumentSerde
}

func (*RuleConditionMemberDmarcExpression) isRuleCondition() {}

// The condition applies to an IP address expression passed in this field.
type RuleConditionMemberIpExpression struct {
	Value RuleIpExpression

	noSmithyDocumentSerde
}

func (*RuleConditionMemberIpExpression) isRuleCondition() {}

// The condition applies to a number expression passed in this field.
type RuleConditionMemberNumberExpression struct {
	Value RuleNumberExpression

	noSmithyDocumentSerde
}

func (*RuleConditionMemberNumberExpression) isRuleCondition() {}

// The condition applies to a string expression passed in this field.
type RuleConditionMemberStringExpression struct {
	Value RuleStringExpression

	noSmithyDocumentSerde
}

func (*RuleConditionMemberStringExpression) isRuleCondition() {}

// The condition applies to a verdict expression passed in this field.
type RuleConditionMemberVerdictExpression struct {
	Value RuleVerdictExpression

	noSmithyDocumentSerde
}

func (*RuleConditionMemberVerdictExpression) isRuleCondition() {}

// A DMARC policy expression. The condition matches if the given DMARC policy
// matches that of the incoming email.
type RuleDmarcExpression struct {

	// The operator to apply to the DMARC policy of the incoming email.
	//
	// This member is required.
	Operator RuleDmarcOperator

	// The values to use for the given DMARC policy operator. For the operator EQUALS,
	// if multiple values are given, they are evaluated as an OR. That is, if any of
	// the given values match, the condition is deemed to match. For the operator
	// NOT_EQUALS, if multiple values are given, they are evaluated as an AND. That is,
	// only if the email's DMARC policy is not equal to any of the given values, then
	// the condition is deemed to match.
	//
	// This member is required.
	Values []RuleDmarcPolicy

	noSmithyDocumentSerde
}

// An IP address expression matching certain IP addresses within a given range of
// IP addresses.
type RuleIpExpression struct {

	// The IP address to evaluate in this condition.
	//
	// This member is required.
	Evaluate RuleIpToEvaluate

	// The operator to evaluate the IP address.
	//
	// This member is required.
	Operator RuleIpOperator

	// The IP CIDR blocks in format "x.y.z.w/n" (eg 10.0.0.0/8) to match with the
	// email's IP address. For the operator CIDR_MATCHES, if multiple values are given,
	// they are evaluated as an OR. That is, if the IP address is contained within any
	// of the given CIDR ranges, the condition is deemed to match. For
	// NOT_CIDR_MATCHES, if multiple CIDR ranges are given, the condition is deemed to
	// match if the IP address is not contained in any of the given CIDR ranges.
	//
	// This member is required.
	Values []string

	noSmithyDocumentSerde
}

// The IP address to evaluate for this condition.
//
// The following types satisfy this interface:
//
//	RuleIpToEvaluateMemberAttribute
type RuleIpToEvaluate interface {
	isRuleIpToEvaluate()
}

// The attribute of the email to evaluate.
type RuleIpToEvaluateMemberAttribute struct {
	Value RuleIpEmailAttribute

	noSmithyDocumentSerde
}

func (*RuleIpToEvaluateMemberAttribute) isRuleIpToEvaluate() {}

// The structure type for a boolean condition that provides the address lists and
// address list attribute to evaluate.
type RuleIsInAddressList struct {

	// The address lists that will be used for evaluation.
	//
	// This member is required.
	AddressLists []string

	// The email attribute that needs to be evaluated against the address list.
	//
	// This member is required.
	Attribute RuleAddressListEmailAttribute

	noSmithyDocumentSerde
}

// A number expression to match numeric conditions with integers from the incoming
// email.
type RuleNumberExpression struct {

	// The number to evaluate in a numeric condition expression.
	//
	// This member is required.
	Evaluate RuleNumberToEvaluate

	// The operator for a numeric condition expression.
	//
	// This member is required.
	Operator RuleNumberOperator

	// The value to evaluate in a numeric condition expression.
	//
	// This member is required.
	Value *float64

	noSmithyDocumentSerde
}

// The number to evaluate in a numeric condition expression.
//
// The following types satisfy this interface:
//
//	RuleNumberToEvaluateMemberAttribute
type RuleNumberToEvaluate interface {
	isRuleNumberToEvaluate()
}

// An email attribute that is used as the number to evaluate.
type RuleNumberToEvaluateMemberAttribute struct {
	Value RuleNumberEmailAttribute

	noSmithyDocumentSerde
}

func (*RuleNumberToEvaluateMemberAttribute) isRuleNumberToEvaluate() {}

// A rule set contains a list of rules that are evaluated in order. Each rule is
// evaluated sequentially for each email.
type RuleSet struct {

	// The last modification date of the rule set.
	LastModificationDate *time.Time

	// The identifier of the rule set.
	RuleSetId *string

	// A user-friendly name for the rule set.
	RuleSetName *string

	noSmithyDocumentSerde
}

// A string expression is evaluated against strings or substrings of the email.
type RuleStringExpression struct {

	// The string to evaluate in a string condition expression.
	//
	// This member is required.
	Evaluate RuleStringToEvaluate

	// The matching operator for a string condition expression.
	//
	// This member is required.
	Operator RuleStringOperator

	// The string(s) to be evaluated in a string condition expression. For all
	// operators, except for NOT_EQUALS, if multiple values are given, the values are
	// processed as an OR. That is, if any of the values match the email's string using
	// the given operator, the condition is deemed to match. However, for NOT_EQUALS,
	// the condition is only deemed to match if none of the given strings match the
	// email's string.
	//
	// This member is required.
	Values []string

	noSmithyDocumentSerde
}

// The string to evaluate in a string condition expression.
//
// The following types satisfy this interface:
//
//	RuleStringToEvaluateMemberAttribute
//	RuleStringToEvaluateMemberMimeHeaderAttribute
type RuleStringToEvaluate interface {
	isRuleStringToEvaluate()
}

// The email attribute to evaluate in a string condition expression.
type RuleStringToEvaluateMemberAttribute struct {
	Value RuleStringEmailAttribute

	noSmithyDocumentSerde
}

func (*RuleStringToEvaluateMemberAttribute) isRuleStringToEvaluate() {}

// The email MIME X-Header attribute to evaluate in a string condition expression.
type RuleStringToEvaluateMemberMimeHeaderAttribute struct {
	Value string

	noSmithyDocumentSerde
}

func (*RuleStringToEvaluateMemberMimeHeaderAttribute) isRuleStringToEvaluate() {}

// A verdict expression is evaluated against verdicts of the email.
type RuleVerdictExpression struct {

	// The verdict to evaluate in a verdict condition expression.
	//
	// This member is required.
	Evaluate RuleVerdictToEvaluate

	// The matching operator for a verdict condition expression.
	//
	// This member is required.
	Operator RuleVerdictOperator

	// The values to match with the email's verdict using the given operator. For the
	// EQUALS operator, if multiple values are given, the condition is deemed to match
	// if any of the given verdicts match that of the email. For the NOT_EQUALS
	// operator, if multiple values are given, the condition is deemed to match of none
	// of the given verdicts match the verdict of the email.
	//
	// This member is required.
	Values []RuleVerdict

	noSmithyDocumentSerde
}

// The verdict to evaluate in a verdict condition expression.
//
// The following types satisfy this interface:
//
//	RuleVerdictToEvaluateMemberAnalysis
//	RuleVerdictToEvaluateMemberAttribute
type RuleVerdictToEvaluate interface {
	isRuleVerdictToEvaluate()
}

// The Add On ARN and its returned value to evaluate in a verdict condition
// expression.
type RuleVerdictToEvaluateMemberAnalysis struct {
	Value Analysis

	noSmithyDocumentSerde
}

func (*RuleVerdictToEvaluateMemberAnalysis) isRuleVerdictToEvaluate() {}

// The email verdict attribute to evaluate in a string verdict expression.
type RuleVerdictToEvaluateMemberAttribute struct {
	Value RuleVerdictAttribute

	noSmithyDocumentSerde
}

func (*RuleVerdictToEvaluateMemberAttribute) isRuleVerdictToEvaluate() {}

// Writes the MIME content of the email to an S3 bucket.
type S3Action struct {

	// The Amazon Resource Name (ARN) of the IAM Role to use while writing to S3. This
	// role must have access to the s3:PutObject, kms:Encrypt, and kms:GenerateDataKey
	// APIs for the given bucket.
	//
	// This member is required.
	RoleArn *string

	// The bucket name of the S3 bucket to write to.
	//
	// This member is required.
	S3Bucket *string

	// A policy that states what to do in the case of failure. The action will fail if
	// there are configuration errors. For example, the specified the bucket has been
	// deleted.
	ActionFailurePolicy ActionFailurePolicy

	// The S3 prefix to use for the write to the s3 bucket.
	S3Prefix *string

	// The KMS Key ID to use to encrypt the message in S3.
	S3SseKmsKeyId *string

	noSmithyDocumentSerde
}

// The configuration for exporting email data to an Amazon S3 bucket.
type S3ExportDestinationConfiguration struct {

	// The S3 location to deliver the exported email data.
	S3Location *string

	noSmithyDocumentSerde
}

// An address that is a member of an address list.
type SavedAddress struct {

	// The email or domain that constitutes the address.
	//
	// This member is required.
	Address *string

	// The timestamp of when the address was added to the address list.
	//
	// This member is required.
	CreatedTimestamp *time.Time

	noSmithyDocumentSerde
}

// The current status of an archive search job.
type SearchStatus struct {

	// The timestamp of when the search completed (if finished).
	CompletionTimestamp *time.Time

	// An error message if the search failed.
	ErrorMessage *string

	// The current state of the search job.
	State SearchState

	// The timestamp of when the search was submitted.
	SubmissionTimestamp *time.Time

	noSmithyDocumentSerde
}

// Summary details of an archive search job.
type SearchSummary struct {

	// The unique identifier of the search job.
	SearchId *string

	// The current status of the search job.
	Status *SearchStatus

	noSmithyDocumentSerde
}

// Sends the email to the internet using the ses:SendRawEmail API.
type SendAction struct {

	// The Amazon Resource Name (ARN) of the role to use for this action. This role
	// must have access to the ses:SendRawEmail API.
	//
	// This member is required.
	RoleArn *string

	// A policy that states what to do in the case of failure. The action will fail if
	// there are configuration errors. For example, the caller does not have the
	// permissions to call the sendRawEmail API.
	ActionFailurePolicy ActionFailurePolicy

	noSmithyDocumentSerde
}

// A key-value pair (the value is optional), that you can define and assign to
// Amazon Web Services resources.
type Tag struct {

	// The key of the key-value tag.
	//
	// This member is required.
	Key *string

	// The value of the key-value tag.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// The structure of a traffic policy resource which is a container for policy
// statements.
type TrafficPolicy struct {

	// Default action instructs the traﬃc policy to either Allow or Deny (block)
	// messages that fall outside of (or not addressed by) the conditions of your
	// policy statements
	//
	// This member is required.
	DefaultAction AcceptAction

	// The identifier of the traffic policy resource.
	//
	// This member is required.
	TrafficPolicyId *string

	// A user-friendly name of the traffic policy resource.
	//
	// This member is required.
	TrafficPolicyName *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde

// UnknownUnionMember is returned when a union member is returned over the wire,
// but has an unknown tag.
type UnknownUnionMember struct {
	Tag   string
	Value []byte

	noSmithyDocumentSerde
}

func (*UnknownUnionMember) isArchiveBooleanToEvaluate()       {}
func (*UnknownUnionMember) isArchiveFilterCondition()         {}
func (*UnknownUnionMember) isArchiveRetention()               {}
func (*UnknownUnionMember) isArchiveStringToEvaluate()        {}
func (*UnknownUnionMember) isExportDestinationConfiguration() {}
func (*UnknownUnionMember) isIngressBooleanToEvaluate()       {}
func (*UnknownUnionMember) isIngressIpToEvaluate()            {}
func (*UnknownUnionMember) isIngressPointConfiguration()      {}
func (*UnknownUnionMember) isIngressStringToEvaluate()        {}
func (*UnknownUnionMember) isIngressTlsProtocolToEvaluate()   {}
func (*UnknownUnionMember) isPolicyCondition()                {}
func (*UnknownUnionMember) isRelayAuthentication()            {}
func (*UnknownUnionMember) isRuleAction()                     {}
func (*UnknownUnionMember) isRuleBooleanToEvaluate()          {}
func (*UnknownUnionMember) isRuleCondition()                  {}
func (*UnknownUnionMember) isRuleIpToEvaluate()               {}
func (*UnknownUnionMember) isRuleNumberToEvaluate()           {}
func (*UnknownUnionMember) isRuleStringToEvaluate()           {}
func (*UnknownUnionMember) isRuleVerdictToEvaluate()          {}
