// Code generated by smithy-go-codegen DO NOT EDIT.

package medialive

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/medialive/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Create as many Networks as you need. You will associate one or more Clusters
// with each Network.Each Network provides MediaLive Anywhere with required
// information about the network in your organization that you are using for video
// encoding using MediaLive.
func (c *Client) CreateNetwork(ctx context.Context, params *CreateNetworkInput, optFns ...func(*Options)) (*CreateNetworkOutput, error) {
	if params == nil {
		params = &CreateNetworkInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateNetwork", params, optFns, c.addOperationCreateNetworkMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateNetworkOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// A request to create a Network.
type CreateNetworkInput struct {

	// An array of IpPoolCreateRequests that identify a collection of IP addresses in
	// your network that you want to reserve for use in MediaLive Anywhere.
	// MediaLiveAnywhere uses these IP addresses for Push inputs (in both Bridge and
	// NATnetworks) and for output destinations (only in Bridge networks).
	// EachIpPoolUpdateRequest specifies one CIDR block.
	IpPools []types.IpPoolCreateRequest

	// Specify a name that is unique in the AWS account. We recommend that you assign
	// a name that hints at the type of traffic on the network. Names are
	// case-sensitive.
	Name *string

	// An ID that you assign to a create request. This ID ensures idempotency when
	// creating resources.
	RequestId *string

	// An array of routes that MediaLive Anywhere needs to know about in order to
	// route encoding traffic.
	Routes []types.RouteCreateRequest

	// A collection of key-value pairs.
	Tags map[string]string

	noSmithyDocumentSerde
}

// Placeholder documentation for CreateNetworkResponse
type CreateNetworkOutput struct {

	// The ARN of this Network. It is automatically assigned when the Network is
	// created.
	Arn *string

	// Placeholder documentation for __listOf__string
	AssociatedClusterIds []string

	// The ID of the Network. Unique in the AWS account. The ID is the resource-id
	// portion of the ARN.
	Id *string

	// An array of IpPools in your organization's network that identify a collection
	// of IP addresses in this network that are reserved for use in MediaLive Anywhere.
	// MediaLive Anywhere uses these IP addresses for Push inputs (in both Bridge and
	// NAT networks) and for output destinations (only in Bridge networks). Each IpPool
	// specifies one CIDR block.
	IpPools []types.IpPool

	// The name that you specified for the Network.
	Name *string

	// An array of routes that MediaLive Anywhere needs to know about in order to
	// route encoding traffic.
	Routes []types.Route

	// The current state of the Network. Only MediaLive Anywhere can change the state.
	State types.NetworkState

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateNetworkMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateNetwork{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateNetwork{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateNetwork"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opCreateNetworkMiddleware(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateNetwork(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpCreateNetwork struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpCreateNetwork) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpCreateNetwork) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*CreateNetworkInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *CreateNetworkInput ")
	}

	if input.RequestId == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.RequestId = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opCreateNetworkMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpCreateNetwork{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opCreateNetwork(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateNetwork",
	}
}
