// Code generated by smithy-go-codegen DO NOT EDIT.

package medialive

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/medialive/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Delete the specified ChannelPlacementGroup that exists in the specified Cluster.
func (c *Client) DeleteChannelPlacementGroup(ctx context.Context, params *DeleteChannelPlacementGroupInput, optFns ...func(*Options)) (*DeleteChannelPlacementGroupOutput, error) {
	if params == nil {
		params = &DeleteChannelPlacementGroupInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DeleteChannelPlacementGroup", params, optFns, c.addOperationDeleteChannelPlacementGroupMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DeleteChannelPlacementGroupOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// Placeholder documentation for DeleteChannelPlacementGroupRequest
type DeleteChannelPlacementGroupInput struct {

	// The ID of the channel placement group.
	//
	// This member is required.
	ChannelPlacementGroupId *string

	// The ID of the cluster.
	//
	// This member is required.
	ClusterId *string

	noSmithyDocumentSerde
}

// Placeholder documentation for DeleteChannelPlacementGroupResponse
type DeleteChannelPlacementGroupOutput struct {

	// The ARN of this ChannelPlacementGroup. It is automatically assigned when the
	// ChannelPlacementGroup is created.
	Arn *string

	// Used in ListChannelPlacementGroupsResult
	Channels []string

	// The ID of the Cluster that the Node belongs to.
	ClusterId *string

	// The ID of the ChannelPlacementGroup. Unique in the AWS account. The ID is the
	// resource-id portion of the ARN.
	Id *string

	// The name that you specified for the ChannelPlacementGroup.
	Name *string

	// An array with one item, which is the single Node that is associated with the
	// ChannelPlacementGroup.
	Nodes []string

	// The current state of the ChannelPlacementGroup.
	State types.ChannelPlacementGroupState

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDeleteChannelPlacementGroupMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpDeleteChannelPlacementGroup{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpDeleteChannelPlacementGroup{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DeleteChannelPlacementGroup"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpDeleteChannelPlacementGroupValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDeleteChannelPlacementGroup(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opDeleteChannelPlacementGroup(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DeleteChannelPlacementGroup",
	}
}
