// Code generated by smithy-go-codegen DO NOT EDIT.

package mediapackagev2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/mediapackagev2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Creates a new harvest job to export content from a MediaPackage v2 channel to
// an S3 bucket.
func (c *Client) CreateHarvestJob(ctx context.Context, params *CreateHarvestJobInput, optFns ...func(*Options)) (*CreateHarvestJobOutput, error) {
	if params == nil {
		params = &CreateHarvestJobInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateHarvestJob", params, optFns, c.addOperationCreateHarvestJobMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateHarvestJobOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// The request object for creating a new harvest job.
type CreateHarvestJobInput struct {

	// The name of the channel group containing the channel from which to harvest
	// content.
	//
	// This member is required.
	ChannelGroupName *string

	// The name of the channel from which to harvest content.
	//
	// This member is required.
	ChannelName *string

	// The S3 destination where the harvested content will be placed.
	//
	// This member is required.
	Destination *types.Destination

	// A list of manifests to be harvested.
	//
	// This member is required.
	HarvestedManifests *types.HarvestedManifests

	// The name of the origin endpoint from which to harvest content.
	//
	// This member is required.
	OriginEndpointName *string

	// The configuration for when the harvest job should run, including start and end
	// times.
	//
	// This member is required.
	ScheduleConfiguration *types.HarvesterScheduleConfiguration

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientToken *string

	// An optional description for the harvest job.
	Description *string

	// A name for the harvest job. This name must be unique within the channel.
	HarvestJobName *string

	// A collection of tags associated with the harvest job.
	Tags map[string]string

	noSmithyDocumentSerde
}

// The response object returned after creating a harvest job.
type CreateHarvestJobOutput struct {

	// The Amazon Resource Name (ARN) of the created harvest job.
	//
	// This member is required.
	Arn *string

	// The name of the channel group containing the channel from which content is
	// being harvested.
	//
	// This member is required.
	ChannelGroupName *string

	// The name of the channel from which content is being harvested.
	//
	// This member is required.
	ChannelName *string

	// The date and time the harvest job was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The S3 destination where the harvested content will be placed.
	//
	// This member is required.
	Destination *types.Destination

	// The name of the created harvest job.
	//
	// This member is required.
	HarvestJobName *string

	// A list of manifests that will be harvested.
	//
	// This member is required.
	HarvestedManifests *types.HarvestedManifests

	// The date and time the harvest job was last modified.
	//
	// This member is required.
	ModifiedAt *time.Time

	// The name of the origin endpoint from which content is being harvested.
	//
	// This member is required.
	OriginEndpointName *string

	// The configuration for when the harvest job will run, including start and end
	// times.
	//
	// This member is required.
	ScheduleConfiguration *types.HarvesterScheduleConfiguration

	// The current status of the harvest job (e.g., CREATED, IN_PROGRESS, ABORTED,
	// COMPLETED, FAILED).
	//
	// This member is required.
	Status types.HarvestJobStatus

	// The description of the harvest job, if provided.
	Description *string

	// The current version of the harvest job. Used for concurrency control.
	ETag *string

	// An error message if the harvest job creation failed.
	ErrorMessage *string

	// A collection of tags associated with the harvest job.
	Tags map[string]string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateHarvestJobMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateHarvestJob{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateHarvestJob{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateHarvestJob"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opCreateHarvestJobMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpCreateHarvestJobValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateHarvestJob(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpCreateHarvestJob struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpCreateHarvestJob) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpCreateHarvestJob) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*CreateHarvestJobInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *CreateHarvestJobInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opCreateHarvestJobMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpCreateHarvestJob{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opCreateHarvestJob(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateHarvestJob",
	}
}
