// Code generated by smithy-go-codegen DO NOT EDIT.

package memorydb

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/memorydb/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates a new multi-Region cluster.
func (c *Client) CreateMultiRegionCluster(ctx context.Context, params *CreateMultiRegionClusterInput, optFns ...func(*Options)) (*CreateMultiRegionClusterOutput, error) {
	if params == nil {
		params = &CreateMultiRegionClusterInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateMultiRegionCluster", params, optFns, c.addOperationCreateMultiRegionClusterMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateMultiRegionClusterOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateMultiRegionClusterInput struct {

	// A suffix to be added to the multi-Region cluster name.
	//
	// This member is required.
	MultiRegionClusterNameSuffix *string

	// The node type to be used for the multi-Region cluster.
	//
	// This member is required.
	NodeType *string

	// A description for the multi-Region cluster.
	Description *string

	// The name of the engine to be used for the multi-Region cluster.
	Engine *string

	// The version of the engine to be used for the multi-Region cluster.
	EngineVersion *string

	// The name of the multi-Region parameter group to be associated with the cluster.
	MultiRegionParameterGroupName *string

	// The number of shards for the multi-Region cluster.
	NumShards *int32

	// Whether to enable TLS encryption for the multi-Region cluster.
	TLSEnabled *bool

	// A list of tags to be applied to the multi-Region cluster.
	Tags []types.Tag

	noSmithyDocumentSerde
}

type CreateMultiRegionClusterOutput struct {

	// Details about the newly created multi-Region cluster.
	MultiRegionCluster *types.MultiRegionCluster

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateMultiRegionClusterMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpCreateMultiRegionCluster{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpCreateMultiRegionCluster{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateMultiRegionCluster"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpCreateMultiRegionClusterValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateMultiRegionCluster(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateMultiRegionCluster(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateMultiRegionCluster",
	}
}
