// Code generated by smithy-go-codegen DO NOT EDIT.

package migrationhub

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/migrationhub/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// This is a paginated API that returns all the migration-task states for the
// specified MigrationTaskName and ProgressUpdateStream .
func (c *Client) ListMigrationTaskUpdates(ctx context.Context, params *ListMigrationTaskUpdatesInput, optFns ...func(*Options)) (*ListMigrationTaskUpdatesOutput, error) {
	if params == nil {
		params = &ListMigrationTaskUpdatesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListMigrationTaskUpdates", params, optFns, c.addOperationListMigrationTaskUpdatesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListMigrationTaskUpdatesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListMigrationTaskUpdatesInput struct {

	// A unique identifier that references the migration task. Do not include
	// sensitive data in this field.
	//
	// This member is required.
	MigrationTaskName *string

	// The name of the progress-update stream, which is used for access control as
	// well as a namespace for migration-task names that is implicitly linked to your
	// AWS account. The progress-update stream must uniquely identify the migration
	// tool as it is used for all updates made by the tool; however, it does not need
	// to be unique for each AWS account because it is scoped to the AWS account.
	//
	// This member is required.
	ProgressUpdateStream *string

	// The maximum number of results to include in the response. If more results exist
	// than the value that you specify here for MaxResults , the response will include
	// a token that you can use to retrieve the next set of results.
	MaxResults *int32

	// If NextToken was returned by a previous call, there are more results available.
	// The value of NextToken is a unique pagination token for each page. To retrieve
	// the next page of results, specify the NextToken value that the previous call
	// returned. Keep all other arguments unchanged. Each pagination token expires
	// after 24 hours. Using an expired pagination token will return an HTTP 400
	// InvalidToken error.
	NextToken *string

	noSmithyDocumentSerde
}

type ListMigrationTaskUpdatesOutput struct {

	// The list of migration-task updates.
	MigrationTaskUpdateList []types.MigrationTaskUpdate

	// If the response includes a NextToken value, that means that there are more
	// results available. The value of NextToken is a unique pagination token for each
	// page. To retrieve the next page of results, call this API again and specify this
	// NextToken value in the request. Keep all other arguments unchanged. Each
	// pagination token expires after 24 hours. Using an expired pagination token will
	// return an HTTP 400 InvalidToken error.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListMigrationTaskUpdatesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpListMigrationTaskUpdates{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpListMigrationTaskUpdates{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListMigrationTaskUpdates"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpListMigrationTaskUpdatesValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListMigrationTaskUpdates(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListMigrationTaskUpdatesPaginatorOptions is the paginator options for
// ListMigrationTaskUpdates
type ListMigrationTaskUpdatesPaginatorOptions struct {
	// The maximum number of results to include in the response. If more results exist
	// than the value that you specify here for MaxResults , the response will include
	// a token that you can use to retrieve the next set of results.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListMigrationTaskUpdatesPaginator is a paginator for ListMigrationTaskUpdates
type ListMigrationTaskUpdatesPaginator struct {
	options   ListMigrationTaskUpdatesPaginatorOptions
	client    ListMigrationTaskUpdatesAPIClient
	params    *ListMigrationTaskUpdatesInput
	nextToken *string
	firstPage bool
}

// NewListMigrationTaskUpdatesPaginator returns a new
// ListMigrationTaskUpdatesPaginator
func NewListMigrationTaskUpdatesPaginator(client ListMigrationTaskUpdatesAPIClient, params *ListMigrationTaskUpdatesInput, optFns ...func(*ListMigrationTaskUpdatesPaginatorOptions)) *ListMigrationTaskUpdatesPaginator {
	if params == nil {
		params = &ListMigrationTaskUpdatesInput{}
	}

	options := ListMigrationTaskUpdatesPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListMigrationTaskUpdatesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListMigrationTaskUpdatesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListMigrationTaskUpdates page.
func (p *ListMigrationTaskUpdatesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListMigrationTaskUpdatesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListMigrationTaskUpdates(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListMigrationTaskUpdatesAPIClient is a client that implements the
// ListMigrationTaskUpdates operation.
type ListMigrationTaskUpdatesAPIClient interface {
	ListMigrationTaskUpdates(context.Context, *ListMigrationTaskUpdatesInput, ...func(*Options)) (*ListMigrationTaskUpdatesOutput, error)
}

var _ ListMigrationTaskUpdatesAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListMigrationTaskUpdates(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListMigrationTaskUpdates",
	}
}
