// Code generated by smithy-go-codegen DO NOT EDIT.

package networkflowmonitor

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/networkflowmonitor/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns the current status of a query for the Network Flow Monitor query
// interface, for a specified query ID and monitor. This call returns the query
// status for the top contributors data for workload insights.
//
// When you start a query, use this call to check the status of the query to make
// sure that it has has SUCCEEDED before you review the results. Use the same
// query ID that you used for the corresponding API call to start the query,
// StartQueryWorkloadInsightsTopContributorsData .
//
// Top contributors in Network Flow Monitor are network flows with the highest
// values for a specific metric type, related to a scope (for workload insights) or
// a monitor.
//
// The top contributor network flows overall for a specific metric type, for
// example, the number of retransmissions.
func (c *Client) GetQueryStatusWorkloadInsightsTopContributorsData(ctx context.Context, params *GetQueryStatusWorkloadInsightsTopContributorsDataInput, optFns ...func(*Options)) (*GetQueryStatusWorkloadInsightsTopContributorsDataOutput, error) {
	if params == nil {
		params = &GetQueryStatusWorkloadInsightsTopContributorsDataInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetQueryStatusWorkloadInsightsTopContributorsData", params, optFns, c.addOperationGetQueryStatusWorkloadInsightsTopContributorsDataMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetQueryStatusWorkloadInsightsTopContributorsDataOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetQueryStatusWorkloadInsightsTopContributorsDataInput struct {

	// The identifier for the query. A query ID is an internally-generated identifier
	// for a specific query returned from an API call to start a query.
	//
	// This member is required.
	QueryId *string

	// The identifier for the scope that includes the resources you want to get data
	// results for. A scope ID is an internally-generated identifier that includes all
	// the resources for a specific root account. A scope ID is returned from a
	// CreateScope API call.
	//
	// This member is required.
	ScopeId *string

	noSmithyDocumentSerde
}

type GetQueryStatusWorkloadInsightsTopContributorsDataOutput struct {

	// The status of a query for top contributors data.
	//
	//   - QUEUED : The query is scheduled to run.
	//
	//   - RUNNING : The query is in progress but not complete.
	//
	//   - SUCCEEDED : The query completed sucessfully.
	//
	//   - FAILED : The query failed due to an error.
	//
	//   - CANCELED : The query was canceled.
	//
	// This member is required.
	Status types.QueryStatus

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetQueryStatusWorkloadInsightsTopContributorsDataMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetQueryStatusWorkloadInsightsTopContributorsData{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetQueryStatusWorkloadInsightsTopContributorsData{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetQueryStatusWorkloadInsightsTopContributorsData"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpGetQueryStatusWorkloadInsightsTopContributorsDataValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetQueryStatusWorkloadInsightsTopContributorsData(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetQueryStatusWorkloadInsightsTopContributorsData(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetQueryStatusWorkloadInsightsTopContributorsData",
	}
}
