// Code generated by smithy-go-codegen DO NOT EDIT.

package notifications

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Disassociates an additional Channel from a particular
// ManagedNotificationConfiguration .
//
// Supported Channels include Chatbot, the Console Mobile Application, and emails
// (notifications-contacts).
func (c *Client) DisassociateManagedNotificationAdditionalChannel(ctx context.Context, params *DisassociateManagedNotificationAdditionalChannelInput, optFns ...func(*Options)) (*DisassociateManagedNotificationAdditionalChannelOutput, error) {
	if params == nil {
		params = &DisassociateManagedNotificationAdditionalChannelInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DisassociateManagedNotificationAdditionalChannel", params, optFns, c.addOperationDisassociateManagedNotificationAdditionalChannelMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DisassociateManagedNotificationAdditionalChannelOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DisassociateManagedNotificationAdditionalChannelInput struct {

	// The Amazon Resource Name (ARN) of the Channel to associate with the
	// ManagedNotificationConfiguration .
	//
	// This member is required.
	ChannelArn *string

	// The Amazon Resource Name (ARN) of the Managed Notification Configuration to
	// associate with the additional Channel.
	//
	// This member is required.
	ManagedNotificationConfigurationArn *string

	noSmithyDocumentSerde
}

type DisassociateManagedNotificationAdditionalChannelOutput struct {
	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDisassociateManagedNotificationAdditionalChannelMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpDisassociateManagedNotificationAdditionalChannel{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpDisassociateManagedNotificationAdditionalChannel{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DisassociateManagedNotificationAdditionalChannel"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpDisassociateManagedNotificationAdditionalChannelValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDisassociateManagedNotificationAdditionalChannel(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opDisassociateManagedNotificationAdditionalChannel(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DisassociateManagedNotificationAdditionalChannel",
	}
}
