// Code generated by smithy-go-codegen DO NOT EDIT.

package observabilityadmin

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/observabilityadmin/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

//	Returns a list of telemetry configurations for AWS resources supported by
//
// telemetry config. For more information, see [Auditing CloudWatch telemetry configurations].
//
// [Auditing CloudWatch telemetry configurations]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/telemetry-config-cloudwatch.html
func (c *Client) ListResourceTelemetry(ctx context.Context, params *ListResourceTelemetryInput, optFns ...func(*Options)) (*ListResourceTelemetryOutput, error) {
	if params == nil {
		params = &ListResourceTelemetryInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListResourceTelemetry", params, optFns, c.addOperationListResourceTelemetryMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListResourceTelemetryOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListResourceTelemetryInput struct {

	//  A number field used to limit the number of results within the returned list.
	MaxResults *int32

	//  The token for the next set of items to return. A previous call generates this
	// token.
	NextToken *string

	//  A string used to filter resources which have a ResourceIdentifier starting
	// with the ResourceIdentifierPrefix .
	ResourceIdentifierPrefix *string

	//  A key-value pair to filter resources based on tags associated with the
	// resource. For more information about tags, see [What are tags?]
	//
	// [What are tags?]: https://docs.aws.amazon.com/whitepapers/latest/tagging-best-practices/what-are-tags.html
	ResourceTags map[string]string

	//  A list of resource types used to filter resources supported by telemetry
	// config. If this parameter is provided, the resources will be returned in the
	// same order used in the request.
	ResourceTypes []types.ResourceType

	//  A key-value pair to filter resources based on the telemetry type and the state
	// of the telemetry configuration. The key is the telemetry type and the value is
	// the state.
	TelemetryConfigurationState map[string]types.TelemetryState

	noSmithyDocumentSerde
}

type ListResourceTelemetryOutput struct {

	//  The token for the next set of items to return. A previous call generates this
	// token.
	NextToken *string

	//  A list of telemetry configurations for AWS resources supported by telemetry
	// config in the caller's account.
	TelemetryConfigurations []types.TelemetryConfiguration

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListResourceTelemetryMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListResourceTelemetry{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListResourceTelemetry{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListResourceTelemetry"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListResourceTelemetry(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListResourceTelemetryPaginatorOptions is the paginator options for
// ListResourceTelemetry
type ListResourceTelemetryPaginatorOptions struct {
	//  A number field used to limit the number of results within the returned list.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListResourceTelemetryPaginator is a paginator for ListResourceTelemetry
type ListResourceTelemetryPaginator struct {
	options   ListResourceTelemetryPaginatorOptions
	client    ListResourceTelemetryAPIClient
	params    *ListResourceTelemetryInput
	nextToken *string
	firstPage bool
}

// NewListResourceTelemetryPaginator returns a new ListResourceTelemetryPaginator
func NewListResourceTelemetryPaginator(client ListResourceTelemetryAPIClient, params *ListResourceTelemetryInput, optFns ...func(*ListResourceTelemetryPaginatorOptions)) *ListResourceTelemetryPaginator {
	if params == nil {
		params = &ListResourceTelemetryInput{}
	}

	options := ListResourceTelemetryPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListResourceTelemetryPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListResourceTelemetryPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListResourceTelemetry page.
func (p *ListResourceTelemetryPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListResourceTelemetryOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListResourceTelemetry(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListResourceTelemetryAPIClient is a client that implements the
// ListResourceTelemetry operation.
type ListResourceTelemetryAPIClient interface {
	ListResourceTelemetry(context.Context, *ListResourceTelemetryInput, ...func(*Options)) (*ListResourceTelemetryOutput, error)
}

var _ ListResourceTelemetryAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListResourceTelemetry(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListResourceTelemetry",
	}
}
