// Code generated by smithy-go-codegen DO NOT EDIT.

package omics

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/omics/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// You can create a run cache to save the task outputs from completed tasks in a
// run for a private workflow. Subsequent runs use the task outputs from the cache,
// rather than computing the task outputs again. You specify an Amazon S3 location
// where HealthOmics saves the cached data. This data must be immediately
// accessible (not in an archived state).
//
// For more information, see [Creating a run cache] in the AWS HealthOmics User Guide.
//
// [Creating a run cache]: https://docs.aws.amazon.com/omics/latest/dev/workflow-cache-create.html
func (c *Client) CreateRunCache(ctx context.Context, params *CreateRunCacheInput, optFns ...func(*Options)) (*CreateRunCacheOutput, error) {
	if params == nil {
		params = &CreateRunCacheInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateRunCache", params, optFns, c.addOperationCreateRunCacheMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateRunCacheOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateRunCacheInput struct {

	// Specify the S3 location for storing the cached task outputs. This data must be
	// immediately accessible (not in an archived state).
	//
	// This member is required.
	CacheS3Location *string

	// A unique request token, to ensure idempotency. If you don't specify a token,
	// HealthOmics automatically generates a universally unique identifier (UUID) for
	// the request.
	//
	// This member is required.
	RequestId *string

	// Default cache behavior for runs that use this cache. Supported values are:
	//
	// CACHE_ON_FAILURE : Caches task outputs from completed tasks for runs that fail.
	// This setting is useful if you're debugging a workflow that fails after several
	// tasks completed successfully. The subsequent run uses the cache outputs for
	// previously-completed tasks if the task definition, inputs, and container in ECR
	// are identical to the prior run.
	//
	// CACHE_ALWAYS : Caches task outputs from completed tasks for all runs. This
	// setting is useful in development mode, but do not use it in a production
	// setting.
	//
	// If you don't specify a value, the default behavior is CACHE_ON_FAILURE. When
	// you start a run that uses this cache, you can override the default cache
	// behavior.
	//
	// For more information, see [Run cache behavior] in the AWS HealthOmics User Guide.
	//
	// [Run cache behavior]: https://docs.aws.amazon.com/omics/latest/dev/how-run-cache.html#run-cache-behavior
	CacheBehavior types.CacheBehavior

	// The AWS account ID of the expected owner of the S3 bucket for the run cache. If
	// not provided, your account ID is set as the owner of the bucket.
	CacheBucketOwnerId *string

	// Enter a description of the run cache.
	Description *string

	// Enter a user-friendly name for the run cache.
	Name *string

	// Specify one or more tags to associate with this run cache.
	Tags map[string]string

	noSmithyDocumentSerde
}

type CreateRunCacheOutput struct {

	// Unique resource identifier for the run cache.
	Arn *string

	// Identifier for the run cache.
	Id *string

	// Run cache status.
	Status types.RunCacheStatus

	// The tags associated with this run cache.
	Tags map[string]string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateRunCacheMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateRunCache{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateRunCache{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateRunCache"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addEndpointPrefix_opCreateRunCacheMiddleware(stack); err != nil {
		return err
	}
	if err = addIdempotencyToken_opCreateRunCacheMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpCreateRunCacheValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateRunCache(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

type endpointPrefix_opCreateRunCacheMiddleware struct {
}

func (*endpointPrefix_opCreateRunCacheMiddleware) ID() string {
	return "EndpointHostPrefix"
}

func (m *endpointPrefix_opCreateRunCacheMiddleware) HandleFinalize(ctx context.Context, in middleware.FinalizeInput, next middleware.FinalizeHandler) (
	out middleware.FinalizeOutput, metadata middleware.Metadata, err error,
) {
	if smithyhttp.GetHostnameImmutable(ctx) || smithyhttp.IsEndpointHostPrefixDisabled(ctx) {
		return next.HandleFinalize(ctx, in)
	}

	req, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, fmt.Errorf("unknown transport type %T", in.Request)
	}

	req.URL.Host = "workflows-" + req.URL.Host

	return next.HandleFinalize(ctx, in)
}
func addEndpointPrefix_opCreateRunCacheMiddleware(stack *middleware.Stack) error {
	return stack.Finalize.Insert(&endpointPrefix_opCreateRunCacheMiddleware{}, "ResolveEndpointV2", middleware.After)
}

type idempotencyToken_initializeOpCreateRunCache struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpCreateRunCache) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpCreateRunCache) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*CreateRunCacheInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *CreateRunCacheInput ")
	}

	if input.RequestId == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.RequestId = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opCreateRunCacheMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpCreateRunCache{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opCreateRunCache(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateRunCache",
	}
}
