// Code generated by smithy-go-codegen DO NOT EDIT.

package omics

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/omics/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists the versions of an annotation store.
func (c *Client) ListAnnotationStoreVersions(ctx context.Context, params *ListAnnotationStoreVersionsInput, optFns ...func(*Options)) (*ListAnnotationStoreVersionsOutput, error) {
	if params == nil {
		params = &ListAnnotationStoreVersionsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListAnnotationStoreVersions", params, optFns, c.addOperationListAnnotationStoreVersionsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListAnnotationStoreVersionsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListAnnotationStoreVersionsInput struct {

	//  The name of an annotation store.
	//
	// This member is required.
	Name *string

	//  A filter to apply to the list of annotation store versions.
	Filter *types.ListAnnotationStoreVersionsFilter

	//  The maximum number of annotation store versions to return in one page of
	// results.
	MaxResults *int32

	//  Specifies the pagination token from a previous request to retrieve the next
	// page of results.
	NextToken *string

	noSmithyDocumentSerde
}

type ListAnnotationStoreVersionsOutput struct {

	//  Lists all versions of an annotation store.
	AnnotationStoreVersions []types.AnnotationStoreVersionItem

	//  Specifies the pagination token from a previous request to retrieve the next
	// page of results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListAnnotationStoreVersionsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListAnnotationStoreVersions{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListAnnotationStoreVersions{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListAnnotationStoreVersions"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addEndpointPrefix_opListAnnotationStoreVersionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpListAnnotationStoreVersionsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListAnnotationStoreVersions(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListAnnotationStoreVersionsPaginatorOptions is the paginator options for
// ListAnnotationStoreVersions
type ListAnnotationStoreVersionsPaginatorOptions struct {
	//  The maximum number of annotation store versions to return in one page of
	// results.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListAnnotationStoreVersionsPaginator is a paginator for
// ListAnnotationStoreVersions
type ListAnnotationStoreVersionsPaginator struct {
	options   ListAnnotationStoreVersionsPaginatorOptions
	client    ListAnnotationStoreVersionsAPIClient
	params    *ListAnnotationStoreVersionsInput
	nextToken *string
	firstPage bool
}

// NewListAnnotationStoreVersionsPaginator returns a new
// ListAnnotationStoreVersionsPaginator
func NewListAnnotationStoreVersionsPaginator(client ListAnnotationStoreVersionsAPIClient, params *ListAnnotationStoreVersionsInput, optFns ...func(*ListAnnotationStoreVersionsPaginatorOptions)) *ListAnnotationStoreVersionsPaginator {
	if params == nil {
		params = &ListAnnotationStoreVersionsInput{}
	}

	options := ListAnnotationStoreVersionsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListAnnotationStoreVersionsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListAnnotationStoreVersionsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListAnnotationStoreVersions page.
func (p *ListAnnotationStoreVersionsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListAnnotationStoreVersionsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListAnnotationStoreVersions(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

type endpointPrefix_opListAnnotationStoreVersionsMiddleware struct {
}

func (*endpointPrefix_opListAnnotationStoreVersionsMiddleware) ID() string {
	return "EndpointHostPrefix"
}

func (m *endpointPrefix_opListAnnotationStoreVersionsMiddleware) HandleFinalize(ctx context.Context, in middleware.FinalizeInput, next middleware.FinalizeHandler) (
	out middleware.FinalizeOutput, metadata middleware.Metadata, err error,
) {
	if smithyhttp.GetHostnameImmutable(ctx) || smithyhttp.IsEndpointHostPrefixDisabled(ctx) {
		return next.HandleFinalize(ctx, in)
	}

	req, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, fmt.Errorf("unknown transport type %T", in.Request)
	}

	req.URL.Host = "analytics-" + req.URL.Host

	return next.HandleFinalize(ctx, in)
}
func addEndpointPrefix_opListAnnotationStoreVersionsMiddleware(stack *middleware.Stack) error {
	return stack.Finalize.Insert(&endpointPrefix_opListAnnotationStoreVersionsMiddleware{}, "ResolveEndpointV2", middleware.After)
}

// ListAnnotationStoreVersionsAPIClient is a client that implements the
// ListAnnotationStoreVersions operation.
type ListAnnotationStoreVersionsAPIClient interface {
	ListAnnotationStoreVersions(context.Context, *ListAnnotationStoreVersionsInput, ...func(*Options)) (*ListAnnotationStoreVersionsOutput, error)
}

var _ ListAnnotationStoreVersionsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListAnnotationStoreVersions(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListAnnotationStoreVersions",
	}
}
