// Code generated by smithy-go-codegen DO NOT EDIT.

package opensearch

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/opensearch/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns information about domain and node health, the standby Availability
// Zone, number of nodes per Availability Zone, and shard count per node.
func (c *Client) DescribeDomainHealth(ctx context.Context, params *DescribeDomainHealthInput, optFns ...func(*Options)) (*DescribeDomainHealthOutput, error) {
	if params == nil {
		params = &DescribeDomainHealthInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeDomainHealth", params, optFns, c.addOperationDescribeDomainHealthMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeDomainHealthOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// Container for the parameters to the DescribeDomainHealth operation.
type DescribeDomainHealthInput struct {

	// The name of the domain.
	//
	// This member is required.
	DomainName *string

	noSmithyDocumentSerde
}

// The result of a DescribeDomainHealth request. Contains health information for
// the requested domain.
type DescribeDomainHealthOutput struct {

	// The number of active Availability Zones configured for the domain. If the
	// service is unable to fetch this information, it will return NotAvailable .
	ActiveAvailabilityZoneCount *string

	// The number of Availability Zones configured for the domain. If the service is
	// unable to fetch this information, it will return NotAvailable .
	AvailabilityZoneCount *string

	// The current health status of your cluster.
	//
	//   - Red - At least one primary shard is not allocated to any node.
	//
	//   - Yellow - All primary shards are allocated to nodes, but some replicas aren’t.
	//
	//   - Green - All primary shards and their replicas are allocated to nodes.
	//
	//   - NotAvailable - Unable to retrieve cluster health.
	ClusterHealth types.DomainHealth

	// The number of data nodes configured for the domain. If the service is unable to
	// fetch this information, it will return NotAvailable .
	DataNodeCount *string

	// A boolean that indicates if dedicated master nodes are activated for the domain.
	DedicatedMaster *bool

	// The current state of the domain.
	//
	//   - Processing - The domain has updates in progress.
	//
	//   - Active - Requested changes have been processed and deployed to the domain.
	DomainState types.DomainState

	// A list of EnvironmentInfo for the domain.
	EnvironmentInformation []types.EnvironmentInfo

	// The number of nodes that can be elected as a master node. If dedicated master
	// nodes is turned on, this value is the number of dedicated master nodes
	// configured for the domain. If the service is unable to fetch this information,
	// it will return NotAvailable .
	MasterEligibleNodeCount *string

	// Indicates whether the domain has an elected master node.
	//
	//   - Available - The domain has an elected master node.
	//
	//   - UnAvailable - The master node hasn't yet been elected, and a quorum to
	//   elect a new master node hasn't been reached.
	MasterNode types.MasterNodeStatus

	// The number of standby Availability Zones configured for the domain. If the
	// service is unable to fetch this information, it will return NotAvailable .
	StandByAvailabilityZoneCount *string

	// The total number of primary and replica shards for the domain.
	TotalShards *string

	// The total number of primary and replica shards not allocated to any of the
	// nodes for the cluster.
	TotalUnAssignedShards *string

	// The number of warm nodes configured for the domain.
	WarmNodeCount *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeDomainHealthMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpDescribeDomainHealth{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpDescribeDomainHealth{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DescribeDomainHealth"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpDescribeDomainHealthValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeDomainHealth(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opDescribeDomainHealth(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DescribeDomainHealth",
	}
}
