// Code generated by smithy-go-codegen DO NOT EDIT.

package panorama

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/panorama/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns a list of camera stream node jobs.
func (c *Client) ListNodeFromTemplateJobs(ctx context.Context, params *ListNodeFromTemplateJobsInput, optFns ...func(*Options)) (*ListNodeFromTemplateJobsOutput, error) {
	if params == nil {
		params = &ListNodeFromTemplateJobsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListNodeFromTemplateJobs", params, optFns, c.addOperationListNodeFromTemplateJobsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListNodeFromTemplateJobsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListNodeFromTemplateJobsInput struct {

	// The maximum number of node from template jobs to return in one page of results.
	MaxResults int32

	// Specify the pagination token from a previous request to retrieve the next page
	// of results.
	NextToken *string

	noSmithyDocumentSerde
}

type ListNodeFromTemplateJobsOutput struct {

	// A list of jobs.
	//
	// This member is required.
	NodeFromTemplateJobs []types.NodeFromTemplateJob

	// A pagination token that's included if more results are available.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListNodeFromTemplateJobsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListNodeFromTemplateJobs{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListNodeFromTemplateJobs{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListNodeFromTemplateJobs"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListNodeFromTemplateJobs(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListNodeFromTemplateJobsPaginatorOptions is the paginator options for
// ListNodeFromTemplateJobs
type ListNodeFromTemplateJobsPaginatorOptions struct {
	// The maximum number of node from template jobs to return in one page of results.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListNodeFromTemplateJobsPaginator is a paginator for ListNodeFromTemplateJobs
type ListNodeFromTemplateJobsPaginator struct {
	options   ListNodeFromTemplateJobsPaginatorOptions
	client    ListNodeFromTemplateJobsAPIClient
	params    *ListNodeFromTemplateJobsInput
	nextToken *string
	firstPage bool
}

// NewListNodeFromTemplateJobsPaginator returns a new
// ListNodeFromTemplateJobsPaginator
func NewListNodeFromTemplateJobsPaginator(client ListNodeFromTemplateJobsAPIClient, params *ListNodeFromTemplateJobsInput, optFns ...func(*ListNodeFromTemplateJobsPaginatorOptions)) *ListNodeFromTemplateJobsPaginator {
	if params == nil {
		params = &ListNodeFromTemplateJobsInput{}
	}

	options := ListNodeFromTemplateJobsPaginatorOptions{}
	if params.MaxResults != 0 {
		options.Limit = params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListNodeFromTemplateJobsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListNodeFromTemplateJobsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListNodeFromTemplateJobs page.
func (p *ListNodeFromTemplateJobsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListNodeFromTemplateJobsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	params.MaxResults = p.options.Limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListNodeFromTemplateJobs(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListNodeFromTemplateJobsAPIClient is a client that implements the
// ListNodeFromTemplateJobs operation.
type ListNodeFromTemplateJobsAPIClient interface {
	ListNodeFromTemplateJobs(context.Context, *ListNodeFromTemplateJobsInput, ...func(*Options)) (*ListNodeFromTemplateJobsOutput, error)
}

var _ ListNodeFromTemplateJobsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListNodeFromTemplateJobs(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListNodeFromTemplateJobs",
	}
}
