// Code generated by smithy-go-codegen DO NOT EDIT.

package partnercentralselling

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/partnercentralselling/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Enables you to create a formal association between an Opportunity and various
// related entities, enriching the context and details of the opportunity for
// better collaboration and decision making. You can associate an opportunity with
// the following entity types:
//
//   - Partner Solution: A software product or consulting practice created and
//     delivered by Partners. Partner Solutions help customers address business
//     challenges using Amazon Web Services services.
//
//   - Amazon Web Services Products: Amazon Web Services offers many products and
//     services that provide scalable, reliable, and cost-effective infrastructure
//     solutions. For the latest list of Amazon Web Services products, see [Amazon Web Services products].
//
//   - Amazon Web Services Marketplace private offer: Allows Amazon Web Services
//     Marketplace sellers to extend custom pricing and terms to individual Amazon Web
//     Services customers. Sellers can negotiate custom prices, payment schedules, and
//     end user license terms through private offers, enabling Amazon Web Services
//     customers to acquire software solutions tailored to their specific needs. For
//     more information, see [Private offers in Amazon Web Services Marketplace].
//
// To obtain identifiers for these entities, use the following methods:
//
//   - Solution: Use the ListSolutions operation.
//
//   - AWS Products: For the latest list of Amazon Web Services products, see [Amazon Web Services products].
//
//   - Amazon Web Services Marketplace private offer: Use the [Using the Amazon Web Services Marketplace Catalog API]to list entities.
//     Specifically, use the ListEntities operation to retrieve a list of private
//     offers. The request returns the details of available private offers. For more
//     information, see [ListEntities].
//
// [Private offers in Amazon Web Services Marketplace]: https://docs.aws.amazon.com/marketplace/latest/buyerguide/buyer-private-offers.html
// [Using the Amazon Web Services Marketplace Catalog API]: https://docs.aws.amazon.com/marketplace/latest/APIReference/catalog-apis.html
// [ListEntities]: https://docs.aws.amazon.com/marketplace-catalog/latest/api-reference/API_ListEntities.html
// [Amazon Web Services products]: https://github.com/aws-samples/partner-crm-integration-samples/blob/main/resources/aws_products.json
func (c *Client) AssociateOpportunity(ctx context.Context, params *AssociateOpportunityInput, optFns ...func(*Options)) (*AssociateOpportunityOutput, error) {
	if params == nil {
		params = &AssociateOpportunityInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "AssociateOpportunity", params, optFns, c.addOperationAssociateOpportunityMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*AssociateOpportunityOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type AssociateOpportunityInput struct {

	// Specifies the catalog associated with the request. This field takes a string
	// value from a predefined list: AWS or Sandbox . The catalog determines which
	// environment the opportunity association is made in. Use AWS to associate
	// opportunities in the Amazon Web Services catalog, and Sandbox for testing in
	// secure, isolated environments.
	//
	// This member is required.
	Catalog *string

	// Requires the Opportunity 's unique identifier when you want to associate it with
	// a related entity. Provide the correct identifier so the intended opportunity is
	// updated with the association.
	//
	// This member is required.
	OpportunityIdentifier *string

	// Requires the related entity's unique identifier when you want to associate it
	// with the Opportunity . For Amazon Web Services Marketplace entities, provide the
	// Amazon Resource Name (ARN). Use the [Amazon Web Services Marketplace API]to obtain the ARN.
	//
	// [Amazon Web Services Marketplace API]: https://docs.aws.amazon.com/marketplace-catalog/latest/api-reference/welcome.html
	//
	// This member is required.
	RelatedEntityIdentifier *string

	// Specifies the entity type that you're associating with the  Opportunity . This
	// helps to categorize and properly process the association.
	//
	// This member is required.
	RelatedEntityType types.RelatedEntityType

	noSmithyDocumentSerde
}

type AssociateOpportunityOutput struct {
	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationAssociateOpportunityMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpAssociateOpportunity{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpAssociateOpportunity{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "AssociateOpportunity"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpAssociateOpportunityValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opAssociateOpportunity(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opAssociateOpportunity(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "AssociateOpportunity",
	}
}
